/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jaxp;

import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import org.web3d.util.BooleanStack;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.util.HashSet;
import org.web3d.util.IntStack;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.sav.ContentHandler;
import org.web3d.vrml.sav.ErrorHandler;
import org.web3d.vrml.sav.Locator;
import org.web3d.vrml.sav.ProtoHandler;
import org.web3d.vrml.sav.RouteHandler;
import org.web3d.vrml.sav.ScriptHandler;
import org.web3d.vrml.sav.StringContentHandler;
import org.web3d.x3d.jaxp.LocatorAdapter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.ext.LexicalHandler;

public class X3DSAVAdapter
implements LexicalHandler,
org.xml.sax.ContentHandler {
    protected static final String CONTAINER_PROPS_FILE = "XMLcontainerfields.properties";
    protected static final String INVALID_DTD_NAME_MSG = "The DTD name provided is wrong: ";
    protected static final String INVALID_PUBLIC_ID_MSG = "The PUBLIC ID provided is wrong";
    protected static final String INVALID_SYSTEM_ID_MSG = "The SYSTEM ID provided is wrong";
    protected static final String TRANSITIONAL_HEADER_MSG = "The file uses the old, out of date transitional header. Please upgrade the content to the correct header required. Soon we may refuse to load this content.";
    protected static final String UNKNOWN_DTD_MSG = "The file uses an unknown DTD.  This content is not validated against the X3D standard DTD.";
    protected static final String UNKNOWN_ACCESS_TYPE_MSG = "The field has declared an invalid access type: ";
    protected static final String NO_PROFILE_MSG = "No profile defined and is a required attribute for a valid X3D file.";
    protected static final String NO_SCENE_TAG_MSG = "No Scene element was defined before starting the file body.";
    protected static final String USE_WITH_KIDS_MSG = "A USE has been declared and there are child elements provided";
    protected static final String XML_ENCODING = "xml";
    protected static final int X3D_TAG = 1;
    protected static final int COMPONENT_TAG = 2;
    protected static final int SCENE_TAG = 3;
    protected static final int PROTO_DECL_TAG = 4;
    protected static final int EXTERNPROTO_DECL_TAG = 5;
    protected static final int IS_TAG = 6;
    protected static final int FIELD_TAG = 7;
    protected static final int META_TAG = 8;
    protected static final int PROTO_INSTANCE_TAG = 9;
    protected static final int IMPORT_TAG = 10;
    protected static final int EXPORT_TAG = 11;
    protected static final int ROUTE_TAG = 12;
    protected static final int FIELD_VALUE_TAG = 13;
    protected static final int SCRIPT_TAG = 14;
    protected static final int CONNECT_TAG = 15;
    protected static final int HEAD_TAG = 16;
    protected static final int PROTO_INTERFACE_TAG = 17;
    protected static final int PROTO_BODY_TAG = 18;
    protected static final String NAME_ATTR = "name";
    protected static final String VERSION_ATTR = "version";
    protected static final String VALUE_ATTR = "value";
    protected static final String DEF_ATTR = "DEF";
    protected static final String USE_ATTR = "USE";
    protected static final String AS_ATTR = "AS";
    protected static final String CLASS_ATTR = "class";
    protected static final String CONTAINER_ATTR = "containerField";
    protected static final int NAME_ATTR_ID = 1;
    protected static final int DEF_ATTR_ID = 2;
    protected static final int USE_ATTR_ID = 3;
    protected static final int CLASS_ATTR_ID = 4;
    protected static final int CONTAINER_ATTR_ID = 5;
    protected static HashMap specVersionMap = new HashMap();
    protected static HashMap specStringMap = new HashMap();
    protected static HashSet allowedPublicIDs = new HashSet();
    protected static HashSet allowedSystemIDs = new HashSet();
    protected static HashMap fieldAccessMap;
    protected static HashMap elementMap;
    protected static HashMap attributeMap;
    protected String versionString;
    protected Properties containerFields;
    protected ErrorReporter errorReporter = DefaultErrorReporter.getDefaultReporter();
    protected org.xml.sax.Locator saxLocator;
    protected Locator savLocator;
    protected StringContentHandler contentHandler;
    protected RouteHandler routeHandler;
    protected ScriptHandler scriptHandler;
    protected ProtoHandler protoHandler;
    protected String worldURL;
    protected String fullURL;
    protected boolean useIsCurrent;
    protected StringBuffer characterDataBuffer;
    protected BooleanStack scriptFlagStack = new BooleanStack();
    protected boolean inScript;
    protected int fieldDeclDepth;
    protected IntStack depthCountStack;
    protected IntStack declDepthStack;
    protected boolean overrideLex;
    protected boolean checkForSceneTag;
    protected String epUrl;
    protected BooleanStack scriptUrlStack = new BooleanStack();
    static /* synthetic */ Class class$org$web3d$x3d$jaxp$X3DSAVAdapter;

    public X3DSAVAdapter() {
        this.depthCountStack = new IntStack();
        this.declDepthStack = new IntStack();
        this.characterDataBuffer = new StringBuffer();
        this.containerFields = new Properties();
        this.scriptFlagStack.push(false);
        this.inScript = false;
        this.fieldDeclDepth = 0;
        this.overrideLex = false;
        this.checkForSceneTag = false;
    }

    public void setLoadState(String string, String string2, boolean bl) {
        this.worldURL = string;
        this.fullURL = string2;
        this.overrideLex = bl;
    }

    public void comment(char[] cArray, int n, int n2) {
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
        if (!string.equals("X3D")) {
            throw new SAXNotSupportedException(INVALID_DTD_NAME_MSG + string);
        }
        boolean bl = false;
        if (allowedPublicIDs.contains((Object)string2)) {
            if ("http://www.web3D.org/TaskGroups/x3d/translation/x3d-compact.dtd".equals(string2)) {
                bl = true;
                this.errorReporter.warningReport(TRANSITIONAL_HEADER_MSG, null);
            } else if ("http://www.web3d.org/specifications/x3d-3.0.dtd".equals(string2)) {
                bl = true;
                this.errorReporter.warningReport(TRANSITIONAL_HEADER_MSG, null);
            }
            if (allowedSystemIDs.contains((Object)string3)) {
                if ("/www.web3D.org/TaskGroups/x3d/translation/x3d-compact.dtd".equals(string3) && !bl) {
                    this.errorReporter.warningReport(TRANSITIONAL_HEADER_MSG, null);
                } else if ("file:///www.web3d.org/TaskGroups/x3d/translation/x3d-3.0.dtd".equals(string3) && !bl) {
                    this.errorReporter.warningReport(TRANSITIONAL_HEADER_MSG, null);
                }
            } else {
                throw new SAXException(INVALID_SYSTEM_ID_MSG);
            }
            Float f = (Float)specVersionMap.get(string2);
            this.versionString = (String)specStringMap.get(f);
        } else {
            this.errorReporter.warningReport(UNKNOWN_DTD_MSG, null);
            this.versionString = "V3.1";
        }
    }

    public void endDTD() {
    }

    public void startCDATA() {
        if (this.overrideLex) {
            return;
        }
    }

    public void endCDATA() {
    }

    protected void startScript() {
        this.characterDataBuffer.setLength(0);
        this.characterDataBuffer.append('\"');
    }

    protected void endScript() {
        this.characterDataBuffer.append('\"');
        this.contentHandler.startField("url");
        this.contentHandler.fieldValue(this.characterDataBuffer.toString());
        this.contentHandler.endField();
        this.characterDataBuffer.setLength(0);
        this.characterDataBuffer.append('\"');
    }

    public void startEntity(String string) {
    }

    public void endEntity(String string) {
    }

    public void setDocumentLocator(org.xml.sax.Locator locator) {
        this.savLocator = new LocatorAdapter(locator);
        if (this.contentHandler != null) {
            this.contentHandler.setDocumentLocator(this.savLocator);
        }
        if (this.errorReporter instanceof ErrorHandler) {
            ErrorHandler errorHandler = (ErrorHandler)this.errorReporter;
            errorHandler.setDocumentLocator(this.savLocator);
        }
        this.saxLocator = locator;
        this.useIsCurrent = false;
    }

    public void startDocument() throws SAXException {
        this.versionString = "V3.0";
    }

    public void endDocument() throws SAXException {
        if (this.contentHandler != null && !this.overrideLex) {
            this.contentHandler.endDocument();
        }
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
    }

    public void endPrefixMapping(String string) throws SAXException {
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.useIsCurrent) {
            throw new SAXException(USE_WITH_KIDS_MSG);
        }
        if (string3.startsWith("X3D:")) {
            string3 = string3.substring(4);
        }
        Integer n = (Integer)elementMap.get(string3);
        String string4 = null;
        if (n == null) {
            if (this.checkForSceneTag) {
                throw new SAXException(NO_SCENE_TAG_MSG);
            }
            if (this.fieldDeclDepth != 0) {
                String string5 = attributes.getValue(CONTAINER_ATTR);
                if (string5 == null && (string5 = this.containerFields.getProperty(string3)) == null) {
                    string5 = "children";
                }
                if (this.contentHandler != null) {
                    try {
                        this.contentHandler.startField(string5);
                    }
                    catch (InvalidFieldException invalidFieldException) {
                        System.out.println("No field: " + string5 + " for: " + string3);
                    }
                }
            }
            string4 = attributes.getValue(USE_ATTR);
            ++this.fieldDeclDepth;
            if (string4 != null) {
                if (this.contentHandler != null) {
                    this.contentHandler.useDecl(string4);
                }
                this.useIsCurrent = true;
            } else {
                string4 = attributes.getValue(DEF_ATTR);
                if (this.contentHandler != null) {
                    this.contentHandler.startNode(string3, string4);
                }
            }
            int n2 = attributes.getLength();
            for (int i = 0; !this.useIsCurrent && i < n2; ++i) {
                String string6;
                String string7 = attributes.getQName(i);
                Integer n3 = (Integer)attributeMap.get(string7);
                if (n3 != null || this.contentHandler == null || (string6 = attributes.getValue(i)).length() == 0) continue;
                this.contentHandler.startField(string7);
                this.contentHandler.fieldValue(string6);
                this.contentHandler.endField();
            }
            return;
        }
        switch (n) {
            case 1: {
                string4 = attributes.getValue(VERSION_ATTR);
                if (string4 != null) {
                    this.versionString = "V" + string4;
                }
                this.loadContainerProperties(Float.parseFloat(this.versionString.substring(1)));
                if (this.contentHandler != null) {
                    this.contentHandler.startDocument(this.fullURL, this.worldURL, XML_ENCODING, "#X3D", this.versionString, null);
                }
                if ((string4 = attributes.getValue("profile")) == null) {
                    throw new SAXException(NO_PROFILE_MSG);
                }
                if (this.contentHandler != null) {
                    this.contentHandler.profileDecl(string4);
                }
                if (this.overrideLex) {
                    this.characterDataBuffer.append("\"");
                }
                this.useIsCurrent = false;
                this.checkForSceneTag = true;
                break;
            }
            case 16: {
                break;
            }
            case 2: {
                string4 = attributes.getValue(NAME_ATTR) + ':' + attributes.getValue("level");
                if (this.contentHandler == null) break;
                this.contentHandler.componentDecl(string4);
                break;
            }
            case 3: {
                this.checkForSceneTag = false;
                break;
            }
            case 4: {
                if (this.checkForSceneTag) {
                    throw new SAXException(NO_SCENE_TAG_MSG);
                }
                if (this.protoHandler != null) {
                    this.protoHandler.startProtoDecl(attributes.getValue(NAME_ATTR));
                }
                this.scriptFlagStack.push(false);
                this.inScript = false;
                break;
            }
            case 17: {
                if (!this.checkForSceneTag) break;
                throw new SAXException(NO_SCENE_TAG_MSG);
            }
            case 18: {
                if (this.checkForSceneTag) {
                    throw new SAXException(NO_SCENE_TAG_MSG);
                }
                if (this.protoHandler == null) break;
                this.protoHandler.endProtoDecl();
                this.protoHandler.startProtoBody();
                break;
            }
            case 5: {
                if (this.checkForSceneTag) {
                    throw new SAXException(NO_SCENE_TAG_MSG);
                }
                if (this.protoHandler != null) {
                    string4 = attributes.getValue(NAME_ATTR);
                    this.protoHandler.startExternProtoDecl(string4);
                    this.epUrl = attributes.getValue("url");
                }
                this.scriptFlagStack.push(false);
                this.inScript = false;
                break;
            }
            case 6: {
                if (!this.checkForSceneTag) break;
                throw new SAXException(NO_SCENE_TAG_MSG);
            }
            case 15: {
                if (this.checkForSceneTag) {
                    throw new SAXException(NO_SCENE_TAG_MSG);
                }
                if (this.contentHandler != null) {
                    this.contentHandler.startField(attributes.getValue("nodeField"));
                }
                if (this.protoHandler == null) break;
                this.protoHandler.protoIsDecl(attributes.getValue("protoField"));
                break;
            }
            case 7: {
                if (this.checkForSceneTag) {
                    throw new SAXException(NO_SCENE_TAG_MSG);
                }
                int n4 = this.processFieldAccess(attributes.getValue("accessType"), attributes.getValue(NAME_ATTR));
                boolean bl = false;
                this.depthCountStack.push(this.fieldDeclDepth);
                this.fieldDeclDepth = 0;
                string4 = attributes.getValue(USE_ATTR);
                if (string4 != null) {
                    bl = true;
                } else {
                    string4 = attributes.getValue(VALUE_ATTR);
                }
                if (this.inScript) {
                    if (bl) {
                        if (this.scriptHandler != null) {
                            this.scriptHandler.scriptFieldDecl(n4, attributes.getValue("type"), attributes.getValue(NAME_ATTR), null);
                        }
                        if (this.contentHandler == null) break;
                        this.contentHandler.useDecl(string4);
                        break;
                    }
                    if (string4 != null && string4.length() == 0) {
                        string4 = null;
                    }
                    if (this.scriptHandler == null) break;
                    this.scriptHandler.scriptFieldDecl(n4, attributes.getValue("type"), attributes.getValue(NAME_ATTR), (Object)string4);
                    break;
                }
                if (bl) {
                    if (this.protoHandler != null) {
                        this.protoHandler.protoFieldDecl(n4, attributes.getValue("type"), attributes.getValue(NAME_ATTR), null);
                    }
                    if (this.contentHandler == null) break;
                    this.contentHandler.useDecl(string4);
                    break;
                }
                if (string4 != null && string4.length() == 0) {
                    string4 = null;
                }
                if (this.protoHandler == null) break;
                this.protoHandler.protoFieldDecl(n4, attributes.getValue("type"), attributes.getValue(NAME_ATTR), (Object)string4);
                break;
            }
            case 8: {
                if (this.contentHandler == null) break;
                this.contentHandler.metaDecl(attributes.getValue(NAME_ATTR), attributes.getValue("content"));
                break;
            }
            case 9: {
                if (this.checkForSceneTag) {
                    throw new SAXException(NO_SCENE_TAG_MSG);
                }
                if (this.contentHandler != null) {
                    String string8 = attributes.getValue(CONTAINER_ATTR);
                    if (string8 == null && (string8 = this.containerFields.getProperty(string2)) == null) {
                        string8 = "children";
                    }
                    if (this.fieldDeclDepth != 0) {
                        this.contentHandler.startField(string8);
                    }
                    ++this.fieldDeclDepth;
                    this.contentHandler.startNode(attributes.getValue(NAME_ATTR), attributes.getValue(DEF_ATTR));
                }
                this.inScript = false;
                break;
            }
            case 10: {
                if (this.contentHandler == null) break;
                this.contentHandler.importDecl(attributes.getValue("inlineDEF"), attributes.getValue("exportedDEF"), attributes.getValue(AS_ATTR));
                break;
            }
            case 11: {
                if (this.checkForSceneTag) {
                    throw new SAXException(NO_SCENE_TAG_MSG);
                }
                if (this.contentHandler == null) break;
                this.contentHandler.exportDecl(attributes.getValue("localDEF"), attributes.getValue(AS_ATTR));
                break;
            }
            case 12: {
                if (this.checkForSceneTag) {
                    throw new SAXException(NO_SCENE_TAG_MSG);
                }
                if (this.routeHandler == null) break;
                this.routeHandler.routeDecl(attributes.getValue("fromNode"), attributes.getValue("fromField"), attributes.getValue("toNode"), attributes.getValue("toField"));
                break;
            }
            case 14: {
                if (this.checkForSceneTag) {
                    throw new SAXException(NO_SCENE_TAG_MSG);
                }
                this.startScript();
                this.scriptFlagStack.push(true);
                this.inScript = true;
                boolean bl = false;
                this.characterDataBuffer.setLength(0);
                this.characterDataBuffer.append('\"');
                String string9 = attributes.getValue(CONTAINER_ATTR);
                if (string9 == null && (string9 = this.containerFields.getProperty(string2)) == null) {
                    string9 = "children";
                }
                if (this.fieldDeclDepth != 0 && this.contentHandler != null) {
                    this.contentHandler.startField(string9);
                }
                ++this.fieldDeclDepth;
                string4 = attributes.getValue(USE_ATTR);
                if (string4 != null) {
                    if (this.contentHandler != null) {
                        this.contentHandler.useDecl(string4);
                    }
                    bl = true;
                    this.useIsCurrent = true;
                } else {
                    string4 = attributes.getValue(DEF_ATTR);
                    bl = false;
                    if (this.contentHandler != null) {
                        this.contentHandler.startNode(string3, string4);
                    }
                }
                if (this.scriptHandler != null && !bl) {
                    this.scriptHandler.startScriptDecl();
                }
                if (bl || this.contentHandler == null) break;
                string4 = attributes.getValue("url");
                if (string4 != null) {
                    this.scriptUrlStack.push(true);
                    this.contentHandler.startField("url");
                    this.contentHandler.fieldValue(string4);
                    this.contentHandler.endField();
                } else {
                    this.scriptUrlStack.push(false);
                }
                string4 = attributes.getValue("mustEvaluate");
                if (string4 != null) {
                    this.contentHandler.startField("mustEvaluate");
                    this.contentHandler.fieldValue(string4);
                }
                if ((string4 = attributes.getValue("directOutput")) == null) break;
                this.contentHandler.startField("directOutput");
                this.contentHandler.fieldValue(string4);
                break;
            }
            case 13: {
                if (this.checkForSceneTag) {
                    throw new SAXException(NO_SCENE_TAG_MSG);
                }
                if (this.contentHandler != null) {
                    this.contentHandler.startField(attributes.getValue(NAME_ATTR));
                    string4 = attributes.getValue(USE_ATTR);
                    if (string4 != null) {
                        this.contentHandler.useDecl(string4);
                    } else {
                        string4 = attributes.getValue(VALUE_ATTR);
                        if (string4 != null && string4.length() > 0) {
                            this.contentHandler.fieldValue(string4);
                        }
                    }
                }
                this.declDepthStack.push(this.fieldDeclDepth);
                this.fieldDeclDepth = 0;
                break;
            }
            default: {
                System.out.println("Unknown start element type " + string3);
            }
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        Object object;
        Integer n = (Integer)elementMap.get(string3);
        if (this.overrideLex && this.characterDataBuffer.length() > 1 && this.inScript && this.contentHandler != null) {
            this.characterDataBuffer.append('\"');
            object = this.characterDataBuffer.toString();
            int n2 = ((String)object).length();
            object = ((String)object).substring(1, n2 - 2);
            object = ((String)object).trim();
            if (((String)object).length() > 1) {
                object = "\"" + (String)object + "\"";
                this.contentHandler.startField("url");
                this.contentHandler.fieldValue(this.characterDataBuffer.toString());
                this.contentHandler.endField();
            }
            this.characterDataBuffer.setLength(0);
            this.characterDataBuffer.append('\"');
        }
        if (n == null) {
            --this.fieldDeclDepth;
            if (this.contentHandler != null) {
                if (this.useIsCurrent) {
                    this.contentHandler.endField();
                    this.useIsCurrent = false;
                } else {
                    this.contentHandler.endNode();
                }
            }
            return;
        }
        switch (n) {
            case 4: {
                this.inScript = this.scriptFlagStack.pop();
                break;
            }
            case 17: {
                break;
            }
            case 18: {
                if (this.protoHandler == null) break;
                this.protoHandler.endProtoBody();
                break;
            }
            case 5: {
                if (this.protoHandler != null) {
                    this.protoHandler.endExternProtoDecl();
                    object = new StringTokenizer(this.epUrl, "\"");
                    ArrayList<String> arrayList = new ArrayList<String>();
                    while (((StringTokenizer)object).hasMoreTokens()) {
                        arrayList.add(((StringTokenizer)object).nextToken());
                    }
                    int n3 = arrayList.size();
                    String[] stringArray = new String[n3];
                    for (int i = 0; i < n3; ++i) {
                        stringArray[i] = (String)arrayList.get(i);
                    }
                    this.protoHandler.externProtoURI(stringArray);
                }
                this.inScript = this.scriptFlagStack.pop();
                break;
            }
            case 6: {
                break;
            }
            case 15: {
                break;
            }
            case 7: {
                this.fieldDeclDepth = this.depthCountStack.pop();
                break;
            }
            case 9: {
                if (this.contentHandler != null) {
                    this.contentHandler.endNode();
                }
                this.inScript = true;
                --this.fieldDeclDepth;
                break;
            }
            case 14: {
                if (!this.useIsCurrent) {
                    boolean bl = this.scriptUrlStack.pop();
                    if (!bl) {
                        this.endScript();
                    }
                    if (this.scriptHandler != null) {
                        this.scriptHandler.endScriptDecl();
                    }
                }
                this.inScript = this.scriptFlagStack.pop();
                --this.fieldDeclDepth;
                if (this.contentHandler == null) break;
                if (this.useIsCurrent) {
                    this.contentHandler.endField();
                    this.useIsCurrent = false;
                    break;
                }
                this.contentHandler.endNode();
                break;
            }
            case 1: {
                if (!this.overrideLex || this.contentHandler == null) break;
                this.contentHandler.endDocument();
                break;
            }
            case 16: {
                this.checkForSceneTag = true;
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 13: {
                this.fieldDeclDepth = this.declDepthStack.pop();
                break;
            }
            default: {
                System.out.println("Unknown end element type " + string3);
            }
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.characterDataBuffer.append(cArray, n, n2);
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    public void processingInstruction(String string, String string2) throws SAXException {
    }

    public void skippedEntity(String string) throws SAXException {
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = (StringContentHandler)contentHandler;
        if (this.savLocator != null) {
            this.contentHandler.setDocumentLocator(this.savLocator);
        }
    }

    public ScriptHandler getScriptHandler() {
        return this.scriptHandler;
    }

    public void setScriptHandler(ScriptHandler scriptHandler) {
        this.scriptHandler = scriptHandler;
    }

    public ProtoHandler getProtoHandler() {
        return this.protoHandler;
    }

    public void setProtoHandler(ProtoHandler protoHandler) {
        this.protoHandler = protoHandler;
    }

    public RouteHandler getRouteHandler() {
        return this.routeHandler;
    }

    public void setRouteHandler(RouteHandler routeHandler) {
        this.routeHandler = routeHandler;
    }

    protected int processFieldAccess(String string, String string2) throws SAXException {
        Integer n = (Integer)fieldAccessMap.get(string);
        if (n == null) {
            throw new SAXException(UNKNOWN_ACCESS_TYPE_MSG + string + " for field: " + string2);
        }
        return n;
    }

    protected void loadContainerProperties(final float f) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    ClassLoader classLoader = ClassLoader.getSystemClassLoader();
                    InputStream inputStream = ClassLoader.getSystemResourceAsStream("config/" + f + "/" + X3DSAVAdapter.CONTAINER_PROPS_FILE);
                    if (inputStream == null) {
                        inputStream = (class$org$web3d$x3d$jaxp$X3DSAVAdapter == null ? (class$org$web3d$x3d$jaxp$X3DSAVAdapter = X3DSAVAdapter.class$("org.web3d.x3d.jaxp.X3DSAVAdapter")) : class$org$web3d$x3d$jaxp$X3DSAVAdapter).getClassLoader().getResourceAsStream("config/" + f + "/" + X3DSAVAdapter.CONTAINER_PROPS_FILE);
                    }
                    if (inputStream != null) {
                        X3DSAVAdapter.this.containerFields.load(inputStream);
                    } else {
                        System.out.println("Couldn't find container properties file");
                    }
                }
                catch (IOException iOException) {
                    System.out.println("Error reading container properties file");
                }
                return null;
            }
        });
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        allowedSystemIDs.add((Object)"/www.web3D.org/TaskGroups/x3d/translation/x3d-compact.dtd");
        allowedSystemIDs.add((Object)"file:///www.web3d.org/TaskGroups/x3d/translation/x3d-3.0.dtd");
        Float f = new Float(3.0f);
        specStringMap.put(f, "V3.0");
        specVersionMap.put("ISO//Web3D//DTD X3D 3.0//EN", f);
        specVersionMap.put("ISO//Web3D//DTD X3D 3.0 Interchange//EN", f);
        specVersionMap.put("ISO//Web3D//DTD X3D 3.0 Interactive//EN", f);
        specVersionMap.put("ISO//Web3D//DTD X3D 3.0 Immersive//EN", f);
        specVersionMap.put("ISO//Web3D//DTD X3D 3.0 Full//EN", f);
        specVersionMap.put("http://www.web3d.org/specifications/x3d-3.0.dtd", f);
        allowedPublicIDs = new HashSet();
        allowedPublicIDs.add((Object)"ISO//Web3D//DTD X3D 3.0//EN");
        allowedPublicIDs.add((Object)"ISO//Web3D//DTD X3D 3.0 Interchange//EN");
        allowedPublicIDs.add((Object)"ISO//Web3D//DTD X3D 3.0 Interactive//EN");
        allowedPublicIDs.add((Object)"ISO//Web3D//DTD X3D 3.0 Immersive//EN");
        allowedPublicIDs.add((Object)"ISO//Web3D//DTD X3D 3.0 Full//EN");
        allowedPublicIDs.add((Object)"http://www.web3D.org/TaskGroups/x3d/translation/x3d-compact.dtd");
        allowedPublicIDs.add((Object)"http://www.web3d.org/specifications/x3d-3.0.dtd");
        allowedSystemIDs.add((Object)"http://www.web3d.org/specifications/x3d-3.0.dtd");
        f = new Float(3.1f);
        specStringMap.put(f, "V3.1");
        specVersionMap.put("ISO//Web3D//DTD X3D 3.1//EN", f);
        specVersionMap.put("ISO//Web3D//DTD X3D 3.1 Interchange//EN", f);
        specVersionMap.put("ISO//Web3D//DTD X3D 3.1 CADInterchange//EN", f);
        specVersionMap.put("ISO//Web3D//DTD X3D 3.1 Interactive//EN", f);
        specVersionMap.put("ISO//Web3D//DTD X3D 3.1 Immersive//EN", f);
        specVersionMap.put("ISO//Web3D//DTD X3D 3.1 Full//EN", f);
        allowedPublicIDs.add((Object)"ISO//Web3D//DTD X3D 3.1//EN");
        allowedPublicIDs.add((Object)"ISO//Web3D//DTD X3D 3.1 Interchange//EN");
        allowedPublicIDs.add((Object)"ISO//Web3D//DTD X3D 3.1 CADInterchange//EN");
        allowedPublicIDs.add((Object)"ISO//Web3D//DTD X3D 3.1 Interactive//EN");
        allowedPublicIDs.add((Object)"ISO//Web3D//DTD X3D 3.1 Immersive//EN");
        allowedPublicIDs.add((Object)"ISO//Web3D//DTD X3D 3.1 Full//EN");
        allowedPublicIDs.add((Object)"http://www.web3D.org/TaskGroups/x3d/translation/x3d-compact.dtd");
        allowedPublicIDs.add((Object)"http://www.web3d.org/specifications/x3d-3.0.dtd");
        allowedSystemIDs.add((Object)"http://www.web3d.org/specifications/x3d-3.1.dtd");
        fieldAccessMap = new HashMap();
        fieldAccessMap.put("inputOnly", new Integer(1));
        fieldAccessMap.put("outputOnly", new Integer(4));
        fieldAccessMap.put("inputOutput", new Integer(3));
        fieldAccessMap.put("initializeOnly", new Integer(2));
        elementMap = new HashMap();
        elementMap.put("X3D", new Integer(1));
        elementMap.put("head", new Integer(16));
        elementMap.put("component", new Integer(2));
        elementMap.put("Scene", new Integer(3));
        elementMap.put("ProtoDeclare", new Integer(4));
        elementMap.put("ProtoInterface", new Integer(17));
        elementMap.put("ProtoBody", new Integer(18));
        elementMap.put("ExternProtoDeclare", new Integer(5));
        elementMap.put("IS", new Integer(6));
        elementMap.put("field", new Integer(7));
        elementMap.put("meta", new Integer(8));
        elementMap.put("ProtoInstance", new Integer(9));
        elementMap.put("IMPORT", new Integer(10));
        elementMap.put("EXPORT", new Integer(11));
        elementMap.put("ROUTE", new Integer(12));
        elementMap.put("fieldValue", new Integer(13));
        elementMap.put("Script", new Integer(14));
        elementMap.put("connect", new Integer(15));
        attributeMap = new HashMap();
        attributeMap.put(DEF_ATTR, new Integer(2));
        attributeMap.put(USE_ATTR, new Integer(3));
        attributeMap.put(CLASS_ATTR, new Integer(4));
        attributeMap.put(CONTAINER_ATTR, new Integer(5));
    }
}

