/*
 * Decompiled with CFR 0.152.
 */
package de.baderjene.aistoolkit.aisparser.parser;

import de.baderjene.aistoolkit.aisparser.AISParserException;
import de.baderjene.aistoolkit.aisparser.message.Message;
import de.baderjene.aistoolkit.aisparser.message.RawMessage;
import de.baderjene.aistoolkit.aisparser.parser.ASCIIMapping;

public abstract class AbstractMessageParser {
    private final RawMessage rawMessage;
    private final String binary;

    public AbstractMessageParser(RawMessage rawMessage) {
        this.rawMessage = rawMessage;
        this.binary = rawMessage.getBinary();
    }

    public abstract Message parse() throws AISParserException;

    public RawMessage getRawMessage() {
        return this.rawMessage;
    }

    private String extract(int begin, int end) throws AISParserException {
        if (begin > this.binary.length() || end + 1 > this.binary.length()) {
            throw new AISParserException();
        }
        return this.binary.substring(begin, end + 1);
    }

    protected boolean parseBoolean(int position) throws AISParserException {
        return "1".equals(this.extract(position, position));
    }

    protected int parseInteger(int begin, int end) throws AISParserException {
        return Integer.parseInt(this.extract(begin, end), 2);
    }

    protected int parseSignedInteger(int begin, int end) throws AISParserException {
        boolean minus = this.binary.charAt(begin) == '1';
        String value = this.extract(begin, end);
        if (minus) {
            return (int)(-(Math.pow(2.0, value.length()) - (double)Math.abs(Integer.parseInt(value, 2))));
        }
        return Integer.parseInt(value.substring(1), 2);
    }

    protected String parseText(int begin, int end) throws AISParserException {
        StringBuilder builder = new StringBuilder();
        int length = end + 1 - begin;
        if (length % 6 != 0) {
            throw new AISParserException();
        }
        int count = length / 6;
        for (int i = 0; i < count; ++i) {
            int start = begin + i * 6;
            int current = this.parseInteger(start, start + 5);
            builder.append(ASCIIMapping.getChar(current));
        }
        while (builder.length() > 0 && builder.charAt(builder.length() - 1) == '@') {
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString().replace(" \\", "Z");
    }
}

