/*
 * Decompiled with CFR 0.152.
 */
package de.baderjene.aistoolkit.aisparser.parser;

import de.baderjene.aistoolkit.aisparser.message.Fragment;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FragmentParser {
    public Fragment parse(String aisInput) {
        Fragment fragment = null;
        Matcher matcher = Pattern.compile("\\!([A-Z]{5},(\\d),(\\d),\\d?,[AB12]?,(.*?),\\d)\\*([0-9A-F]{2})").matcher(aisInput);
        if (matcher.find()) {
            int currentChecksum = 0;
            for (char c : matcher.group(1).toCharArray()) {
                currentChecksum ^= c;
            }
            int expectedChecksum = Integer.parseInt(matcher.group(5), 16);
            if (currentChecksum == expectedChecksum) {
                int totalFragments = Integer.parseInt(matcher.group(2));
                int currentFragment = Integer.parseInt(matcher.group(3));
                String payload = matcher.group(4);
                fragment = new Fragment();
                fragment.setTotalFragments(totalFragments);
                fragment.setCurrentFragment(currentFragment);
                fragment.setPayload(payload);
            }
        }
        return fragment;
    }
}

