/*
 * Decompiled with CFR 0.152.
 */
package de.baderjene.aistoolkit.aisparser.parser;

import de.baderjene.aistoolkit.aisparser.AISParserException;
import de.baderjene.aistoolkit.aisparser.message.Message;
import de.baderjene.aistoolkit.aisparser.message.Message01;
import de.baderjene.aistoolkit.aisparser.message.RawMessage;
import de.baderjene.aistoolkit.aisparser.parser.AbstractMessageParser;

public class Message01Parser
extends AbstractMessageParser {
    public Message01Parser(RawMessage message) {
        super(message);
    }

    @Override
    public Message parse() throws AISParserException {
        RawMessage baseMessage = this.getRawMessage();
        int type = baseMessage.getType();
        int repeatIndicator = baseMessage.getRepeatIndicator();
        int sourceMmsi = baseMessage.getSourceMmsi();
        int navigationStatus = this.parseInteger(38, 41);
        int rateOfTurn = this.parseSignedInteger(42, 49);
        double speedOverGround = (double)this.parseInteger(50, 59) / 10.0;
        boolean positionAccurate = this.parseBoolean(60);
        double longitude = (double)this.parseSignedInteger(61, 88) / 600000.0;
        double latitude = (double)this.parseSignedInteger(89, 115) / 600000.0;
        double courseOverGround = (double)this.parseInteger(116, 127) / 10.0;
        int trueHeading = this.parseInteger(128, 136);
        int timestamp = this.parseInteger(137, 142);
        int maneuverIndicator = this.parseInteger(143, 144);
        boolean raimUsed = this.parseBoolean(148);
        int radioStatus = this.parseInteger(149, 167);
        Message01 message = new Message01();
        message.setType(type);
        message.setRepeatIndicator(repeatIndicator);
        message.setSourceMmsi(sourceMmsi);
        message.setNavigationStatus(navigationStatus);
        message.setRateOfTurn(rateOfTurn);
        message.setSpeedOverGround(speedOverGround);
        message.setPositionAccurate(positionAccurate);
        message.setLongitude(longitude);
        message.setLatitude(latitude);
        message.setCourseOverGround(courseOverGround);
        message.setTrueHeading(trueHeading);
        message.setTimestamp(timestamp);
        message.setManeuverIndicator(maneuverIndicator);
        message.setRaimUsed(raimUsed);
        message.setRadioStatus(radioStatus);
        return message;
    }
}

