/*
 * Decompiled with CFR 0.152.
 */
package de.baderjene.aistoolkit.aisparser.parser;

import de.baderjene.aistoolkit.aisparser.AISParserException;
import de.baderjene.aistoolkit.aisparser.message.Message;
import de.baderjene.aistoolkit.aisparser.message.Message05;
import de.baderjene.aistoolkit.aisparser.message.RawMessage;
import de.baderjene.aistoolkit.aisparser.parser.AbstractMessageParser;

public class Message05Parser
extends AbstractMessageParser {
    public Message05Parser(RawMessage message) {
        super(message);
    }

    @Override
    public Message parse() throws AISParserException {
        RawMessage baseMessage = this.getRawMessage();
        int type = baseMessage.getType();
        int repeatIndicator = baseMessage.getRepeatIndicator();
        int sourceMmsi = baseMessage.getSourceMmsi();
        int aisVersion = this.parseInteger(38, 39);
        int imoNumber = this.parseInteger(40, 69);
        String callSign = this.parseText(70, 111);
        String vesselName = this.parseText(112, 231);
        int shipType = this.parseInteger(232, 239);
        int dimensionToBow = this.parseInteger(240, 248);
        int dimensionToStern = this.parseInteger(249, 257);
        int dimensionToPort = this.parseInteger(258, 263);
        int dimensionToStarboard = this.parseInteger(264, 269);
        int positionFixType = this.parseInteger(270, 273);
        int etaMonth = this.parseInteger(274, 277);
        int etaDay = this.parseInteger(278, 282);
        int etaHour = this.parseInteger(283, 287);
        int etaMinute = this.parseInteger(288, 293);
        double draught = (double)this.parseInteger(294, 301) / 10.0;
        String destination = this.parseText(302, 421);
        boolean terminalReady = this.parseBoolean(422);
        Message05 message = new Message05();
        message.setType(type);
        message.setRepeatIndicator(repeatIndicator);
        message.setSourceMmsi(sourceMmsi);
        message.setAisVersion(aisVersion);
        message.setImoNumber(imoNumber);
        message.setCallSign(callSign);
        message.setVesselName(vesselName);
        message.setShipType(shipType);
        message.setDimensionToBow(dimensionToBow);
        message.setDimensionToStern(dimensionToStern);
        message.setDimensionToPort(dimensionToPort);
        message.setDimensionToStarboard(dimensionToStarboard);
        message.setPositionFixType(positionFixType);
        message.setEtaMonth(etaMonth);
        message.setEtaDay(etaDay);
        message.setEtaHour(etaHour);
        message.setEtaMinute(etaMinute);
        message.setDraught(draught);
        message.setDestination(destination);
        message.setTerminalReady(terminalReady);
        return message;
    }
}

