/*
 * Decompiled with CFR 0.152.
 */
package de.baderjene.aistoolkit.aisparser.parser;

import de.baderjene.aistoolkit.aisparser.AISParserException;
import de.baderjene.aistoolkit.aisparser.message.Message;
import de.baderjene.aistoolkit.aisparser.message.RawMessage;
import de.baderjene.aistoolkit.aisparser.parser.AbstractMessageParser;
import de.baderjene.aistoolkit.aisparser.parser.ParserFactory;

public class MessageParser
extends AbstractMessageParser {
    public MessageParser(RawMessage message) {
        super(message);
    }

    @Override
    public Message parse() {
        Message parsedMessage = null;
        try {
            int type = this.parseInteger(0, 5);
            RawMessage rawMessage = this.getRawMessage();
            rawMessage.setType(type);
            AbstractMessageParser parser = ParserFactory.create(rawMessage);
            if (parser != null) {
                int repeatIndicator = this.parseInteger(6, 7);
                int sourceMmsi = this.parseInteger(8, 37);
                rawMessage.setRepeatIndicator(repeatIndicator);
                rawMessage.setSourceMmsi(sourceMmsi);
                parsedMessage = parser.parse();
            }
        }
        catch (AISParserException e) {
            e.printStackTrace();
        }
        return parsedMessage;
    }
}

