/*
 * Decompiled with CFR 0.152.
 */
package de.baderjene.aistoolkit.aisparser.parser;

import de.baderjene.aistoolkit.aisparser.message.Fragment;
import de.baderjene.aistoolkit.aisparser.message.RawMessage;
import java.util.ArrayList;
import java.util.List;

public class RawMessageAssembler {
    private final List<Fragment> fragments = new ArrayList<Fragment>();

    public RawMessage addFragment(Fragment fragment) {
        int actualFragment = fragment.getCurrentFragment();
        int totalFragments = fragment.getTotalFragments();
        int expectedFragment = this.fragments.size() + 1;
        if (actualFragment == expectedFragment) {
            this.fragments.add(fragment);
        } else {
            this.fragments.clear();
            if (actualFragment == 1) {
                this.fragments.add(fragment);
            }
        }
        RawMessage message = null;
        if (totalFragments == this.fragments.size()) {
            message = new RawMessage();
            message.setFragments(new ArrayList<Fragment>(this.fragments));
            message.setBinary(this.getBinaryPayload());
            this.fragments.clear();
        }
        return message;
    }

    private String getBinaryPayload() {
        StringBuilder builder = new StringBuilder();
        for (Fragment fragment : this.fragments) {
            for (int n : fragment.getPayload().toCharArray()) {
                n = n < 89 ? (n -= 48) : (n -= 56);
                StringBuilder binary = new StringBuilder(Integer.toBinaryString(n));
                while (binary.length() < 6) {
                    binary.insert(0, "0");
                }
                builder.append((CharSequence)binary);
            }
        }
        return builder.toString();
    }
}

