/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DatabaseStats;
import com.sleepycat.je.DatabaseTrigger;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.DeleteConstraintException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.JoinConfig;
import com.sleepycat.je.JoinCursor;
import com.sleepycat.je.LockConflictException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationFailureException;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.PreloadConfig;
import com.sleepycat.je.PreloadStats;
import com.sleepycat.je.SecondaryDatabase;
import com.sleepycat.je.SecondaryTrigger;
import com.sleepycat.je.Sequence;
import com.sleepycat.je.SequenceConfig;
import com.sleepycat.je.SequenceExistsException;
import com.sleepycat.je.SequenceNotFoundException;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.VerifyConfig;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.GetMode;
import com.sleepycat.je.dbi.PutMode;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.LockerFactory;
import com.sleepycat.je.utilint.DatabaseUtil;
import com.sleepycat.je.utilint.LoggerUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Database {
    private volatile DbState state;
    private OperationFailureException preemptedCause;
    Environment envHandle;
    private DatabaseImpl databaseImpl;
    DatabaseConfig configuration;
    private boolean isWritable;
    private AtomicInteger openCursors = new AtomicInteger();
    Locker handleLocker;
    private List<DatabaseTrigger> triggerList;
    protected final Logger logger;

    protected Database(Environment env) {
        this.envHandle = env;
        this.handleLocker = null;
        this.logger = this.envHandle.getEnvironmentImpl().getLogger();
    }

    void initNew(Environment env, Locker locker, String databaseName, DatabaseConfig dbConfig) throws DatabaseException {
        dbConfig.validateForNewDb();
        this.init(env, dbConfig);
        EnvironmentImpl environmentImpl = DbInternal.getEnvironmentImpl(this.envHandle);
        this.databaseImpl = environmentImpl.getDbTree().createDb(locker, databaseName, dbConfig, this);
        this.databaseImpl.addReferringHandle(this);
        this.configuration.setReplicated(this.databaseImpl.isReplicated());
    }

    void initExisting(Environment env, Locker locker, DatabaseImpl dbImpl, DatabaseConfig dbConfig) throws DatabaseException {
        this.validateConfigAgainstExistingDb(dbConfig, dbImpl);
        this.init(env, dbConfig);
        this.databaseImpl = dbImpl;
        dbImpl.addReferringHandle(this);
        this.configuration.setSortedDuplicates(dbImpl.getSortedDuplicates());
        this.configuration.setTransactional(dbImpl.isTransactional());
        this.configuration.setReplicated(dbImpl.isReplicated());
    }

    private void init(Environment env, DatabaseConfig config) {
        this.handleLocker = null;
        this.envHandle = env;
        this.configuration = config.cloneConfig();
        this.isWritable = !this.configuration.getReadOnly();
        this.state = DbState.OPEN;
    }

    private void validateConfigAgainstExistingDb(DatabaseConfig config, DatabaseImpl dbImpl) throws DatabaseException {
        boolean newKeyPrefixing;
        if (!config.getUseExistingConfig()) {
            this.validatePropertyMatches("sortedDuplicates", dbImpl.getSortedDuplicates(), config.getSortedDuplicates());
            this.validatePropertyMatches("temporary", dbImpl.isTemporary(), config.getTemporary());
            if (this.envHandle.getEnvironmentImpl().isReplicated()) {
                if (dbImpl.unknownReplicated()) {
                    throw new UnsupportedOperationException("Conversion of standalone environments to replicated environments isn't supported yet");
                }
                this.validatePropertyMatches("replicated", dbImpl.isReplicated(), DbInternal.getReplicated(config));
            }
        }
        if (dbImpl.hasOpenHandles()) {
            if (!config.getUseExistingConfig()) {
                this.validatePropertyMatches("transactional", dbImpl.isTransactional(), config.getTransactional());
                this.validatePropertyMatches("deferredWrite", dbImpl.isDurableDeferredWrite(), config.getDeferredWrite());
            }
        } else {
            dbImpl.setTransactional(config.getTransactional());
            dbImpl.setDeferredWrite(config.getDeferredWrite());
        }
        boolean dbImplModified = false;
        if (config.getOverrideBtreeComparator()) {
            dbImplModified |= dbImpl.setBtreeComparator(config.getBtreeComparator(), config.getBtreeComparatorByClassName());
        }
        if (config.getOverrideDuplicateComparator()) {
            dbImplModified |= dbImpl.setDuplicateComparator(config.getDuplicateComparator(), config.getDuplicateComparatorByClassName());
        }
        if ((newKeyPrefixing = config.getKeyPrefixing()) != dbImpl.getKeyPrefixing()) {
            dbImplModified = true;
            if (newKeyPrefixing) {
                dbImpl.setKeyPrefixing();
            } else {
                dbImpl.clearKeyPrefixing();
            }
        }
        if (dbImplModified) {
            EnvironmentImpl envImpl = this.envHandle.getEnvironmentImpl();
            envImpl.getDbTree().modifyDbRoot(dbImpl);
        }
    }

    private void validatePropertyMatches(String propName, boolean existingValue, boolean newValue) throws IllegalArgumentException {
        if (newValue != existingValue) {
            throw new IllegalArgumentException("You can't open a Database with a " + propName + " configuration of " + newValue + " if the underlying database was created with a " + propName + " setting of " + existingValue + '.');
        }
    }

    public void close() throws DatabaseException {
        try {
            this.closeInternal(true, true, DbState.CLOSED, null);
        }
        catch (Error E) {
            DbInternal.getEnvironmentImpl(this.envHandle).invalidate(E);
            throw E;
        }
    }

    private void closeNoSync() throws DatabaseException {
        try {
            this.closeInternal(false, true, DbState.CLOSED, null);
        }
        catch (Error E) {
            DbInternal.getEnvironmentImpl(this.envHandle).invalidate(E);
            throw E;
        }
    }

    synchronized void setPreempted(String dbName, String msg) {
        OperationFailureException preemptedException = this.databaseImpl.getDbEnvironment().createDatabasePreemptedException(msg, dbName, this);
        this.closeInternal(false, false, DbState.PREEMPTED, preemptedException);
    }

    synchronized void invalidate() {
        this.closeInternal(false, false, DbState.INVALID, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeInternal(boolean doSyncDw, boolean deleteTempDb, DbState newState, OperationFailureException preemptedException) throws DatabaseException {
        StringBuffer errors = null;
        DatabaseImpl dbClosed = null;
        Database database = this;
        synchronized (database) {
            this.checkEnv();
            if (this.state != DbState.OPEN) {
                return;
            }
            this.state = newState;
            this.preemptedCause = preemptedException;
            if (newState == DbState.CLOSED && this.openCursors.get() != 0) {
                errors = new StringBuffer();
                errors.append("Database still has " + this.openCursors.get() + " open cursors while trying to close.");
            }
            this.trace(Level.FINEST, "Database.close: ", null, null);
            this.removeAllTriggers();
            this.envHandle.removeReferringHandle(this);
            if (this.databaseImpl != null) {
                dbClosed = this.databaseImpl;
                this.databaseImpl.removeReferringHandle(this);
                this.envHandle.getEnvironmentImpl().getDbTree().releaseDb(this.databaseImpl);
                this.databaseImpl = null;
                if (this.handleLocker != null) {
                    if (newState == DbState.PREEMPTED) {
                        this.handleLocker.setOnlyAbortable(preemptedException);
                    }
                    if (newState == DbState.CLOSED) {
                        this.handleLocker.setHandleLockOwner(true, this, true);
                        this.handleLocker.operationEnd(true);
                    } else {
                        this.handleLocker.operationEnd(false);
                    }
                }
            }
        }
        if (dbClosed != null) {
            dbClosed.handleClosed(doSyncDw, deleteTempDb);
        }
        if (errors != null) {
            throw new IllegalStateException(errors.toString());
        }
    }

    public void sync() throws DatabaseException, UnsupportedOperationException {
        this.checkEnv();
        this.checkOpen("Can't call Database.sync:");
        this.checkWritable("sync");
        this.trace(Level.FINEST, "Database.sync", null, null, null, null);
        this.databaseImpl.sync(true);
    }

    public Sequence openSequence(Transaction txn, DatabaseEntry key, SequenceConfig config) throws SequenceNotFoundException, SequenceExistsException {
        try {
            this.checkEnv();
            DatabaseUtil.checkForNullDbt(key, "key", true);
            this.checkOpen("Can't call Database.openSequence:");
            this.checkWritable("openSequence");
            this.trace(Level.FINEST, "Database.openSequence", txn, key, null, null);
            return new Sequence(this, txn, key, config);
        }
        catch (Error E) {
            DbInternal.getEnvironmentImpl(this.envHandle).invalidate(E);
            throw E;
        }
    }

    public void removeSequence(Transaction txn, DatabaseEntry key) throws DatabaseException {
        try {
            this.delete(txn, key);
        }
        catch (Error E) {
            DbInternal.getEnvironmentImpl(this.envHandle).invalidate(E);
            throw E;
        }
    }

    public Cursor openCursor(Transaction txn, CursorConfig cursorConfig) throws DatabaseException, IllegalArgumentException {
        try {
            CursorConfig useConfig;
            this.checkEnv();
            this.checkOpen("Can't open a cursor");
            CursorConfig cursorConfig2 = useConfig = cursorConfig == null ? CursorConfig.DEFAULT : cursorConfig;
            if (useConfig.getReadUncommitted() && useConfig.getReadCommitted()) {
                throw new IllegalArgumentException("Only one may be specified: ReadCommitted or ReadUncommitted");
            }
            this.trace(Level.FINEST, "Database.openCursor", txn, cursorConfig);
            Cursor ret = this.newDbcInstance(txn, useConfig);
            return ret;
        }
        catch (Error E) {
            DbInternal.getEnvironmentImpl(this.envHandle).invalidate(E);
            throw E;
        }
    }

    Cursor newDbcInstance(Transaction txn, CursorConfig cursorConfig) throws DatabaseException {
        return new Cursor(this, txn, cursorConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationStatus delete(Transaction txn, DatabaseEntry key) throws DeleteConstraintException, LockConflictException, DatabaseException, UnsupportedOperationException, IllegalArgumentException {
        OperationStatus operationStatus;
        block6: {
            this.checkEnv();
            DatabaseUtil.checkForNullDbt(key, "key", true);
            this.checkOpen("Can't call Database.delete:");
            this.checkWritable("delete");
            this.trace(Level.FINEST, "Database.delete", txn, key, null, null);
            OperationStatus commitStatus = OperationStatus.NOTFOUND;
            Locker locker = null;
            try {
                locker = LockerFactory.getWritableLocker(this.envHandle, txn, this.isTransactional(), this.databaseImpl.isReplicated());
                operationStatus = commitStatus = this.deleteInternal(locker, key, null);
                if (locker == null) break block6;
            }
            catch (Throwable throwable) {
                try {
                    if (locker != null) {
                        locker.operationEnd(commitStatus);
                    }
                    throw throwable;
                }
                catch (Error E) {
                    DbInternal.getEnvironmentImpl(this.envHandle).invalidate(E);
                    throw E;
                }
            }
            locker.operationEnd(commitStatus);
        }
        return operationStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OperationStatus deleteInternal(Locker locker, DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
        Cursor cursor = null;
        try {
            OperationStatus searchStatus;
            DatabaseEntry oldData;
            cursor = new Cursor(this, locker, null);
            cursor.setNonCloning(true);
            OperationStatus commitStatus = OperationStatus.NOTFOUND;
            if (data == null) {
                oldData = new DatabaseEntry();
                searchStatus = cursor.search(key, oldData, LockMode.RMW, CursorImpl.SearchMode.SET);
            } else {
                oldData = data;
                searchStatus = cursor.search(key, oldData, LockMode.RMW, CursorImpl.SearchMode.BOTH);
            }
            if (searchStatus == OperationStatus.SUCCESS) {
                do {
                    if (this.hasTriggers()) {
                        this.notifyTriggers(locker, key, oldData, null);
                    }
                    if ((commitStatus = cursor.deleteNoNotify(this.databaseImpl.getRepContext())) == OperationStatus.SUCCESS) continue;
                    OperationStatus operationStatus = commitStatus;
                    return operationStatus;
                } while (data == null && (searchStatus = this.databaseImpl.getSortedDuplicates() ? cursor.retrieveNext(key, oldData, LockMode.RMW, GetMode.NEXT_DUP) : OperationStatus.NOTFOUND) == OperationStatus.SUCCESS);
                commitStatus = OperationStatus.SUCCESS;
            }
            OperationStatus operationStatus = commitStatus;
            return operationStatus;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationStatus get(Transaction txn, DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws LockConflictException, DatabaseException, IllegalArgumentException {
        OperationStatus operationStatus;
        OperationStatus commitStatus;
        Locker locker;
        block9: {
            this.checkEnv();
            DatabaseUtil.checkForNullDbt(key, "key", true);
            DatabaseUtil.checkForNullDbt(data, "data", false);
            this.checkOpen("Can't call Database.get:");
            this.trace(Level.FINEST, "Database.get", txn, key, null, lockMode);
            CursorConfig cursorConfig = CursorConfig.DEFAULT;
            if (lockMode == LockMode.READ_COMMITTED) {
                cursorConfig = CursorConfig.READ_COMMITTED;
                lockMode = null;
            }
            this.checkLockModeWithoutTxn(txn, lockMode);
            locker = null;
            Cursor cursor = null;
            commitStatus = null;
            try {
                locker = LockerFactory.getReadableLocker(this.envHandle, txn, this.isTransactional(), false, cursorConfig.getReadCommitted());
                cursor = new Cursor(this, locker, cursorConfig);
                cursor.setNonCloning(true);
                operationStatus = commitStatus = cursor.search(key, data, lockMode, CursorImpl.SearchMode.SET);
                if (cursor == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (cursor != null) {
                        cursor.close();
                    }
                    if (locker != null) {
                        locker.operationEnd(commitStatus);
                    }
                    throw throwable;
                }
                catch (Error E) {
                    DbInternal.getEnvironmentImpl(this.envHandle).invalidate(E);
                    throw E;
                }
            }
            cursor.close();
        }
        if (locker != null) {
            locker.operationEnd(commitStatus);
        }
        return operationStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationStatus getSearchBoth(Transaction txn, DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws LockConflictException, DatabaseException, IllegalArgumentException {
        OperationStatus operationStatus;
        OperationStatus commitStatus;
        Locker locker;
        block9: {
            this.checkEnv();
            DatabaseUtil.checkForNullDbt(key, "key", true);
            DatabaseUtil.checkForNullDbt(data, "data", true);
            this.checkOpen("Can't call Database.getSearchBoth:");
            this.trace(Level.FINEST, "Database.getSearchBoth", txn, key, data, lockMode);
            CursorConfig cursorConfig = CursorConfig.DEFAULT;
            if (lockMode == LockMode.READ_COMMITTED) {
                cursorConfig = CursorConfig.READ_COMMITTED;
                lockMode = null;
            }
            this.checkLockModeWithoutTxn(txn, lockMode);
            locker = null;
            Cursor cursor = null;
            commitStatus = null;
            try {
                locker = LockerFactory.getReadableLocker(this.envHandle, txn, this.isTransactional(), false, cursorConfig.getReadCommitted());
                cursor = new Cursor(this, locker, cursorConfig);
                cursor.setNonCloning(true);
                operationStatus = commitStatus = cursor.search(key, data, lockMode, CursorImpl.SearchMode.BOTH);
                if (cursor == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (cursor != null) {
                        cursor.close();
                    }
                    if (locker != null) {
                        locker.operationEnd(commitStatus);
                    }
                    throw throwable;
                }
                catch (Error E) {
                    DbInternal.getEnvironmentImpl(this.envHandle).invalidate(E);
                    throw E;
                }
            }
            cursor.close();
        }
        if (locker != null) {
            locker.operationEnd(commitStatus);
        }
        return operationStatus;
    }

    public OperationStatus put(Transaction txn, DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
        this.checkEnv();
        DatabaseUtil.checkForNullDbt(key, "key", true);
        DatabaseUtil.checkForNullDbt(data, "data", true);
        DatabaseUtil.checkForPartialKey(key);
        this.checkOpen("Can't call Database.put");
        this.checkWritable("put");
        this.trace(Level.FINEST, "Database.put", txn, key, data, null);
        return this.putInternal(txn, key, data, PutMode.OVERWRITE);
    }

    public OperationStatus putNoOverwrite(Transaction txn, DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
        this.checkEnv();
        DatabaseUtil.checkForNullDbt(key, "key", true);
        DatabaseUtil.checkForNullDbt(data, "data", true);
        DatabaseUtil.checkForPartialKey(key);
        this.checkOpen("Can't call Database.putNoOverWrite");
        this.checkWritable("putNoOverwrite");
        this.trace(Level.FINEST, "Database.putNoOverwrite", txn, key, data, null);
        return this.putInternal(txn, key, data, PutMode.NO_OVERWRITE);
    }

    public OperationStatus putNoDupData(Transaction txn, DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
        this.checkEnv();
        DatabaseUtil.checkForNullDbt(key, "key", true);
        DatabaseUtil.checkForNullDbt(data, "data", true);
        DatabaseUtil.checkForPartialKey(key);
        this.checkOpen("Can't call Database.putNoDupData");
        if (!this.databaseImpl.getSortedDuplicates()) {
            throw new UnsupportedOperationException("Database is not configured for duplicate data.");
        }
        this.checkWritable("putNoDupData");
        this.trace(Level.FINEST, "Database.putNoDupData", txn, key, data, null);
        return this.putInternal(txn, key, data, PutMode.NO_DUP_DATA);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OperationStatus putInternal(Transaction txn, DatabaseEntry key, DatabaseEntry data, PutMode putMode) throws DatabaseException {
        OperationStatus operationStatus;
        OperationStatus commitStatus;
        Locker locker;
        block8: {
            locker = null;
            Cursor cursor = null;
            commitStatus = OperationStatus.KEYEXIST;
            try {
                locker = LockerFactory.getWritableLocker(this.envHandle, txn, this.isTransactional(), this.databaseImpl.isReplicated());
                cursor = new Cursor(this, locker, null);
                cursor.setNonCloning(true);
                operationStatus = commitStatus = cursor.putInternal(key, data, putMode);
                if (cursor == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (cursor != null) {
                        cursor.close();
                    }
                    if (locker != null) {
                        locker.operationEnd(commitStatus);
                    }
                    throw throwable;
                }
                catch (Error E) {
                    DbInternal.getEnvironmentImpl(this.envHandle).invalidate(E);
                    throw E;
                }
            }
            cursor.close();
        }
        if (locker != null) {
            locker.operationEnd(commitStatus);
        }
        return operationStatus;
    }

    public JoinCursor join(Cursor[] cursors, JoinConfig config) throws DatabaseException, IllegalArgumentException {
        try {
            this.checkEnv();
            this.checkOpen("Can't call Database.join");
            DatabaseUtil.checkForNullParam(cursors, "cursors");
            if (cursors.length == 0) {
                throw new IllegalArgumentException("At least one cursor is required.");
            }
            Locker locker = cursors[0].getCursorImpl().getLocker();
            if (!locker.isTransactional()) {
                EnvironmentImpl env = this.envHandle.getEnvironmentImpl();
                for (int i = 1; i < cursors.length; ++i) {
                    Locker locker2 = cursors[i].getCursorImpl().getLocker();
                    if (locker2.isTransactional()) {
                        throw new IllegalArgumentException("All cursors must use the same transaction.");
                    }
                    EnvironmentImpl env2 = cursors[i].getDatabaseImpl().getDbEnvironment();
                    if (env == env2) continue;
                    throw new IllegalArgumentException("All cursors must use the same environment.");
                }
                locker = null;
            } else {
                for (int i = 1; i < cursors.length; ++i) {
                    Locker locker2 = cursors[i].getCursorImpl().getLocker();
                    if (locker.getTxnLocker() == locker2.getTxnLocker()) continue;
                    throw new IllegalArgumentException("All cursors must use the same transaction.");
                }
            }
            return new JoinCursor(locker, this, cursors, config);
        }
        catch (Error E) {
            DbInternal.getEnvironmentImpl(this.envHandle).invalidate(E);
            throw E;
        }
    }

    public void preload(long maxBytes) throws DatabaseException {
        this.checkEnv();
        this.checkOpen("Can't call Database.preload");
        PreloadConfig config = new PreloadConfig();
        config.setMaxBytes(maxBytes);
        this.databaseImpl.preload(config);
    }

    public void preload(long maxBytes, long maxMillisecs) throws DatabaseException {
        this.checkEnv();
        this.checkOpen("Can't call Database.preload");
        PreloadConfig config = new PreloadConfig();
        config.setMaxBytes(maxBytes);
        config.setMaxMillisecs(maxMillisecs);
        this.databaseImpl.preload(config);
    }

    public PreloadStats preload(PreloadConfig config) throws DatabaseException {
        this.checkEnv();
        this.checkOpen("Can't call Database.preload");
        PreloadConfig useConfig = config == null ? new PreloadConfig() : config;
        return this.databaseImpl.preload(useConfig);
    }

    public long count() throws DatabaseException {
        this.checkEnv();
        this.checkOpen("Can't call Database.count");
        return this.databaseImpl.count();
    }

    public DatabaseStats getStats(StatsConfig config) throws DatabaseException {
        StatsConfig useConfig;
        this.checkEnv();
        this.checkOpen("Can't call Database.stat");
        StatsConfig statsConfig = useConfig = config == null ? StatsConfig.DEFAULT : config;
        if (this.databaseImpl != null) {
            return this.databaseImpl.stat(useConfig);
        }
        return null;
    }

    public DatabaseStats verify(VerifyConfig config) throws DatabaseException {
        try {
            this.checkEnv();
            this.checkOpen("Can't call Database.verify");
            VerifyConfig useConfig = config == null ? VerifyConfig.DEFAULT : config;
            DatabaseStats stats = this.databaseImpl.getEmptyStats();
            this.databaseImpl.verify(useConfig, stats);
            return stats;
        }
        catch (Error E) {
            DbInternal.getEnvironmentImpl(this.envHandle).invalidate(E);
            throw E;
        }
    }

    public String getDatabaseName() throws DatabaseException {
        try {
            this.checkEnv();
            if (this.databaseImpl != null) {
                return this.databaseImpl.getName();
            }
            return null;
        }
        catch (Error E) {
            DbInternal.getEnvironmentImpl(this.envHandle).invalidate(E);
            throw E;
        }
    }

    String getDebugName() {
        if (this.databaseImpl != null) {
            return this.databaseImpl.getDebugName();
        }
        return null;
    }

    public DatabaseConfig getConfig() throws DatabaseException {
        try {
            DatabaseConfig showConfig = this.configuration.cloneConfig();
            Comparator<byte[]> btComp = null;
            Comparator<byte[]> dupComp = null;
            boolean btCompByClass = false;
            boolean dupCompByClass = false;
            if (this.databaseImpl != null) {
                btComp = this.databaseImpl.getBtreeComparator();
                dupComp = this.databaseImpl.getDuplicateComparator();
                btCompByClass = this.databaseImpl.getBtreeComparatorByClass();
                dupCompByClass = this.databaseImpl.getDuplicateComparatorByClass();
            }
            showConfig.setBtreeComparatorInternal(btComp, btCompByClass);
            showConfig.setDuplicateComparatorInternal(dupComp, dupCompByClass);
            return showConfig;
        }
        catch (Error E) {
            DbInternal.getEnvironmentImpl(this.envHandle).invalidate(E);
            throw E;
        }
    }

    boolean isTransactional() {
        return this.databaseImpl.isTransactional();
    }

    public Environment getEnvironment() {
        return this.envHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SecondaryDatabase> getSecondaryDatabases() throws DatabaseException {
        try {
            ArrayList<SecondaryDatabase> list = new ArrayList<SecondaryDatabase>();
            if (this.hasTriggers()) {
                this.acquireTriggerListReadLock();
                try {
                    for (int i = 0; i < this.triggerList.size(); ++i) {
                        DatabaseTrigger t = this.triggerList.get(i);
                        if (!(t instanceof SecondaryTrigger)) continue;
                        list.add(((SecondaryTrigger)t).getDb());
                    }
                }
                finally {
                    this.releaseTriggerListReadLock();
                }
            }
            return list;
        }
        catch (Error E) {
            DbInternal.getEnvironmentImpl(this.envHandle).invalidate(E);
            throw E;
        }
    }

    public int compareKeys(DatabaseEntry entry1, DatabaseEntry entry2) {
        return this.doCompareKeys(entry1, entry2, false);
    }

    public int compareDuplicates(DatabaseEntry entry1, DatabaseEntry entry2) {
        return this.doCompareKeys(entry1, entry2, true);
    }

    private int doCompareKeys(DatabaseEntry entry1, DatabaseEntry entry2, boolean duplicates) {
        try {
            this.checkEnv();
            DatabaseUtil.checkForNullDbt(entry1, "entry1", true);
            DatabaseUtil.checkForNullDbt(entry2, "entry2", true);
            DatabaseUtil.checkForPartialKey(entry1);
            DatabaseUtil.checkForPartialKey(entry2);
            return this.databaseImpl.compareEntries(entry1, entry2, duplicates);
        }
        catch (Error E) {
            DbInternal.getEnvironmentImpl(this.envHandle).invalidate(E);
            throw E;
        }
    }

    boolean isWritable() {
        return this.isWritable;
    }

    DatabaseImpl getDatabaseImpl() {
        return this.databaseImpl;
    }

    void setHandleLocker(Locker locker) {
        this.handleLocker = locker;
    }

    void removeCursor(Cursor dbc) throws DatabaseException {
        if (this.state != DbState.PREEMPTED) {
            this.checkOpen("Database was closed while still in use:");
        }
        this.openCursors.getAndDecrement();
    }

    void addCursor(Cursor dbc) throws DatabaseException {
        this.checkOpen("Database was closed while still in use:");
        this.openCursors.getAndIncrement();
    }

    void checkOpen(String msg) {
        switch (this.state) {
            case OPEN: {
                break;
            }
            case CLOSED: {
                throw new IllegalStateException(msg + " Database was closed.");
            }
            case INVALID: {
                throw new IllegalStateException(msg + " The Transaction used to open the Database was aborted.");
            }
            case PREEMPTED: {
                throw this.preemptedCause.wrapSelf(msg);
            }
            default: {
                assert (false) : this.state;
                break;
            }
        }
    }

    void checkEnv() throws EnvironmentFailureException {
        EnvironmentImpl env = this.envHandle.getEnvironmentImpl();
        if (env != null) {
            env.checkIfInvalid();
        }
    }

    private void checkWritable(String operation) {
        if (!this.isWritable) {
            throw new UnsupportedOperationException("Database is Read Only: " + operation);
        }
    }

    void checkLockModeWithoutTxn(Transaction userTxn, LockMode lockMode) {
        if (userTxn == null && LockMode.RMW.equals((Object)lockMode)) {
            throw new IllegalArgumentException((Object)((Object)lockMode) + " is meaningless and can not be specified " + "when a null (autocommit) transaction is used. There " + "will never be a follow on operation which will promote " + "the lock to WRITE.");
        }
    }

    void trace(Level level, String methodName, Transaction txn, DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        if (this.logger.isLoggable(level)) {
            StringBuffer sb = new StringBuffer();
            sb.append(methodName);
            if (txn != null) {
                sb.append(" txnId=").append(txn.getId());
            }
            sb.append(" key=").append(key.dumpData());
            if (data != null) {
                sb.append(" data=").append(data.dumpData());
            }
            if (lockMode != null) {
                sb.append(" lockMode=").append((Object)lockMode);
            }
            LoggerUtils.logMsg(this.logger, this.envHandle.getEnvironmentImpl(), level, sb.toString());
        }
    }

    void trace(Level level, String methodName, Transaction txn, CursorConfig config) throws DatabaseException {
        if (this.logger.isLoggable(level)) {
            StringBuffer sb = new StringBuffer();
            sb.append(methodName);
            sb.append(" name=" + this.getDebugName());
            if (txn != null) {
                sb.append(" txnId=").append(txn.getId());
            }
            if (config != null) {
                sb.append(" config=").append(config);
            }
            LoggerUtils.logMsg(this.logger, this.envHandle.getEnvironmentImpl(), level, sb.toString());
        }
    }

    boolean hasTriggers() {
        return this.triggerList != null;
    }

    private void acquireTriggerListReadLock() throws DatabaseException {
        EnvironmentImpl env = this.envHandle.getEnvironmentImpl();
        env.getTriggerLatch().acquireShared();
        if (this.triggerList == null) {
            this.triggerList = new ArrayList<DatabaseTrigger>();
        }
    }

    private void releaseTriggerListReadLock() throws DatabaseException {
        EnvironmentImpl env = this.envHandle.getEnvironmentImpl();
        env.getTriggerLatch().release();
    }

    private void acquireTriggerListWriteLock() throws DatabaseException {
        EnvironmentImpl env = this.envHandle.getEnvironmentImpl();
        env.getTriggerLatch().acquireExclusive();
        if (this.triggerList == null) {
            this.triggerList = new ArrayList<DatabaseTrigger>();
        }
    }

    private void releaseTriggerListWriteLock() throws DatabaseException {
        if (this.triggerList.size() == 0) {
            this.triggerList = null;
        }
        EnvironmentImpl env = this.envHandle.getEnvironmentImpl();
        env.getTriggerLatch().release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addTrigger(DatabaseTrigger trigger, boolean insertAtFront) throws DatabaseException {
        this.acquireTriggerListWriteLock();
        try {
            if (insertAtFront) {
                this.triggerList.add(0, trigger);
            } else {
                this.triggerList.add(trigger);
            }
            trigger.triggerAdded(this);
        }
        finally {
            this.releaseTriggerListWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeTrigger(DatabaseTrigger trigger) throws DatabaseException {
        this.acquireTriggerListWriteLock();
        try {
            this.triggerList.remove(trigger);
            trigger.triggerRemoved(this);
        }
        finally {
            this.releaseTriggerListWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAllTriggers() throws DatabaseException {
        this.acquireTriggerListWriteLock();
        try {
            for (int i = 0; i < this.triggerList.size(); ++i) {
                DatabaseTrigger trigger = this.triggerList.get(i);
                trigger.triggerRemoved(this);
            }
            this.triggerList.clear();
        }
        finally {
            this.releaseTriggerListWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyTriggers(Locker locker, DatabaseEntry priKey, DatabaseEntry oldData, DatabaseEntry newData) throws DatabaseException {
        this.acquireTriggerListReadLock();
        try {
            for (int i = 0; i < this.triggerList.size(); ++i) {
                DatabaseTrigger trigger = this.triggerList.get(i);
                trigger.databaseUpdated(this, locker, priKey, oldData, newData);
            }
        }
        finally {
            this.releaseTriggerListReadLock();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum DbState {
        OPEN,
        CLOSED,
        INVALID,
        PREEMPTED;

    }
}

