/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.jni.netcdf;

import java.util.List;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Variable;
import ucar.nc2.jni.netcdf.Nc4Chunking;

public class Nc4ChunkingDefault
implements Nc4Chunking {
    private static final int DEFAULT_CHUNKSIZE = (int)Math.pow(2.0, 22.0);

    @Override
    public long[] computeChunking(Variable v) {
        Attribute att = v.findAttribute("_ChunkSize");
        if (att != null && att.getDataType().isIntegral() && att.getLength() == v.getRank()) {
            long[] result = new long[v.getRank()];
            for (int i = 0; i < v.getRank(); ++i) {
                result[i] = att.getNumericValue(i).longValue();
            }
            return result;
        }
        long size = v.getSize();
        if (size < (long)DEFAULT_CHUNKSIZE) {
            return this.convert(v.getShape());
        }
        List<Dimension> dims = v.getDimensions();
        long[] result = new long[dims.size()];
        int count = 0;
        for (Dimension d : dims) {
            if (d.isUnlimited()) {
                result[count++] = 1L;
                continue;
            }
            result[count++] = d.getLength();
        }
        return result;
    }

    private long[] convert(int[] shape) {
        if (shape.length == 0) {
            shape = new int[1];
        }
        long[] result = new long[shape.length];
        for (int i = 0; i < shape.length; ++i) {
            result[i] = shape[i] > 0 ? (long)shape[i] : 1L;
        }
        return result;
    }
}

