/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import ucar.grib.grib2.ParameterTable;
import ucar.nc2.Attribute;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.grib.grib2.table.WmoCodeTable;
import ucar.nc2.iosp.grid.GridParameter;
import ucar.nc2.ui.widget.BAMutil;
import ucar.nc2.ui.widget.FileManager;
import ucar.nc2.ui.widget.IndependentWindow;
import ucar.nc2.ui.widget.PopupMenu;
import ucar.nc2.ui.widget.TextHistoryPane;
import ucar.nc2.units.SimpleUnit;
import ucar.unidata.util.StringUtil2;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.BeanTableSorted;

public class GribWmoCodesPanel
extends JPanel {
    private PreferencesExt prefs;
    private BeanTableSorted codeTable;
    private BeanTableSorted entryTable;
    private JSplitPane split;
    private JSplitPane split2;
    private TextHistoryPane compareTA;
    private IndependentWindow infoWindow;
    private FileManager fileChooser;
    private WmoCodeTable.Version currTable = null;
    private boolean showSame = false;
    private boolean showCase = false;
    private boolean showUnknown = false;
    private char[] remove = new char[]{'(', ')', ' ', '\"', ',', '*', '-'};
    private String[] replace = new String[]{"", "", "", "", "", "", ""};

    public GribWmoCodesPanel(PreferencesExt prefs, JPanel buttPanel) {
        this.prefs = prefs;
        this.codeTable = new BeanTableSorted(CodeTableBean.class, (PreferencesExt)prefs.node("CodeTableBean"), false);
        this.codeTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                CodeTableBean csb = (CodeTableBean)GribWmoCodesPanel.this.codeTable.getSelectedBean();
                GribWmoCodesPanel.this.setEntries(csb.codeTable);
            }
        });
        PopupMenu varPopup = new PopupMenu(this.codeTable.getJTable(), "Options");
        varPopup.addAction("Show table", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Formatter out = new Formatter();
                CodeTableBean csb = (CodeTableBean)GribWmoCodesPanel.this.codeTable.getSelectedBean();
                csb.showTable(out);
                GribWmoCodesPanel.this.compareTA.setText(out.toString());
                GribWmoCodesPanel.this.compareTA.gotoTop();
                GribWmoCodesPanel.this.infoWindow.setVisible(true);
            }
        });
        this.entryTable = new BeanTableSorted(EntryBean.class, (PreferencesExt)prefs.node("EntryBean"), false);
        this.entryTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                EntryBean csb = (EntryBean)GribWmoCodesPanel.this.entryTable.getSelectedBean();
            }
        });
        AbstractButton compareButton = BAMutil.makeButtcon("Select", "Compare to 4.2 table", false);
        compareButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GribWmoCodesPanel.this.compareToCurrent();
            }
        });
        buttPanel.add(compareButton);
        AbstractButton compare2Button = BAMutil.makeButtcon("Select", "Compare to standard WMO table", false);
        compare2Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GribWmoCodesPanel.this.compareToStandardWMO();
            }
        });
        buttPanel.add(compare2Button);
        AbstractButton dupButton = BAMutil.makeButtcon("Select", "Look for problems in this table", false);
        dupButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GribWmoCodesPanel.this.lookForProblems();
            }
        });
        buttPanel.add(dupButton);
        AbstractButton modelsButton = BAMutil.makeButtcon("Select", "Check current models", false);
        modelsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    GribWmoCodesPanel.this.checkCurrentModels();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        });
        buttPanel.add(modelsButton);
        this.compareTA = new TextHistoryPane();
        this.infoWindow = new IndependentWindow("Extra Information", BAMutil.getImage("netcdfUI"), this.compareTA);
        this.infoWindow.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", new Rectangle(300, 300, 800, 600)));
        this.split = new JSplitPane(0, false, this.codeTable, this.entryTable);
        this.split.setDividerLocation(prefs.getInt("splitPos", 500));
        this.setLayout(new BorderLayout());
        this.add((Component)this.split, "Center");
    }

    public void setTable(WmoCodeTable.Version v) {
        try {
            WmoCodeTable.WmoTables wmo = WmoCodeTable.readGribCodes(v);
            List<WmoCodeTable> codes = wmo.list;
            ArrayList<CodeTableBean> dds = new ArrayList<CodeTableBean>(codes.size());
            for (WmoCodeTable code : codes) {
                dds.add(new CodeTableBean(code));
            }
            this.codeTable.setBeans(dds);
            this.currTable = v;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void save() {
        this.codeTable.saveState(false);
        this.entryTable.saveState(false);
        this.prefs.putBeanObject("InfoWindowBounds", this.infoWindow.getBounds());
        this.prefs.putInt("splitPos", this.split.getDividerLocation());
        if (this.fileChooser != null) {
            this.fileChooser.save();
        }
    }

    public void setEntries(WmoCodeTable codeTable) {
        ArrayList<EntryBean> beans = new ArrayList<EntryBean>(codeTable.entries.size());
        for (WmoCodeTable.TableEntry d : codeTable.entries) {
            beans.add(new EntryBean(d));
        }
        this.entryTable.setBeans(beans);
    }

    private void lookForProblems() {
        WmoCodeTable gt;
        int total = 0;
        int dups = 0;
        HashMap<String, WmoCodeTable.TableEntry> paramSet = new HashMap<String, WmoCodeTable.TableEntry>();
        Formatter f = new Formatter();
        f.format("WMO parameter table %s%n", new Object[]{this.currTable});
        f.format("%nDuplicates Names%n", new Object[0]);
        for (Object t : this.codeTable.getBeans()) {
            gt = ((CodeTableBean)t).codeTable;
            if (!gt.isParameter) continue;
            for (WmoCodeTable.TableEntry p : gt.entries) {
                if (p.meaning.equalsIgnoreCase("Reserved") || p.meaning.equalsIgnoreCase("Missing") || p.start != p.stop) continue;
                WmoCodeTable.TableEntry pdup = (WmoCodeTable.TableEntry)paramSet.get(p.name);
                if (pdup != null) {
                    f.format("Duplicate %s%n", p);
                    f.format("          %s%n%n", pdup);
                    ++dups;
                } else {
                    paramSet.put(p.name, p);
                }
                ++total;
            }
        }
        f.format("%nTotal=%d dups=%d%n%n", total, dups);
        total = 0;
        dups = 0;
        f.format("Names with parenthesis%n", new Object[0]);
        for (Object t : this.codeTable.getBeans()) {
            gt = ((CodeTableBean)t).codeTable;
            if (!gt.isParameter) continue;
            for (WmoCodeTable.TableEntry p : gt.entries) {
                if (p.meaning.indexOf(40) > 0) {
                    f.format("  %s:%n  org='%s'%n name='%s' %n%n", p.getId(), p.meaning, p.name);
                    ++dups;
                }
                ++total;
            }
        }
        f.format("%nTotal=%d parens=%d%n%n", total, dups);
        total = 0;
        dups = 0;
        f.format("non-udunits%n", new Object[0]);
        for (Object t : this.codeTable.getBeans()) {
            gt = ((CodeTableBean)t).codeTable;
            if (!gt.isParameter) continue;
            for (WmoCodeTable.TableEntry p : gt.entries) {
                if (p.unit == null || p.unit.length() == 0) continue;
                try {
                    SimpleUnit su = SimpleUnit.factoryWithExceptions(p.unit);
                    if (su.isUnknownUnit()) {
                        f.format("%s %s has UNKNOWN udunit%n", p.getId(), p.unit);
                        ++dups;
                    }
                }
                catch (Exception ioe) {
                    f.format("%s %s FAILS on udunit parse%n", p.getId(), p.unit);
                    ++dups;
                }
                ++total;
            }
        }
        f.format("%nTotal=%d problems=%d%n%n", total, dups);
        this.compareTA.setText(f.toString());
        this.infoWindow.show();
    }

    private void compareToCurrent() {
        int total = 0;
        int nsame = 0;
        int nsameIgn = 0;
        int ndiff = 0;
        int unknownCount = 0;
        Formatter f = new Formatter();
        f.format("DIFFERENCES of %s with 4.2 standard parameter table%n", new Object[]{this.currTable});
        List tables = this.codeTable.getBeans();
        for (Object t : tables) {
            WmoCodeTable gt = ((CodeTableBean)t).codeTable;
            if (!gt.isParameter) continue;
            for (WmoCodeTable.TableEntry p : gt.entries) {
                boolean sameIgnore;
                boolean same;
                if (p.meaning.equalsIgnoreCase("Reserved") || p.meaning.equalsIgnoreCase("Missing") || p.start != p.stop) continue;
                GridParameter gp = ParameterTable.getParameter(gt.discipline, gt.category, p.start);
                String paramDesc = gp.getDescription();
                boolean unknown = paramDesc.startsWith("Unknown");
                if (unknown) {
                    ++unknownCount;
                }
                if (same = paramDesc.equals(p.name)) {
                    ++nsame;
                }
                if (sameIgnore = paramDesc.equalsIgnoreCase(p.name)) {
                    ++nsameIgn;
                } else {
                    ++ndiff;
                }
                ++total;
                String unitsCurr = gp.getUnit();
                String unitsWmo = p.unit;
                boolean sameUnits = unitsWmo == null ? unitsCurr == null : unitsWmo.equals(unitsCurr);
                boolean bl = same = same && sameUnits;
                if (unknown && !this.showUnknown || same && !this.showSame || sameIgnore && !this.showCase) continue;
                String state = same ? "  " : (sameIgnore ? "* " : "**");
                f.format("%s%d %d %d (%d)%n wmo =%s%n curr=%s%n", state, gt.discipline, gt.category, p.start, p.line, p.name, paramDesc);
                if (sameUnits) continue;
                f.format(" units wmo='%s' curr='%s' %n", unitsWmo, unitsCurr);
            }
        }
        f.format("%nTotal=%d same=%d sameIgnoreCase=%d dif=%d unknown=%d%n", total, nsame, nsameIgn, ndiff, unknownCount);
        this.compareTA.setText(f.toString());
        this.infoWindow.show();
    }

    private void compareToStandardWMO() {
        int total = 0;
        int nsame = 0;
        int nsameIgn = 0;
        int ndiff = 0;
        int unknownCount = 0;
        int missingCount = 0;
        Formatter f = new Formatter();
        f.format("DIFFERENCES of %s with standard WMO table%n", new Object[]{this.currTable});
        List tables = this.codeTable.getBeans();
        for (Object t : tables) {
            WmoCodeTable gt = ((CodeTableBean)t).codeTable;
            if (!gt.isParameter) continue;
            for (WmoCodeTable.TableEntry p : gt.entries) {
                boolean sameIgnore;
                boolean same;
                if (p.meaning.equalsIgnoreCase("Reserved") || p.meaning.equalsIgnoreCase("Missing") || p.start != p.stop) continue;
                WmoCodeTable.TableEntry wmo = WmoCodeTable.getParameterEntry(gt.discipline, gt.category, p.start);
                if (wmo == null) {
                    ++missingCount;
                    f.format(" NEW %d %d %d %s (%s)%n", gt.discipline, gt.category, p.start, p.name, p.unit);
                    continue;
                }
                String paramDesc = wmo.getName();
                boolean unknown = paramDesc.startsWith("Unknown");
                if (unknown) {
                    ++unknownCount;
                }
                if (same = paramDesc.equals(p.name)) {
                    ++nsame;
                }
                if (sameIgnore = paramDesc.equalsIgnoreCase(p.name)) {
                    ++nsameIgn;
                } else {
                    ++ndiff;
                }
                ++total;
                String unitsCurr = wmo.getUnit();
                String unitsWmo = p.unit;
                boolean sameUnits = unitsWmo == null ? unitsCurr == null : unitsWmo.equals(unitsCurr);
                boolean bl = same = same && sameUnits;
                if (unknown && !this.showUnknown || same && !this.showSame || sameIgnore && !this.showCase) continue;
                String state = same ? "  " : (sameIgnore ? "* " : "**");
                f.format("%s%d %d %d (%d)%n this =%s%n wmo=%s%n", state, gt.discipline, gt.category, p.start, p.line, p.name, paramDesc);
                if (sameUnits) continue;
                f.format(" units this='%s' wmo='%s' %n", unitsWmo, unitsCurr);
            }
        }
        f.format("%nTotal=%d same=%d sameIgnoreCase=%d dif=%d unknown=%d new=%d%n", total, nsame, nsameIgn, ndiff, unknownCount, missingCount);
        this.compareTA.setText(f.toString());
        this.infoWindow.show();
    }

    private boolean equiv(String org1, String org2) {
        String s1 = StringUtil2.replace(org1, this.remove, this.replace).toLowerCase();
        String s2 = StringUtil2.replace(org2, this.remove, this.replace).toLowerCase();
        return s1.equals(s2);
    }

    private boolean equivUnits(String unitS1, String unitS2) {
        String lower2;
        String lower1 = unitS1.toLowerCase();
        if (lower1.equals(lower2 = unitS2.toLowerCase())) {
            return true;
        }
        if (lower1.startsWith("code") && lower2.startsWith("code")) {
            return true;
        }
        if (lower1.startsWith("flag") && lower2.startsWith("flag")) {
            return true;
        }
        if (unitS1.startsWith("CCITT") && unitS2.startsWith("CCITT")) {
            return true;
        }
        try {
            return SimpleUnit.isCompatibleWithExceptions(unitS1, unitS2);
        }
        catch (Exception e) {
            return this.equiv(unitS1, unitS2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkCurrentModels() throws IOException {
        int total = 0;
        int nsame = 0;
        int nsameIgn = 0;
        int ndiff = 0;
        int unknownCount = 0;
        String dirName = "F:/data/cdmUnitTest/tds/normal";
        Formatter fm = new Formatter();
        fm.format("Check Current Models in directory %s%n", dirName);
        File allDir = new File(dirName);
        File[] allFiles = allDir.listFiles();
        List<File> flist = Arrays.asList(allFiles);
        Collections.sort(flist);
        for (File f : flist) {
            String name = f.getAbsolutePath();
            if (f.isDirectory() || !name.endsWith(".grib2")) continue;
            fm.format("Check file %s%n", name);
            GridDataset ncfile = null;
            try {
                ncfile = GridDataset.open(name);
                for (GridDatatype dt : ncfile.getGrids()) {
                    String currName = dt.getFullName().toLowerCase();
                    Attribute att = dt.findAttributeIgnoreCase("Grib_Parameter");
                    if (att == null || att.getLength() != 3) continue;
                    int discipline = (Integer)att.getValue(0);
                    int category = (Integer)att.getValue(1);
                    int number = (Integer)att.getValue(2);
                    if (number >= 192) continue;
                    WmoCodeTable.TableEntry entry = WmoCodeTable.getParameterEntry(discipline, category, number);
                    if (entry == null) {
                        fm.format("%n%d %d %d CANT FIND %s%n", discipline, category, number, currName);
                        continue;
                    }
                    String wmoName = entry.name.toLowerCase();
                    boolean same = currName.startsWith(wmoName);
                    if (same) {
                        ++nsame;
                    } else {
                        ++ndiff;
                    }
                    ++total;
                    if (same && !this.showSame) continue;
                    fm.format("%d %d %d%n wmo =%s%n curr=%s%n", discipline, category, number, wmoName, currName);
                }
            }
            finally {
                if (ncfile == null) continue;
                ncfile.close();
            }
        }
        fm.format("%nTotal=%d same=%d sameIgnoreCase=%d dif=%d unknown=%d%n", total, nsame, nsameIgn, ndiff, unknownCount);
        this.compareTA.setText(fm.toString());
        this.infoWindow.show();
    }

    public class EntryBean {
        WmoCodeTable.TableEntry te;

        public EntryBean() {
        }

        public EntryBean(WmoCodeTable.TableEntry te) {
            this.te = te;
        }

        public String getCode() {
            return this.te.code;
        }

        public String getName() {
            return this.te.name;
        }

        public String getMeaning() {
            return this.te.meaning;
        }

        public String getUnit() {
            return this.te.unit;
        }

        public String getUdunit() {
            if (this.te.unit == null) {
                return "";
            }
            if (this.te.unit.length() == 0) {
                return "";
            }
            try {
                SimpleUnit su = SimpleUnit.factoryWithExceptions(this.te.unit);
                if (su.isUnknownUnit()) {
                    return "UNKNOWN";
                }
                return su.toString();
            }
            catch (Exception ioe) {
                return "FAIL";
            }
        }

        public String getStatus() {
            return this.te.status;
        }

        public int getLine() {
            return this.te.line;
        }
    }

    public class CodeTableBean {
        WmoCodeTable codeTable;

        public CodeTableBean() {
        }

        public CodeTableBean(WmoCodeTable code) {
            this.codeTable = code;
        }

        public String getTitle() {
            return this.codeTable.tableName;
        }

        public int getDiscipline() {
            return this.codeTable.discipline;
        }

        public String getTableNo() {
            Formatter f = new Formatter();
            f.format("%d.%d", this.codeTable.m1, this.codeTable.m2);
            if (this.codeTable.discipline >= 0) {
                f.format(".%d", this.codeTable.discipline);
            }
            if (this.codeTable.category >= 0) {
                f.format(".%d", this.codeTable.category);
            }
            return f.toString();
        }

        public int getCategory() {
            return this.codeTable.category;
        }

        public boolean isParameter() {
            return this.codeTable.isParameter;
        }

        void showTable(Formatter f) {
            f.format("Code Table %s (%s)%n", this.codeTable.getTableName(), this.codeTable.getTableId());
            for (WmoCodeTable.TableEntry entry : this.codeTable.entries) {
                f.format("  %3d: %s%n", entry.number, entry.meaning);
            }
        }
    }
}

