/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.uavs;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;

public class UavVehicleIcon {
    private String drawMode;
    private Shape icon;
    private Color alertLevel;
    private Rectangle iconContactSurface;
    private int height;
    private int width;

    public UavVehicleIcon(int height, int width, String drawMode) {
        this.setHeight(height);
        this.setWidth(width);
        this.setAlertLevel(Color.green.darker());
        this.generateIconContactSurface();
        this.setDrawMode(drawMode);
        this.buildIcon();
    }

    public UavVehicleIcon(String drawMode) {
        this.setHeight(1);
        this.setWidth(1);
        this.setAlertLevel(Color.green.darker());
        this.generateIconContactSurface();
        this.setDrawMode(drawMode);
        this.buildIcon();
    }

    public Shape getIcon() {
        return this.icon;
    }

    public void setDrawMode(String drawMode) {
        this.drawMode = drawMode;
    }

    public String getDrawMode() {
        return this.drawMode;
    }

    public void setAlertLevel(Color alertLevel) {
        this.alertLevel = alertLevel;
    }

    public Color getAlertLevel() {
        return this.alertLevel;
    }

    public void generateIconContactSurface() {
        this.iconContactSurface = new Rectangle(this.height, this.width);
    }

    public Rectangle getIconContactSurface() {
        return this.iconContactSurface;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getHeight() {
        return this.height;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getWidth() {
        return this.width;
    }

    public void updateIconContactSurface(double x, double y) {
        this.iconContactSurface.setLocation((int)(x - (double)(this.iconContactSurface.width / 2)), (int)(y - (double)(this.iconContactSurface.height / 2)));
    }

    public void buildIcon() {
        GeneralPath ret = new GeneralPath();
        if (this.drawMode.equalsIgnoreCase("Side View")) {
            ret.moveTo(-this.width / 4, -this.height / 3);
            ret.lineTo(-this.width / 2, -this.height / 8);
            ret.lineTo(-this.width / 2, 0.0f);
            ret.lineTo(-this.width / 4, this.height / 8);
            ret.lineTo(this.width / 4, this.height / 8);
            ret.lineTo(this.width * 5 / 12, this.height / 2);
            ret.lineTo(this.width / 2, this.height / 2);
            ret.lineTo(this.width / 2, 0.0f);
            ret.lineTo(this.width / 4, -this.height / 3);
            ret.closePath();
        } else {
            ret.moveTo(-this.width / 2, -this.height / 2);
            ret.lineTo(0.0f, this.height / 2);
            ret.lineTo(this.width / 2, -this.height / 2);
            ret.lineTo(0.0f, -this.height / 2 * 3 / 5);
            ret.closePath();
        }
        this.icon = ret;
    }
}

