/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.uavs.painters.background;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.util.LinkedHashMap;
import pt.lsts.neptus.plugins.uavs.interfaces.IUavPainter;

public class UavCoverLayerPainter
implements IUavPainter {
    private String name;
    private Point2D[] gradientPoints;
    private Shape shape;
    private GradientPaint backgroundColor;
    private Color[] colors;
    private int[] drawPoints;
    private int[] size;
    private LinkedHashMap<String, Object> receivedArgs;

    public UavCoverLayerPainter(String name) {
        this.name = name;
        this.backgroundColor = null;
        this.shape = null;
        this.drawPoints = new int[2];
        this.size = new int[2];
        this.gradientPoints = new Point2D[2];
        this.colors = new Color[2];
        this.receivedArgs = new LinkedHashMap();
    }

    @Override
    public void paint(Graphics2D g, int width, int height, Object args) {
        boolean update = false;
        this.receivedArgs = (LinkedHashMap)args;
        if (this.receivedArgs.get(this.name + ".Size") != null) {
            this.size = (int[])this.receivedArgs.get(this.name + ".Size");
            this.gradientPoints[0] = new Point2D.Double(this.size[0] >> 1, this.size[1]);
            this.gradientPoints[1] = new Point2D.Double(this.size[0] >> 1, 0.0);
            update = true;
        }
        if (this.receivedArgs.get(this.name + ".Color") != null) {
            this.colors = (Color[])this.receivedArgs.get(this.name + ".Color");
            update = true;
        }
        if (this.receivedArgs.get(this.name + ".DrawPoint") != null) {
            this.drawPoints = (int[])this.receivedArgs.get(this.name + ".DrawPoint");
            update = true;
        }
        if (update) {
            this.backgroundColor = new GradientPaint(this.gradientPoints[0], this.colors[0], this.gradientPoints[1], this.colors[1]);
            this.shape = new Rectangle(this.drawPoints[0], this.drawPoints[1], this.size[0], this.size[1]);
        }
        g.setPaint(this.backgroundColor);
        g.fill(this.shape);
    }
}

