/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.uavs.painters.background;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.math.BigDecimal;
import java.util.Hashtable;
import pt.lsts.neptus.plugins.uavs.interfaces.IUavPainter;

public class UavVirtualHorizonPainter
implements IUavPainter {
    private Hashtable<String, Object> receivedArgs;
    private double roll = 0.0;
    private double pitch = 0.0;
    private static final int VERTICAL_FOV = 50;
    private int currentHorizonHeight = 0;
    private Shape ground;

    @Override
    public void paint(Graphics2D g, int width, int height, Object args) {
        this.receivedArgs = (Hashtable)args;
        if (!this.receivedArgs.isEmpty()) {
            this.roll = ((Number)this.receivedArgs.get("roll")).doubleValue();
            this.pitch = ((Number)this.receivedArgs.get("pitch")).doubleValue();
        }
        g.setPaint(this.gradientColorer(width, height, Color.cyan.darker(), Color.blue.darker()));
        g.fillRect(0, 0, width, height);
        this.ground = this.createGround(width, height);
        this.currentHorizonHeight = (int)((double)(height / 2) + (double)(height / 2) * this.pitch / 50.0);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.translate(width / 2, this.currentHorizonHeight);
        g.scale(-1.0, 1.0);
        g.setPaint(this.gradientColorer(width, height, Color.gray.darker(), Color.orange.darker()));
        g.rotate(Math.toRadians(this.roll));
        g.fill(this.ground);
        this.drawPitchRuler(g, width, height, 20, 4);
        g.rotate(-Math.toRadians(this.roll));
        g.scale(-1.0, 1.0);
        g.translate(-(width / 2), -this.currentHorizonHeight);
    }

    private void drawPitchRuler(Graphics2D g, int width, int height, int scale, int numMarks) {
        g.setColor(Color.black);
        while (numMarks > 0) {
            int markHeight;
            if (scale % 10 != 0) {
                markHeight = scale * (height / 2) / 50;
                g.fill(new Rectangle(-width / 16, markHeight, width / 8, 1));
            } else if (scale != 0) {
                markHeight = scale * (height / 2) / 50;
                g.fill(new Rectangle(-width / 8, markHeight, width / 4, 1));
                g.scale(-1.0, 1.0);
                g.drawString(String.valueOf(BigDecimal.valueOf(-scale).intValue()), width / 8, markHeight);
                g.scale(-1.0, 1.0);
                --numMarks;
            }
            scale -= 2;
        }
    }

    private GradientPaint gradientColorer(int width, int height, Color color1, Color color2) {
        return new GradientPaint(new Point2D.Double(width / 2, height), color1, new Point2D.Double(width / 2, 0.0), color2);
    }

    private Shape createGround(int width, int height) {
        int newWidth = (int)Math.sqrt(Math.pow(width, 2.0) + Math.pow(height, 2.0));
        GeneralPath ret = new GeneralPath();
        ret.moveTo(-newWidth / 2, 0.0f);
        ret.lineTo(-newWidth / 2, height);
        ret.lineTo(newWidth / 2, height);
        ret.lineTo(newWidth / 2, 0.0f);
        ret.closePath();
        return ret;
    }
}

