/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.uavs.painters.elements;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.util.LinkedHashMap;
import pt.lsts.neptus.plugins.uavs.interfaces.IUavPainter;

public class UavLabelPainter
implements IUavPainter {
    private String name;
    private LinkedHashMap<String, Object> receivedArgs = new LinkedHashMap();
    private Point2D[] gradientPoints;
    private Shape shape;
    private GradientPaint backgroundColor;
    private Color[] colors;
    private String text;
    private int[] drawPoints;
    private int[] textDrawPoints;
    private int[] size;

    public UavLabelPainter(String name) {
        this.name = name;
        this.size = new int[2];
        this.gradientPoints = new Point2D[2];
        this.backgroundColor = null;
        this.colors = new Color[2];
        this.drawPoints = new int[2];
        this.textDrawPoints = new int[2];
    }

    @Override
    public void paint(Graphics2D g, int width, int height, Object args) {
        boolean update = false;
        this.receivedArgs = (LinkedHashMap)args;
        if (this.receivedArgs.get(this.name + ".Size") != null) {
            this.size = (int[])this.receivedArgs.get(this.name + ".Size");
            this.gradientPoints[0] = new Point2D.Double(this.size[0] / 2, this.size[1]);
            this.gradientPoints[1] = new Point2D.Double(this.size[0] / 2, 0.0);
            update = true;
        }
        if (this.receivedArgs.get(this.name + ".DrawPoint") != null) {
            this.drawPoints = (int[])this.receivedArgs.get(this.name + ".DrawPoint");
            update = true;
        }
        if (this.receivedArgs.get(this.name + ".Color") != null) {
            this.colors = (Color[])this.receivedArgs.get(this.name + ".Color");
            update = true;
        }
        if (this.receivedArgs.get(this.name + ".Text") != null) {
            this.text = (String)this.receivedArgs.get(this.name + ".Text");
            update = true;
        }
        if (update) {
            this.backgroundColor = new GradientPaint(this.gradientPoints[0], this.colors[0], this.gradientPoints[1], this.colors[1]);
            this.shape = new Rectangle(this.drawPoints[0], this.drawPoints[1], this.size[0], this.size[1]);
            FontMetrics fm = g.getFontMetrics(g.getFont());
            this.textDrawPoints[0] = this.drawPoints[0] + (this.size[0] - fm.stringWidth(this.text)) / 2;
            this.textDrawPoints[1] = this.drawPoints[1] + fm.getHeight() + (this.size[1] - fm.getHeight()) / 2;
        }
        g.setPaint(this.backgroundColor);
        g.fill(this.shape);
        g.setPaint(Color.black);
        g.drawString(this.text, this.textDrawPoints[0], this.textDrawPoints[1]);
    }
}

