/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.uavs.painters.elements;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.LinkedHashMap;
import pt.lsts.neptus.plugins.uavs.UavVehicleIcon;
import pt.lsts.neptus.plugins.uavs.interfaces.IUavPainter;

public class UavMissionElementPainter
implements IUavPainter {
    private String name;
    public static final int MARK_MIN_THICKNESS = 2;
    public static final int MARK_MIN_SPACING = 6;
    public static final int MARKS_PER_SECTION = 10;
    public static final int MAX_ALTITUDE_BUFFER = 100;
    private int vehicleMaxAtl;
    private int maxDrawAlt;
    private int scale;
    private int rulerSections;
    public static int WIDTH_RACIO = 5;
    public static int HEIGHT_RACIO = 7;
    private LinkedHashMap<String, Object> receivedArgs;
    private LinkedHashMap<String, Integer> vehicleAltitudes;
    private LinkedHashMap<String, UavVehicleIcon> vehicleIconTable = new LinkedHashMap();

    public UavMissionElementPainter(String name) {
        this.name = name;
        this.receivedArgs = new LinkedHashMap();
        this.vehicleAltitudes = new LinkedHashMap();
        this.vehicleMaxAtl = 0;
        this.maxDrawAlt = 0;
        this.scale = 100;
        this.rulerSections = 0;
    }

    @Override
    public void paint(Graphics2D g, int width, int height, Object args) {
        this.receivedArgs = (LinkedHashMap)args;
        if (this.receivedArgs.get(this.name + ".MaxAlt") != null) {
            this.vehicleMaxAtl = (Integer)this.receivedArgs.get(this.name + ".MaxAlt");
            this.vehicleMaxAtl = (int)Math.floor(this.vehicleMaxAtl / 100) * 100 + 100;
        }
        this.scale = 100;
        this.rulerSections = height / 80;
        this.maxDrawAlt = this.scale * this.rulerSections;
        while (this.maxDrawAlt < this.vehicleMaxAtl) {
            this.scale <<= 1;
            this.maxDrawAlt = this.scale * this.rulerSections;
        }
        if (this.receivedArgs.get(this.name + ".VehicleList") != null) {
            this.vehicleAltitudes = (LinkedHashMap)this.receivedArgs.get(this.name + ".VehicleList");
        }
        this.determineDrawingOriginPoint(g, height, width);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        for (String vehicle : this.vehicleAltitudes.keySet()) {
            if (this.vehicleIconTable.get(vehicle) == null) {
                this.vehicleIconTable.put(vehicle, new UavVehicleIcon(width / HEIGHT_RACIO, width / WIDTH_RACIO, "Side View"));
            }
            g.setFont(g.getFont().deriveFont(10.0f));
            int altitude = this.vehicleAltitudes.get(vehicle) * 80 / this.scale;
            g.translate(0, altitude - height / 2);
            g.scale(1.0, -1.0);
            this.drawVehicleLabel(g, vehicle);
            g.scale(1.0, -1.0);
            g.setColor(Color.white.darker());
            g.drawRect(-width / 2, 0, height, 0);
            this.drawVehicleIcon(g, vehicle);
            g.translate(0, -(altitude - height / 2));
        }
    }

    private void determineDrawingOriginPoint(Graphics2D g, int height, int width) {
        g.translate(width / 2, height / 2);
        g.scale(1.0, -1.0);
    }

    private void drawVehicleLabel(Graphics2D g, String vehicle) {
        g.drawString(vehicle, this.vehicleIconTable.get(vehicle).getWidth() / 2, -2);
        g.drawString(this.vehicleAltitudes.get(vehicle) + " m", this.vehicleIconTable.get(vehicle).getWidth() / 2, 12);
    }

    private void drawVehicleIcon(Graphics2D g, String vehicle) {
        g.setColor(this.vehicleIconTable.get(vehicle).getAlertLevel());
        g.fill(this.vehicleIconTable.get(vehicle).getIcon());
        g.setColor(Color.black);
        g.draw(this.vehicleIconTable.get(vehicle).getIcon());
    }
}

