/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.uavs.painters.foreground;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.math.BigDecimal;
import java.util.Hashtable;
import pt.lsts.neptus.plugins.uavs.UavLib;
import pt.lsts.neptus.plugins.uavs.interfaces.IUavPainter;

public class UavHUDInfoPainter
implements IUavPainter {
    private boolean needsCreation;
    private static final int RIGHTSIDED = 0;
    private static final int LEFTSIDED = 1;
    private static final int NO_ORIENTATION = 3;
    private Hashtable<String, Object> receivedArgs;
    private double roll = 0.0;
    private double pitch = 0.0;
    private double yaw = 0.0;
    private double indicatedSpeed = 0.0;
    private int altitude = 0;
    private AffineTransform identity = new AffineTransform();
    private Shape pitchReadOut;
    private Shape rollReadOut;
    private Shape yawReadOut;
    private Shape indicatedSpeedReadOut;
    private Shape altitudeReadOut;
    private Shape pitchOuterBox;
    private Shape rollOuterBox;
    private Shape yawOuterBox;
    private Shape indicatedSpeedOuterBox;
    private Shape altitudeOuterBox;
    private Shape triangleMarker;
    private TextLayout text;

    public UavHUDInfoPainter() {
        this.setNeedsCreation(true);
        this.setTriangleMarker(this.createTriangleMarker(10, 10));
    }

    private void setNeedsCreation(boolean needsCreation) {
        this.needsCreation = needsCreation;
    }

    public boolean isNeedsCreation() {
        return this.needsCreation;
    }

    public void setTriangleMarker(Shape triangleMarker) {
        this.triangleMarker = triangleMarker;
    }

    public Shape getTriangleMarker() {
        return this.triangleMarker;
    }

    @Override
    public void paint(Graphics2D g, int width, int height, Object args) {
        this.receivedArgs = (Hashtable)args;
        if (!this.receivedArgs.isEmpty()) {
            this.roll = ((Number)this.receivedArgs.get("roll")).doubleValue();
            this.pitch = ((Number)this.receivedArgs.get("pitch")).doubleValue();
            this.yaw = ((Number)this.receivedArgs.get("yaw")).doubleValue();
            this.indicatedSpeed = ((Number)this.receivedArgs.get("indicatedSpeed")).doubleValue();
            this.altitude = ((Number)this.receivedArgs.get("altitude")).intValue();
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.pitchReadOut = this.createVisualReadOut(g, this.pitch, "SansSerif", 0, 14);
        this.rollReadOut = this.createVisualReadOut(g, this.roll, "SansSerif", 0, 14);
        this.yawReadOut = this.createVisualReadOut(g, this.yaw, "SansSerif", 0, 14);
        this.indicatedSpeedReadOut = this.createVisualReadOut(g, this.indicatedSpeed, "SansSerif", 0, 14);
        this.altitudeReadOut = this.createVisualReadOut(g, this.altitude, "SansSerif", 0, 14);
        if (this.needsCreation) {
            this.pitchOuterBox = this.createPitchOuterBox(this.pitchReadOut.getBounds().width, this.pitchReadOut.getBounds().height, 90, 10);
            this.rollOuterBox = this.createDefaultOuterBox(this.rollReadOut.getBounds().width, this.rollReadOut.getBounds().height, 80, 10, 3);
            this.yawOuterBox = this.createDefaultOuterBox(this.yawReadOut.getBounds().width, this.yawReadOut.getBounds().height, 80, 10, 3);
            this.indicatedSpeedOuterBox = this.createDefaultOuterBox(this.indicatedSpeedReadOut.getBounds().width, this.indicatedSpeedReadOut.getBounds().height, 80, 10, 0);
            this.altitudeOuterBox = this.createDefaultOuterBox(this.altitudeReadOut.getBounds().width, this.altitudeReadOut.getBounds().height, 80, 10, 1);
            this.setNeedsCreation(false);
        }
        this.drawPitch(g, width, height);
        this.drawRoll(g, width, height);
        this.drawYaw(g, width, height);
        this.drawSpeed(g, width, height);
        this.drawAltitude(g, width, height);
    }

    private void drawAltitude(Graphics2D g, int width, int height) {
        g.translate(0, 0);
        this.drawRulerBackgrounds(g, width, height, width / 4, height, 0.6);
        this.drawRuler(g, width, height, width / 4, 4 * height / 6, this.altitude, 25, 8, 1);
        g.translate(width / 8, height / 2);
        g.draw(this.altitudeOuterBox);
        g.setColor(Color.gray.brighter());
        g.fill(this.altitudeOuterBox);
        g.setColor(Color.black);
        this.drawReadOut(g, this.altitudeReadOut);
        g.translate(-width / 8, -height / 2);
        g.translate(0, 0);
    }

    private void drawSpeed(Graphics2D g, int width, int height) {
        g.translate(3 * width / 4, 0);
        this.drawRulerBackgrounds(g, width, height, width / 4, height, 0.6);
        this.drawRuler(g, width, height, width / 4, 4 * height / 6, this.indicatedSpeed, 10, 5, 0);
        g.translate(width / 8, height / 2);
        g.setColor(Color.black);
        g.draw(this.indicatedSpeedOuterBox);
        g.setColor(Color.gray.brighter());
        g.fill(this.indicatedSpeedOuterBox);
        g.setColor(Color.black);
        this.drawReadOut(g, this.indicatedSpeedReadOut);
        g.translate(-width / 8, -height / 2);
        g.translate(-3 * width / 4, 0);
    }

    private void drawYaw(Graphics2D g, int width, int height) {
        g.translate(width / 2, height / 8);
        g.setColor(Color.black);
        g.draw(this.yawOuterBox);
        g.setColor(Color.gray.brighter());
        g.fill(this.yawOuterBox);
        g.setColor(Color.black);
        this.drawReadOut(g, this.yawReadOut);
        g.translate(-width / 2, -height / 8);
    }

    private void drawRoll(Graphics2D g, int width, int height) {
        g.translate(width / 2, 5 * height / 6);
        g.setColor(Color.black);
        g.draw(this.rollOuterBox);
        g.translate(0, -2 * height / 6);
        for (int i = 0; i < 360; i += 5) {
            g.setColor(Color.black);
            if (i == 0) {
                g.setColor(Color.red);
                g.translate((double)(2 * height / 5) * Math.sin(Math.toRadians(i)), (double)(2 * height / 5) * Math.cos(Math.toRadians(i)));
                g.scale(1.0, -1.0);
                g.fill(this.triangleMarker);
                g.scale(1.0, -1.0);
                g.translate((double)(-2 * height / 5) * Math.sin(Math.toRadians(i)), (double)(-2 * height / 5) * Math.cos(Math.toRadians(i)));
                continue;
            }
            if (i >= 50 && i <= 310) continue;
            g.translate((double)(2 * height / 5) * Math.sin(Math.toRadians(i)), (double)(2 * height / 5) * Math.cos(Math.toRadians(i)));
            g.fillRect(-1, -1, 2, 2);
            g.translate((double)(-2 * height / 5) * Math.sin(Math.toRadians(i)), (double)(-2 * height / 5) * Math.cos(Math.toRadians(i)));
        }
        g.setColor(Color.yellow);
        g.translate((double)(2 * height / 5) * Math.sin(Math.toRadians(this.roll)), (double)(2 * height / 5) * Math.cos(Math.toRadians(this.roll)));
        g.rotate(-Math.toRadians(this.roll));
        g.fill(this.triangleMarker);
        g.rotate(Math.toRadians(this.roll));
        g.translate((double)(-2 * height / 5) * Math.sin(Math.toRadians(this.roll)), (double)(-2 * height / 5) * Math.cos(Math.toRadians(this.roll)));
        g.translate(0, 2 * height / 6);
        g.setColor(Color.gray.brighter());
        g.fill(this.rollOuterBox);
        g.setColor(Color.black);
        this.drawReadOut(g, this.rollReadOut);
        g.translate(-width / 2, -5 * height / 6);
    }

    private void drawPitch(Graphics2D g, int width, int height) {
        g.translate(width / 2, height / 2);
        g.setColor(Color.black);
        g.draw(this.pitchOuterBox);
        g.setColor(Color.gray.brighter());
        g.fill(this.pitchOuterBox);
        g.setColor(Color.black);
        this.drawReadOut(g, this.pitchReadOut);
        g.translate(-width / 2, -height / 2);
    }

    private void drawRuler(Graphics2D g, int hostWidth, int hostHeight, int desiredWidth, int desiredHeight, double value, int scale, int numMarks, int orientation) {
        if (orientation == 1) {
            g.translate(0, (hostHeight - desiredHeight) / 2);
            int markValue = BigDecimal.valueOf(value).intValue() / scale + numMarks / 2;
            int markSeparation = desiredHeight / numMarks;
            int alignment = BigDecimal.valueOf(value % (double)scale).intValue() * markSeparation / scale;
            int i = desiredHeight / 2 + alignment - numMarks / 2 * markSeparation;
            g.setColor(Color.black);
            while (i < desiredHeight) {
                if (i > 0) {
                    g.fillRect(0, i - 2, desiredWidth / 6, 4);
                    if (i < desiredHeight / 2 - 10 || i > desiredHeight / 2 + 10) {
                        g.drawString(String.valueOf(markValue * scale), desiredWidth / 6 + 3, i + g.getFontMetrics().getHeight() / 4);
                    }
                }
                i += markSeparation;
                --markValue;
            }
            g.fillRect(0, 0, 3, desiredHeight);
            g.translate(0, -(hostHeight - desiredHeight) / 2);
        } else if (orientation == 0) {
            g.translate(0, (hostHeight - desiredHeight) / 2);
            int markValue = BigDecimal.valueOf(value * 10.0).intValue() / scale + numMarks / 2;
            int markSeparation = desiredHeight / numMarks;
            int alignment = BigDecimal.valueOf(value * 10.0 % (double)scale).intValue() * markSeparation / scale;
            int i = desiredHeight / 2 + alignment - numMarks / 2 * markSeparation;
            g.setColor(Color.black);
            while (i < desiredHeight) {
                if (i > 0) {
                    g.fillRect(5 * desiredWidth / 6, i - 2, desiredWidth / 6, 4);
                    if (i < desiredHeight / 2 - 10 || i > desiredHeight / 2 + 10) {
                        g.drawString(String.valueOf(BigDecimal.valueOf(markValue).doubleValue()), 5 * desiredWidth / 6 - g.getFontMetrics().stringWidth(String.valueOf(BigDecimal.valueOf(markValue).doubleValue())), i + g.getFontMetrics().getHeight() / 4);
                    }
                }
                i += markSeparation;
                --markValue;
            }
            g.fillRect(desiredWidth - 3, 0, 3, desiredHeight);
            g.translate(0, -(hostHeight - desiredHeight) / 2);
        }
    }

    private void drawRulerBackgrounds(Graphics2D g, int hostWidth, int hostHeight, int desiredWidth, int desiredHeight, double transparency) {
        g.setPaint(UavLib.gradientColorer(hostWidth, hostHeight, Color.gray, Color.gray));
        g.setComposite(UavLib.makeTransparent((float)transparency));
        g.fill(new Rectangle2D.Double(0.0, 0.0, desiredWidth, desiredHeight));
        g.setComposite(UavLib.makeTransparent(1.0f));
    }

    private void drawReadOut(Graphics2D g, Shape readOut) {
        g.translate(-readOut.getBounds().width / 2, readOut.getBounds().height / 2);
        g.fill(readOut);
        g.translate(readOut.getBounds().width / 2, -readOut.getBounds().height / 2);
    }

    private Shape createVisualReadOut(Graphics2D g, double readOut, String fontName, int fontType, int size) {
        this.text = new TextLayout(BigDecimal.valueOf(readOut).setScale(1, 0).toPlainString(), new Font(fontName, fontType, size), g.getFontRenderContext());
        Area ret = new Area(this.text.getOutline(this.identity));
        return ret;
    }

    private Shape createVisualReadOut(Graphics2D g, int readOut, String fontName, int fontType, int size) {
        this.text = new TextLayout(BigDecimal.valueOf(readOut).toPlainString(), new Font(fontName, fontType, size), g.getFontRenderContext());
        Area ret = new Area(this.text.getOutline(this.identity));
        return ret;
    }

    private Shape createPitchOuterBox(int width, int height, int widthOffSet, int hightOffSet) {
        GeneralPath ret = new GeneralPath();
        ret.moveTo(-(width + widthOffSet) / 8, -(height + hightOffSet) / 2);
        ret.lineTo(-(width + widthOffSet) / 4, 0.0f);
        ret.lineTo(-(width + widthOffSet) / 2, 0.0f);
        ret.lineTo(-(width + widthOffSet) / 4, 0.0f);
        ret.lineTo(-(width + widthOffSet) / 8, (height + hightOffSet) / 2);
        ret.lineTo((width + widthOffSet) / 8, (height + hightOffSet) / 2);
        ret.lineTo((width + widthOffSet) / 4, 0.0f);
        ret.lineTo((width + widthOffSet) / 2, 0.0f);
        ret.lineTo((width + widthOffSet) / 4, 0.0f);
        ret.lineTo((width + widthOffSet) / 8, -(height + hightOffSet) / 2);
        ret.closePath();
        return ret;
    }

    private Shape createDefaultOuterBox(int width, int height, int widthOffSet, int hightOffSet, int orientation) {
        GeneralPath ret = new GeneralPath();
        if (orientation == 1) {
            ret.moveTo(-(width + widthOffSet) / 8, -(height + hightOffSet) / 2);
            ret.lineTo(-(width + widthOffSet) / 4, 0.0f);
            ret.lineTo(-(width + widthOffSet) / 8, (height + hightOffSet) / 2);
            ret.lineTo((width + widthOffSet) / 5, (height + hightOffSet) / 2);
            ret.lineTo((width + widthOffSet) / 5, -(height + hightOffSet) / 2);
        } else if (orientation == 0) {
            ret.moveTo(-(width + widthOffSet) / 5, -(height + hightOffSet) / 2);
            ret.lineTo(-(width + widthOffSet) / 5, (height + hightOffSet) / 2);
            ret.lineTo((width + widthOffSet) / 8, (height + hightOffSet) / 2);
            ret.lineTo((width + widthOffSet) / 4, 0.0f);
            ret.lineTo((width + widthOffSet) / 8, -(height + hightOffSet) / 2);
        } else {
            ret.moveTo(-(width + widthOffSet) / 6, -(height + hightOffSet) / 2);
            ret.lineTo(-(width + widthOffSet) / 4, 0.0f);
            ret.lineTo(-(width + widthOffSet) / 6, (height + hightOffSet) / 2);
            ret.lineTo((width + widthOffSet) / 6, (height + hightOffSet) / 2);
            ret.lineTo((width + widthOffSet) / 4, 0.0f);
            ret.lineTo((width + widthOffSet) / 6, -(height + hightOffSet) / 2);
        }
        ret.closePath();
        return ret;
    }

    private Shape createTriangleMarker(int width, int height) {
        GeneralPath ret = new GeneralPath();
        ret.moveTo(-width / 2, 0.0f);
        ret.lineTo(0.0f, height);
        ret.lineTo(width / 2, 0.0f);
        ret.closePath();
        return ret;
    }
}

