/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.uavs.painters.foreground;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.LinkedHashMap;
import pt.lsts.neptus.plugins.uavs.interfaces.IUavPainter;

public class UavRulerPainter
implements IUavPainter {
    private String name;
    public static final int MARK_MIN_THICKNESS = 2;
    public static final int MARK_MIN_SPACING = 6;
    public static final int MARKS_PER_SECTION = 10;
    public static final int MAX_ALTITUDE_BUFFER = 100;
    private int vehicleMaxAtl;
    private int maxDrawAlt;
    private int scale;
    private int rulerSections;
    private LinkedHashMap<String, Object> receivedArgs;

    public UavRulerPainter(String name) {
        this.name = name;
        this.vehicleMaxAtl = 0;
        this.maxDrawAlt = 0;
        this.scale = 100;
        this.rulerSections = 0;
    }

    @Override
    public void paint(Graphics2D g, int width, int height, Object args) {
        this.receivedArgs = (LinkedHashMap)args;
        if (this.receivedArgs.get(this.name + ".MaxAlt") != null) {
            this.vehicleMaxAtl = (Integer)this.receivedArgs.get(this.name + ".MaxAlt");
            this.vehicleMaxAtl = (int)Math.floor(this.vehicleMaxAtl / 100) * 100 + 100;
        }
        this.scale = 100;
        this.rulerSections = height / 80;
        this.maxDrawAlt = this.scale * this.rulerSections;
        while (this.maxDrawAlt < this.vehicleMaxAtl) {
            this.scale <<= 1;
            this.maxDrawAlt = this.scale * this.rulerSections;
        }
        int markCounter = 0;
        int markGrade = 1;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        while (height > 0) {
            this.drawMark(g, height -= 2, width, markCounter, 2);
            if (markCounter == 10) {
                g.drawString(String.valueOf(markGrade * this.scale), width / 4 + 3, height + 2);
                markCounter = 0;
                ++markGrade;
            }
            height -= 6;
            ++markCounter;
        }
    }

    private void drawMark(Graphics2D g, int panelHeight, int panelWidth, int markCounter, int markThickness) {
        if (markCounter == 0 || markCounter == 10) {
            g.fillRect(0, panelHeight, panelWidth / 5, markThickness);
        } else if (markCounter == 5) {
            g.fillRect(0, panelHeight, panelWidth / 8, markThickness);
        } else {
            g.fillRect(0, panelHeight, panelWidth / 16, markThickness);
        }
    }
}

