/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.uavs.panels;

import com.google.common.eventbus.Subscribe;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import pt.lsts.imc.AutopilotMode;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.console.plugins.MainVehicleChangeListener;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.plugins.PluginDescription;

@PluginDescription(name="Autopilot Mode Indicator", author="jfortuna", version="0.1", category=PluginDescription.CATEGORY.INTERFACE)
public class AutopilotModePanel
extends ConsolePanel
implements MainVehicleChangeListener {
    private static final long serialVersionUID = 1L;
    private String currentMode = null;
    private AutopilotMode.AUTONOMY autonomyLevel = AutopilotMode.AUTONOMY.MANUAL;
    private JPanel modePanel = null;

    @Subscribe
    public void on(AutopilotMode msg) {
        if (!msg.getSourceName().equals(this.getConsole().getMainSystem())) {
            return;
        }
        this.currentMode = msg.getMode();
        this.autonomyLevel = msg.getAutonomy();
        this.modePanel.removeAll();
        JLabel modeLabel = new JLabel(this.currentMode, 0);
        modeLabel.setFont(new Font(modeLabel.getFont().getFontName(), 1, modeLabel.getFont().getSize()));
        switch (this.autonomyLevel) {
            case MANUAL: {
                this.modePanel.setBackground(Color.yellow);
                break;
            }
            case ASSISTED: {
                this.modePanel.setBackground(Color.blue);
                modeLabel.setForeground(Color.white);
                break;
            }
            case AUTO: {
                this.modePanel.setBackground(Color.green.darker());
            }
        }
        this.modePanel.add((Component)modeLabel, "w 100%, h 100%");
    }

    public AutopilotModePanel(ConsoleLayout console) {
        super(console);
        this.removeAll();
    }

    public void initSubPanel() {
        this.titlePanelSetup();
        this.setLayout((LayoutManager)new MigLayout("gap 0 0, ins 0"));
        this.add(this.modePanel, "w 100%, h 100%, wrap");
    }

    private void titlePanelSetup() {
        this.modePanel = new JPanel((LayoutManager)new MigLayout("gap 0 0, ins 0"));
        this.modePanel.add((Component)new JLabel(I18n.text((String)"Mode Indicator"), 0), "w 100%, h 100%");
    }

    public void cleanSubPanel() {
    }
}

