/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.uavs.panels;

import com.google.common.eventbus.Subscribe;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.text.DecimalFormat;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import net.miginfocom.swing.MigLayout;
import pt.lsts.imc.IMCDefinition;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.IndicatedSpeed;
import pt.lsts.imc.Maneuver;
import pt.lsts.imc.PlanControl;
import pt.lsts.imc.PlanControlState;
import pt.lsts.imc.PlanManeuver;
import pt.lsts.imc.PlanSpecification;
import pt.lsts.imc.TrueSpeed;
import pt.lsts.neptus.comm.IMCSendMessageUtils;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.console.plugins.MainVehicleChangeListener;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.util.ImageUtils;

@PluginDescription(name="Speed Indicator Panel", icon="pt/lsts/neptus/plugins/uavs/speed.png", author="canasta", version="3.0", category=PluginDescription.CATEGORY.INTERFACE)
public class SpeedIndicatorPanel
extends ConsolePanel
implements MainVehicleChangeListener {
    private static final long serialVersionUID = 1L;
    @NeptusProperty(name="Minimum Speed", description="Speed below which the vehicle enters VStall (m/s)", userLevel=NeptusProperty.LEVEL.REGULAR)
    public double minSpeed = 12.0;
    @NeptusProperty(name="Maximum Speed", description="Speed above which it's undesirable to fly (m/s)", userLevel=NeptusProperty.LEVEL.REGULAR)
    public double maxSpeed = 25.0;
    public static final double MS_TO_KNOTS_CONV = 1.94384449244;
    private ImageIcon ICON_TSPEED;
    private ImageIcon ICON_GSPEED;
    private ImageIcon ICON_ASPEED;
    private boolean samePlan = false;
    private String currentPlan = null;
    private String currentManeuver = null;
    private PlanSpecification planSpec = null;
    private double aSpeed = 0.0;
    private double gSpeed = 0.0;
    private double tSpeed = 0.0;
    private JPanel titlePanel = null;
    private JPanel topLabelPanel = null;
    private JPanel speedPanel = null;
    private JPanel speedNumberPanel = null;
    private JPanel speedGraphPanel = null;
    private JPanel bottomLabelPanel = null;
    private JProgressBar aSpeedBar = null;
    private JProgressBar gSpeedBar = null;
    private JLabel aSpeedLabel = null;
    private JLabel gSpeedLabel = null;
    private JLabel tSpeedLabel = null;
    private JLabel maxSpeedLabel = null;
    private DecimalFormat formatter = new DecimalFormat("0.0");

    public SpeedIndicatorPanel(ConsoleLayout console) {
        super(console);
        this.removeAll();
    }

    @Subscribe
    public void on(TrueSpeed msg) {
        if (msg.getSourceName().equals(this.getConsole().getMainSystem())) {
            this.gSpeed = msg.getValue();
            this.speedLabelPositionUpdate();
        }
    }

    @Subscribe
    public void on(IndicatedSpeed msg) {
        if (msg.getSourceName().equals(this.getConsole().getMainSystem())) {
            this.aSpeed = msg.getValue();
            this.speedLabelPositionUpdate();
        }
    }

    @Subscribe
    public void on(PlanControlState msg) {
        if (msg.getSourceName().equals(this.getConsole().getMainSystem())) {
            if (msg.getAsNumber("state").longValue() == PlanControlState.STATE.EXECUTING.value()) {
                if (!msg.getAsString("plan_id").equals(this.currentPlan)) {
                    this.samePlan = false;
                }
                this.currentPlan = msg.getAsString("plan_id");
                this.currentManeuver = msg.getAsString("man_id");
                if (this.planSpec != null && this.samePlan) {
                    for (PlanManeuver planMan : this.planSpec.getManeuvers()) {
                        if (!planMan.getManeuverId().equals(this.currentManeuver)) continue;
                        Maneuver man = planMan.getData();
                        this.tSpeed = man.getAsNumber("speed").doubleValue();
                        this.tSpeedLabelPositionUpdate();
                    }
                }
                if (!this.samePlan) {
                    IMCMessage planControlMessage = IMCDefinition.getInstance().create("PlanControl", new Object[0]);
                    planControlMessage.setValue("type", (Object)0);
                    planControlMessage.setValue("op", (Object)"GET");
                    planControlMessage.setValue("request_id", (Object)IMCSendMessageUtils.getNextRequestId());
                    IMCSendMessageUtils.sendMessage((IMCMessage)planControlMessage, (String)I18n.text((String)"Error requesting plan specificaion"), (boolean)true, (String[])new String[]{this.getConsole().getMainSystem()});
                }
            } else {
                this.samePlan = false;
            }
        }
    }

    @Subscribe
    public void on(PlanControl msg) {
        if (msg.getSourceName().equals(this.getConsole().getMainSystem()) && !this.samePlan && msg.getMessage("arg").getAbbrev().equals("PlanSpecification")) {
            this.planSpec = (PlanSpecification)msg.getMessage("arg");
            this.samePlan = true;
        }
    }

    public void initSubPanel() {
        this.ICON_TSPEED = ImageUtils.createScaleImageIcon((String)"pt/lsts/neptus/plugins/uavs/icons/target.png", (int)((int)((double)this.getHeight() * 0.2)), (int)((int)((double)this.getHeight() * 0.2)));
        this.ICON_GSPEED = ImageUtils.createScaleImageIcon((String)"pt/lsts/neptus/plugins/uavs/icons/ground.png", (int)((int)((double)this.getHeight() * 0.2)), (int)((int)((double)this.getHeight() * 0.2)));
        this.ICON_ASPEED = ImageUtils.createScaleImageIcon((String)"pt/lsts/neptus/plugins/uavs/icons/air.png", (int)((int)((double)this.getHeight() * 0.2)), (int)((int)((double)this.getHeight() * 0.2)));
        this.titlePanelSetup();
        this.topLabelPanelSetup();
        this.bottomLabelPanelSetup();
        this.speedPanelSetup();
        this.setLayout((LayoutManager)new MigLayout("gap 0 0, ins 0"));
        this.add(this.titlePanel, "w 100%, h 15%!, wrap");
        this.add(this.topLabelPanel, "w 100%, h 15%!, wrap");
        this.add(this.speedPanel, "w 100%, h 50%!, wrap");
        this.add(this.bottomLabelPanel, "w 100%, h 20%!");
    }

    private void titlePanelSetup() {
        this.titlePanel = new JPanel((LayoutManager)new MigLayout("gap 0 0, ins 0"));
        this.titlePanel.add((Component)new JLabel(I18n.text((String)"Speed Indicator"), 0), "w 100%, h 100%");
    }

    private void topLabelPanelSetup() {
        this.maxSpeedLabel = new JLabel(this.formatter.format(this.maxSpeed), 4);
        this.topLabelPanel = new JPanel((LayoutManager)new MigLayout("gap 0 0, ins 0, rtl"));
        JPanel tempPanel2 = new JPanel((LayoutManager)new MigLayout("ins 0"));
        tempPanel2.add((Component)new JLabel("0.0", 2), "w 50%, h 100%");
        tempPanel2.add((Component)this.maxSpeedLabel, "w 50%, h 100%");
        this.topLabelPanel.add((Component)tempPanel2, "w 80%, h 100%");
    }

    private void speedPanelSetup() {
        this.speedPanel = new JPanel((LayoutManager)new MigLayout("gap 0 0, ins 0"));
        this.speedNumberPanel = new JPanel((LayoutManager)new MigLayout("ins 0"));
        this.aSpeedLabel = new JLabel(this.ICON_ASPEED);
        this.gSpeedLabel = new JLabel(this.ICON_GSPEED);
        this.speedNumberPanel.add((Component)this.aSpeedLabel, "w 100%, h 50%, wrap");
        this.speedNumberPanel.add((Component)this.gSpeedLabel, "w 100%, h 50%");
        this.speedGraphPanel = new JPanel((LayoutManager)new MigLayout("ins 0, rtl"));
        this.aSpeedBar = new JProgressBar(0, (int)(this.maxSpeed * 10.0));
        this.aSpeedBar.setForeground(Color.cyan.darker());
        this.aSpeedBar.setBorderPainted(false);
        this.gSpeedBar = new JProgressBar(0, (int)(this.maxSpeed * 10.0));
        this.gSpeedBar.setForeground(Color.green.darker());
        this.gSpeedBar.setBorderPainted(false);
        this.speedGraphPanel.add((Component)this.aSpeedBar, "w 100%, h 50%, wrap");
        this.speedGraphPanel.add((Component)this.gSpeedBar, "w 100%, h 50%");
        this.speedLabelPositionUpdate();
        this.speedPanel.add((Component)this.speedNumberPanel, "w 20%, h 100%");
        this.speedPanel.add((Component)this.speedGraphPanel, "w 80%, h 100%");
    }

    private void bottomLabelPanelSetup() {
        this.bottomLabelPanel = new JPanel((LayoutManager)new MigLayout("gap 0 0, ins 0, rtl"));
        this.tSpeedLabel = new JLabel(this.ICON_TSPEED);
        this.tSpeedLabel.setHorizontalTextPosition(10);
        this.tSpeedLabel.setHorizontalAlignment(2);
        this.tSpeedLabelPositionUpdate();
    }

    private void speedLabelPositionUpdate() {
        this.maxSpeedLabel.setText(this.formatter.format(this.maxSpeed));
        this.aSpeedBar.setValue((int)(this.aSpeed * 10.0));
        if (this.aSpeed < this.minSpeed) {
            this.aSpeedBar.setForeground(Color.red.darker());
        } else {
            this.aSpeedBar.setForeground(Color.cyan.darker());
        }
        this.aSpeedBar.setString(this.formatter.format(this.aSpeed));
        this.aSpeedBar.setStringPainted(true);
        this.gSpeedBar.setValue((int)(this.gSpeed * 10.0));
        this.gSpeedBar.setString(this.formatter.format(this.gSpeed));
        this.gSpeedBar.setStringPainted(true);
        this.revalidate();
    }

    private void tSpeedLabelPositionUpdate() {
        this.tSpeedLabel.setText(this.formatter.format(this.tSpeed));
        int iconSizePercent = this.ICON_TSPEED.getIconWidth() * 50 / this.getWidth();
        int tPercent = (int)(this.tSpeed * 80.0 / this.maxSpeed) + this.tSpeedLabel.getMinimumSize().width * 100 / this.getWidth() + iconSizePercent;
        this.bottomLabelPanel.remove(this.tSpeedLabel);
        this.bottomLabelPanel.add((Component)this.tSpeedLabel, "w " + (100 - tPercent) + "%, h 100%");
    }

    public void cleanSubPanel() {
    }
}

