/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.uavs.panels;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.Collections;
import java.util.LinkedHashMap;
import pt.lsts.imc.IMCMessage;
import pt.lsts.neptus.comm.manager.imc.ImcId16;
import pt.lsts.neptus.comm.manager.imc.ImcSystemsHolder;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.console.plugins.containers.MigLayoutContainer;
import pt.lsts.neptus.plugins.MultiSystemIMCMessageListener;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.uavs.interfaces.IUavPainter;
import pt.lsts.neptus.plugins.uavs.painters.background.UavCoverLayerPainter;
import pt.lsts.neptus.plugins.uavs.painters.elements.UavLabelPainter;
import pt.lsts.neptus.plugins.uavs.painters.elements.UavMissionElementPainter;
import pt.lsts.neptus.plugins.uavs.painters.foreground.UavRulerPainter;

@PluginDescription(name="Uav Altitude Panel", icon="pt/lsts/neptus/plugins/uavs/planning.png", author="canasta", version="3.0", category=PluginDescription.CATEGORY.INTERFACE)
public class UavAltitudePanel
extends ConsolePanel
implements ComponentListener {
    private static final long serialVersionUID = 1L;
    private static final int SIDE_PANEL_WIDTH = 25;
    private static final int BOTTOM_LABEL_HEIGHT = 25;
    @NeptusProperty(name="Vehicles detected", category="UAV", userLevel=NeptusProperty.LEVEL.REGULAR)
    public String vehicleType = "UAV";
    @NeptusProperty(name="Minimum security vertical distance between UAVs", category="UAV", userLevel=NeptusProperty.LEVEL.REGULAR)
    public Integer secAlt = 50;
    @NeptusProperty(name="Panel measuring units", category="UAV", userLevel=NeptusProperty.LEVEL.REGULAR)
    public String measure = "SI";
    @NeptusProperty(name="Individual ruler mark width in pixels", category="UAV", userLevel=NeptusProperty.LEVEL.REGULAR)
    public Integer markWidth = 5;
    private LinkedHashMap<String, IUavPainter> layers;
    private LinkedHashMap<String, Object> args;
    private LinkedHashMap<String, Integer> vehicleAltitudes;
    private String profile;
    private MultiSystemIMCMessageListener listener;

    public UavAltitudePanel(ConsoleLayout console) {
        super(console);
        this.removeAll();
    }

    private void setLayers(LinkedHashMap<String, IUavPainter> backgroundLayers) {
        this.layers = backgroundLayers;
    }

    private void setArgs(LinkedHashMap<String, Object> args) {
        this.args = args;
    }

    private void setVehicleAltitudes(LinkedHashMap<String, Integer> layerArgs) {
        this.vehicleAltitudes = layerArgs;
    }

    private void setListener() {
        this.listener = new MultiSystemIMCMessageListener(this.getClass().getSimpleName() + " [" + Integer.toHexString(this.hashCode()) + "]"){

            public void messageArrived(ImcId16 id, IMCMessage msg) {
                if (ImcSystemsHolder.lookupSystem((ImcId16)id).getTypeVehicle().name().equalsIgnoreCase(UavAltitudePanel.this.vehicleType)) {
                    UavAltitudePanel.this.vehicleAltitudes.put(ImcSystemsHolder.lookupSystem((ImcId16)id).getName(), msg.getInteger("height") + -msg.getInteger("z"));
                    UavAltitudePanel.this.repaint();
                }
            }
        };
    }

    public void initSubPanel() {
        this.setListener();
        this.setLayers(new LinkedHashMap<String, IUavPainter>());
        this.setVehicleAltitudes(new LinkedHashMap<String, Integer>());
        this.setArgs(new LinkedHashMap<String, Object>());
        this.listener.setSystemToListen(new ImcId16[0]);
        this.listener.setMessagesToListen(new String[]{"EstimatedState"});
        this.layers.put("Skybox", new UavCoverLayerPainter("Skybox"));
        this.layers.put("SidePanel", new UavCoverLayerPainter("SidePanel"));
        this.layers.put("AltitudeLabel", new UavLabelPainter("AltitudeLabel"));
        this.layers.put("UavRulerPainter", new UavRulerPainter("Ruler"));
        this.layers.put("UavMissionElement", new UavMissionElementPainter("Uavs"));
        this.args.put("Skybox.Color", new Color[]{Color.blue, Color.gray.brighter()});
        this.args.put("SidePanel.Color", new Color[]{Color.gray, Color.gray});
        this.args.put("AltitudeLabel.Color", new Color[]{Color.gray.brighter(), Color.gray.brighter()});
        this.addComponentListener(this);
        this.updateLabelText();
        this.updatePainterSizes();
    }

    public void cleanSubPanel() {
        this.listener.clean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.profile = this.getConsole().getMainPanel().getComponent(0).getClass().getSimpleName().equals("MigLayoutContainer") ? ((MigLayoutContainer)this.getConsole().getMainPanel().getComponent((int)0)).currentProfile : "None";
        this.prepareArgs();
        LinkedHashMap<String, IUavPainter> linkedHashMap = this.layers;
        synchronized (linkedHashMap) {
            for (IUavPainter layer : this.layers.values()) {
                Graphics2D gNew = (Graphics2D)g.create();
                layer.paint(gNew, this.getWidth(), this.getHeight(), this.args);
                gNew.dispose();
            }
            this.args.clear();
        }
    }

    private void prepareArgs() {
        if (this.profile.equals("TACO")) {
            this.args.put("Uavs.VehicleList", this.vehicleAltitudes);
        } else {
            LinkedHashMap<String, Integer> singleUav = new LinkedHashMap<String, Integer>();
            if (this.vehicleAltitudes.get(this.getMainVehicleId()) != null) {
                singleUav.put(this.getMainVehicleId(), this.vehicleAltitudes.get(this.getMainVehicleId()));
            }
            this.args.put("Uavs.VehicleList", singleUav);
        }
        if (!this.vehicleAltitudes.isEmpty()) {
            this.args.put("Ruler.MaxAlt", Collections.max(this.vehicleAltitudes.values()));
            this.args.put("Uavs.MaxAlt", Collections.max(this.vehicleAltitudes.values()));
        }
    }

    private void updatePainterSizes() {
        this.args.put("Skybox.DrawPoint", new int[]{0, 0});
        this.args.put("SidePanel.DrawPoint", new int[]{this.getWidth() - 25, 0});
        this.args.put("AltitudeLabel.DrawPoint", new int[]{0, this.getHeight() - 25});
        this.args.put("Skybox.Size", new int[]{this.getWidth() - 25, this.getHeight() - 25});
        this.args.put("SidePanel.Size", new int[]{25, this.getHeight()});
        this.args.put("AltitudeLabel.Size", new int[]{this.getWidth() - 25, 25});
        this.repaint();
    }

    private void updateLabelText() {
        if (this.measure.equals("SI")) {
            this.args.put("AltitudeLabel.Text", "Alt. [m]");
        } else if (this.measure.equals("Imperial")) {
            this.args.put("AltitudeLabel.Text", "Alt. [f]");
        }
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.updatePainterSizes();
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }
}

