/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.uavs.panels;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Hashtable;
import pt.lsts.imc.IMCMessage;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.plugins.NeptusMessageListener;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.uavs.UavPaintersBag;
import pt.lsts.neptus.plugins.uavs.interfaces.IUavPainter;
import pt.lsts.neptus.plugins.uavs.painters.background.UavVirtualHorizonPainter;
import pt.lsts.neptus.plugins.uavs.painters.foreground.UavHUDInfoPainter;

@PluginDescription(name="Uav HUD Panel", icon="pt/lsts/neptus/plugins/uavs/wbutt.png", author="sergioferreira")
public class UavHUDPanel
extends ConsolePanel
implements NeptusMessageListener {
    private static final long serialVersionUID = 1L;
    private UavPaintersBag layers;
    private Hashtable<String, Object> args;
    private double indicatedSpeed;
    private double tmpVar;

    public UavHUDPanel(ConsoleLayout console) {
        super(console);
        this.removeAll();
    }

    private void setLayers(UavPaintersBag layers) {
        this.layers = layers;
    }

    public UavPaintersBag getLayers() {
        return this.layers;
    }

    private void setArgs(Hashtable<String, Object> args) {
        this.args = args;
    }

    public String[] getObservedMessages() {
        return new String[]{"EstimatedState"};
    }

    public void messageArrived(IMCMessage message) {
        this.indicatedSpeed = Math.sqrt(Math.pow(message.getDouble("u"), 2.0) + Math.pow(message.getDouble("v"), 2.0) + Math.pow(message.getDouble("w"), 2.0));
        this.args.put("indicatedSpeed", this.indicatedSpeed);
        this.args.put("altitude", message.getInteger("height") - message.getInteger("z"));
        this.args.put("roll", Math.toDegrees(message.getDouble("phi")));
        this.args.put("pitch", Math.toDegrees(message.getDouble("theta")));
        this.tmpVar = Math.toDegrees(message.getDouble("psi"));
        if (this.tmpVar < 0.0) {
            this.tmpVar = 360.0 + this.tmpVar;
        }
        this.args.put("yaw", this.tmpVar);
        this.repaint();
    }

    public void addLayer(String name, Integer priority, IUavPainter layer, int cacheMillis) {
        this.layers.addPainter(name, layer, priority, cacheMillis);
    }

    public void cleanSubPanel() {
    }

    public void initSubPanel() {
        this.setLayers(new UavPaintersBag());
        this.setArgs(new Hashtable<String, Object>());
        this.addLayer("Virtual Horizon Painter", 1, new UavVirtualHorizonPainter(), 0);
        this.addLayer("Uav HUDInfo Painter", 2, new UavHUDInfoPainter(), 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        UavPaintersBag uavPaintersBag = this.layers;
        synchronized (uavPaintersBag) {
            for (IUavPainter layer : this.layers.getPostRenderPainters()) {
                Graphics2D gNew = (Graphics2D)g.create();
                layer.paint(gNew, this.getWidth(), this.getHeight(), this.args);
                gNew.dispose();
            }
        }
    }
}

