/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.acoustic;

import com.google.common.eventbus.Subscribe;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Vector;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Synthesizer;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jdesktop.swingx.JXLabel;
import org.jdesktop.swingx.JXPanel;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.LblBeacon;
import pt.lsts.imc.LblConfig;
import pt.lsts.imc.LblRangeAcceptance;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.manager.imc.ImcSystem;
import pt.lsts.neptus.comm.manager.imc.ImcSystemsHolder;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.console.events.ConsoleEventMainSystemChange;
import pt.lsts.neptus.console.plugins.MainVehicleChangeListener;
import pt.lsts.neptus.console.plugins.MissionChangeListener;
import pt.lsts.neptus.console.plugins.SubPanelChangeEvent;
import pt.lsts.neptus.console.plugins.SubPanelChangeListener;
import pt.lsts.neptus.gui.PropertiesEditor;
import pt.lsts.neptus.gui.PropertiesProvider;
import pt.lsts.neptus.gui.ToolbarButton;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.i18n.Translate;
import pt.lsts.neptus.loader.NeptusMain;
import pt.lsts.neptus.mp.MapChangeEvent;
import pt.lsts.neptus.mp.MapChangeListener;
import pt.lsts.neptus.plugins.ConfigurationListener;
import pt.lsts.neptus.plugins.NeptusMessageListener;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.Popup;
import pt.lsts.neptus.plugins.acoustic.LBLRangeLabel;
import pt.lsts.neptus.plugins.acoustic.RangePainter;
import pt.lsts.neptus.renderer2d.ILayerPainter;
import pt.lsts.neptus.renderer2d.LayerPriority;
import pt.lsts.neptus.renderer2d.Renderer2DPainter;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.MapGroup;
import pt.lsts.neptus.types.map.MarkElement;
import pt.lsts.neptus.types.map.ScatterPointsElement;
import pt.lsts.neptus.types.map.TransponderElement;
import pt.lsts.neptus.types.mission.HomeReference;
import pt.lsts.neptus.types.mission.MapMission;
import pt.lsts.neptus.types.mission.MissionType;
import pt.lsts.neptus.util.ImageUtils;
import pt.lsts.neptus.util.ReflectionUtil;
import pt.lsts.neptus.util.conf.ConfigFetch;
import pt.lsts.neptus.util.lbl.LBLTriangulationHelper;

@Popup(pos=Popup.POSITION.RIGHT, width=300, height=250, accelerator=66)
@PluginDescription(author="Paulo Dias", name="LBL Ranges", icon="pt/lsts/neptus/plugins/acoustic/lbl.png", description="Displays the LBL ranges.", documentation="lbl-ranges/lbl-ranges.html", category=PluginDescription.CATEGORY.INTERFACE)
@LayerPriority(priority=40)
public class LBLRangeDisplay
extends ConsolePanel
implements MainVehicleChangeListener,
Renderer2DPainter,
SubPanelChangeListener,
MissionChangeListener,
MapChangeListener,
ConfigurationListener,
NeptusMessageListener {
    private final Icon ICON_LBL_SHOW = ImageUtils.getIcon((String)"pt/lsts/neptus/plugins/acoustic/lbl-show.png");
    private final Icon ICON_LBL_HIDE = ImageUtils.getIcon((String)"pt/lsts/neptus/plugins/acoustic/lbl-hide.png");
    private final Icon ICON_RESET = ImageUtils.getIcon((String)"pt/lsts/neptus/plugins/acoustic/reload.png");
    private final Icon ICON_SOUND_ON = ImageUtils.getIcon((String)"pt/lsts/neptus/plugins/acoustic/sound.png");
    private final Icon ICON_SOUND_OFF = ImageUtils.getIcon((String)"pt/lsts/neptus/plugins/acoustic/sound-off.png");
    private final Icon ICON_SETTINGS = ImageUtils.getScaledIcon((Image)ImageUtils.getImage((String)"pt/lsts/neptus/plugins/acoustic/settings.png"), (int)24, (int)24);
    @NeptusProperty(name="Seconds to display ranges", description="Use -1 to not clear the ranges from the renderer.", userLevel=NeptusProperty.LEVEL.REGULAR)
    public int secondsToDisplayRanges = 5;
    @NeptusProperty(name="Hide or fade the old ranges", description="True to hide the range and false to fade when display time elapses.", userLevel=NeptusProperty.LEVEL.REGULAR)
    public HideOrFadeRangeEnum hideOrFadeRange = HideOrFadeRangeEnum.FADE;
    @NeptusProperty(name="Number of points to display", userLevel=NeptusProperty.LEVEL.REGULAR)
    public int numberOfShownPoints = 100;
    @NeptusProperty(name="Accepted range color", userLevel=NeptusProperty.LEVEL.REGULAR)
    public Color acceptedColor = Color.ORANGE;
    @NeptusProperty(name="Rejected range color", userLevel=NeptusProperty.LEVEL.REGULAR)
    public Color rejectedColor = Color.RED.brighter();
    @NeptusProperty(name="Surface range color", userLevel=NeptusProperty.LEVEL.REGULAR)
    public Color surfaceColor = Color.BLUE;
    @NeptusProperty(name="MIDI Channel", category="Communication")
    public int midi_channel = 13;
    @NeptusProperty(name="Number of distinct frequencies", category="Communication", editable=false, userLevel=NeptusProperty.LEVEL.REGULAR)
    public int numFreqs = 8;
    @NeptusProperty(name="Volume")
    public int volume = 100;
    @NeptusProperty(name="Use Only New LBL Range Acceptance Message", category="Communication")
    public boolean useOnlyNewLblRangeAcceptance = true;
    @NeptusProperty(name="Draw Range Up Or Down The Point")
    public boolean drawRangeUpOrDownThePoint = true;
    @NeptusProperty(name="Play Sound On Surface Ranges")
    public boolean playSoundOnSurfaceRanges = false;
    private JXLabel title = null;
    private JScrollPane scrollPane = null;
    private JXPanel holder = null;
    private final LinkedHashMap<String, LBLRangeLabel> beacons = new LinkedHashMap();
    private MissionType missionType = new MissionType();
    private HomeReference hRef = new HomeReference();
    private final LocationType locStart = new LocationType();
    private LocationType startPos = new LocationType();
    private Vector<ILayerPainter> renderers = new Vector();
    private ScatterPointsElement scatter = null;
    private long lastCalcPosTimeMillis = -1L;
    private LinkedList<TransponderElement> transponders = new LinkedList();
    private LinkedList<RangePainter> rangeFixPainter = new LinkedList();
    private LBLTriangulationHelper lblTriangulationHelper = null;
    protected ShortMessage msg = new ShortMessage();
    protected Synthesizer synth;
    protected Receiver receiver;
    private boolean showInRender = true;
    private boolean playSound = true;
    private boolean initCalled = false;
    private AbstractAction showAction;
    private AbstractAction resetAction;
    private AbstractAction soundAction;
    private AbstractAction settingsAction;

    public LBLRangeDisplay(ConsoleLayout console) {
        super(console);
        this.initializeActions();
        this.initialize();
    }

    private void initialize() {
        block3: {
            this.removeAll();
            this.setLayout(new BorderLayout());
            this.title = new JXLabel("<html><b>" + I18n.text((String)"LBL Ranges"));
            this.title.setHorizontalTextPosition(0);
            this.title.setHorizontalAlignment(0);
            this.title.setFont(new Font("Arial", 1, 12));
            this.holder = new JXPanel(true);
            this.holder.setLayout((LayoutManager)new BoxLayout((Container)this.holder, 1));
            this.scrollPane = new JScrollPane();
            this.scrollPane.setVerticalScrollBarPolicy(20);
            this.scrollPane.setHorizontalScrollBarPolicy(30);
            this.scrollPane.setViewportView((Component)this.holder);
            JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 2));
            panel.add((Component)this.title);
            if (this.getConsole() == null) {
                panel.add((Component)new ToolbarButton(this.settingsAction));
            }
            panel.add((Component)new ToolbarButton(this.soundAction));
            panel.add((Component)new ToolbarButton(this.showAction));
            panel.add((Component)new ToolbarButton(this.resetAction));
            this.add(panel, "North");
            this.add(this.scrollPane, "Center");
            try {
                this.synth = MidiSystem.getSynthesizer();
                this.receiver = this.synth.getReceiver();
            }
            catch (Exception e) {
                NeptusLog.pub().error((Object)I18n.text((String)"Unable to start MIDI sound device"));
                if (!ConfigFetch.isOSEqual((short)1)) break block3;
                System.err.println(I18n.text((String)"For midi, try running Neptus with the command 'padsp ./neptus.sh'."));
            }
        }
        this.initTracker();
    }

    public void initSubPanel() {
        if (this.initCalled) {
            return;
        }
        this.initCalled = true;
        this.missionType = this.getConsole().getMission();
        try {
            this.reInitTracker();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.synth.open();
        }
        catch (Exception e) {
            if (ConfigFetch.isOSEqual((short)1)) {
                System.err.println(I18n.text((String)"Unable to open midi synthesizer. Try running Neptus with the command 'padsp ./neptus.sh'."));
            }
            NeptusLog.pub().error((Object)e);
        }
        this.renderers = this.getConsole().getSubPanelsOfInterface(ILayerPainter.class);
        for (ILayerPainter str2d : this.renderers) {
            str2d.addPostRenderPainter((Renderer2DPainter)this, ((Object)((Object)this)).getClass().getSimpleName());
        }
    }

    public void cleanSubPanel() {
        if (this.synth != null) {
            try {
                this.synth.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.renderers = this.getConsole().getSubPanelsOfInterface(ILayerPainter.class);
        for (ILayerPainter str2d : this.renderers) {
            str2d.removePostRenderPainter((Renderer2DPainter)this);
        }
        for (RangePainter rp : this.rangeFixPainter) {
            rp.cleanup();
        }
        this.rangeFixPainter.clear();
        for (LBLRangeLabel lrl : this.beacons.values()) {
            lrl.dispose();
        }
        this.beacons.clear();
        this.holder.removeAll();
        NeptusLog.pub().debug((Object)"lbl cleanup end");
    }

    public void propertiesChanged() {
        for (RangePainter rgp : this.rangeFixPainter) {
            rgp.setSecondsToDisplayRanges(this.secondsToDisplayRanges);
            rgp.setHideOrFadeRange(this.hideOrFadeRange == HideOrFadeRangeEnum.HIDE);
            rgp.setAcceptedColor(this.acceptedColor);
            rgp.setRejectedColor(this.rejectedColor);
        }
    }

    private void reset() {
        for (LBLRangeLabel lrl : this.beacons.values()) {
            lrl.dispose();
        }
        this.beacons.clear();
        this.holder.removeAll();
        this.reInitTracker();
    }

    public void initializeActions() {
        this.showAction = new AbstractAction(I18n.text((String)"Show Tracker Data"), this.ICON_LBL_SHOW){

            @Override
            public void actionPerformed(ActionEvent e) {
                String actionCmd = LBLRangeDisplay.this.showAction.getValue("ShortDescription").toString();
                if (actionCmd.equals(I18n.text((String)"Hide Tracker Data"))) {
                    LBLRangeDisplay.this.showInRender = false;
                    LBLRangeDisplay.this.showAction.putValue("ShortDescription", I18n.text((String)"Show Tracker Data"));
                    LBLRangeDisplay.this.showAction.putValue("SmallIcon", LBLRangeDisplay.this.ICON_LBL_HIDE);
                } else if (actionCmd.equals(I18n.text((String)"Show Tracker Data"))) {
                    LBLRangeDisplay.this.showInRender = true;
                    LBLRangeDisplay.this.showAction.putValue("ShortDescription", I18n.text((String)"Hide Tracker Data"));
                    LBLRangeDisplay.this.showAction.putValue("SmallIcon", LBLRangeDisplay.this.ICON_LBL_SHOW);
                }
            }
        };
        this.showAction.putValue("ShortDescription", I18n.text((String)"Hide Tracker Data"));
        this.resetAction = new AbstractAction(I18n.text((String)"Reset"), this.ICON_RESET){

            @Override
            public void actionPerformed(ActionEvent e) {
                LBLRangeDisplay.this.reset();
            }
        };
        this.resetAction.putValue("ShortDescription", I18n.text((String)"Reset Tracker"));
        this.soundAction = new AbstractAction(I18n.text((String)"Play Sound"), this.ICON_SOUND_ON){

            @Override
            public void actionPerformed(ActionEvent e) {
                String actionCmd = LBLRangeDisplay.this.soundAction.getValue("ShortDescription").toString();
                if (actionCmd.equals(I18n.text((String)"Don't Play Sound"))) {
                    LBLRangeDisplay.this.playSound = false;
                    LBLRangeDisplay.this.soundAction.putValue("ShortDescription", I18n.text((String)"Play Sound"));
                    LBLRangeDisplay.this.soundAction.putValue("SmallIcon", LBLRangeDisplay.this.ICON_SOUND_OFF);
                } else if (actionCmd.equals(I18n.text((String)"Play Sound"))) {
                    LBLRangeDisplay.this.playSound = true;
                    LBLRangeDisplay.this.soundAction.putValue("ShortDescription", I18n.text((String)"Don't Play Sound"));
                    LBLRangeDisplay.this.soundAction.putValue("SmallIcon", LBLRangeDisplay.this.ICON_SOUND_ON);
                }
            }
        };
        this.soundAction.putValue("ShortDescription", I18n.text((String)"Don't Play Sound"));
        this.settingsAction = new AbstractAction(I18n.text((String)"Settings"), this.ICON_SETTINGS){

            @Override
            public void actionPerformed(ActionEvent e) {
                PropertiesEditor.editProperties((PropertiesProvider)LBLRangeDisplay.this, (Frame)LBLRangeDisplay.this.getConsole(), (boolean)true);
            }
        };
        this.settingsAction.putValue("ShortDescription", I18n.text((String)"Settings"));
    }

    private void playSound(int channel, boolean accepted) {
        if (this.receiver != null && this.playSound) {
            try {
                if (!accepted) {
                    channel += this.numFreqs / 2;
                }
                this.msg.setMessage(144, this.midi_channel, 50 + 16 / this.numFreqs * channel, this.volume);
                this.receiver.send(this.msg, -1L);
            }
            catch (Exception e) {
                NeptusLog.pub().error((Object)e);
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    @Subscribe
    public void mainVehicleChangeNotification(ConsoleEventMainSystemChange evt) {
        this.reset();
    }

    @Subscribe
    public void consume(LblConfig msg) {
        if (!msg.getSourceName().equals(this.getConsole().getMainSystem())) {
            return;
        }
        if (msg.getOp() == LblConfig.OP.CUR_CFG) {
            this.reInitTracker();
        }
    }

    public void paint(Graphics2D g2, StateRenderer2D renderer) {
        AffineTransform identity = g2.getTransform();
        if (!this.showInRender) {
            return;
        }
        double alfaPercentage = 1.0;
        long deltaTimeMillis = System.currentTimeMillis() - this.lastCalcPosTimeMillis;
        if ((double)deltaTimeMillis > (double)this.secondsToDisplayRanges * 1000.0 / 2.0) {
            alfaPercentage = 0.5;
        } else if ((double)deltaTimeMillis > (double)this.secondsToDisplayRanges * 1000.0 / 4.0) {
            alfaPercentage = 0.7;
        }
        if (this.scatter != null) {
            this.scatter.paint(g2, renderer, -renderer.getRotation());
        }
        try {
            for (RangePainter rfp : this.rangeFixPainter.toArray(new RangePainter[0])) {
                rfp.paint(g2, renderer);
            }
        }
        catch (ConcurrentModificationException e) {
            e.printStackTrace();
        }
        Point2D centerPos = renderer.getScreenPosition(new LocationType(this.lblTriangulationHelper.getLastKnownPos()));
        Graphics2D g = (Graphics2D)g2.create();
        g.setTransform(identity);
        g.setColor(new Color(255, 255, 255, (int)(255.0 * alfaPercentage)));
        g.draw(new Ellipse2D.Double(centerPos.getX() - 10.0, centerPos.getY() - 10.0, 20.0, 20.0));
        g.setColor(new Color(this.acceptedColor.getRed(), this.acceptedColor.getGreen(), this.acceptedColor.getBlue(), (int)(255.0 * alfaPercentage)));
        g.draw(new Ellipse2D.Double(centerPos.getX() - 12.0, centerPos.getY() - 12.0, 24.0, 24.0));
        g.setColor(new Color(255, 255, 255, (int)(255.0 * alfaPercentage)));
        g.draw(new Ellipse2D.Double(centerPos.getX() - 14.0, centerPos.getY() - 14.0, 28.0, 28.0));
        g.translate(centerPos.getX(), centerPos.getY());
        Color color = this.acceptedColor.darker();
        g.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)(200.0 * alfaPercentage)));
        g.fill(new Ellipse2D.Double(-7.0, -7.0, 14.0, 14.0));
        color = this.acceptedColor.brighter();
        g.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)(150.0 * alfaPercentage)));
        g.setStroke(new BasicStroke(2.0f));
        g.draw(new Ellipse2D.Double(-7.0, -7.0, 14.0, 14.0));
        g.setColor(new Color(255, 255, 255, (int)(150.0 * alfaPercentage)));
        g.fill(new Ellipse2D.Double(-2.0, -2.0, 4.0, 4.0));
        g.setColor(Color.BLACK);
        g.dispose();
    }

    public void subPanelChanged(SubPanelChangeEvent panelChange) {
        if (ReflectionUtil.hasInterface(panelChange.getPanel().getClass(), ILayerPainter.class)) {
            ILayerPainter str2d;
            ILayerPainter sub = (ILayerPainter)panelChange.getPanel();
            if (panelChange.added()) {
                this.renderers.add(sub);
                str2d = sub;
                if (str2d != null) {
                    str2d.addPostRenderPainter((Renderer2DPainter)this, "LBL Tracker Range");
                }
            }
            if (panelChange.removed()) {
                this.renderers.remove(sub);
                str2d = sub;
                if (str2d != null) {
                    str2d.removePostRenderPainter((Renderer2DPainter)this);
                }
            }
        }
    }

    public void missionReplaced(MissionType mission) {
        this.missionType = mission;
        this.reInitTracker();
    }

    public void missionUpdated(MissionType mission) {
        this.missionType = mission;
        this.reInitTracker();
    }

    public void mapChanged(MapChangeEvent mapChange) {
        this.reInitTracker();
    }

    private void reInitTracker() {
        if (this.scatter != null) {
            this.scatter.clearPoints();
        }
        for (RangePainter rp : this.rangeFixPainter) {
            rp.cleanup();
        }
        this.rangeFixPainter.clear();
        this.initTracker();
    }

    private void initTracker() {
        LocationType sysLoc;
        LinkedHashMap mapList = this.missionType.getMapsList();
        ImcSystem system = ImcSystemsHolder.getSystemWithName((String)this.getMainVehicleId());
        if (system != null) {
            Vector beaconList;
            LblConfig lbl = (LblConfig)system.retrieveData("LblConfig");
            try {
                beaconList = lbl.getBeacons();
            }
            catch (Exception e) {
                return;
            }
            ArrayList<TransponderElement> tal = new ArrayList<TransponderElement>();
            short duneId = 0;
            MapGroup mg = MapGroup.getMapGroupInstance((MissionType)this.getConsole().getMission());
            for (LblBeacon lblBeacon : beaconList) {
                tal.add(new TransponderElement(lblBeacon, duneId, mg, mg.getMaps()[0]));
                duneId = (short)(duneId + 1);
            }
            for (TransponderElement transponderElement : tal) {
                this.transponders.add(transponderElement);
                RangePainter rgp = new RangePainter(transponderElement.getCenterLocation()){

                    @Override
                    public void callParentRepaint() {
                        for (ILayerPainter str2d : LBLRangeDisplay.this.renderers) {
                            ((ConsolePanel)str2d).repaint();
                        }
                    }
                };
                rgp.setSecondsToDisplayRanges(this.secondsToDisplayRanges);
                rgp.setHideOrFadeRange(this.hideOrFadeRange == HideOrFadeRangeEnum.HIDE);
                rgp.setSquareColor(Color.GREEN);
                rgp.setAcceptedColor(this.acceptedColor);
                rgp.setRejectedColor(this.rejectedColor);
                rgp.setSurfaceColor(this.surfaceColor);
                rgp.setDrawRangeUpOrDownThePoint(this.drawRangeUpOrDownThePoint);
                this.rangeFixPainter.add(rgp);
            }
        }
        this.hRef = new HomeReference(this.missionType.getHomeRef().asXML());
        this.hRef.setRoll(0.0);
        this.hRef.setPitch(0.0);
        this.hRef.setYaw(0.0);
        this.locStart.setLocation((LocationType)this.hRef);
        boolean isFound = false;
        ImcSystem sys = ImcSystemsHolder.lookupSystemByName((String)this.getMainVehicleId());
        if (sys != null && !(sysLoc = sys.getLocation()).equals((Object)LocationType.ABSOLUTE_ZERO)) {
            this.startPos = new LocationType(sysLoc);
            isFound = true;
        }
        if (!isFound) {
            for (MapMission mpm : mapList.values()) {
                LinkedHashMap transList = mpm.getMap().getMarksList();
                for (MarkElement markElement : transList.values()) {
                    String name = markElement.getId();
                    if (!name.equalsIgnoreCase("start")) continue;
                    this.locStart.setLocation(markElement.getCenterLocation());
                    isFound = true;
                    break;
                }
                if (!isFound) continue;
                break;
            }
        }
        this.startPos = isFound ? new LocationType(this.locStart) : new LocationType(this.locStart);
        try {
            if (this.lblTriangulationHelper == null) {
                this.lblTriangulationHelper = new LBLTriangulationHelper(this.transponders.toArray(new TransponderElement[0]), this.startPos);
            } else {
                this.lblTriangulationHelper.reset(this.transponders.toArray(new TransponderElement[0]), this.startPos);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (ILayerPainter str2d : this.renderers) {
            str2d.addPostRenderPainter((Renderer2DPainter)this, "LBL Tracker Display");
        }
    }

    private void paintRange(int indOrigin, double distance, boolean accepted, String reason) {
        try {
            RangePainter rangePainter = this.rangeFixPainter.get(indOrigin);
            if (rangePainter != null) {
                rangePainter.updateGraphics(distance, accepted, reason);
            }
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)(e.getMessage() + "   ::  " + (Object)((Object)this)));
        }
    }

    public String[] getObservedMessages() {
        return new String[]{"LblRangeAcceptance", "LblRange"};
    }

    public void messageArrived(IMCMessage message) {
        if (this.transponders.size() == 0) {
            return;
        }
        if (message.getAbbrev().equals("LblRangeAcceptance")) {
            try {
                LblRangeAcceptance acceptance = LblRangeAcceptance.clone((IMCMessage)message);
                LBLRangeLabel lb = this.beacons.get("" + acceptance.getId());
                if (lb == null) {
                    lb = new LBLRangeLabel("" + acceptance.getId());
                    this.beacons.put("" + acceptance.getId(), lb);
                    this.holder.add((Component)((Object)lb));
                }
                lb.setRange(acceptance.getRange());
                lb.setTimeStampMillis(acceptance.getTimestampMillis());
                switch (acceptance.getAcceptance()) {
                    case ACCEPTED: {
                        this.lblTriangulationHelper.updateRangeAccepted((long)acceptance.getId(), acceptance.getRange(), acceptance.getTimestampMillis());
                        this.paintRange(acceptance.getId(), acceptance.getRange(), true, "");
                        lb.setAccepted(true, "");
                        this.playSound(acceptance.getId(), true);
                        break;
                    }
                    default: {
                        this.lblTriangulationHelper.updateRangeRejected((long)acceptance.getId(), acceptance.getRange(), acceptance.getTimestampMillis(), acceptance.getAcceptance().toString());
                        this.paintRange(acceptance.getId(), acceptance.getRange(), false, I18n.text((String)acceptance.getAcceptance().toString()));
                        lb.setAccepted(false, I18n.text((String)acceptance.getAcceptance().toString()));
                        if (!acceptance.getAcceptance().equals((Object)LblRangeAcceptance.ACCEPTANCE.AT_SURFACE) || this.playSoundOnSurfaceRanges && acceptance.getAcceptance().equals((Object)LblRangeAcceptance.ACCEPTANCE.AT_SURFACE)) {
                            this.playSound(acceptance.getId(), false);
                        }
                        break;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (!this.useOnlyNewLblRangeAcceptance && message.getAbbrev().equals("LblRange")) {
            int id = message.getInteger("id");
            double range = message.getDouble("range");
            long timeStampMillis = message.getTimestampMillis();
            this.lblTriangulationHelper.updateRangeAccepted((long)id, range, timeStampMillis);
            this.paintRange(id, range, true, "");
            LBLRangeLabel lb = this.beacons.get("" + id);
            if (lb == null) {
                lb = new LBLRangeLabel("" + id);
                this.beacons.put("" + id, lb);
                this.holder.add((Component)((Object)lb));
            }
            lb.setRange(range);
            lb.setTimeStampMillis(timeStampMillis);
            lb.setAccepted(true, "");
            this.playSound(id, true);
        } else if (!this.useOnlyNewLblRangeAcceptance && message.getAbbrev().equals("LblRangeRejection")) {
            int id = message.getInteger("id");
            double range = message.getDouble("range");
            long timeStampMillis = message.getTimestampMillis();
            String reason = message.getString("reason");
            this.lblTriangulationHelper.updateRangeRejected((long)id, range, timeStampMillis, reason);
            this.paintRange(id, range, false, I18n.text((String)reason));
            LBLRangeLabel lb = this.beacons.get("" + id);
            if (lb == null) {
                lb = new LBLRangeLabel("" + id);
                this.beacons.put("" + id, lb);
                this.holder.add((Component)((Object)lb));
            }
            lb.setRange(range);
            lb.setTimeStampMillis(timeStampMillis);
            lb.setAccepted(false, I18n.text((String)reason));
            if (!reason.equals("AT_SURFACE") || this.playSoundOnSurfaceRanges && reason.equals("AT_SURFACE")) {
                this.playSound(id, false);
            }
        }
    }

    public static void main(String[] args) {
        NeptusMain.main((String[])new String[]{"./conf/consoles/seacon-light.ncon"});
    }

    @Translate
    public static enum HideOrFadeRangeEnum {
        HIDE,
        FADE;

    }
}

