/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.acoustic;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Paint;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import org.jdesktop.swingx.JXLabel;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.painter.AbstractAreaPainter;
import org.jdesktop.swingx.painter.CompoundPainter;
import org.jdesktop.swingx.painter.GlossPainter;
import org.jdesktop.swingx.painter.Painter;
import org.jdesktop.swingx.painter.RectanglePainter;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.MathMiscUtils;
import pt.lsts.neptus.util.gui.LBLUtil;

public class LBLRangeLabel
extends JXPanel {
    private static final Color COLOR_IDLE = new JXPanel().getBackground();
    private static final Color COLOR_ACCEPT = Color.GREEN.darker();
    private static final Color COLOR_REJECTED = new Color(245, 20, 40);
    private static final Color COLOR_SURFACE = Color.blue;
    private static final Color COLOR_OLD = Color.GRAY.darker();
    private Timer timer = null;
    private TimerTask colorUpdaterTask = null;
    private TimerTask periodicTask = null;
    private String name = "?";
    private double range = -1.0;
    private boolean isAccepted = true;
    private String rejectionReason = "";
    private JXLabel label = null;
    private long timeStampMillis = -1L;
    private RectanglePainter rectPainter;
    private CompoundPainter<JXPanel> compoundBackPainter;

    public LBLRangeLabel(String name) {
        this.name = name;
        this.initialize();
    }

    private void initialize() {
        this.setBackgroundPainter((Painter)this.getCompoundBackPainter());
        this.label = new JXLabel("<html><b>" + this.name, 0){

            public void setText(String text) {
                if (text.equals(this.getText())) {
                    return;
                }
                super.setText(text);
            }
        };
        this.label.setHorizontalTextPosition(0);
        this.label.setHorizontalAlignment(0);
        this.label.setFont(new Font("Arial", 1, 12));
        this.label.setForeground(Color.WHITE);
        this.label.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.setLayout(new BorderLayout());
        this.add((Component)this.label, "Center");
        this.setPreferredSize(new Dimension(215, 180));
        this.setSize(new Dimension(215, 180));
    }

    public double getRange() {
        return this.range;
    }

    public void setRange(double range) {
        this.range = range;
        this.updateLabel();
    }

    public boolean isAccepted() {
        return this.isAccepted;
    }

    public void setAccepted(boolean isAccepted, String rejectionReason) {
        this.isAccepted = isAccepted;
        this.rejectionReason = rejectionReason;
        if (isAccepted) {
            this.updateBackColor(COLOR_ACCEPT);
        } else {
            this.updateBackColor(rejectionReason.contains("SURFACE") ? COLOR_SURFACE : COLOR_REJECTED);
        }
        this.setToolTipText(isAccepted ? I18n.text((String)"Accepted") : I18n.text((String)"Rejected") + (rejectionReason != null ? " " + rejectionReason : ""));
        this.updateLabel();
        this.revokeScheduleUpdateTask();
        this.scheduleUpdateTask();
    }

    public void setTimeStampMillis(long timeStampMillis) {
        this.timeStampMillis = timeStampMillis;
        if (this.periodicTask == null) {
            this.periodicTask = new TimerTask(){

                @Override
                public void run() {
                    LBLRangeLabel.this.updateLabel(false);
                }
            };
            this.timer.scheduleAtFixedRate(this.periodicTask, 50L, 1000L);
        }
    }

    private void updateLabel() {
        this.updateLabel(true);
    }

    private void updateLabel(boolean triggerChangeColorIndicator) {
        String ellapsedTime = LBLUtil.writeTimeLabel((long)this.timeStampMillis);
        this.label.setText(I18n.textf((String)"<html><b>Beacon %beaconid (%range m) %datetime <br>%reason", (Object[])new Object[]{"ch" + this.name, MathMiscUtils.round((double)this.range, (int)1), ellapsedTime, this.isAccepted ? I18n.text((String)"Accepted") : I18n.text((String)"Rejected") + (this.rejectionReason != null ? ": " + this.rejectionReason : "")}));
        if (triggerChangeColorIndicator) {
            this.revokeScheduleUpdateTask();
            this.scheduleUpdateTask();
        }
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        super.setName(name);
        this.name = name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof LBLRangeLabel) {
            return ((LBLRangeLabel)((Object)obj)).getName().equals(this.name);
        }
        return false;
    }

    private void scheduleUpdateTask() {
        if (this.colorUpdaterTask == null) {
            if (this.timer == null) {
                this.timer = new Timer(LBLRangeLabel.class.getSimpleName() + " color updater: " + this.name, true);
            }
            this.colorUpdaterTask = this.createTimerTask();
            this.timer.schedule(this.colorUpdaterTask, 1000L);
        }
    }

    private void revokeScheduleUpdateTask() {
        if (this.colorUpdaterTask != null) {
            this.colorUpdaterTask.cancel();
            this.colorUpdaterTask = null;
        }
    }

    private TimerTask createTimerTask() {
        return new TimerTask(){

            @Override
            public void run() {
                LBLRangeLabel.this.updateBackColor(((Color)LBLRangeLabel.this.rectPainter.getFillPaint()).darker());
                LBLRangeLabel.this.colorUpdaterTask = LBLRangeLabel.this.createTimerTask2();
                LBLRangeLabel.this.timer.schedule(LBLRangeLabel.this.colorUpdaterTask, 4000L);
            }
        };
    }

    private TimerTask createTimerTask2() {
        return new TimerTask(){

            @Override
            public void run() {
                LBLRangeLabel.this.updateBackColor(COLOR_OLD);
            }
        };
    }

    private RectanglePainter getRectPainter() {
        if (this.rectPainter == null) {
            this.rectPainter = new RectanglePainter(5, 5, 5, 5, 20, 20);
            this.rectPainter.setFillPaint((Paint)COLOR_IDLE);
            this.rectPainter.setBorderPaint((Paint)COLOR_IDLE.darker().darker().darker());
            this.rectPainter.setStyle(AbstractAreaPainter.Style.BOTH);
            this.rectPainter.setBorderWidth(2.0f);
            this.rectPainter.setAntialiasing(true);
        }
        return this.rectPainter;
    }

    private CompoundPainter<JXPanel> getCompoundBackPainter() {
        this.compoundBackPainter = new CompoundPainter(new Painter[]{this.getRectPainter(), new GlossPainter()});
        return this.compoundBackPainter;
    }

    private void updateBackColor(Color color) {
        this.getRectPainter().setFillPaint((Paint)color);
        this.getRectPainter().setBorderPaint((Paint)color.darker());
        this.repaint();
    }

    public void dispose() {
        this.revokeScheduleUpdateTask();
        if (this.periodicTask != null) {
            this.periodicTask.cancel();
            this.periodicTask = null;
        }
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
    }

    public static void main(String[] args) {
        final LBLRangeLabel lb = new LBLRangeLabel("1");
        GuiUtils.testFrame((JComponent)((Object)lb));
        lb.setRange(233.5);
        lb.setAccepted(false, "ABOVE_THRESHOLD");
        Timer timer = new Timer("LblRangeLabel Main");
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                lb.setAccepted(!lb.isAccepted(), "ABOVE_THRESHOLD");
            }
        }, 6000L, 6000L);
    }
}

