/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.acoustic;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import pt.lsts.imc.IMCMessage;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mra.importers.IMraLog;
import pt.lsts.neptus.mra.importers.IMraLogGroup;
import pt.lsts.neptus.mra.replay.LogReplayComponent;
import pt.lsts.neptus.mra.replay.LogReplayLayer;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.acoustic.RangePainter;
import pt.lsts.neptus.renderer2d.LayerPriority;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.TransponderElement;
import pt.lsts.neptus.util.lbl.LBLTriangulationHelper;
import pt.lsts.neptus.util.llf.LogUtils;

@LayerPriority(priority=-50)
@PluginDescription(name="LBL Ranges", icon="pt/lsts/neptus/plugins/acoustic/transponder.png")
public class LBLRangesReplay
implements LogReplayLayer {
    private LinkedList<TransponderElement> transponders = new LinkedList();
    private LocationType start = new LocationType();
    private LinkedList<LocationType> triangulatedRangesPointsList = new LinkedList();
    private LinkedList<RangePainter> rangeFixPainter = new LinkedList();
    private LBLTriangulationHelper lblTriangulationHelper = null;

    public String getName() {
        return I18n.text((String)"LBL Ranges");
    }

    public void cleanup() {
        this.transponders.clear();
        this.triangulatedRangesPointsList.clear();
        this.rangeFixPainter.clear();
        this.start = null;
    }

    public boolean canBeApplied(IMraLogGroup source, LogReplayComponent.Context context) {
        return source.getLog("LblRangeAcceptance") != null && source.getLog("LblConfig") != null;
    }

    public void parse(IMraLogGroup source) {
        TransponderElement[] transpondersArray = LogUtils.getTransponders((IMraLogGroup)source);
        if (transpondersArray.length == 0) {
            return;
        }
        this.transponders.addAll(Arrays.asList(transpondersArray));
        try {
            IMCMessage m;
            this.start = LogUtils.getStartupPoint((IMraLogGroup)source);
            if (this.start == null) {
                this.start = LogUtils.getHomeRef((IMraLogGroup)source);
            }
            for (TransponderElement te : this.transponders) {
                RangePainter rp = new RangePainter(te.getCenterLocation()){

                    @Override
                    public void callParentRepaint() {
                    }
                };
                this.rangeFixPainter.add(rp);
            }
            try {
                IMraLog gpsFix = source.getLog("GpsFix");
                if (gpsFix != null) {
                    IMCMessage m2;
                    while ((m2 = gpsFix.nextLogEntry()) != null) {
                        double lat = Math.toDegrees(m2.getDouble("lat"));
                        double lon = Math.toDegrees(m2.getDouble("lon"));
                        LinkedHashMap validity = m2.getBitmask("validity");
                        if (!((Boolean)validity.get("VALID_POS")).booleanValue()) continue;
                        this.start = new LocationType(lat, lon);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            IMraLog lblRangeAcceptancesLog = source.getLog("LblRangeAcceptance");
            if (this.lblTriangulationHelper == null) {
                this.lblTriangulationHelper = new LBLTriangulationHelper(this.transponders.toArray(new TransponderElement[this.transponders.size()]), this.start);
            } else {
                this.lblTriangulationHelper.reset(this.transponders.toArray(new TransponderElement[this.transponders.size()]), this.start);
            }
            boolean useEstimatedStateToFixLastKnownPos = false;
            IMraLog esLog = source.getLog("EstimatedState");
            if (esLog != null) {
                useEstimatedStateToFixLastKnownPos = true;
            }
            while ((m = lblRangeAcceptancesLog.nextLogEntry()) != null) {
                LocationType loc;
                IMCMessage esEntry;
                LocationType locES;
                double id = m.getInteger("id");
                double range = m.getDouble("range");
                if (useEstimatedStateToFixLastKnownPos && (locES = LogUtils.getLocation((IMCMessage)(esEntry = esLog.getEntryAtOrAfter(m.getTimestampMillis())))) != null) {
                    this.lblTriangulationHelper.resetLastKnownPos(locES, esEntry.getTimestampMillis());
                }
                if ((loc = this.lblTriangulationHelper.updateRangeAccepted((long)id, range, m.getTimestampMillis())) == null) continue;
                this.triangulatedRangesPointsList.add(loc);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String[] getObservedMessages() {
        return new String[]{"LblRangeAcceptance"};
    }

    public void onMessage(IMCMessage message) {
        if ("LblRangeAcceptance".equalsIgnoreCase(message.getAbbrev())) {
            if (this.rangeFixPainter.isEmpty()) {
                return;
            }
            int id = message.getInteger("id");
            double range = message.getDouble("range");
            String accep = message.getString("acceptance");
            String reason = message.getString("reason");
            RangePainter rp = this.rangeFixPainter.get(id);
            rp.setRange(range);
            rp.setAccepted(accep == null || "ACCEPTED".equalsIgnoreCase(accep));
            rp.setRejectionReason(reason);
        }
    }

    public void paint(Graphics2D g, StateRenderer2D renderer) {
        g.setColor(Color.magenta);
        for (RangePainter rp : this.rangeFixPainter) {
            rp.paint((Graphics2D)g.create(), renderer);
        }
        for (LocationType loc : this.triangulatedRangesPointsList) {
            Point2D pt = renderer.getScreenPosition(loc);
            g.drawLine((int)pt.getX() - 3, (int)pt.getY(), (int)pt.getX() + 3, (int)pt.getY());
            g.drawLine((int)pt.getX(), (int)pt.getY() - 3, (int)pt.getX(), (int)pt.getY() + 3);
        }
    }

    public boolean getVisibleByDefault() {
        return true;
    }
}

