/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.acoustic;

import com.google.common.eventbus.Subscribe;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.util.LinkedHashMap;
import java.util.Map;
import pt.lsts.imc.LblEstimate;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.console.notifications.Notification;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.renderer2d.Renderer2DPainter;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.LocationType;

@PluginDescription(author="ZP", name="LBL Estimates Overlay", icon="pt/lsts/neptus/plugins/acoustic/lbl.png", description="Displays LBL position estimations calculated by AUVs", category=PluginDescription.CATEGORY.INTERFACE)
public class LblEstimateOverlay
extends ConsolePanel
implements Renderer2DPainter {
    private static final long serialVersionUID = -1669624418060388974L;
    protected LinkedHashMap<String, LblEstimate> lastEstimates = new LinkedHashMap();
    protected LinkedHashMap<String, Long> lastWarnings = new LinkedHashMap();
    protected static final long millisBetweenWarnings = 60000L;
    @NeptusProperty(name="Paint received estimates on the map")
    public boolean paintEstimates = true;
    @NeptusProperty
    public boolean simulation = true;
    @NeptusProperty(name="Distance above which user will be warned about estimations")
    public double minDistanceForWarning = 5.0;

    public LblEstimateOverlay(ConsoleLayout console) {
        super(console);
    }

    public void initSubPanel() {
    }

    public void cleanSubPanel() {
    }

    public void paint(Graphics2D g2d, StateRenderer2D renderer) {
        if (!this.paintEstimates) {
            return;
        }
        double zoom = renderer.getZoom();
        for (Map.Entry<String, LblEstimate> estimateEntry : this.lastEstimates.entrySet()) {
            boolean outside;
            Graphics2D g = (Graphics2D)g2d.create();
            LocationType loc = new LocationType(Math.toDegrees(estimateEntry.getValue().getBeacon().getLat()), Math.toDegrees(estimateEntry.getValue().getBeacon().getLon()));
            Point2D center = renderer.getScreenPosition(loc);
            g.translate(center.getX(), center.getY());
            g.rotate(-renderer.getRotation());
            boolean bl = outside = estimateEntry.getValue().getDistance() > Math.max(estimateEntry.getValue().getVarX(), estimateEntry.getValue().getVarY());
            if (!outside) {
                g.setColor(new Color(0, 255, 0, 128));
            } else {
                g.setColor(new Color(192, 64, 0, 128));
            }
            double northVar = estimateEntry.getValue().getVarX() * zoom;
            double eastVar = estimateEntry.getValue().getVarY() * zoom;
            g.fill(new Ellipse2D.Double(-eastVar, -northVar, eastVar * 2.0, northVar * 2.0));
            if (System.currentTimeMillis() / 1000L % 2L == 0L) {
                if (outside) {
                    g.setColor(Color.red.brighter());
                } else {
                    g.setColor(Color.green.brighter());
                }
            } else {
                g.setColor(Color.black);
            }
            g.fill(new Ellipse2D.Double(-2.5, -2.5, 5.0, 5.0));
        }
    }

    @Subscribe
    public void on(LblEstimate estimate) {
        String beacon = estimate.getBeacon().getBeacon();
        this.lastEstimates.put(beacon, estimate);
        boolean warn = estimate.getDistance() > Math.max(estimate.getVarX(), estimate.getVarY());
        if ((warn &= estimate.getDistance() > 5.0) && this.getConsole() != null && (!this.lastWarnings.containsKey(beacon) || System.currentTimeMillis() - this.lastWarnings.get(beacon) > 60000L)) {
            this.post(Notification.warning((String)"Potential LBL mis-configuration", (String)("The system " + estimate.getSourceName() + " is estimating that " + beacon + " is " + estimate.getDistance() + " meters away from current configuration.")));
            this.lastWarnings.put(beacon, System.currentTimeMillis());
        }
    }
}

