/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.acoustic;

import com.google.common.eventbus.Subscribe;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import org.mozilla.javascript.edu.emory.mathcs.backport.java.util.Arrays;
import org.mozilla.javascript.edu.emory.mathcs.backport.java.util.Collections;
import pt.lsts.imc.AcousticOperation;
import pt.lsts.imc.AcousticSystems;
import pt.lsts.imc.AcousticSystemsQuery;
import pt.lsts.imc.GpsFix;
import pt.lsts.imc.IMCDefinition;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.PlanControl;
import pt.lsts.imc.RSSI;
import pt.lsts.imc.StorageUsage;
import pt.lsts.imc.TextMessage;
import pt.lsts.imc.Voltage;
import pt.lsts.imc.state.ImcSysState;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.IMCSendMessageUtils;
import pt.lsts.neptus.comm.manager.imc.ImcMsgManager;
import pt.lsts.neptus.comm.manager.imc.ImcSystem;
import pt.lsts.neptus.comm.manager.imc.ImcSystemsHolder;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.console.notifications.Notification;
import pt.lsts.neptus.gui.VehicleChooser;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.messages.listener.MessageListener;
import pt.lsts.neptus.mystate.MyState;
import pt.lsts.neptus.plugins.ConfigurationListener;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.PluginUtils;
import pt.lsts.neptus.plugins.Popup;
import pt.lsts.neptus.plugins.update.Periodic;
import pt.lsts.neptus.renderer2d.ILayerPainter;
import pt.lsts.neptus.renderer2d.LayerPriority;
import pt.lsts.neptus.renderer2d.Renderer2DPainter;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.vehicle.VehicleType;
import pt.lsts.neptus.types.vehicle.VehiclesHolder;
import pt.lsts.neptus.util.ConsoleParse;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;
import pt.lsts.neptus.util.conf.GeneralPreferences;

@PluginDescription(name="Acoustic Operations", author="ZP", icon="pt/lsts/neptus/plugins/acoustic/manta.png")
@LayerPriority(priority=40)
@Popup(name="Acoustic Operations", accelerator=77, width=350, height=250, pos=Popup.POSITION.BOTTOM_RIGHT, icon="pt/lsts/neptus/plugins/acoustic/manta.png")
public class MantaOperations
extends ConsolePanel
implements ConfigurationListener,
Renderer2DPainter {
    private static final long serialVersionUID = 1L;
    protected static JDialog visibleDialog = null;
    protected LinkedHashMap<String, JRadioButton> radioButtons = new LinkedHashMap();
    protected LinkedHashMap<String, JButton> cmdButtons = new LinkedHashMap();
    protected ButtonGroup group = new ButtonGroup();
    protected JPanel listPanel = new JPanel();
    protected JTextArea bottomPane = new JTextArea();
    protected JToggleButton toggle;
    protected String selectedSystem = null;
    protected String gateway = "any";
    protected JLabel lblState = new JLabel("<html><h1>" + I18n.text((String)"Please select a gateway") + "</h1>");
    protected LinkedHashMap<Integer, PlanControl> pendingRequests = new LinkedHashMap();
    @NeptusProperty(name="Systems listing", description="Use commas to separate system identifiers")
    public String sysListing = "benthos-1,benthos-2,benthos-3,benthos-4,lauv-xtreme-2,lauv-noptilus-1,lauv-noptilus-2,lauv-noptilus-3";
    public HashSet<String> knownSystems = new HashSet();
    @NeptusProperty(name="Display ranges in the map")
    public boolean showRanges = true;
    @NeptusProperty(name="Use system discovery", description="Instead of a static list, receive supported systems from gateway")
    public boolean sysDiscovery = true;
    protected LinkedHashMap<String, LocationType> systemLocations = new LinkedHashMap();
    protected Vector<LocationType> rangeSources = new Vector();
    protected Vector<Double> rangeDistances = new Vector();
    protected ActionListener systemActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            MantaOperations.this.selectedSystem = e.getActionCommand();
        }
    };
    protected boolean initialized = false;

    public MantaOperations(ConsoleLayout console) {
        super(console);
    }

    private boolean sendAcoustically(IMCMessage msg) {
        ImcSystem[] sysLst = this.gateways();
        if (sysLst.length == 0) {
            this.post(Notification.error((String)I18n.text((String)"Send message"), (String)I18n.text((String)"No acoustic device is capable of sending this message")).src(I18n.text((String)"Console")));
            return false;
        }
        AcousticOperation op = new AcousticOperation(AcousticOperation.OP.MSG, this.selectedSystem, 0.0f, msg);
        int successCount = 0;
        for (ImcSystem sys : sysLst) {
            if (!ImcMsgManager.getManager().sendMessage((IMCMessage)op, sys.getId(), null)) continue;
            ++successCount;
        }
        if (successCount > 0) {
            this.bottomPane.setText(I18n.textf((String)"Message sent to %systemName via %systemCount acoustic gateways", (Object[])new Object[]{this.selectedSystem, successCount}));
            return true;
        }
        this.post(Notification.error((String)I18n.text((String)"Send message"), (String)I18n.text((String)"Unable to send message to selected system")).src(I18n.text((String)"Console")));
        return false;
    }

    @Periodic(millisBetweenUpdates=1500)
    public void updateStateLabel() {
        if (!this.lblState.isVisible()) {
            return;
        }
        this.lblState.setText(this.buildState());
    }

    private String buildState() {
        if (this.gateway == null || this.gateway.equals(I18n.text((String)"any"))) {
            return "<html><h1>" + I18n.text((String)"Please select a gateway") + "</h1></html>";
        }
        ImcSysState state = ImcMsgManager.getManager().getState(this.gateway);
        StringBuilder html = new StringBuilder("<html>");
        html.append("<h1>" + I18n.textf((String)"%gateway state", (Object[])new Object[]{this.gateway}) + "</h1>");
        html.append("<blockquote><ul>\n");
        try {
            RSSI iridiumRSSI = state.lastRSSI("Iridium Modem");
            html.append("<li>" + I18n.textf((String)"Iridium RSSI: %d  &#37;", (Object[])new Object[]{iridiumRSSI.getValue()}) + "</li>\n");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            GpsFix gpsFix = state.lastGpsFix();
            html.append("<li>" + I18n.textf((String)"GPS satellites: %d", (Object[])new Object[]{gpsFix.getSatellites()}) + "</li>\n");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            StorageUsage storageUsage = state.lastStorageUsage();
            html.append("<li>" + I18n.textf((String)"Storage Usage: %d  &#37;", (Object[])new Object[]{storageUsage.getValue()}) + "</li>\n");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            Voltage voltage = state.lastVoltage("Main Board");
            html.append("<li>" + I18n.textf((String)"Voltage: %d V", (Object[])new Object[]{voltage.getValue()}) + "</li>\n");
        }
        catch (Exception exception) {
            // empty catch block
        }
        html.append("</html>");
        return html.toString();
    }

    public void initSubPanel() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        Vector renderers = this.getConsole().getSubPanelsOfInterface(ILayerPainter.class);
        for (ILayerPainter str2d : renderers) {
            str2d.addPostRenderPainter((Renderer2DPainter)this, ((Object)((Object)this)).getClass().getSimpleName());
        }
        this.addMenuItem(I18n.text((String)"Tools") + ">" + I18n.text((String)"Start Plan By Acoustic Modem"), ImageUtils.getIcon((String)PluginUtils.getPluginIcon(((Object)((Object)this)).getClass())), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String defaultVehicle = MantaOperations.this.getConsole().getMainSystem();
                Set plans = MantaOperations.this.getConsole().getMission().getIndividualPlansList().keySet();
                Vector<String> filtered = new Vector<String>();
                for (String planId : plans) {
                    if (planId.length() > GeneralPreferences.maximumSizePlanNameForAcoustics) continue;
                    filtered.add(planId);
                }
                if (filtered.isEmpty()) {
                    MantaOperations.this.post(Notification.error((String)I18n.text((String)"Send Plan acoustically"), (String)I18n.textf((String)"Plans started acoustically cannot have an ID bigger than %number character", (Object[])new Object[]{GeneralPreferences.maximumSizePlanNameForAcoustics})).src(I18n.text((String)"Console")));
                    return;
                }
                VehicleType choice = VehicleChooser.showVehicleDialog(null, (VehicleType)VehiclesHolder.getVehicleById((String)defaultVehicle), null);
                if (choice == null) {
                    return;
                }
                Object[] ops = filtered.toArray(new String[0]);
                int option = JOptionPane.showOptionDialog((Component)MantaOperations.this.getConsole(), I18n.text((String)"Please select plan to start"), I18n.text((String)"Start plan"), -1, 3, null, ops, null);
                if (option == -1) {
                    return;
                }
                NeptusLog.pub().warn((Object)("Start plan " + (String)ops[option]));
                ImcSystem[] sysLst = ImcSystemsHolder.lookupSystemByService((String)"acoustic/operation", (VehicleType.SystemTypeEnum)VehicleType.SystemTypeEnum.ALL, (boolean)true);
                if (sysLst.length == 0) {
                    MantaOperations.this.post(Notification.error((String)I18n.text((String)"Start Plan"), (String)I18n.text((String)"No acoustic device is capable of sending this request")).src(I18n.text((String)"Console")));
                    return;
                }
                PlanControl pc = new PlanControl();
                pc.setType(PlanControl.TYPE.REQUEST);
                pc.setOp(PlanControl.OP.START);
                pc.setPlanId((String)ops[option]);
                int req = IMCSendMessageUtils.getNextRequestId();
                pc.setRequestId(req);
                MantaOperations.this.pendingRequests.put(req, pc);
                AcousticOperation aop = new AcousticOperation();
                aop.setOp(AcousticOperation.OP.MSG);
                aop.setSystem(choice.getId());
                aop.setMsg((IMCMessage)pc);
                int successCount = 0;
                for (ImcSystem sys : sysLst) {
                    if (!ImcMsgManager.getManager().sendMessage((IMCMessage)aop, sys.getId(), null)) continue;
                    ++successCount;
                }
                if (successCount == 0) {
                    MantaOperations.this.post(Notification.error((String)I18n.text((String)"Error sending start plan"), (String)I18n.text((String)"No system was able to send the message")).src(I18n.text((String)"Console")));
                }
            }
        });
        ImcMsgManager.getManager().addListener((MessageListener)this);
        JPanel ctrlPanel = new JPanel();
        ctrlPanel.setLayout(new GridLayout(0, 1, 2, 2));
        JButton btn = new JButton(I18n.textf((String)"GW: %gateway", (Object[])new Object[]{this.gateway}));
        btn.setActionCommand("gw");
        this.cmdButtons.put("gw", btn);
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Vector<String> systems = new Vector<String>();
                systems.add(I18n.text((String)"any"));
                systems.addAll(Arrays.asList((Object[])ImcSystemsHolder.lookupSystemByService((String)"acoustic/operation", (VehicleType.SystemTypeEnum)VehicleType.SystemTypeEnum.ALL, (boolean)true)));
                Object[] choices = systems.toArray();
                if (choices.length == 0) {
                    GuiUtils.errorMessage((Component)MantaOperations.this.getConsole(), (String)I18n.text((String)"Select acoustic gateway"), (String)I18n.text((String)"No acoustic gateways have been discovered in the network"));
                    return;
                }
                Object gw = JOptionPane.showInputDialog((Component)MantaOperations.this.getConsole(), I18n.text((String)"Select Gateway"), I18n.text((String)"Select acoustic gateway to use"), 3, null, choices, choices[0]);
                if (gw != null) {
                    MantaOperations.this.gateway = "" + gw;
                }
                ((JButton)event.getSource()).setText(I18n.textf((String)"GW: %gateway", (Object[])new Object[]{MantaOperations.this.gateway}));
                MantaOperations.this.lblState.setText(MantaOperations.this.buildState());
            }
        });
        ctrlPanel.add(btn);
        btn = new JButton(I18n.text((String)"Range System"));
        btn.setActionCommand("range");
        this.cmdButtons.put("range", btn);
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ImcSystem sys;
                ImcSystem[] sysLst = MantaOperations.this.gateway.equals(I18n.text((String)"any")) ? ImcSystemsHolder.lookupSystemByService((String)"acoustic/operation", (VehicleType.SystemTypeEnum)VehicleType.SystemTypeEnum.ALL, (boolean)true) : ((sys = ImcSystemsHolder.lookupSystemByName((String)MantaOperations.this.gateway)) != null ? new ImcSystem[]{sys} : new ImcSystem[]{});
                if (sysLst.length == 0) {
                    MantaOperations.this.post(Notification.error((String)I18n.text((String)"Range System"), (String)I18n.text((String)"No acoustic device is capable of sending this request")).src(I18n.text((String)"Console")));
                }
                if (MantaOperations.this.selectedSystem == null) {
                    MantaOperations.this.bottomPane.setText(I18n.textf((String)"Please select a system.", (Object[])new Object[]{MantaOperations.this.selectedSystem}));
                } else {
                    IMCMessage m = IMCDefinition.getInstance().create("AcousticOperation", new Object[]{"op", "RANGE", "system", MantaOperations.this.selectedSystem});
                    int successCount = 0;
                    for (ImcSystem sys2 : sysLst) {
                        if (!ImcMsgManager.getManager().sendMessage(m, sys2.getId(), null)) continue;
                        ++successCount;
                    }
                    if (successCount > 0) {
                        MantaOperations.this.bottomPane.setText(I18n.textf((String)"Range %systemName commanded to %systemCount systems", (Object[])new Object[]{MantaOperations.this.selectedSystem, successCount}));
                    } else {
                        MantaOperations.this.post(Notification.error((String)I18n.text((String)"Range System"), (String)I18n.text((String)"Unable to range selected system")).src(I18n.text((String)"Console")));
                    }
                }
            }
        });
        ctrlPanel.add(btn);
        this.toggle = new JToggleButton(I18n.text((String)"Show Ranges"));
        this.toggle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                MantaOperations.this.showRanges = ((JToggleButton)event.getSource()).isSelected();
                if (!MantaOperations.this.showRanges) {
                    MantaOperations.this.rangeDistances.clear();
                    MantaOperations.this.rangeSources.clear();
                }
            }
        });
        this.toggle.setSelected(this.showRanges);
        ctrlPanel.add(this.toggle);
        btn = new JButton(I18n.text((String)"Send command"));
        btn.setActionCommand("text");
        this.cmdButtons.put("text", btn);
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (MantaOperations.this.selectedSystem == null) {
                    return;
                }
                String cmd = JOptionPane.showInputDialog((Component)MantaOperations.this.getConsole(), (Object)I18n.textf((String)"Enter command to send to %vehicle", (Object[])new Object[]{MantaOperations.this.selectedSystem}));
                if (cmd == null) {
                    return;
                }
                if (cmd.length() > 64) {
                    GuiUtils.errorMessage((Component)MantaOperations.this.getConsole(), (String)I18n.text((String)"Send command"), (String)I18n.text((String)"Cannot send command because it has more than 64 characters."));
                    return;
                }
                TextMessage msg = new TextMessage("", cmd);
                MantaOperations.this.sendAcoustically((IMCMessage)msg);
            }
        });
        ctrlPanel.add(btn);
        btn = new JButton(I18n.text((String)"Abort"));
        btn.setBackground(Color.red);
        btn.setActionCommand("abort");
        this.cmdButtons.put("abort", btn);
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ImcSystem sys;
                ImcSystem[] sysLst = MantaOperations.this.gateway.equals(I18n.text((String)"any")) ? ImcSystemsHolder.lookupSystemByService((String)"acoustic/operation", (VehicleType.SystemTypeEnum)VehicleType.SystemTypeEnum.ALL, (boolean)true) : ((sys = ImcSystemsHolder.lookupSystemByName((String)MantaOperations.this.gateway)) != null ? new ImcSystem[]{sys} : new ImcSystem[]{});
                if (sysLst.length == 0) {
                    MantaOperations.this.post(Notification.error((String)I18n.text((String)"Abort"), (String)I18n.text((String)"No acoustic device is capable of sending this request")).src(I18n.text((String)"Console")));
                }
                IMCMessage m = IMCDefinition.getInstance().create("AcousticOperation", new Object[]{"op", "ABORT", "system", MantaOperations.this.selectedSystem});
                int successCount = 0;
                for (ImcSystem sys2 : sysLst) {
                    if (!ImcMsgManager.getManager().sendMessage(m, sys2.getId(), null)) continue;
                    ++successCount;
                }
                if (successCount > 0) {
                    MantaOperations.this.bottomPane.setText(I18n.textf((String)"Abort %systemName commanded to %systemCount systems", (Object[])new Object[]{MantaOperations.this.selectedSystem, successCount}));
                } else {
                    MantaOperations.this.post(Notification.error((String)I18n.text((String)"Abort"), (String)I18n.text((String)"Unable to abort selected system")).src(I18n.text((String)"Console")));
                }
            }
        });
        ctrlPanel.add(btn);
        this.listPanel.setBackground(Color.white);
        this.listPanel.setLayout(new BoxLayout(this.listPanel, 3));
        JSplitPane split1 = new JSplitPane(1, new JScrollPane(this.listPanel), ctrlPanel);
        split1.setDividerLocation(180);
        JTabbedPane tabs = new JTabbedPane();
        tabs.addTab(I18n.text((String)"Acoustic Operations"), split1);
        tabs.addTab(I18n.text((String)"Gateway state"), this.lblState);
        this.bottomPane.setEditable(false);
        this.bottomPane.setBackground(Color.white);
        JSplitPane split2 = new JSplitPane(0, tabs, new JScrollPane(this.bottomPane));
        split2.setDividerLocation(150);
        this.setLayout(new BorderLayout());
        this.add(split2, "Center");
        this.propertiesChanged();
    }

    public void propertiesChanged() {
        for (JRadioButton r : this.radioButtons.values()) {
            r.setVisible(false);
            this.group.remove(r);
        }
        this.radioButtons.clear();
        for (String s : this.sysListing.split(",")) {
            if (s.isEmpty() || s.endsWith(" list")) continue;
            this.knownSystems.add(s.trim());
        }
        ArrayList<String> systems = new ArrayList<String>(this.knownSystems);
        Collections.sort(systems);
        for (String s : systems) {
            JRadioButton btn = new JRadioButton(s);
            btn.setActionCommand(s);
            this.group.add(btn);
            this.radioButtons.put(s, btn);
            btn.setBackground(Color.white);
            btn.addActionListener(this.systemActionListener);
            this.listPanel.add(btn);
        }
        if (this.radioButtons.containsKey(this.selectedSystem)) {
            this.radioButtons.get(this.selectedSystem).setSelected(true);
        } else {
            this.selectedSystem = null;
        }
    }

    protected void updateButtons() {
        if (this.selectedSystem == null) {
            for (String key : this.cmdButtons.keySet()) {
                this.cmdButtons.get(key).setEnabled(false);
            }
        } else {
            for (String key : this.cmdButtons.keySet()) {
                this.cmdButtons.get(key).setEnabled(true);
            }
            if (this.selectedSystem.startsWith("lsts")) {
                this.cmdButtons.get("abort").setEnabled(false);
            }
        }
    }

    public void addText(String text) {
        this.bottomPane.setText(this.bottomPane.getText() + " \n" + text);
        this.bottomPane.scrollRectToVisible(new Rectangle(0, this.bottomPane.getHeight() + 22, 1, 1));
    }

    @Subscribe
    public void on(PlanControl msg) {
        if (this.pendingRequests.containsKey(msg.getRequestId())) {
            PlanControl request = this.pendingRequests.get(msg.getRequestId());
            String text = I18n.textf((String)"Request %d completed successfully.", (Object[])new Object[]{msg.getRequestId()});
            String src = ImcSystemsHolder.translateImcIdToSystemName((long)msg.getSrc());
            if (request != null) {
                switch (request.getOp()) {
                    case START: {
                        text = I18n.textf((String)"Starting of %plan was acknowledged by %system.", (Object[])new Object[]{request.getPlanId(), src});
                        break;
                    }
                    case STOP: {
                        text = I18n.textf((String)"Stopping of %plan was acknowledged by %system.", (Object[])new Object[]{request.getPlanId(), src});
                        break;
                    }
                }
            }
            this.post(Notification.success((String)I18n.text((String)"Manta Operations"), (String)text));
        }
    }

    @Subscribe
    public void on(AcousticOperation msg) {
        switch (msg.getOp()) {
            case RANGE_RECVED: {
                if (!this.showRanges) break;
                LocationType loc = new LocationType(MyState.getLocation());
                if (ImcSystemsHolder.getSystemWithName((String)msg.getSourceName()) != null) {
                    loc = ImcSystemsHolder.getSystemWithName((String)msg.getSourceName()).getLocation();
                }
                this.rangeDistances.add(msg.getRange());
                this.rangeSources.add(loc);
                this.addText(I18n.textf((String)"Distance to %systemName is %distance", (Object[])new Object[]{msg.getSystem().toString(), GuiUtils.getNeptusDecimalFormat((int)1).format(msg.getRange())}));
                break;
            }
            case ABORT_ACKED: {
                this.addText(I18n.textf((String)"%systemName has acknowledged abort command", (Object[])new Object[]{msg.getSystem().toString()}));
                break;
            }
            case BUSY: {
                this.addText(I18n.textf((String)"%manta is busy. Try again in a few moments", (Object[])new Object[]{msg.getSourceName()}));
                break;
            }
            case NO_TXD: {
                this.addText(I18n.textf((String)"%manta has no acoustic transducer connected. Connect a transducer.", (Object[])new Object[]{msg.getSourceName()}));
                break;
            }
            case ABORT_IP: {
                this.addText(I18n.textf((String)"Aborting %systemName acoustically (via %manta)...", (Object[])new Object[]{msg.getSystem().toString(), msg.getSourceName()}));
                break;
            }
            case ABORT_TIMEOUT: {
                this.addText(I18n.textf((String)"%manta timed out while trying to abort %systemName", (Object[])new Object[]{msg.getSourceName(), msg.getSystem().toString()}));
                break;
            }
            case MSG_DONE: {
                this.addText(I18n.textf((String)"Message to %systemName has been sent successfully.", (Object[])new Object[]{msg.getSystem().toString()}));
                break;
            }
            case MSG_FAILURE: {
                this.addText(I18n.textf((String)"Failed to send message to %systemName.", (Object[])new Object[]{msg.getSystem().toString()}));
                break;
            }
            case MSG_IP: {
                this.addText(I18n.textf((String)"Sending message to %systemName...", (Object[])new Object[]{msg.getSystem().toString()}));
                break;
            }
            case MSG_QUEUED: {
                this.addText(I18n.textf((String)"Message to %systemName has been queued in %manta.", (Object[])new Object[]{msg.getSystem().toString(), msg.getSourceName()}));
                break;
            }
            case RANGE_IP: {
                this.addText(I18n.textf((String)"Ranging of %systemName is in progress...", (Object[])new Object[]{msg.getSystem().toString()}));
                break;
            }
            case RANGE_TIMEOUT: {
                this.addText(I18n.textf((String)"Ranging of %systemName timed out.", (Object[])new Object[]{msg.getSystem().toString()}));
                break;
            }
            case UNSUPPORTED: {
                this.addText(I18n.textf((String)"The command is not supported by %manta.", (Object[])new Object[]{msg.getSourceName()}));
                break;
            }
            default: {
                this.addText(I18n.textf((String)"[%manta]: %status", (Object[])new Object[]{msg.getSourceName(), msg.getOp().toString()}));
            }
        }
    }

    @Subscribe
    public void on(AcousticSystems systems) {
        String acSystems = systems.getString("list", false);
        boolean newSystem = false;
        for (String s : acSystems.split(",")) {
            newSystem |= this.knownSystems.add(s);
        }
        if (newSystem) {
            this.propertiesChanged();
        }
    }

    private ImcSystem[] gateways() {
        ImcSystem sys;
        ImcSystem[] sysLst = null;
        sysLst = this.gateway.equals(I18n.text((String)"any")) ? ImcSystemsHolder.lookupSystemByService((String)"acoustic/operation", (VehicleType.SystemTypeEnum)VehicleType.SystemTypeEnum.ALL, (boolean)true) : ((sys = ImcSystemsHolder.lookupSystemByName((String)this.gateway)) != null ? new ImcSystem[]{sys} : new ImcSystem[]{});
        return sysLst;
    }

    @Periodic(millisBetweenUpdates=120000)
    public void requestSysListing() {
        if (this.sysDiscovery) {
            AcousticSystemsQuery asq = new AcousticSystemsQuery();
            for (ImcSystem s : this.gateways()) {
                this.send(s.getName(), (IMCMessage)asq);
            }
        }
    }

    public void paint(Graphics2D g, StateRenderer2D renderer) {
        for (int i = 0; i < this.rangeSources.size(); ++i) {
            double radius = this.rangeDistances.get(i) * (double)renderer.getZoom();
            Point2D pt = renderer.getScreenPosition(this.rangeSources.get(i));
            if (i < this.rangeSources.size() - 1) {
                g.setColor(new Color(255, 128, 0, 128));
            } else {
                g.setColor(new Color(255, 128, 0, 255));
            }
            g.setStroke(new BasicStroke(2.0f));
            g.draw(new Ellipse2D.Double(pt.getX() - radius, pt.getY() - radius, radius * 2.0, radius * 2.0));
        }
    }

    public void cleanSubPanel() {
        ImcMsgManager.getManager().removeListener((MessageListener)this);
    }

    public static void main(String[] args) {
        ConsoleParse.testSubPanel(MantaOperations.class);
    }
}

