/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.acoustic;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Timer;
import java.util.TimerTask;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.renderer2d.Renderer2DPainter;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.util.ColorUtils;
import pt.lsts.neptus.util.MathMiscUtils;

public abstract class RangePainter
implements Renderer2DPainter {
    protected Timer timer = new Timer(RangePainter.class.getSimpleName() + ":" + this.hashCode());
    protected TimerTask ttRange = null;
    protected LocationType curLoc = null;
    protected double range = Double.NaN;
    protected boolean accepted = true;
    protected boolean atSurface = false;
    private int secondsToDisplayRanges = 10;
    private Color squareColor = new Color(255, 128, 0, 100);
    private Color acceptedColor = Color.ORANGE;
    private Color rejectedColor = Color.RED;
    private Color surfaceColor = Color.BLUE;
    private boolean drawRangeUpOrDownThePoint = true;
    private boolean hideOrFadeRange = true;
    private boolean hideFadeTrigger = false;
    private String reason;

    public RangePainter(LocationType curLoc) {
        this.curLoc = curLoc;
    }

    public boolean isDrawRangeUpOrDownThePoint() {
        return this.drawRangeUpOrDownThePoint;
    }

    public void setDrawRangeUpOrDownThePoint(boolean drawRangeUpOrDownThePoint) {
        this.drawRangeUpOrDownThePoint = drawRangeUpOrDownThePoint;
    }

    public int getSecondsToDisplayRanges() {
        return this.secondsToDisplayRanges;
    }

    public void setSecondsToDisplayRanges(int secondsToDisplayRanges) {
        this.secondsToDisplayRanges = secondsToDisplayRanges;
    }

    public boolean isHideOrFadeRange() {
        return this.hideOrFadeRange;
    }

    public void setHideOrFadeRange(boolean hideOrFadeRange) {
        this.hideOrFadeRange = hideOrFadeRange;
    }

    public Color getSquareColor() {
        return this.squareColor;
    }

    public void setSquareColor(Color squareColor) {
        this.squareColor = ColorUtils.setTransparencyToColor((Color)squareColor, (int)100);
    }

    public Color getAcceptedColor() {
        return this.acceptedColor;
    }

    public void setAcceptedColor(Color acceptedColor) {
        this.acceptedColor = acceptedColor;
    }

    public Color getRejectedColor() {
        return this.rejectedColor;
    }

    public void setRejectedColor(Color rejectedColor) {
        this.rejectedColor = rejectedColor;
    }

    public void setSurfaceColor(Color surfaceColor) {
        this.surfaceColor = surfaceColor;
    }

    public void setRejectionReason(String reason) {
        this.reason = reason;
    }

    public void setRange(double range) {
        this.range = range;
    }

    public void setAccepted(boolean accepted) {
        this.accepted = accepted;
    }

    public abstract void callParentRepaint();

    public void updateGraphics(double newRange, boolean accepted, String reason) {
        this.setRange(newRange);
        this.setAccepted(accepted);
        this.setRejectionReason(reason);
        this.hideFadeTrigger = false;
        this.callParentRepaint();
        if (this.ttRange != null) {
            this.ttRange.cancel();
        }
        if (this.secondsToDisplayRanges > 0) {
            this.ttRange = new TimerTask(){

                @Override
                public void run() {
                    RangePainter.this.ttRange = null;
                    if (RangePainter.this.hideOrFadeRange) {
                        RangePainter.this.hideFadeTrigger = false;
                        RangePainter.this.setRange(Double.NaN);
                    } else {
                        RangePainter.this.hideFadeTrigger = true;
                    }
                    RangePainter.this.callParentRepaint();
                }
            };
            this.timer.schedule(this.ttRange, this.secondsToDisplayRanges * 1000);
        }
    }

    public void cleanup() {
        try {
            this.timer.cancel();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void paint(Graphics2D g, StateRenderer2D renderer) {
        if (this.curLoc != null) {
            g = (Graphics2D)g.create();
            float zoom = renderer.getZoom();
            if (Double.isNaN(this.range) || Double.isInfinite(this.range)) {
                double radius = 0.0;
                return;
            }
            double radius = this.range * (double)zoom;
            Point2D pt = renderer.getScreenPosition(this.curLoc);
            g.setColor(this.squareColor);
            g.fill(new Rectangle2D.Double(pt.getX() - 3.0, pt.getY() - 3.0, 6.0, 6.0));
            Color color = this.accepted ? this.acceptedColor : (this.reason != null && this.reason.contains("SURFACE") ? this.surfaceColor : this.rejectedColor);
            if (!this.hideFadeTrigger) {
                g.setColor(color);
            } else {
                g.setColor(ColorUtils.setTransparencyToColor((Color)color, (int)70));
            }
            g.draw(new Rectangle2D.Double(pt.getX() - 3.0, pt.getY() - 3.0, 6.0, 6.0));
            Ellipse2D.Double rC = new Ellipse2D.Double(pt.getX() - radius, pt.getY() - radius, radius * 2.0, radius * 2.0);
            Stroke oldStroke = g.getStroke();
            BasicStroke newStroke = new BasicStroke(5.0f);
            g.setStroke(newStroke);
            g.draw(rC);
            g.setStroke(oldStroke);
            String rangeTxt = "" + MathMiscUtils.round((double)this.range, (int)1) + I18n.textc((String)"m", (String)"meters");
            Color oldColor = g.getColor();
            g.setColor(ColorUtils.setTransparencyToColor((Color)Color.WHITE, (int)oldColor.getAlpha()));
            g.drawString(rangeTxt, (int)(pt.getX() - 5.0 + 1.0), (int)(pt.getY() - (double)(10 * (this.isDrawRangeUpOrDownThePoint() ? 1 : -2)) + 1.0));
            g.setColor(oldColor);
            g.drawString(rangeTxt, (int)(pt.getX() - 5.0), (int)(pt.getY() - (double)(10 * (this.isDrawRangeUpOrDownThePoint() ? 1 : -2))));
            color = this.accepted ? this.acceptedColor : (this.reason != null && this.reason.contains("SURFACE") ? this.surfaceColor : this.rejectedColor);
            if (!this.hideFadeTrigger) {
                g.setColor(ColorUtils.setTransparencyToColor((Color)color, (int)40));
            } else {
                g.setColor(ColorUtils.setTransparencyToColor((Color)color, (int)20));
            }
            g.fill(rC);
            g.setColor(Color.BLACK);
        }
    }
}

