/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.acoustic;

import com.google.common.eventbus.Subscribe;
import java.awt.Component;
import pt.lsts.imc.AcousticOperation;
import pt.lsts.imc.IMCDefinition;
import pt.lsts.imc.IMCMessage;
import pt.lsts.neptus.comm.manager.imc.ImcId16;
import pt.lsts.neptus.comm.manager.imc.ImcMsgManager;
import pt.lsts.neptus.comm.manager.imc.ImcSystem;
import pt.lsts.neptus.comm.manager.imc.ImcSystemsHolder;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.console.notifications.Notification;
import pt.lsts.neptus.console.plugins.MainVehicleChangeListener;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.plugins.ConfigurationListener;
import pt.lsts.neptus.plugins.IAbortSenderProvider;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.update.IPeriodicUpdates;
import pt.lsts.neptus.types.vehicle.VehicleType;
import pt.lsts.neptus.util.GuiUtils;

@PluginDescription(author="Paulo Dias", name="Abort Request", version="0.9.0", icon="pt/lsts/neptus/plugins/acoustic/lbl.png", description="Simple Abort Modem Request by Manta Gateway", documentation="abort/abort-button.html#SimpleAbortModemRequest", category=PluginDescription.CATEGORY.COMMUNICATIONS)
public class SimpleAbortModemRequest
extends ConsolePanel
implements IAbortSenderProvider,
IPeriodicUpdates,
MainVehicleChangeListener,
ConfigurationListener {
    @NeptusProperty(name="Service Name")
    public String serviceName = "acoustic/operation";
    @NeptusProperty(name="Use only active systems")
    public boolean useOnlyActive = false;

    public SimpleAbortModemRequest(ConsoleLayout console) {
        super(console);
        this.initialize();
    }

    private void initialize() {
        this.setVisibility(false);
    }

    @Subscribe
    public void consume(AcousticOperation msg) {
        String source = msg.getSourceName();
        String system = msg.getSystem();
        AcousticOperation.OP op = msg.getOp();
        switch (op) {
            case ABORT_ACKED: {
                this.post(Notification.success((String)I18n.text((String)"Abort Request"), (String)I18n.textf((String)"%systemName has acknowledged abort command", (Object[])new Object[]{system})).requireHumanAction(true));
                break;
            }
            case ABORT_IP: {
                this.post(Notification.warning((String)I18n.text((String)"Abort Request"), (String)I18n.textf((String)"Aborting %systemName acoustically (via %manta)...", (Object[])new Object[]{system, source})));
                break;
            }
            case ABORT_TIMEOUT: {
                this.post(Notification.error((String)I18n.text((String)"Abort Request"), (String)I18n.textf((String)"%manta timed out while trying to abort %systemName", (Object[])new Object[]{source, system})));
                break;
            }
            case UNSUPPORTED: {
                this.post(Notification.error((String)I18n.text((String)"Abort Request"), (String)I18n.textf((String)"%manta does not support aborting of %systemName", (Object[])new Object[]{source, system})));
                break;
            }
        }
    }

    public void initSubPanel() {
    }

    public void cleanSubPanel() {
    }

    public boolean sendAbortRequest() {
        return this.sendAbortRequest(this.getMainVehicleId());
    }

    public boolean sendAbortRequest(String system) {
        ImcSystem[] sysLst = ImcSystemsHolder.lookupSystemByService((String)this.serviceName, (VehicleType.SystemTypeEnum)VehicleType.SystemTypeEnum.ALL, (boolean)this.useOnlyActive);
        if (sysLst.length == 0) {
            return false;
        }
        boolean retAll = false;
        for (ImcSystem imcSystem : sysLst) {
            ImcId16 id = imcSystem.getId();
            IMCMessage msgAcousticOperation = IMCDefinition.getInstance().create("AcousticOperation", new Object[0]);
            msgAcousticOperation.setValue("op", (Object)"ABORT");
            msgAcousticOperation.setValue("system", (Object)system);
            boolean ret = this.sendTheMessage(msgAcousticOperation, I18n.text((String)"Error sending ABORT command message!"), id);
            retAll = retAll || ret;
        }
        return retAll;
    }

    public long millisBetweenUpdates() {
        return 0L;
    }

    public boolean update() {
        return false;
    }

    public void propertiesChanged() {
    }

    private boolean sendTheMessage(IMCMessage msg, String errorTextForDialog, ImcId16 id) {
        boolean ret = ImcMsgManager.getManager().sendMessage(msg, id, null);
        if (!ret) {
            ImcSystem sys = ImcSystemsHolder.lookupSystem((ImcId16)id);
            GuiUtils.errorMessage((Component)((Object)this), (String)I18n.textf((String)"Error Sending Abort by Modem by '%sendermodemid'", (Object[])new Object[]{sys != null ? sys.getName() : id}), (String)errorTextForDialog);
            return false;
        }
        return true;
    }
}

