/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.envdisp;

import java.util.ArrayList;
import java.util.Date;

public class BaseDataPoint<T extends BaseDataPoint>
implements Comparable<BaseDataPoint> {
    protected double lat;
    protected double lon;
    protected Date dateUTC;
    protected ArrayList<T> historicalData = new ArrayList();

    public BaseDataPoint(double lat, double lon) {
        this.lat = lat;
        this.lon = lon;
    }

    public BaseDataPoint getACopyWithoutHistory() {
        BaseDataPoint<T> copy = new BaseDataPoint<T>(this.getLat(), this.getLon());
        copy.setDateUTC(this.getDateUTC());
        return copy;
    }

    public double getLat() {
        return this.lat;
    }

    public double getLon() {
        return this.lon;
    }

    public Date getDateUTC() {
        return this.dateUTC;
    }

    public void setDateUTC(Date dateUTC) {
        this.dateUTC = dateUTC;
    }

    public String toString() {
        return "Lat:\t" + this.lat + "\tLon:\t" + this.lon + "\tDate:\t" + this.dateUTC;
    }

    public ArrayList<T> getHistoricalData() {
        return this.historicalData;
    }

    public void purgeAllBefore(Date date) {
        if (date == null || this.historicalData.size() == 0) {
            return;
        }
        for (BaseDataPoint dp : this.historicalData.toArray(new BaseDataPoint[0])) {
            if (!dp.getDateUTC().before(date)) continue;
            this.historicalData.remove(dp);
        }
    }

    @Override
    public int compareTo(BaseDataPoint o) {
        if (Double.compare(this.lat, o.lat) == 0 && Double.compare(this.lon, o.lon) == 0) {
            return 0;
        }
        return 1;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BaseDataPoint)) {
            return false;
        }
        return this.compareTo((BaseDataPoint)obj) == 0;
    }

    public static String getId(BaseDataPoint hfrdp) {
        return hfrdp.lat + ":" + hfrdp.lon;
    }
}

