/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.envdisp;

import java.util.ArrayList;
import java.util.Date;
import pt.lsts.neptus.plugins.envdisp.BaseDataPoint;

public class HFRadarDataPoint
extends BaseDataPoint<HFRadarDataPoint> {
    private double speedCmS;
    private double headingDegrees;
    private double resolutionKm = -1.0;
    private String info = "";

    public HFRadarDataPoint(double lat, double lon) {
        super(lat, lon);
    }

    @Override
    public HFRadarDataPoint getACopyWithoutHistory() {
        HFRadarDataPoint copy = new HFRadarDataPoint(this.getLat(), this.getLon());
        copy.setSpeedCmS(this.getSpeedCmS());
        copy.setHeadingDegrees(this.getHeadingDegrees());
        copy.setDateUTC(this.getDateUTC());
        copy.setResolutionKm(this.getResolutionKm());
        copy.setInfo(this.getInfo());
        return copy;
    }

    public HFRadarDataPoint copyToWithoutHistory(HFRadarDataPoint copy) {
        copy.setDateUTC(this.getDateUTC());
        copy.setSpeedCmS(this.getSpeedCmS());
        copy.setHeadingDegrees(this.getHeadingDegrees());
        copy.setDateUTC(this.getDateUTC());
        copy.setResolutionKm(this.getResolutionKm());
        copy.setInfo(this.getInfo());
        return copy;
    }

    public double getSpeedCmS() {
        return this.speedCmS;
    }

    public void setSpeedCmS(double speedCmS) {
        this.speedCmS = speedCmS;
    }

    public double getHeadingDegrees() {
        return this.headingDegrees;
    }

    public void setHeadingDegrees(double headingDegrees) {
        this.headingDegrees = headingDegrees;
    }

    public double getResolutionKm() {
        return this.resolutionKm;
    }

    public void setResolutionKm(double resolutionKm) {
        this.resolutionKm = resolutionKm;
    }

    public String getInfo() {
        return this.info;
    }

    public void setInfo(String info) {
        this.info = info;
    }

    @Override
    public String toString() {
        return super.toString() + "\tSpeed:\t" + this.speedCmS + "\tHeading:\t" + this.headingDegrees + "\tResolution:\t" + this.resolutionKm + "\tInfo:\t" + this.info;
    }

    @Override
    public ArrayList<HFRadarDataPoint> getHistoricalData() {
        return this.historicalData;
    }

    public boolean calculateMean(Date currentDate) {
        if (this.historicalData.size() == 0) {
            return false;
        }
        Date mostRecentDate = null;
        double meanSpeed = 0.0;
        double meanHeading = 0.0;
        int size = this.historicalData.size();
        for (HFRadarDataPoint dp : this.historicalData) {
            if (currentDate.before(dp.dateUTC)) {
                --size;
                continue;
            }
            if (mostRecentDate == null || !mostRecentDate.after(dp.dateUTC)) {
                mostRecentDate = dp.dateUTC;
            }
            meanSpeed += dp.speedCmS;
            meanHeading += dp.headingDegrees;
        }
        if (size < 1) {
            this.setSpeedCmS(Double.NaN);
            this.setHeadingDegrees(Double.NaN);
            this.setDateUTC(new Date(0L));
            return false;
        }
        this.setSpeedCmS(meanSpeed /= (double)size);
        this.setHeadingDegrees(meanHeading /= (double)size);
        this.setDateUTC(mostRecentDate);
        return true;
    }

    public boolean useMostRecent(Date currentDate) {
        if (this.historicalData.size() == 0) {
            return false;
        }
        Date mostRecentDate = null;
        double mRecentSpeed = 0.0;
        double mRecentHeading = 0.0;
        int size = this.historicalData.size();
        for (HFRadarDataPoint dp : this.historicalData) {
            if (currentDate.before(dp.dateUTC)) {
                --size;
                continue;
            }
            if (dp.dateUTC.after(currentDate) || mostRecentDate != null && !dp.dateUTC.after(mostRecentDate)) {
                --size;
                continue;
            }
            mostRecentDate = dp.dateUTC;
            mRecentSpeed = dp.speedCmS;
            mRecentHeading = dp.headingDegrees;
        }
        if (size < 1) {
            this.setSpeedCmS(Double.NaN);
            this.setHeadingDegrees(Double.NaN);
            this.setDateUTC(new Date(0L));
            return false;
        }
        this.setSpeedCmS(mRecentSpeed);
        this.setHeadingDegrees(mRecentHeading);
        this.setDateUTC(mostRecentDate);
        return true;
    }
}

