/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.envdisp;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.colormap.ColorMap;
import pt.lsts.neptus.colormap.ColorMapFactory;
import pt.lsts.neptus.console.ConsoleLayer;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.console.IConsoleLayer;
import pt.lsts.neptus.gui.editor.FolderPropertyEditor;
import pt.lsts.neptus.plugins.ConfigurationListener;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.envdisp.BaseDataPoint;
import pt.lsts.neptus.plugins.envdisp.HFRadarDataPoint;
import pt.lsts.neptus.plugins.envdisp.LoaderHelper;
import pt.lsts.neptus.plugins.envdisp.SSTDataPoint;
import pt.lsts.neptus.plugins.envdisp.WavesDataPoint;
import pt.lsts.neptus.plugins.envdisp.WindDataPoint;
import pt.lsts.neptus.plugins.update.IPeriodicUpdates;
import pt.lsts.neptus.renderer2d.LayerPriority;
import pt.lsts.neptus.renderer2d.Renderer2DPainter;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.util.AngleCalc;
import pt.lsts.neptus.util.ColorUtils;
import pt.lsts.neptus.util.FileUtil;
import pt.lsts.neptus.util.MathMiscUtils;
import pt.lsts.neptus.util.http.client.HttpClientConnectionHelper;

@PluginDescription(name="HF Radar Visualization", author="Paulo Dias", version="1.0", icon="pt/lsts/neptus/plugins/envdisp/hf-radar.png")
@LayerPriority(priority=-50)
public class HFRadarVisualization
extends ConsolePanel
implements Renderer2DPainter,
IPeriodicUpdates,
ConfigurationListener {
    @NeptusProperty(name="Show currents", userLevel=NeptusProperty.LEVEL.REGULAR, category="Visibility")
    public boolean showCurrents = true;
    @NeptusProperty(name="Show SST", userLevel=NeptusProperty.LEVEL.REGULAR, category="Visibility")
    public boolean showSST = true;
    @NeptusProperty(name="Show wind", userLevel=NeptusProperty.LEVEL.REGULAR, category="Visibility")
    public boolean showWind = true;
    @NeptusProperty(name="Show waves", userLevel=NeptusProperty.LEVEL.REGULAR, category="Visibility")
    public boolean showWaves = false;
    @NeptusProperty(name="Show currents legend", userLevel=NeptusProperty.LEVEL.REGULAR, category="Visibility")
    public boolean showCurrentsLegend = true;
    @NeptusProperty(name="Show currents legend from zoom level bigger than", userLevel=NeptusProperty.LEVEL.REGULAR, category="Visibility")
    public int showCurrentsLegendFromZoomLevel = 13;
    @NeptusProperty(name="Show SST legend", userLevel=NeptusProperty.LEVEL.REGULAR, category="Visibility")
    public boolean showSSTLegend = true;
    @NeptusProperty(name="Show SST legend from zoom level bigger than", userLevel=NeptusProperty.LEVEL.REGULAR, category="Visibility")
    public int showSSTLegendFromZoomLevel = 11;
    @NeptusProperty(name="Show waves legend", userLevel=NeptusProperty.LEVEL.REGULAR, category="Visibility")
    public boolean showWavesLegend = true;
    @NeptusProperty(name="Show waves legend from zoom level bigger than", userLevel=NeptusProperty.LEVEL.REGULAR, category="Visibility")
    public int showWavesLegendFromZoomLevel = 13;
    @NeptusProperty(name="Minutes between file updates", category="Data Update")
    public long updateFileDataMinutes = 5L;
    @NeptusProperty(name="Data limit validity (hours)", userLevel=NeptusProperty.LEVEL.REGULAR, category="Data Update")
    public int dateLimitHours = 12;
    @NeptusProperty(name="Use data x hour in the future (hours)", userLevel=NeptusProperty.LEVEL.REGULAR, category="Data Update")
    public int dateHoursToUseForData = 1;
    @NeptusProperty(name="Ignore data limit validity to load data", userLevel=NeptusProperty.LEVEL.ADVANCED, category="Data Update")
    public boolean ignoreDateLimitToLoad = false;
    @NeptusProperty(name="Request data from Web", editable=false, userLevel=NeptusProperty.LEVEL.ADVANCED, category="Test", description="Don't use this (testing purposes).")
    public boolean requestFromWeb = false;
    @NeptusProperty(name="Load data from file (hfradar.txt)", editable=false, userLevel=NeptusProperty.LEVEL.ADVANCED, category="Test", description="Don't use this (testing purposes).")
    public boolean loadFromFile = false;
    @NeptusProperty(name="Show currents as most recent (true) or mean (false) value", userLevel=NeptusProperty.LEVEL.REGULAR, category="Data Update")
    public boolean hfradarUseMostRecentOrMean = true;
    @NeptusProperty(name="Use color map for wind", userLevel=NeptusProperty.LEVEL.REGULAR, category="Visibility")
    public boolean useColorMapForWind = true;
    @NeptusProperty(name="Base Folder For Currents TUV or netCDF Files", userLevel=NeptusProperty.LEVEL.REGULAR, category="Data Update", description="The folder to look for currents data. Admissible files '*.tuv' and '*.nc'. NetCDF variables used: lat, lon, time, u, v.", editorClass=FolderPropertyEditor.class)
    public File baseFolderForCurrentsTUVFiles = new File("IHData/CODAR");
    @NeptusProperty(name="Base Folder For Meteo netCDF Files", userLevel=NeptusProperty.LEVEL.REGULAR, category="Data Update", description="The folder to look for meteo data (wind and SST). Admissible files '*.nc'. NetCDF variables used: lat, lon, time, u, v, sst.", editorClass=FolderPropertyEditor.class)
    public File baseFolderForMeteoNetCDFFiles = new File("IHData/METEO");
    @NeptusProperty(name="Base Folder For Waves netCDF Files", userLevel=NeptusProperty.LEVEL.REGULAR, category="Data Update", description="The folder to look for waves (significant height, peak period and direction) data. Admissible files '*.nc'. NetCDF variables used: lat, lon, time, hs, tp, pdir.", editorClass=FolderPropertyEditor.class)
    public File baseFolderForWavesNetCDFFiles = new File("IHData/WAVES");
    @NeptusProperty(name="Show currents visible data date-time interval", userLevel=NeptusProperty.LEVEL.ADVANCED, category="Test", description="Draws the string with visible curents data date-time interval.")
    public boolean showDataDebugLegend = false;
    private static final String tuvFilePattern = ".\\.tuv$";
    private static final String netCDFFilePattern = ".\\.nc$";
    private static final String currentsFilePatternTUV = ".\\.tuv$";
    private static final String currentsFilePatternNetCDF = ".\\.nc$";
    private static final String meteoFilePattern = ".\\.nc$";
    private static final String wavesFilePattern = ".\\.nc$";
    private boolean clearImgCachRqst = false;
    private final Font font8Pt = new Font("Helvetica", 0, 8);
    static final SimpleDateFormat dateTimeFormaterUTC = new SimpleDateFormat("yyyy-MM-dd HH':'mm':'ss"){
        {
            this.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
    };
    static final SimpleDateFormat dateTimeFormaterSpacesUTC = new SimpleDateFormat("yyyy MM dd  HH mm ss"){
        {
            this.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
    };
    private static final SimpleDateFormat dateFormaterUTC = new SimpleDateFormat("yyyy-MM-dd"){
        {
            this.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
    };
    private static final SimpleDateFormat timeFormaterUTC = new SimpleDateFormat("HH':'mm"){
        {
            this.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
    };
    private long updateSeconds = 60L;
    private long lastMillisFileDataUpdated = -1L;
    private static final Path2D.Double arrow = new Path2D.Double();
    private static final Ellipse2D circle;
    private static final Path2D.Double windPoleKnots;
    private static final Path2D.Double wind50Knots1;
    private static final Path2D.Double wind10Knots1;
    private static final Path2D.Double wind5Knots2;
    private static final Path2D.Double wind10Knots2;
    private static final Path2D.Double wind5Knots3;
    private static final Path2D.Double wind10Knots3;
    private static final Path2D.Double wind5Knots4;
    private static final Path2D.Double wind10Knots4;
    private static final Path2D.Double wind5Knots5;
    private final String noaaURL = "http://hfradar.ndbc.noaa.gov/tabdownload.php?from=#FROM_DATE#%20#FROM_TIME#:00&to=#TO_DATE#%20#TO_TIME#:00&lat=#LAT1#&lng=#LNG1#&lat2=#LAT2#&lng2=#LNG2#";
    private final double noaaMaxLat = 55.47885346331034;
    private final double noaaMaxLng = -61.87500000000001;
    private final double noaaMinLat = 14.093957177836236;
    private final double noaaMinLng = -132.1875;
    private static final String sampleNoaaFile = "hfradar-noaa-sample1.txt";
    protected final double m_sToKnotConv = 1.94384449244;
    private final ColorMap colorMapCurrents = ColorMapFactory.createJetColorMap();
    private final double maxCurrentCmS = 200.0;
    private final ColorMap colorMapSST = ColorMapFactory.createJetColorMap();
    private final double minSST = -10.0;
    private final double maxSST = 40.0;
    private final ColorMap colorMapWind = this.colorMapCurrents;
    private final double maxWind = 33.43888888889929;
    private final ColorMap colorMapWaves = ColorMapFactory.createJetColorMap();
    private final double maxWaves = 7.0;
    private BufferedImage cacheImg = null;
    private static int offScreenBufferPixel;
    private Dimension dim = null;
    private int lastLod = -1;
    private LocationType lastCenter = null;
    private double lastRotation = Double.NaN;
    private final HttpClientConnectionHelper httpComm = new HttpClientConnectionHelper();
    private HttpGet getHttpRequest;
    private final HashMap<String, HFRadarDataPoint> dataPointsCurrents = new HashMap();
    private final HashMap<String, SSTDataPoint> dataPointsSST = new HashMap();
    private final HashMap<String, WindDataPoint> dataPointsWind = new HashMap();
    private final HashMap<String, WavesDataPoint> dataPointsWaves = new HashMap();
    private final HFRadarConsoleLayer consoleLayer = new HFRadarConsoleLayer();

    public HFRadarVisualization(ConsoleLayout console) {
        super(console);
        this.httpComm.initializeComm();
    }

    public void initSubPanel() {
        this.getConsole().addMapLayer((IConsoleLayer)this.consoleLayer, false);
    }

    public void cleanSubPanel() {
        this.getConsole().removeMapLayer((IConsoleLayer)this.consoleLayer);
        this.httpComm.cleanUp();
    }

    public String validateDataLimitHours(int value) {
        if (value < 3 && value > 24) {
            return "Keep it between 3 and 24";
        }
        return null;
    }

    public long millisBetweenUpdates() {
        return this.updateSeconds * 1000L;
    }

    public synchronized boolean update() {
        NeptusLog.pub().info((Object)"Update");
        if (this.lastMillisFileDataUpdated <= 0L || System.currentTimeMillis() - this.lastMillisFileDataUpdated >= this.updateFileDataMinutes * 60L * 1000L) {
            this.lastMillisFileDataUpdated = System.currentTimeMillis();
            this.loadCurrentsFromFiles();
            this.loadMeteoFromFiles();
            this.loadWavesFromFiles();
        }
        this.propertiesChanged();
        return true;
    }

    public void propertiesChanged() {
        this.lastMillisFileDataUpdated = -1L;
        this.cleanDataPointsBeforeDate();
        this.updateValues();
        this.clearImgCachRqst = true;
    }

    private Date createDateToMostRecent() {
        Date nowDate = new Date(System.currentTimeMillis() + (long)this.dateHoursToUseForData * 3600000L);
        return nowDate;
    }

    private Date createDateLimitToRemove() {
        Date dateLimit = new Date(System.currentTimeMillis() - (long)this.dateLimitHours * 3600000L);
        return dateLimit;
    }

    private void updateValues() {
        BaseDataPoint dp;
        Date nowDate = this.createDateToMostRecent();
        for (String dpID : this.dataPointsCurrents.keySet().toArray(new String[0])) {
            dp = this.dataPointsCurrents.get(dpID);
            if (dp == null) continue;
            this.updateHFRadarToUseMostRecentOrMean(nowDate, (HFRadarDataPoint)dp);
        }
        for (String dpID : this.dataPointsSST.keySet().toArray(new String[0])) {
            dp = this.dataPointsSST.get(dpID);
            if (dp == null) continue;
            ((SSTDataPoint)dp).useMostRecent(nowDate);
        }
        for (String dpID : this.dataPointsWind.keySet().toArray(new String[0])) {
            dp = this.dataPointsWind.get(dpID);
            if (dp == null) continue;
            ((WindDataPoint)dp).useMostRecent(nowDate);
        }
        for (String dpID : this.dataPointsWaves.keySet().toArray(new String[0])) {
            dp = this.dataPointsWaves.get(dpID);
            if (dp == null) continue;
            ((WavesDataPoint)dp).useMostRecent(nowDate);
        }
    }

    private void updateHFRadarToUseMostRecentOrMean(Date nowDate, HFRadarDataPoint dp) {
        if (this.hfradarUseMostRecentOrMean) {
            dp.useMostRecent(nowDate);
        } else {
            dp.calculateMean(nowDate);
        }
    }

    private void cleanDataPointsBeforeDate() {
        Date dateLimit = this.ignoreDateLimitToLoad ? null : this.createDateLimitToRemove();
        this.cleanCurrentsDataPointsBeforeDate(dateLimit);
        this.cleanSSTDataPointsBeforeDate(dateLimit);
        this.cleanWindDataPointsBeforeDate(dateLimit);
        this.cleanWavesDataPointsBeforeDate(dateLimit);
    }

    private void cleanCurrentsDataPointsBeforeDate(Date dateLimit) {
        if (dateLimit == null) {
            return;
        }
        for (String dpID : this.dataPointsCurrents.keySet().toArray(new String[0])) {
            HFRadarDataPoint dp = this.dataPointsCurrents.get(dpID);
            if (dp == null) continue;
            if (dp.getDateUTC().before(dateLimit)) {
                this.dataPointsCurrents.remove(dpID);
                continue;
            }
            dp.purgeAllBefore(dateLimit);
        }
    }

    private void cleanSSTDataPointsBeforeDate(Date dateLimit) {
        if (dateLimit == null) {
            return;
        }
        for (String dpID : this.dataPointsSST.keySet().toArray(new String[0])) {
            BaseDataPoint dp = this.dataPointsSST.get(dpID);
            if (dp == null) continue;
            if (dp.getDateUTC().before(dateLimit)) {
                this.dataPointsSST.remove(dpID);
                continue;
            }
            dp.purgeAllBefore(dateLimit);
        }
    }

    private void cleanWindDataPointsBeforeDate(Date dateLimit) {
        if (dateLimit == null) {
            return;
        }
        for (String dpID : this.dataPointsWind.keySet().toArray(new String[0])) {
            BaseDataPoint dp = this.dataPointsWind.get(dpID);
            if (dp == null) continue;
            if (dp.getDateUTC().before(dateLimit)) {
                this.dataPointsWind.remove(dpID);
                continue;
            }
            dp.purgeAllBefore(dateLimit);
        }
    }

    private void cleanWavesDataPointsBeforeDate(Date dateLimit) {
        if (dateLimit == null) {
            return;
        }
        for (String dpID : this.dataPointsWaves.keySet().toArray(new String[0])) {
            BaseDataPoint dp = this.dataPointsWaves.get(dpID);
            if (dp == null) continue;
            if (dp.getDateUTC().before(dateLimit)) {
                this.dataPointsWaves.remove(dpID);
                continue;
            }
            dp.purgeAllBefore(dateLimit);
        }
    }

    public void mergeCurrentsDataToInternalDataList(HashMap<String, HFRadarDataPoint> toMergeData) {
        for (String dpId : toMergeData.keySet()) {
            HFRadarDataPoint dp = toMergeData.get(dpId);
            HFRadarDataPoint dpo = this.dataPointsCurrents.get(dpId);
            if (dpo == null) {
                this.dataPointsCurrents.put(dpId, dp);
                dpo = dp;
                continue;
            }
            this.mergeDataPointsWorker(dp, dpo);
        }
    }

    public void mergeSSTDataToInternalDataList(HashMap<String, SSTDataPoint> toMergeData) {
        for (String dpId : toMergeData.keySet()) {
            SSTDataPoint dp = toMergeData.get(dpId);
            SSTDataPoint dpo = this.dataPointsSST.get(dpId);
            if (dpo == null) {
                this.dataPointsSST.put(dpId, dp);
                dpo = dp;
                continue;
            }
            this.mergeDataPointsWorker(dp, dpo);
        }
    }

    public void mergeWindDataToInternalDataList(HashMap<String, WindDataPoint> toMergeData) {
        for (String dpId : toMergeData.keySet()) {
            WindDataPoint dp = toMergeData.get(dpId);
            WindDataPoint dpo = this.dataPointsWind.get(dpId);
            if (dpo == null) {
                this.dataPointsWind.put(dpId, dp);
                dpo = dp;
                continue;
            }
            this.mergeDataPointsWorker(dp, dpo);
        }
    }

    public void mergeWavesDataToInternalDataList(HashMap<String, WavesDataPoint> toMergeData) {
        for (String dpId : toMergeData.keySet()) {
            WavesDataPoint dp = toMergeData.get(dpId);
            WavesDataPoint dpo = this.dataPointsWaves.get(dpId);
            if (dpo == null) {
                this.dataPointsWaves.put(dpId, dp);
                dpo = dp;
                continue;
            }
            this.mergeDataPointsWorker(dp, dpo);
        }
    }

    private void mergeDataPointsWorker(BaseDataPoint<?> dpToMerge, BaseDataPoint<?> dpOriginal) {
        ArrayList<?> histToMergeData = dpToMerge.getHistoricalData();
        ArrayList<?> histOrigData = dpOriginal.getHistoricalData();
        ArrayList<BaseDataPoint> toAddDP = new ArrayList<BaseDataPoint>();
        BaseDataPoint toRemove = null;
        for (BaseDataPoint hdp : histToMergeData) {
            boolean foundMatch = false;
            for (BaseDataPoint hodp : histOrigData) {
                if (!hdp.getDateUTC().equals(hodp.getDateUTC())) continue;
                foundMatch = true;
                toRemove = hodp;
                break;
            }
            if (foundMatch && !histOrigData.remove(toRemove)) {
                NeptusLog.pub().warn((Object)("Not able to remove from historical data element:" + toRemove.toString()));
                continue;
            }
            toAddDP.add(hdp);
        }
        if (toAddDP.size() > 0) {
            histOrigData.addAll(toAddDP);
        }
    }

    private void loadCurrentsFromFiles() {
        HashMap<String, HFRadarDataPoint> tdp;
        File[] fileList = FileUtil.getFilesFromDisk((File)this.baseFolderForCurrentsTUVFiles, (String)".\\.tuv$");
        if (fileList == null) {
            return;
        }
        for (File fx : fileList) {
            tdp = this.processTuvHFRadarTest(fx.getAbsolutePath());
            if (tdp == null || tdp.size() <= 0) continue;
            this.mergeCurrentsDataToInternalDataList(tdp);
        }
        fileList = FileUtil.getFilesFromDisk((File)this.baseFolderForCurrentsTUVFiles, (String)".\\.nc$");
        if (fileList == null) {
            return;
        }
        for (File fx : fileList) {
            tdp = this.processNetCDFHFRadarTest(fx.getAbsolutePath());
            if (tdp == null || tdp.size() <= 0) continue;
            this.mergeCurrentsDataToInternalDataList(tdp);
        }
    }

    private void loadMeteoFromFiles() {
        File[] fileList = FileUtil.getFilesFromDisk((File)this.baseFolderForMeteoNetCDFFiles, (String)".\\.nc$");
        if (fileList == null) {
            return;
        }
        for (File fx : fileList) {
            HashMap<String, WindDataPoint> winddp;
            HashMap<?, ?>[] meteodp = this.processMeteoFile(fx.getAbsolutePath());
            HashMap<String, SSTDataPoint> sstdp = meteodp[0];
            if (sstdp != null && sstdp.size() > 0) {
                this.mergeSSTDataToInternalDataList(sstdp);
            }
            if ((winddp = meteodp[1]) == null || winddp.size() <= 0) continue;
            this.mergeWindDataToInternalDataList(winddp);
        }
    }

    private void loadWavesFromFiles() {
        File[] fileList = FileUtil.getFilesFromDisk((File)this.baseFolderForWavesNetCDFFiles, (String)".\\.nc$");
        if (fileList == null) {
            return;
        }
        for (File fx : fileList) {
            HashMap<String, WavesDataPoint> wavesdp = this.processWavesFile(fx.getAbsolutePath());
            if (wavesdp == null || wavesdp.size() <= 0) continue;
            this.mergeWavesDataToInternalDataList(wavesdp);
        }
    }

    public HashMap<String, HFRadarDataPoint> getNoaaHFRadarData() {
        Date nowDate = new Date(System.currentTimeMillis());
        Date tillDate = new Date(nowDate.getTime() - (long)this.dateLimitHours * 3600000L);
        if (this.lastCenter == null) {
            return null;
        }
        LocationType lc = this.lastCenter.getNewAbsoluteLatLonDepth();
        Dimension boxDim = this.dim.getSize();
        LocationType lTop = lc.getNewAbsoluteLatLonDepth();
        lTop.translateInPixel(-boxDim.getWidth() / 2.0, -boxDim.getHeight() / 2.0, 22);
        LocationType lBot = lc.getNewAbsoluteLatLonDepth();
        lBot.translateInPixel(boxDim.getWidth() / 2.0, boxDim.getHeight() / 2.0, 22);
        lTop = new LocationType(55.47885346331034, -61.87500000000001);
        lBot = new LocationType(14.093957177836236, -132.1875);
        return this.getNoaaHFRadarData(tillDate, nowDate, lTop, lBot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, HFRadarDataPoint> getNoaaHFRadarData(Date tillDate, Date nowDate, LocationType lTop, LocationType lBot) {
        if (this.getHttpRequest != null) {
            this.getHttpRequest.abort();
        }
        this.getHttpRequest = null;
        try {
            HashMap<String, HFRadarDataPoint> lst;
            String uri = "http://hfradar.ndbc.noaa.gov/tabdownload.php?from=#FROM_DATE#%20#FROM_TIME#:00&to=#TO_DATE#%20#TO_TIME#:00&lat=#LAT1#&lng=#LNG1#&lat2=#LAT2#&lng2=#LNG2#";
            uri = this.getNoaaURI(tillDate, nowDate, lTop, lBot);
            System.out.println(uri);
            this.getHttpRequest = new HttpGet(uri);
            this.getHttpRequest.setHeader("Referer", "http://hfradar.ndbc.noaa.gov/tab.php");
            long reqTime = System.currentTimeMillis();
            CloseableHttpResponse iGetResultCode = this.httpComm.getClient().execute((HttpUriRequest)this.getHttpRequest);
            this.httpComm.autenticateProxyIfNeeded((HttpResponse)iGetResultCode, null);
            if (iGetResultCode.getStatusLine().getStatusCode() != 200) {
                NeptusLog.pub().info((Object)("<###>getRemoteImcData [" + iGetResultCode.getStatusLine().getStatusCode() + "] " + iGetResultCode.getStatusLine().getReasonPhrase() + " code was return from the server"));
                if (this.getHttpRequest != null) {
                    this.getHttpRequest.abort();
                }
                HashMap<String, HFRadarDataPoint> hashMap = null;
                return hashMap;
            }
            InputStream streamGetResponseBody = iGetResultCode.getEntity().getContent();
            long fullSize = iGetResultCode.getEntity().getContentLength();
            InputStreamReader isr = new InputStreamReader(streamGetResponseBody);
            HashMap<String, HFRadarDataPoint> hashMap = lst = this.processNoaaHFRadar(isr);
            return hashMap;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (this.getHttpRequest != null) {
                this.getHttpRequest.abort();
                this.getHttpRequest = null;
            }
        }
        return null;
    }

    private String getNoaaURI(Date tillDate, Date nowDate, LocationType lTop, LocationType lBot) {
        String uri = "http://hfradar.ndbc.noaa.gov/tabdownload.php?from=#FROM_DATE#%20#FROM_TIME#:00&to=#TO_DATE#%20#TO_TIME#:00&lat=#LAT1#&lng=#LNG1#&lat2=#LAT2#&lng2=#LNG2#";
        uri = uri.replace("#FROM_DATE#", dateFormaterUTC.format(tillDate));
        uri = uri.replace("#FROM_TIME#", timeFormaterUTC.format(tillDate));
        uri = uri.replace("#TO_DATE#", dateFormaterUTC.format(nowDate));
        uri = uri.replace("#TO_TIME#", timeFormaterUTC.format(nowDate));
        uri = uri.replace("#LAT1#", "" + lTop.getLatitudeDegs());
        uri = uri.replace("#LNG1#", "" + lTop.getLongitudeDegs());
        uri = uri.replace("#LAT2#", "" + lBot.getLatitudeDegs());
        uri = uri.replace("#LNG2#", "" + lBot.getLongitudeDegs());
        return uri;
    }

    public void paint(Graphics2D go, StateRenderer2D renderer) {
    }

    public void paintWorker(Graphics2D go, StateRenderer2D renderer) {
        if (!this.clearImgCachRqst) {
            if (this.isToRegenerateCache(renderer)) {
                this.cacheImg = null;
            }
        } else {
            this.cacheImg = null;
            this.clearImgCachRqst = false;
        }
        if (this.cacheImg == null) {
            this.dim = renderer.getSize(new Dimension());
            this.lastLod = renderer.getLevelOfDetail();
            this.lastCenter = renderer.getCenter();
            this.lastRotation = renderer.getRotation();
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice gs = ge.getDefaultScreenDevice();
            GraphicsConfiguration gc = gs.getDefaultConfiguration();
            this.cacheImg = gc.createCompatibleImage((int)this.dim.getWidth() + offScreenBufferPixel * 2, (int)this.dim.getHeight() + offScreenBufferPixel * 2, 2);
            Graphics2D g2 = this.cacheImg.createGraphics();
            g2.translate(offScreenBufferPixel, offScreenBufferPixel);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            Date dateColorLimit = new Date(System.currentTimeMillis() - 10800000L);
            Date dateLimit = new Date(System.currentTimeMillis() - (long)this.dateLimitHours * 3600000L);
            if (this.showCurrents) {
                this.paintHFRadarInGraphics(renderer, g2, dateColorLimit, dateLimit);
            }
            if (this.showSST) {
                this.paintSSTInGraphics(renderer, g2, dateColorLimit, dateLimit);
            }
            if (this.showWind) {
                this.paintWindInGraphics(renderer, g2, dateColorLimit, dateLimit);
            }
            if (this.showWaves) {
                this.paintWavesInGraphics(renderer, g2, dateColorLimit, dateLimit);
            }
            g2.dispose();
        }
        if (this.cacheImg != null) {
            Graphics2D g3 = (Graphics2D)go.create();
            double[] offset = renderer.getCenter().getDistanceInPixelTo(this.lastCenter, renderer.getLevelOfDetail());
            offset = AngleCalc.rotate((double)renderer.getRotation(), (double)offset[0], (double)offset[1], (boolean)true);
            g3.drawImage(this.cacheImg, null, (int)offset[0] - offScreenBufferPixel, (int)offset[1] - offScreenBufferPixel);
            g3.dispose();
        }
    }

    private boolean isToRegenerateCache(StateRenderer2D renderer) {
        LocationType last;
        if (this.dim == null || this.lastLod < 0 || this.lastCenter == null || Double.isNaN(this.lastRotation)) {
            Dimension dimN = renderer.getSize(new Dimension());
            if (dimN.height != 0 && dimN.width != 0) {
                this.dim = dimN;
            }
            return true;
        }
        LocationType current = renderer.getCenter().getNewAbsoluteLatLonDepth();
        double[] offset = current.getDistanceInPixelTo(last = this.lastCenter == null ? new LocationType(0.0, 0.0) : this.lastCenter, renderer.getLevelOfDetail());
        if (Math.abs(offset[0]) > (double)offScreenBufferPixel || Math.abs(offset[1]) > (double)offScreenBufferPixel) {
            return true;
        }
        return !this.dim.equals(renderer.getSize()) || this.lastLod != renderer.getLevelOfDetail() || Double.compare(this.lastRotation, renderer.getRotation()) != 0;
    }

    private void paintHFRadarInGraphics(StateRenderer2D renderer, Graphics2D g2, Date dateColorLimit, Date dateLimit) {
        LocationType loc = new LocationType();
        Date fromDate = null;
        Date toDate = null;
        for (HFRadarDataPoint dp : this.dataPointsCurrents.values().toArray(new HFRadarDataPoint[0])) {
            if (dp.getDateUTC().before(dateLimit) && !this.ignoreDateLimitToLoad) continue;
            double latV = dp.getLat();
            double lonV = dp.getLon();
            double headingV = dp.getHeadingDegrees();
            if (Double.isNaN(latV) || Double.isNaN(lonV) || Double.isNaN(headingV)) continue;
            loc.setLatitudeDegs(latV);
            loc.setLongitudeDegs(lonV);
            Point2D pt = renderer.getScreenPosition(loc);
            if (!this.isVisibleInRender(pt, renderer)) continue;
            if (fromDate == null) {
                fromDate = dp.getDateUTC();
            } else if (dp.getDateUTC().before(fromDate)) {
                fromDate = dp.getDateUTC();
            }
            if (toDate == null) {
                toDate = dp.getDateUTC();
            } else if (dp.getDateUTC().after(toDate)) {
                toDate = dp.getDateUTC();
            }
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            Graphics2D gt = (Graphics2D)g2.create();
            gt.translate(pt.getX(), pt.getY());
            Color color = Color.WHITE;
            color = this.colorMapCurrents.getColor(dp.getSpeedCmS() / 200.0);
            if (dp.getDateUTC().before(dateColorLimit)) {
                color = ColorUtils.setTransparencyToColor((Color)color, (int)128);
            }
            gt.setColor(color);
            double rot = Math.toRadians(-headingV + 90.0) - renderer.getRotation();
            gt.rotate(rot);
            gt.fill(arrow);
            gt.rotate(-rot);
            if (this.showCurrentsLegend && renderer.getLevelOfDetail() >= this.showCurrentsLegendFromZoomLevel) {
                gt.setFont(this.font8Pt);
                gt.setColor(Color.WHITE);
                gt.drawString(MathMiscUtils.round((double)dp.getSpeedCmS(), (int)1) + "cm/s", 10, 2);
            }
            gt.dispose();
        }
        if (this.showDataDebugLegend) {
            String txtMsg = "Currents data from '" + fromDate + "' till '" + toDate + "'";
            Graphics2D gt = (Graphics2D)g2.create();
            gt.setFont(this.font8Pt);
            gt.setColor(Color.WHITE);
            gt.drawString(txtMsg, 10, 52);
            gt.dispose();
        }
    }

    private void paintSSTInGraphics(StateRenderer2D renderer, Graphics2D g2, Date dateColorLimit, Date dateLimit) {
        LocationType loc = new LocationType();
        for (SSTDataPoint dp : this.dataPointsSST.values().toArray(new SSTDataPoint[0])) {
            if (dp.getDateUTC().before(dateLimit) && !this.ignoreDateLimitToLoad) continue;
            double latV = dp.getLat();
            double lonV = dp.getLon();
            double sstV = dp.getSst();
            if (Double.isNaN(latV) || Double.isNaN(lonV) || Double.isNaN(sstV)) continue;
            loc.setLatitudeDegs(latV);
            loc.setLongitudeDegs(lonV);
            Point2D pt = renderer.getScreenPosition(loc);
            if (!this.isVisibleInRender(pt, renderer)) continue;
            Graphics2D gt = (Graphics2D)g2.create();
            gt.translate(pt.getX(), pt.getY());
            Color color = Color.WHITE;
            color = this.colorMapSST.getColor((dp.getSst() - -10.0) / 50.0);
            if (dp.getDateUTC().before(dateColorLimit)) {
                color = ColorUtils.setTransparencyToColor((Color)color, (int)128);
            }
            gt.setColor(color);
            gt.draw(circle);
            gt.fill(circle);
            if (this.showSSTLegend && renderer.getLevelOfDetail() >= this.showSSTLegendFromZoomLevel) {
                gt.setFont(this.font8Pt);
                gt.setColor(Color.WHITE);
                gt.drawString(MathMiscUtils.round((double)dp.getSst(), (int)1) + "\u00b0C", -15, 15);
            }
            gt.dispose();
        }
    }

    private void paintWindInGraphics(StateRenderer2D renderer, Graphics2D g2, Date dateColorLimit, Date dateLimit) {
        LocationType loc = new LocationType();
        for (WindDataPoint dp : this.dataPointsWind.values().toArray(new WindDataPoint[0])) {
            if (dp.getDateUTC().before(dateLimit) && !this.ignoreDateLimitToLoad) continue;
            double latV = dp.getLat();
            double lonV = dp.getLon();
            double speedV = dp.getSpeed();
            double headingV = dp.getHeading();
            if (Double.isNaN(latV) || Double.isNaN(lonV) || Double.isNaN(speedV) || Double.isNaN(headingV)) continue;
            loc.setLatitudeDegs(latV);
            loc.setLongitudeDegs(lonV);
            Point2D pt = renderer.getScreenPosition(loc);
            if (!this.isVisibleInRender(pt, renderer)) continue;
            Graphics2D gt = (Graphics2D)g2.create();
            gt.translate(pt.getX(), pt.getY());
            Color color = Color.BLACK;
            if (this.useColorMapForWind) {
                color = this.colorMapWind.getColor(dp.getSpeed() / 33.43888888889929);
            }
            if (dp.getDateUTC().before(dateColorLimit)) {
                color = ColorUtils.setTransparencyToColor((Color)color, (int)128);
            }
            gt.setColor(color);
            gt.rotate(Math.toRadians(headingV) - renderer.getRotation());
            double speedKnots = speedV * 1.94384449244;
            if (speedKnots >= 2.0) {
                gt.draw(windPoleKnots);
            }
            if (speedKnots >= 5.0 && speedKnots < 10.0) {
                gt.draw(wind5Knots2);
            } else if (speedKnots >= 10.0 && speedKnots < 15.0) {
                gt.draw(wind10Knots1);
            } else if (speedKnots >= 15.0 && speedKnots < 20.0) {
                gt.draw(wind10Knots1);
                gt.draw(wind5Knots2);
            } else if (speedKnots >= 20.0 && speedKnots < 25.0) {
                gt.draw(wind10Knots1);
                gt.draw(wind10Knots2);
            } else if (speedKnots >= 25.0 && speedKnots < 30.0) {
                gt.draw(wind10Knots1);
                gt.draw(wind10Knots2);
                gt.draw(wind5Knots3);
            } else if (speedKnots >= 30.0 && speedKnots < 35.0) {
                gt.draw(wind10Knots1);
                gt.draw(wind10Knots2);
                gt.draw(wind10Knots3);
            } else if (speedKnots >= 35.0 && speedKnots < 40.0) {
                gt.draw(wind10Knots1);
                gt.draw(wind10Knots2);
                gt.draw(wind10Knots3);
                gt.draw(wind5Knots4);
            } else if (speedKnots >= 40.0 && speedKnots < 45.0) {
                gt.draw(wind10Knots1);
                gt.draw(wind10Knots2);
                gt.draw(wind10Knots3);
                gt.draw(wind10Knots4);
            } else if (speedKnots >= 45.0 && speedKnots < 50.0) {
                gt.draw(wind10Knots1);
                gt.draw(wind10Knots2);
                gt.draw(wind10Knots3);
                gt.draw(wind10Knots4);
                gt.draw(wind5Knots5);
            } else if (speedKnots >= 50.0) {
                gt.draw(wind50Knots1);
                gt.fill(wind50Knots1);
            }
            gt.dispose();
        }
    }

    private void paintWavesInGraphics(StateRenderer2D renderer, Graphics2D g2, Date dateColorLimit, Date dateLimit) {
        LocationType loc = new LocationType();
        for (WavesDataPoint dp : this.dataPointsWaves.values().toArray(new WavesDataPoint[0])) {
            if (dp.getDateUTC().before(dateLimit) && !this.ignoreDateLimitToLoad) continue;
            double latV = dp.getLat();
            double lonV = dp.getLon();
            double sigHeightV = dp.getSignificantHeight();
            double headingV = dp.getPeakDirection();
            double periodV = dp.getPeakPeriod();
            if (Double.isNaN(latV) || Double.isNaN(lonV) || Double.isNaN(sigHeightV) || Double.isNaN(headingV) || Double.isNaN(periodV)) continue;
            loc.setLatitudeDegs(latV);
            loc.setLongitudeDegs(lonV);
            Point2D pt = renderer.getScreenPosition(loc);
            if (!this.isVisibleInRender(pt, renderer)) continue;
            Graphics2D gt = (Graphics2D)g2.create();
            gt.translate(pt.getX(), pt.getY());
            Color color = Color.WHITE;
            color = this.colorMapWaves.getColor(dp.getSignificantHeight() / 7.0);
            if (dp.getDateUTC().before(dateColorLimit)) {
                color = ColorUtils.setTransparencyToColor((Color)color, (int)128);
            }
            gt.setColor(color);
            double rot = Math.toRadians(headingV) - renderer.getRotation();
            gt.rotate(rot);
            gt.fill(arrow);
            gt.rotate(-rot);
            if (this.showWavesLegend && renderer.getLevelOfDetail() >= this.showWavesLegendFromZoomLevel) {
                gt.setFont(this.font8Pt);
                gt.setColor(Color.WHITE);
                gt.drawString(MathMiscUtils.round((double)dp.getSignificantHeight(), (int)1) + "m", 10, -8);
            }
            gt.dispose();
        }
    }

    private boolean isVisibleInRender(Point2D sPos, StateRenderer2D renderer) {
        Dimension rendDim = renderer.getSize();
        if (sPos.getX() < (double)(0 - offScreenBufferPixel) && sPos.getY() < (double)(0 - offScreenBufferPixel)) {
            return false;
        }
        return !(sPos.getX() > rendDim.getWidth() + (double)offScreenBufferPixel) || !(sPos.getY() > rendDim.getHeight() + (double)offScreenBufferPixel);
    }

    private FileReader getFileReaderForFile(String fileName) {
        String fxName = FileUtil.getResourceAsFileKeepName((String)fileName);
        if (fxName == null) {
            fxName = fileName;
        }
        File fx = new File(fxName);
        try {
            FileReader freader = new FileReader(fx);
            return freader;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    private HashMap<String, HFRadarDataPoint> processTuvHFRadarTest(String fileName) {
        HashMap<String, HFRadarDataPoint> hfdp = new HashMap<String, HFRadarDataPoint>();
        FileReader freader = this.getFileReaderForFile(fileName);
        if (freader == null) {
            return hfdp;
        }
        HashMap<String, HFRadarDataPoint> ret = LoaderHelper.processTUGHFRadar(freader, this.ignoreDateLimitToLoad ? null : this.createDateLimitToRemove());
        return ret;
    }

    private HashMap<String, HFRadarDataPoint> processNetCDFHFRadarTest(String fileName) {
        String fxName = FileUtil.getResourceAsFileKeepName((String)fileName);
        if (fxName == null) {
            fxName = fileName;
        }
        if (!new File(fxName).exists()) {
            return new HashMap<String, HFRadarDataPoint>();
        }
        HashMap<String, HFRadarDataPoint> ret = LoaderHelper.processNetCDFHFRadar(fxName, this.ignoreDateLimitToLoad ? null : this.createDateLimitToRemove());
        return ret;
    }

    private HashMap<?, ?>[] processMeteoFile(String fileName) {
        String fxName = FileUtil.getResourceAsFileKeepName((String)fileName);
        if (fxName == null) {
            fxName = fileName;
        }
        if (!new File(fxName).exists()) {
            return new HashMap[]{new HashMap(), new HashMap()};
        }
        return LoaderHelper.processMeteo(fxName, this.ignoreDateLimitToLoad ? null : this.createDateLimitToRemove());
    }

    private HashMap<String, WavesDataPoint> processWavesFile(String fileName) {
        String fxName = FileUtil.getResourceAsFileKeepName((String)fileName);
        if (fxName == null) {
            fxName = fileName;
        }
        if (!new File(fxName).exists()) {
            return new HashMap<String, WavesDataPoint>();
        }
        return LoaderHelper.processWavesFile(fxName, this.ignoreDateLimitToLoad ? null : this.createDateLimitToRemove());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap<String, HFRadarDataPoint> processNoaaHFRadar(Reader readerInput) {
        long deltaTimeToHFRadarHistoricalData = (long)this.dateLimitHours * 3600000L;
        HashMap<String, HFRadarDataPoint> hfdp = new HashMap<String, HFRadarDataPoint>();
        BufferedReader reader = null;
        Date dateLimite = new Date(System.currentTimeMillis() - deltaTimeToHFRadarHistoricalData);
        try {
            reader = new BufferedReader(readerInput);
            String line = reader.readLine();
            while (line != null) {
                if (line.startsWith("#")) {
                    line = reader.readLine();
                    continue;
                }
                String[] tokens = line.split("[\t ,]");
                try {
                    HFRadarDataPoint dpo;
                    String dateStr = tokens[4];
                    String timeStr = tokens[5];
                    Date date = dateTimeFormaterUTC.parse(dateStr + " " + timeStr);
                    if (date.before(dateLimite) && !this.ignoreDateLimitToLoad) {
                        line = reader.readLine();
                        continue;
                    }
                    double lat = Double.parseDouble(tokens[0]);
                    double lon = Double.parseDouble(tokens[1]);
                    HFRadarDataPoint dp = new HFRadarDataPoint(lat, lon);
                    dp.setSpeedCmS(Double.parseDouble(tokens[2]));
                    dp.setHeadingDegrees(Double.parseDouble(tokens[3]));
                    dp.setDateUTC(date);
                    if (tokens.length >= 7) {
                        dp.setResolutionKm(Double.parseDouble(tokens[6]));
                        for (int j = 7; j < tokens.length; ++j) {
                            dp.setInfo(dp.getInfo() + tokens[j]);
                        }
                    }
                    if ((dpo = hfdp.get(HFRadarDataPoint.getId(dp))) == null) {
                        dpo = dp.getACopyWithoutHistory();
                        hfdp.put(HFRadarDataPoint.getId(dp), dp);
                    }
                    ArrayList<HFRadarDataPoint> lst = dpo.getHistoricalData();
                    boolean alreadyIn = false;
                    for (HFRadarDataPoint tmpDp : lst) {
                        if (!tmpDp.getDateUTC().equals(dp.getDateUTC())) continue;
                        alreadyIn = true;
                        break;
                    }
                    if (!alreadyIn) {
                        dpo.getHistoricalData().add(dp);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                line = reader.readLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        Date nowDate = this.createDateToMostRecent();
        for (HFRadarDataPoint elm : hfdp.values()) {
            this.updateHFRadarToUseMostRecentOrMean(nowDate, elm);
        }
        return hfdp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main1(String[] args) {
        String fxName = FileUtil.getResourceAsFileKeepName((String)sampleNoaaFile);
        File fx = new File(fxName);
        BufferedReader reader = null;
        try {
            FileReader freader = new FileReader(fx);
            reader = new BufferedReader(freader);
            String line = reader.readLine();
            int i = 0;
            while (line != null) {
                String[] tokens = line.split("[\t ,]");
                try {
                    double lat = Double.parseDouble(tokens[0]);
                    double lon = Double.parseDouble(tokens[1]);
                    HFRadarDataPoint dp = new HFRadarDataPoint(lat, lon);
                    dp.setSpeedCmS(Double.parseDouble(tokens[2]));
                    dp.setHeadingDegrees(Double.parseDouble(tokens[3]));
                    String dateStr = tokens[4];
                    String timeStr = tokens[5];
                    dp.setDateUTC(dateTimeFormaterUTC.parse(dateStr + " " + timeStr));
                    dp.setResolutionKm(Double.parseDouble(tokens[6]));
                    for (int j = 7; j < tokens.length; ++j) {
                        dp.setInfo(dp.getInfo() + tokens[j]);
                    }
                    System.out.println(dp);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                line = reader.readLine();
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void main(String[] args) {
        String currentsFilePattern = "TOTL_TRAD_\\d{4}_\\d{2}_\\d{2}_\\d{4}\\.tuv";
        Pattern pat = Pattern.compile(currentsFilePattern);
        Matcher m = pat.matcher("TOTL_TRAD_2013_07_11_0800.tuv");
        System.out.println(m.find());
        Object[] fileList = FileUtil.getFilesFromDisk((File)new File("IHData/CODAR"), (String)".\\.nc$");
        System.out.println(Arrays.toString(fileList));
        HashMap<String, HFRadarDataPoint> ret = LoaderHelper.processNetCDFHFRadar("IHData/CODAR/mola_his_z-20140512.nc", null);
        System.out.println("First :: " + ret.values().iterator().next());
        HFRadarDataPoint lastdp = null;
        Iterator<HFRadarDataPoint> i$ = ret.values().iterator().next().getHistoricalData().iterator();
        while (i$.hasNext()) {
            HFRadarDataPoint dp;
            lastdp = dp = i$.next();
        }
        System.out.println("Last  :: " + lastdp);
        HFRadarDataPoint dp = ret.values().iterator().next();
        System.out.println("" + dp);
        Date newDate = new Date(dp.dateUTC.getTime() + 10800000L + 1800000L);
        System.out.println(newDate);
        dp.useMostRecent(newDate);
        System.out.println("" + dp);
    }

    static {
        arrow.moveTo(-5.0, 6.0);
        arrow.lineTo(0.0, -6.0);
        arrow.lineTo(5.0, 6.0);
        arrow.lineTo(0.0, 3.0);
        arrow.lineTo(-5.0, 6.0);
        arrow.closePath();
        circle = new Ellipse2D.Double(-4.0, -4.0, 8.0, 8.0);
        windPoleKnots = new Path2D.Double();
        windPoleKnots.moveTo(0.0, 0.0);
        windPoleKnots.lineTo(0.0, 28.0);
        windPoleKnots.closePath();
        wind50Knots1 = new Path2D.Double();
        wind50Knots1.moveTo(0.0, 28.0);
        wind50Knots1.lineTo(-16.0, 28.0);
        wind50Knots1.lineTo(0.0, 24.0);
        wind50Knots1.closePath();
        wind10Knots1 = new Path2D.Double();
        wind10Knots1.moveTo(0.0, 28.0);
        wind10Knots1.lineTo(-16.0, 28.0);
        wind10Knots1.closePath();
        wind5Knots2 = new Path2D.Double();
        wind5Knots2.moveTo(0.0, 24.0);
        wind5Knots2.lineTo(-8.0, 24.0);
        wind5Knots2.closePath();
        wind10Knots2 = new Path2D.Double();
        wind10Knots2.moveTo(0.0, 24.0);
        wind10Knots2.lineTo(-16.0, 24.0);
        wind10Knots2.closePath();
        wind5Knots3 = new Path2D.Double();
        wind5Knots3.moveTo(0.0, 20.0);
        wind5Knots3.lineTo(-8.0, 20.0);
        wind5Knots3.closePath();
        wind10Knots3 = new Path2D.Double();
        wind10Knots3.moveTo(0.0, 20.0);
        wind10Knots3.lineTo(-16.0, 20.0);
        wind10Knots3.closePath();
        wind5Knots4 = new Path2D.Double();
        wind5Knots4.moveTo(0.0, 16.0);
        wind5Knots4.lineTo(-8.0, 16.0);
        wind5Knots4.closePath();
        wind10Knots4 = new Path2D.Double();
        wind10Knots4.moveTo(0.0, 16.0);
        wind10Knots4.lineTo(-16.0, 16.0);
        wind10Knots4.closePath();
        wind5Knots5 = new Path2D.Double();
        wind5Knots5.moveTo(0.0, 12.0);
        wind5Knots5.lineTo(-8.0, 12.0);
        wind5Knots5.closePath();
        offScreenBufferPixel = 400;
    }

    @PluginDescription(name="HF Radar Visualization Layer", icon="pt/lsts/neptus/plugins/envdisp/hf-radar.png")
    private class HFRadarConsoleLayer
    extends ConsoleLayer {
        private HFRadarConsoleLayer() {
        }

        public void setVisible(boolean visible) {
            super.setVisible(visible);
        }

        public boolean userControlsOpacity() {
            return false;
        }

        public void initLayer() {
        }

        public void cleanLayer() {
        }

        public void paint(Graphics2D g, StateRenderer2D renderer) {
            super.paint(g, renderer);
            HFRadarVisualization.this.paintWorker(g, renderer);
        }
    }
}

