/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.envdisp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.data.Pair;
import pt.lsts.neptus.plugins.envdisp.BaseDataPoint;
import pt.lsts.neptus.plugins.envdisp.HFRadarDataPoint;
import pt.lsts.neptus.plugins.envdisp.HFRadarVisualization;
import pt.lsts.neptus.plugins.envdisp.SSTDataPoint;
import pt.lsts.neptus.plugins.envdisp.WavesDataPoint;
import pt.lsts.neptus.plugins.envdisp.WindDataPoint;
import ucar.ma2.Array;
import ucar.ma2.Index;
import ucar.ma2.Index3D;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;

public class LoaderHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final HashMap<String, HFRadarDataPoint> processTUGHFRadar(Reader readerInput, Date dateLimit) {
        boolean ignoreDateLimitToLoad = false;
        if (dateLimit == null) {
            ignoreDateLimitToLoad = true;
        }
        HashMap<String, HFRadarDataPoint> hfdp = new HashMap<String, HFRadarDataPoint>();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(readerInput);
            String line = reader.readLine();
            Date dateStart = null;
            while (line != null) {
                Object tsStr;
                if (line.startsWith("#")) {
                    line = reader.readLine();
                    continue;
                }
                if (line.startsWith("%")) {
                    tsStr = "%TimeStamp: ";
                    if (line.startsWith((String)tsStr)) {
                        dateStart = HFRadarVisualization.dateTimeFormaterSpacesUTC.parse(line, new ParsePosition(((String)tsStr).length() - 1));
                    }
                    line = reader.readLine();
                    continue;
                }
                if (dateStart == null) {
                    NeptusLog.pub().warn((Object)"No start date found on TUV CODAR file.");
                    tsStr = hfdp;
                    return tsStr;
                }
                if (!ignoreDateLimitToLoad && dateStart.before(dateLimit)) {
                    tsStr = hfdp;
                    return tsStr;
                }
                String[] tokens = line.trim().split("[\\t ,]+");
                if (tokens.length < 4) {
                    line = reader.readLine();
                    continue;
                }
                int latIdx = 1;
                int lonIdx = 0;
                int uIdx = 2;
                int vIdx = 3;
                try {
                    double lat = Double.parseDouble(tokens[latIdx]);
                    double lon = Double.parseDouble(tokens[lonIdx]);
                    double u = Double.parseDouble(tokens[uIdx]);
                    double v = Double.parseDouble(tokens[vIdx]);
                    double speed = Math.sqrt(u * u + v * v);
                    double heading = Math.atan2(v, u);
                    HFRadarDataPoint dp = new HFRadarDataPoint(lat, lon);
                    dp.setSpeedCmS(speed);
                    dp.setHeadingDegrees(Math.toDegrees(heading));
                    dp.setDateUTC(dateStart);
                    HFRadarDataPoint dpo = hfdp.get(HFRadarDataPoint.getId(dp));
                    if (dpo == null) {
                        dpo = dp.getACopyWithoutHistory();
                        hfdp.put(HFRadarDataPoint.getId(dp), dp);
                    }
                    ArrayList<HFRadarDataPoint> lst = dpo.getHistoricalData();
                    boolean alreadyIn = false;
                    for (HFRadarDataPoint tmpDp : lst) {
                        if (!tmpDp.getDateUTC().equals(dp.getDateUTC())) continue;
                        alreadyIn = true;
                        break;
                    }
                    if (!alreadyIn) {
                        dpo.getHistoricalData().add(dp);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                line = reader.readLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return hfdp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final HashMap<String, HFRadarDataPoint> processNetCDFHFRadar(String fileName, Date dateLimit) {
        boolean ignoreDateLimitToLoad = false;
        if (dateLimit == null) {
            ignoreDateLimitToLoad = true;
        }
        NeptusLog.pub().info((Object)("Starting processing Currents netCDF file '" + fileName + "'." + (ignoreDateLimitToLoad ? " ignoring dateTime limit" : " Accepting data after " + dateLimit + ".")));
        HashMap<String, HFRadarDataPoint> hfdp = new HashMap<String, HFRadarDataPoint>();
        NetcdfFile dataFile = null;
        Date fromDate = null;
        Date toDate = null;
        try {
            Attribute vFillValueAtt;
            double[] multAndOffset;
            dataFile = NetcdfFile.open((String)fileName, null);
            Variable latVar = dataFile.findVariable("lat");
            if (latVar == null) {
                NeptusLog.pub().error((Object)("Aborting. Can't find variable 'lat' for netCDF file '" + fileName + "'."));
                HashMap<String, HFRadarDataPoint> hashMap = hfdp;
                return hashMap;
            }
            Variable lonVar = dataFile.findVariable("lon");
            if (lonVar == null) {
                NeptusLog.pub().error((Object)("Aborting. Can't find variable 'lon' for netCDF file '" + fileName + "'."));
                HashMap<String, HFRadarDataPoint> ioe = hfdp;
                return ioe;
            }
            Variable timeVar = dataFile.findVariable("time");
            if (timeVar == null) {
                NeptusLog.pub().error((Object)("Aborting. Can't find variable 'time' for netCDF file '" + fileName + "'."));
                HashMap<String, HFRadarDataPoint> ioe = hfdp;
                return ioe;
            }
            Variable uVar = dataFile.findVariable("u");
            if (uVar == null) {
                NeptusLog.pub().error((Object)("Aborting. Can't find variable 'u' for netCDF file '" + fileName + "'."));
                HashMap<String, HFRadarDataPoint> ioe = hfdp;
                return ioe;
            }
            Variable vVar = dataFile.findVariable("v");
            if (vVar == null) {
                NeptusLog.pub().error((Object)("Aborting. Can't find variable 'v' for netCDF file '" + fileName + "'."));
                HashMap<String, HFRadarDataPoint> ioe = hfdp;
                return ioe;
            }
            Array latArray = latVar.read();
            Array lonArray = lonVar.read();
            Array timeArray = timeVar.read();
            Array uArray = uVar.read();
            Array vArray = vVar.read();
            int[] shape = uVar.getShape();
            String timeUnits = "days since 00-01-00 00:00:00";
            Attribute timeUnitsAtt = timeVar.findAttribute("units");
            if (timeUnitsAtt != null) {
                timeUnits = (String)timeUnitsAtt.getValue(0);
            }
            if ((multAndOffset = LoaderHelper.getMultiplierAndMillisOffsetFromTimeUnits(timeUnits)) == null) {
                NeptusLog.pub().error((Object)("Aborting. Can't parse units for variable 'time' (was '" + timeUnits + "') for netCDF file '" + fileName + "'."));
                HashMap<String, HFRadarDataPoint> hashMap = hfdp;
                return hashMap;
            }
            double timeMultiplier = multAndOffset[0];
            double timeOffset = multAndOffset[1];
            double uFillValue = Double.NaN;
            double vFillValue = Double.NaN;
            Attribute uFillValueAtt = uVar.findAttribute("_FillValue");
            if (uFillValueAtt != null) {
                try {
                    uFillValue = (Double)uFillValueAtt.getValue(0);
                }
                catch (ClassCastException e) {
                    uFillValue = Double.parseDouble((String)uFillValueAtt.getValue(0));
                }
            }
            if ((vFillValueAtt = vVar.findAttribute("_FillValue")) != null) {
                try {
                    vFillValue = (Double)vFillValueAtt.getValue(0);
                }
                catch (ClassCastException e) {
                    vFillValue = Double.parseDouble((String)vFillValueAtt.getValue(0));
                }
            }
            String uUnits = "cm/s";
            Attribute uUnitsAtt = uVar.findAttribute("units");
            if (uUnitsAtt != null) {
                uUnits = (String)uUnitsAtt.getValue(0);
            }
            String vUnits = "cm/s";
            Attribute vUnitsAtt = uVar.findAttribute("units");
            if (vUnitsAtt != null) {
                vUnits = (String)vUnitsAtt.getValue(0);
            }
            Pair<Integer, Integer> latLonIndexOrder = LoaderHelper.getLatLonIndexOrder(uVar.getDimensionsString());
            for (int timeIdx = 0; timeIdx < shape[0]; ++timeIdx) {
                double timeVal = timeArray.getDouble(timeIdx);
                Date dateValue = new Date((long)(timeVal * timeMultiplier + timeOffset));
                if (!ignoreDateLimitToLoad && dateValue.before(dateLimit)) continue;
                if (fromDate == null) {
                    fromDate = dateValue;
                } else if (dateValue.before(fromDate)) {
                    fromDate = dateValue;
                }
                if (toDate == null) {
                    toDate = dateValue;
                } else if (dateValue.after(toDate)) {
                    toDate = dateValue;
                }
                for (int latOrLonFirstIdx = 0; latOrLonFirstIdx < shape[1]; ++latOrLonFirstIdx) {
                    for (int latOrLonSecondIdx = 0; latOrLonSecondIdx < shape[2]; ++latOrLonSecondIdx) {
                        double lat = latArray.getDouble((Integer)latLonIndexOrder.first() == 1 ? latOrLonFirstIdx : latOrLonSecondIdx);
                        double lon = lonArray.getDouble((Integer)latLonIndexOrder.second() == 1 ? latOrLonFirstIdx : latOrLonSecondIdx);
                        Index3D idx3d = (Index3D)uArray.getIndex();
                        idx3d.set(timeIdx, latOrLonFirstIdx, latOrLonSecondIdx);
                        double u = uArray.getDouble((Index)idx3d);
                        idx3d = (Index3D)vArray.getIndex();
                        idx3d.set(timeIdx, latOrLonFirstIdx, latOrLonSecondIdx);
                        double v = vArray.getDouble((Index)idx3d);
                        if (Double.isNaN(u) || Double.isNaN(v) || u == uFillValue || v == vFillValue) continue;
                        double speedCmS = Math.sqrt((u *= LoaderHelper.getMultiplierForCmPerSecondsFromSpeedUnits(uUnits)) * u + (v *= LoaderHelper.getMultiplierForCmPerSecondsFromSpeedUnits(vUnits)) * v) * 100.0;
                        double heading = Math.atan2(v, u);
                        HFRadarDataPoint dp = new HFRadarDataPoint(lat, lon);
                        dp.setSpeedCmS(speedCmS);
                        dp.setHeadingDegrees(Math.toDegrees(heading));
                        dp.setDateUTC(dateValue);
                        HFRadarDataPoint dpo = hfdp.get(HFRadarDataPoint.getId(dp));
                        if (dpo == null) {
                            dpo = dp.getACopyWithoutHistory();
                            hfdp.put(HFRadarDataPoint.getId(dp), dp);
                        }
                        ArrayList<HFRadarDataPoint> lst = dpo.getHistoricalData();
                        boolean alreadyIn = false;
                        for (HFRadarDataPoint tmpDp : lst) {
                            if (!tmpDp.getDateUTC().equals(dp.getDateUTC())) continue;
                            alreadyIn = true;
                            break;
                        }
                        if (alreadyIn) continue;
                        dpo.getHistoricalData().add(dp);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            HashMap<String, HFRadarDataPoint> hashMap = null;
            return hashMap;
        }
        finally {
            if (dataFile != null) {
                try {
                    dataFile.close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
            NeptusLog.pub().info((Object)("Ending processing Currents netCDF file '" + fileName + "'. Reading from date '" + fromDate + "' till '" + toDate + "'."));
        }
        return hfdp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final HashMap<?, ?>[] processMeteo(String fileName, Date dateLimit) {
        boolean ignoreDateLimitToLoad = false;
        if (dateLimit == null) {
            ignoreDateLimitToLoad = true;
        }
        NeptusLog.pub().info((Object)("Starting processing Meteo (wind and SST) netCDF file '" + fileName + "'." + (ignoreDateLimitToLoad ? " ignoring dateTime limit" : " Accepting data after " + dateLimit + ".")));
        HashMap<String, BaseDataPoint> sstdp = new HashMap<String, BaseDataPoint>();
        HashMap<String, BaseDataPoint> winddp = new HashMap<String, BaseDataPoint>();
        NetcdfFile dataFile = null;
        Date fromDate = null;
        Date toDate = null;
        try {
            Attribute sstFillValueAtt;
            Attribute vFillValueAtt;
            double[] multAndOffset;
            dataFile = NetcdfFile.open((String)fileName, null);
            Variable latVar = dataFile.findVariable("lat");
            if (latVar == null) {
                NeptusLog.pub().error((Object)("Aborting. Can't find variable 'lat' for netCDF file '" + fileName + "'."));
                HashMap[] hashMapArray = new HashMap[]{sstdp, winddp};
                return hashMapArray;
            }
            Variable lonVar = dataFile.findVariable("lon");
            if (lonVar == null) {
                NeptusLog.pub().error((Object)("Aborting. Can't find variable 'lon' for netCDF file '" + fileName + "'."));
                HashMap[] ioe = new HashMap[]{sstdp, winddp};
                return ioe;
            }
            Variable timeVar = dataFile.findVariable("time");
            if (timeVar == null) {
                NeptusLog.pub().error((Object)("Aborting. Can't find variable 'time' for netCDF file '" + fileName + "'."));
                HashMap[] ioe = new HashMap[]{sstdp, winddp};
                return ioe;
            }
            Variable uVar = dataFile.findVariable("u");
            if (uVar == null) {
                NeptusLog.pub().error((Object)("Aborting. Can't find variable 'u' for netCDF file '" + fileName + "'."));
                HashMap[] ioe = new HashMap[]{sstdp, winddp};
                return ioe;
            }
            Variable vVar = dataFile.findVariable("v");
            if (vVar == null) {
                NeptusLog.pub().error((Object)("Aborting. Can't find variable 'v' for netCDF file '" + fileName + "'."));
                HashMap[] ioe = new HashMap[]{sstdp, winddp};
                return ioe;
            }
            Variable sstVar = dataFile.findVariable("sst");
            if (sstVar == null) {
                NeptusLog.pub().error((Object)("Aborting. Can't find variable 'sst' for netCDF file '" + fileName + "'."));
                HashMap[] ioe = new HashMap[]{sstdp, winddp};
                return ioe;
            }
            Array latArray = latVar.read();
            Array lonArray = lonVar.read();
            Array timeArray = timeVar.read();
            Array uArray = uVar.read();
            Array vArray = vVar.read();
            Array sstArray = sstVar.read();
            int[] shape = uVar.getShape();
            String timeUnits = "days since 00-01-00 00:00:00";
            Attribute timeUnitsAtt = timeVar.findAttribute("units");
            if (timeUnitsAtt != null) {
                timeUnits = (String)timeUnitsAtt.getValue(0);
            }
            if ((multAndOffset = LoaderHelper.getMultiplierAndMillisOffsetFromTimeUnits(timeUnits)) == null) {
                NeptusLog.pub().error((Object)("Aborting. Can't parse units for variable 'time' (was '" + timeUnits + "') for netCDF file '" + fileName + "'."));
                HashMap[] hashMapArray = new HashMap[]{sstdp, winddp};
                return hashMapArray;
            }
            double timeMultiplier = multAndOffset[0];
            double timeOffset = multAndOffset[1];
            double uFillValue = Double.NaN;
            double vFillValue = Double.NaN;
            double sstFillValue = Double.NaN;
            Attribute uFillValueAtt = uVar.findAttribute("_FillValue");
            if (uFillValueAtt != null) {
                try {
                    uFillValue = (Double)uFillValueAtt.getValue(0);
                }
                catch (ClassCastException e) {
                    uFillValue = Double.parseDouble((String)uFillValueAtt.getValue(0));
                }
            }
            if ((vFillValueAtt = vVar.findAttribute("_FillValue")) != null) {
                try {
                    vFillValue = (Double)vFillValueAtt.getValue(0);
                }
                catch (ClassCastException e) {
                    vFillValue = Double.parseDouble((String)vFillValueAtt.getValue(0));
                }
            }
            if ((sstFillValueAtt = sstVar.findAttribute("_FillValue")) != null) {
                try {
                    sstFillValue = (Double)sstFillValueAtt.getValue(0);
                }
                catch (ClassCastException e) {
                    sstFillValue = Double.parseDouble((String)sstFillValueAtt.getValue(0));
                }
            }
            String uUnits = "cm/s";
            Attribute uUnitsAtt = uVar.findAttribute("units");
            if (uUnitsAtt != null) {
                uUnits = (String)uUnitsAtt.getValue(0);
            }
            String vUnits = "cm/s";
            Attribute vUnitsAtt = uVar.findAttribute("units");
            if (vUnitsAtt != null) {
                vUnits = (String)vUnitsAtt.getValue(0);
            }
            String sstUnits = "K";
            Attribute sstUnitsAtt = sstVar.findAttribute("units");
            if (sstUnitsAtt != null) {
                sstUnits = (String)sstUnitsAtt.getValue(0);
            }
            Pair<Integer, Integer> latLonIndexOrder = LoaderHelper.getLatLonIndexOrder(uVar.getDimensionsString());
            for (int timeIdx = 0; timeIdx < shape[0]; ++timeIdx) {
                double timeVal = timeArray.getDouble(timeIdx);
                Date dateValue = new Date((long)(timeVal * timeMultiplier + timeOffset));
                if (!ignoreDateLimitToLoad && dateValue.before(dateLimit)) continue;
                if (fromDate == null) {
                    fromDate = dateValue;
                } else if (dateValue.before(fromDate)) {
                    fromDate = dateValue;
                }
                if (toDate == null) {
                    toDate = dateValue;
                } else if (dateValue.after(toDate)) {
                    toDate = dateValue;
                }
                for (int latOrLonFirstIdx = 0; latOrLonFirstIdx < shape[1]; ++latOrLonFirstIdx) {
                    for (int latOrLonSecondIdx = 0; latOrLonSecondIdx < shape[2]; ++latOrLonSecondIdx) {
                        boolean alreadyIn;
                        ArrayList lst;
                        BaseDataPoint dpo;
                        BaseDataPoint dp;
                        double lat = latArray.getDouble((Integer)latLonIndexOrder.first() == 1 ? latOrLonFirstIdx : latOrLonSecondIdx);
                        double lon = lonArray.getDouble((Integer)latLonIndexOrder.second() == 1 ? latOrLonFirstIdx : latOrLonSecondIdx);
                        Index3D idx3d = (Index3D)uArray.getIndex();
                        idx3d.set(timeIdx, latOrLonFirstIdx, latOrLonSecondIdx);
                        double u = uArray.getDouble((Index)idx3d);
                        idx3d = (Index3D)vArray.getIndex();
                        idx3d.set(timeIdx, latOrLonFirstIdx, latOrLonSecondIdx);
                        double v = vArray.getDouble((Index)idx3d);
                        idx3d = (Index3D)sstArray.getIndex();
                        idx3d.set(timeIdx, latOrLonFirstIdx, latOrLonSecondIdx);
                        double sst = sstArray.getDouble((Index)idx3d);
                        if (!Double.isNaN(u) && !Double.isNaN(v) && u != uFillValue && v != vFillValue) {
                            dp = new WindDataPoint(lat, lon);
                            ((WindDataPoint)dp).setU(u *= LoaderHelper.getMultiplierForCmPerSecondsFromSpeedUnits(uUnits));
                            ((WindDataPoint)dp).setV(v *= LoaderHelper.getMultiplierForCmPerSecondsFromSpeedUnits(vUnits));
                            dp.setDateUTC(dateValue);
                            dpo = (WindDataPoint)winddp.get(WindDataPoint.getId(dp));
                            if (dpo == null) {
                                dpo = ((WindDataPoint)dp).getACopyWithoutHistory();
                                winddp.put(HFRadarDataPoint.getId(dp), dp);
                            }
                            lst = dpo.getHistoricalData();
                            alreadyIn = false;
                            for (BaseDataPoint tmpDp : lst) {
                                if (!tmpDp.getDateUTC().equals(dp.getDateUTC())) continue;
                                alreadyIn = true;
                                break;
                            }
                            if (!alreadyIn) {
                                dpo.getHistoricalData().add(dp);
                            }
                        }
                        if (Double.isNaN(sst) || sst == sstFillValue) continue;
                        dp = new SSTDataPoint(lat, lon);
                        sst = LoaderHelper.getValueForDegreesCelciusFromTempUnits(sst, sstUnits);
                        ((SSTDataPoint)dp).setSst(sst);
                        dp.setDateUTC(dateValue);
                        dpo = (SSTDataPoint)sstdp.get(SSTDataPoint.getId(dp));
                        if (dpo == null) {
                            dpo = ((SSTDataPoint)dp).getACopyWithoutHistory();
                            sstdp.put(SSTDataPoint.getId(dp), dp);
                        }
                        lst = dpo.getHistoricalData();
                        alreadyIn = false;
                        for (BaseDataPoint tmpDp : lst) {
                            if (!tmpDp.getDateUTC().equals(dp.getDateUTC())) continue;
                            alreadyIn = true;
                            break;
                        }
                        if (alreadyIn) continue;
                        dpo.getHistoricalData().add(dp);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            HashMap<?, ?>[] hashMapArray = null;
            return hashMapArray;
        }
        finally {
            if (dataFile != null) {
                try {
                    dataFile.close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
            NeptusLog.pub().info((Object)("Ending processing Meteo (wind and SST) netCDF file '" + fileName + "'. Reading from date '" + fromDate + "' till '" + toDate + "'."));
        }
        return new HashMap[]{sstdp, winddp};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final HashMap<String, WavesDataPoint> processWavesFile(String fileName, Date dateLimit) {
        boolean ignoreDateLimitToLoad = false;
        if (dateLimit == null) {
            ignoreDateLimitToLoad = true;
        }
        NeptusLog.pub().info((Object)("Starting processing Waves netCDF file '" + fileName + "'." + (ignoreDateLimitToLoad ? " ignoring dateTime limit" : " Accepting data after " + dateLimit + ".")));
        HashMap<String, WavesDataPoint> wavesdp = new HashMap<String, WavesDataPoint>();
        NetcdfFile dataFile = null;
        Date fromDate = null;
        Date toDate = null;
        try {
            Attribute sstFillValueAtt;
            Attribute vFillValueAtt;
            double[] multAndOffset;
            dataFile = NetcdfFile.open((String)fileName, null);
            Variable latVar = dataFile.findVariable("lat");
            if (latVar == null) {
                NeptusLog.pub().error((Object)("Aborting. Can't find variable 'lat' for netCDF file '" + fileName + "'."));
                HashMap<String, WavesDataPoint> hashMap = wavesdp;
                return hashMap;
            }
            Variable lonVar = dataFile.findVariable("lon");
            if (lonVar == null) {
                NeptusLog.pub().error((Object)("Aborting. Can't find variable 'lon' for netCDF file '" + fileName + "'."));
                HashMap<String, WavesDataPoint> ioe = wavesdp;
                return ioe;
            }
            Variable timeVar = dataFile.findVariable("time");
            if (timeVar == null) {
                NeptusLog.pub().error((Object)("Aborting. Can't find variable 'time' for netCDF file '" + fileName + "'."));
                HashMap<String, WavesDataPoint> ioe = wavesdp;
                return ioe;
            }
            Variable hsVar = dataFile.findVariable("hs");
            if (hsVar == null) {
                NeptusLog.pub().error((Object)("Aborting. Can't find variable 'hs' for netCDF file '" + fileName + "'."));
                HashMap<String, WavesDataPoint> ioe = wavesdp;
                return ioe;
            }
            Variable tpVar = dataFile.findVariable("tp");
            if (tpVar == null) {
                NeptusLog.pub().error((Object)("Aborting. Can't find variable 'tp' for netCDF file '" + fileName + "'."));
                HashMap<String, WavesDataPoint> ioe = wavesdp;
                return ioe;
            }
            Variable pdirVar = dataFile.findVariable("pdir");
            if (pdirVar == null) {
                NeptusLog.pub().error((Object)("Aborting. Can't find variable 'pdir' for netCDF file '" + fileName + "'."));
                HashMap<String, WavesDataPoint> ioe = wavesdp;
                return ioe;
            }
            Array latArray = latVar.read();
            Array lonArray = lonVar.read();
            Array timeArray = timeVar.read();
            Array hsArray = hsVar.read();
            Array tpArray = tpVar.read();
            Array pdirArray = pdirVar.read();
            int[] shape = hsVar.getShape();
            String timeUnits = "days since 00-01-00 00:00:00";
            Attribute timeUnitsAtt = timeVar.findAttribute("units");
            if (timeUnitsAtt != null) {
                timeUnits = (String)timeUnitsAtt.getValue(0);
            }
            if ((multAndOffset = LoaderHelper.getMultiplierAndMillisOffsetFromTimeUnits(timeUnits)) == null) {
                NeptusLog.pub().error((Object)("Aborting. Can't parse units for variable 'time' (was '" + timeUnits + "') for netCDF file '" + fileName + "'."));
                HashMap<String, WavesDataPoint> hashMap = wavesdp;
                return hashMap;
            }
            double timeMultiplier = multAndOffset[0];
            double timeOffset = multAndOffset[1];
            double hsFillValue = Double.NaN;
            double tpFillValue = Double.NaN;
            double pdirFillValue = Double.NaN;
            Attribute uFillValueAtt = hsVar.findAttribute("_FillValue");
            if (uFillValueAtt != null) {
                try {
                    hsFillValue = (Double)uFillValueAtt.getValue(0);
                }
                catch (ClassCastException e) {
                    hsFillValue = Double.parseDouble((String)uFillValueAtt.getValue(0));
                }
            }
            if ((vFillValueAtt = tpVar.findAttribute("_FillValue")) != null) {
                try {
                    tpFillValue = (Double)vFillValueAtt.getValue(0);
                }
                catch (ClassCastException e) {
                    tpFillValue = Double.parseDouble((String)vFillValueAtt.getValue(0));
                }
            }
            if ((sstFillValueAtt = pdirVar.findAttribute("_FillValue")) != null) {
                try {
                    pdirFillValue = (Double)sstFillValueAtt.getValue(0);
                }
                catch (ClassCastException e) {
                    pdirFillValue = Double.parseDouble((String)sstFillValueAtt.getValue(0));
                }
            }
            Pair<Integer, Integer> latLonIndexOrder = LoaderHelper.getLatLonIndexOrder(hsVar.getDimensionsString());
            for (int timeIdx = 0; timeIdx < shape[0]; ++timeIdx) {
                double timeVal = timeArray.getDouble(timeIdx);
                Date dateValue = new Date((long)(timeVal * timeMultiplier + timeOffset));
                if (!ignoreDateLimitToLoad && dateValue.before(dateLimit)) continue;
                if (fromDate == null) {
                    fromDate = dateValue;
                } else if (dateValue.before(fromDate)) {
                    fromDate = dateValue;
                }
                if (toDate == null) {
                    toDate = dateValue;
                } else if (dateValue.after(toDate)) {
                    toDate = dateValue;
                }
                for (int latOrLonFirstIdx = 0; latOrLonFirstIdx < shape[1]; ++latOrLonFirstIdx) {
                    for (int latOrLonSecondIdx = 0; latOrLonSecondIdx < shape[2]; ++latOrLonSecondIdx) {
                        double lat = latArray.getDouble((Integer)latLonIndexOrder.first() == 1 ? latOrLonFirstIdx : latOrLonSecondIdx);
                        double lon = lonArray.getDouble((Integer)latLonIndexOrder.second() == 1 ? latOrLonFirstIdx : latOrLonSecondIdx);
                        Index3D idx3d = (Index3D)hsArray.getIndex();
                        idx3d.set(timeIdx, latOrLonFirstIdx, latOrLonSecondIdx);
                        double hs = hsArray.getDouble((Index)idx3d);
                        idx3d = (Index3D)tpArray.getIndex();
                        idx3d.set(timeIdx, latOrLonFirstIdx, latOrLonSecondIdx);
                        double tp = tpArray.getDouble((Index)idx3d);
                        idx3d = (Index3D)pdirArray.getIndex();
                        idx3d.set(timeIdx, latOrLonFirstIdx, latOrLonSecondIdx);
                        double pdir = pdirArray.getDouble((Index)idx3d);
                        if (Double.isNaN(hs) || Double.isNaN(tp) || Double.isNaN(pdir) || hs == hsFillValue || tp == tpFillValue || pdir == pdirFillValue) continue;
                        WavesDataPoint dp = new WavesDataPoint(lat, lon);
                        dp.setSignificantHeight(hs);
                        dp.setPeakPeriod(tp);
                        dp.setPeakDirection(pdir);
                        dp.setDateUTC(dateValue);
                        WavesDataPoint dpo = wavesdp.get(WavesDataPoint.getId(dp));
                        if (dpo == null) {
                            dpo = dp.getACopyWithoutHistory();
                            wavesdp.put(HFRadarDataPoint.getId(dp), dp);
                        }
                        ArrayList lst = dpo.getHistoricalData();
                        boolean alreadyIn = false;
                        for (WavesDataPoint tmpDp : lst) {
                            if (!tmpDp.getDateUTC().equals(dp.getDateUTC())) continue;
                            alreadyIn = true;
                            break;
                        }
                        if (alreadyIn) continue;
                        dpo.getHistoricalData().add(dp);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            HashMap<String, WavesDataPoint> hashMap = null;
            return hashMap;
        }
        finally {
            if (dataFile != null) {
                try {
                    dataFile.close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
            NeptusLog.pub().info((Object)("Ending processing Waves netCDF file '" + fileName + "'. Reading from date '" + fromDate + "' till '" + toDate + "'."));
        }
        return wavesdp;
    }

    private static Pair<Integer, Integer> getLatLonIndexOrder(String uDimentions) {
        Pair ret = null;
        if (uDimentions == null || uDimentions.length() == 0) {
            return ret;
        }
        String[] tk = uDimentions.split("[, \t]");
        if (tk.length < 3) {
            return ret;
        }
        int latIdx = 1;
        int lonIdx = 2;
        if ("lon".equalsIgnoreCase(tk[1].trim())) {
            latIdx = 2;
            lonIdx = 1;
        }
        ret = new Pair((Object)latIdx, (Object)lonIdx);
        return ret;
    }

    public static double[] getMultiplierAndMillisOffsetFromTimeUnits(String timeStr) {
        if ("days since 00-01-00 00:00:00".equalsIgnoreCase(timeStr) || "days since 00-01-00".equalsIgnoreCase(timeStr)) {
            return new double[]{8.64E7, -6.2167392E13};
        }
        String[] tk = timeStr.trim().split("[ ]");
        if (tk.length < 3) {
            return null;
        }
        double mult = 1.0;
        double off = 1.0;
        switch (tk[0].trim().toLowerCase().replace(".", "")) {
            case "days": 
            case "day": 
            case "d": {
                mult = 8.64E7;
                break;
            }
            case "hours": 
            case "hour": 
            case "hr": 
            case "h": {
                mult = 3600000.0;
                break;
            }
            case "minutes": 
            case "minute": 
            case "min": {
                mult = 60000.0;
                break;
            }
            case "seconds": 
            case "second": 
            case "sec": 
            case "s": {
                mult = 1000.0;
            }
        }
        String dateTkStr = tk[2];
        String timeTkStr = tk.length > 3 ? tk[3] : "0:0:0";
        String timeZoneTkStr = tk.length > 4 ? tk[4] : "";
        try {
            Date date = HFRadarVisualization.dateTimeFormaterUTC.parse(dateTkStr + " " + timeTkStr);
            off = date.getTime();
            String[] mSplitArray = timeTkStr.split("\\.");
            if (mSplitArray.length > 1) {
                String millisStr = mSplitArray[1];
                int millisSize = millisStr.length();
                switch (millisSize) {
                    case 1: {
                        off += (double)(Integer.parseInt(millisStr) * 100);
                        break;
                    }
                    case 2: {
                        off += (double)(Integer.parseInt(millisStr) * 10);
                        break;
                    }
                    case 3: {
                        off += (double)Integer.parseInt(millisStr);
                        break;
                    }
                    default: {
                        off += (double)Integer.parseInt(millisStr.substring(0, 3));
                    }
                }
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        try {
            if (!timeZoneTkStr.isEmpty()) {
                String[] tzStrs = timeZoneTkStr.split(":");
                if (tzStrs.length > 1) {
                    int hrTzNb = Integer.parseInt(tzStrs[0]);
                    off -= (double)((long)hrTzNb * 3600000L);
                    off -= (double)((float)Integer.parseInt(tzStrs[1]) * Math.signum(hrTzNb) * 60000.0f);
                } else {
                    String tzSt = timeZoneTkStr.replace(":", "");
                    int tzNb = Integer.parseInt(tzSt);
                    if (Math.abs(tzNb) < 100) {
                        off -= (double)((long)tzNb * 3600000L);
                    } else {
                        int hrTzNb = tzNb / 100;
                        off -= (double)((long)hrTzNb * 3600000L);
                        int minTzNb = tzNb - hrTzNb * 100;
                        off -= (double)((long)minTzNb * 60000L);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new double[]{mult, off};
    }

    private static double getMultiplierForCmPerSecondsFromSpeedUnits(String speedUnits) {
        double mult = 1.0;
        switch (speedUnits.trim().toLowerCase()) {
            case "cm/s": 
            case "cm s-1": 
            case "cm s^-1": 
            case "cm.s^-1": {
                mult = 1.0;
                break;
            }
            case "m/s": 
            case "m s-1": 
            case "m s^-1": 
            case "m.s^-1": {
                mult = 100.0;
                break;
            }
            case "ft/s": 
            case "ft s-1": 
            case "ft s^-1": 
            case "ft.s^-1": {
                mult = 30.48;
            }
        }
        return mult;
    }

    private static double getValueForDegreesCelciusFromTempUnits(double value, String units) {
        double ret = value;
        switch (units.trim()) {
            case "K": {
                ret = value + -272.15;
                break;
            }
            case "\u00b0F": 
            case "\u00baF": {
                ret = (value - 32.0) / 1.8;
            }
        }
        return ret;
    }

    public static void main(String[] args) throws Exception {
        String str = "    -7.3280918  36.4298738  -24.540   15.514          0      15.440       2.180     -25.700     10.5000    -48.0000   49.1357   167.7     29.033     302.3      1   1";
        String[] tokens = str.trim().split("[\\t ,]+");
        System.out.println(tokens.length);
        try {
            double[] val = LoaderHelper.getMultiplierAndMillisOffsetFromTimeUnits("days since 00-01-00 00:00:00");
            System.out.println(val[0] + "    " + val[1]);
            val = LoaderHelper.getMultiplierAndMillisOffsetFromTimeUnits("seconds since 2013-07-04 00:00:00");
            System.out.println(val[0] + "    " + val[1]);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        try {
            Pattern timeStringPattern = Pattern.compile("^(\\w+?)\\ssince\\s(\\w+?)");
            String timeUnits = "days since 00-01-00 00:00:00";
            Matcher matcher = timeStringPattern.matcher(timeUnits);
            System.out.println(matcher.group(1));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            Date date = HFRadarVisualization.dateTimeFormaterUTC.parse("0001-01-01 00:00:00");
            System.out.println(date.getTime());
            Date ndate = new Date(date.getTime() + 62167392000000L);
            System.out.println(ndate + "           " + ndate.getTime());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("------ Test time load -----");
        String dateT1Str = "2013-07-04 00:00:00";
        Date dateT1 = HFRadarVisualization.dateTimeFormaterUTC.parse(dateT1Str);
        System.out.printf("%22s  ==  %s \t%s\n", dateT1Str, dateT1, dateT1.getTime());
        dateT1Str = "2013-7-4 0:0:0";
        dateT1 = HFRadarVisualization.dateTimeFormaterUTC.parse(dateT1Str);
        System.out.printf("%22s  ==  %s \t%s\n", dateT1Str, dateT1, dateT1.getTime());
        dateT1Str = "2013-7-4 13:3:4.32";
        dateT1 = HFRadarVisualization.dateTimeFormaterUTC.parse(dateT1Str);
        System.out.printf("%22s  ==  %s \t%s\n", dateT1Str, dateT1, dateT1.getTime());
        dateT1Str = "2013-7-4 13:3:4";
        dateT1 = HFRadarVisualization.dateTimeFormaterUTC.parse(dateT1Str);
        System.out.printf("%22s  ==  %s \t%s\n", dateT1Str, dateT1, dateT1.getTime());
        String dateT2Str = "2013-7-4 13:3:4.32";
        System.out.println(Arrays.toString(dateT2Str.split("\\.")));
        dateT2Str = "2013-7-4 13:3:4";
        System.out.println(Arrays.toString(dateT2Str.split("\\.")));
        dateT2Str = "2013-7-4 13:3:4.";
        System.out.println(Arrays.toString(dateT2Str.split("\\.")));
        dateT2Str = "2013-7-4 13:3:4.262626";
        System.out.println(Arrays.toString(dateT2Str.split("\\.")));
        String dateT3Str = "seconds since 2013-7-4 13:3:4.32";
        double[] multPlusOffset = LoaderHelper.getMultiplierAndMillisOffsetFromTimeUnits(dateT3Str);
        Date dateT3 = new Date((long)(0.0 * multPlusOffset[0] + multPlusOffset[1]));
        System.out.printf("%37s == %22s \t mult=%f off=%f\n", dateT3Str, dateT3, multPlusOffset[0], multPlusOffset[1]);
        System.out.println("\nEvery resulting date should result in the same values!");
        dateT3Str = "seconds since 2013-7-4 13:3:4";
        multPlusOffset = LoaderHelper.getMultiplierAndMillisOffsetFromTimeUnits(dateT3Str);
        dateT3 = new Date((long)(0.0 * multPlusOffset[0] + multPlusOffset[1]));
        System.out.printf("%37s == %22s \t mult=%f off=%f\n", dateT3Str, dateT3, multPlusOffset[0], multPlusOffset[1]);
        dateT3Str = "seconds since 2013-7-4 14:3:4 +1:0";
        multPlusOffset = LoaderHelper.getMultiplierAndMillisOffsetFromTimeUnits(dateT3Str);
        dateT3 = new Date((long)(0.0 * multPlusOffset[0] + multPlusOffset[1]));
        System.out.printf("%37s == %22s \t mult=%f off=%f\n", dateT3Str, dateT3, multPlusOffset[0], multPlusOffset[1]);
        dateT3Str = "seconds since 2013-7-4 14:3:4 1";
        multPlusOffset = LoaderHelper.getMultiplierAndMillisOffsetFromTimeUnits(dateT3Str);
        dateT3 = new Date((long)(0.0 * multPlusOffset[0] + multPlusOffset[1]));
        System.out.printf("%37s == %22s \t mult=%f off=%f\n", dateT3Str, dateT3, multPlusOffset[0], multPlusOffset[1]);
        dateT3Str = "seconds since 2013-7-4 14:3:4 100";
        multPlusOffset = LoaderHelper.getMultiplierAndMillisOffsetFromTimeUnits(dateT3Str);
        dateT3 = new Date((long)(0.0 * multPlusOffset[0] + multPlusOffset[1]));
        System.out.printf("%37s == %22s \t mult=%f off=%f\n", dateT3Str, dateT3, multPlusOffset[0], multPlusOffset[1]);
        dateT3Str = "seconds since 2013-7-4 12:3:4 -100";
        multPlusOffset = LoaderHelper.getMultiplierAndMillisOffsetFromTimeUnits(dateT3Str);
        dateT3 = new Date((long)(0.0 * multPlusOffset[0] + multPlusOffset[1]));
        System.out.printf("%37s == %22s \t mult=%f off=%f\n", dateT3Str, dateT3, multPlusOffset[0], multPlusOffset[1]);
        dateT3Str = "seconds since 2013-7-4 11:33:4 -130";
        multPlusOffset = LoaderHelper.getMultiplierAndMillisOffsetFromTimeUnits(dateT3Str);
        dateT3 = new Date((long)(0.0 * multPlusOffset[0] + multPlusOffset[1]));
        System.out.printf("%37s == %22s \t mult=%f off=%f\n", dateT3Str, dateT3, multPlusOffset[0], multPlusOffset[1]);
        dateT3Str = "seconds since 2013-7-4 11:33:4 -1:30";
        multPlusOffset = LoaderHelper.getMultiplierAndMillisOffsetFromTimeUnits(dateT3Str);
        dateT3 = new Date((long)(0.0 * multPlusOffset[0] + multPlusOffset[1]));
        System.out.printf("%37s == %22s \t mult=%f off=%f\n", dateT3Str, dateT3, multPlusOffset[0], multPlusOffset[1]);
        dateT3Str = "seconds since 2013-7-4 14:33:4 +130";
        multPlusOffset = LoaderHelper.getMultiplierAndMillisOffsetFromTimeUnits(dateT3Str);
        dateT3 = new Date((long)(0.0 * multPlusOffset[0] + multPlusOffset[1]));
        System.out.printf("%37s == %22s \t mult=%f off=%f\n", dateT3Str, dateT3, multPlusOffset[0], multPlusOffset[1]);
        dateT3Str = "seconds since 2013-7-4 14:33:04 +1:30";
        multPlusOffset = LoaderHelper.getMultiplierAndMillisOffsetFromTimeUnits(dateT3Str);
        dateT3 = new Date((long)(0.0 * multPlusOffset[0] + multPlusOffset[1]));
        System.out.printf("%37s == %22s \t mult=%f off=%f\n", dateT3Str, dateT3, multPlusOffset[0], multPlusOffset[1]);
    }
}

