/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.envdisp;

import java.util.Date;
import pt.lsts.neptus.plugins.envdisp.BaseDataPoint;

public class SSTDataPoint
extends BaseDataPoint<SSTDataPoint> {
    public static final double KELVIN_TO_CELSIUS = -272.15;
    private double sst = 0.0;

    public SSTDataPoint(double lat, double lon) {
        super(lat, lon);
    }

    public double getSst() {
        return this.sst;
    }

    public void setSst(double sst) {
        this.sst = sst;
    }

    @Override
    public SSTDataPoint getACopyWithoutHistory() {
        SSTDataPoint copy = new SSTDataPoint(this.getLat(), this.getLon());
        copy.setSst(this.getSst());
        return copy;
    }

    public SSTDataPoint copyToWithoutHistory(SSTDataPoint copy) {
        copy.setDateUTC(this.getDateUTC());
        copy.setSst(this.getSst());
        return copy;
    }

    @Override
    public String toString() {
        return super.toString() + "\tSST:\t" + this.sst;
    }

    public boolean useMostRecent(Date currentDate) {
        if (this.historicalData.size() == 0) {
            return false;
        }
        Date mostRecentDate = null;
        double mRecentSST = 0.0;
        int size = this.historicalData.size();
        for (SSTDataPoint dp : this.historicalData) {
            if (currentDate.before(dp.dateUTC)) {
                --size;
                continue;
            }
            if (dp.dateUTC.after(currentDate) || mostRecentDate != null && !dp.dateUTC.after(mostRecentDate)) {
                --size;
                continue;
            }
            mostRecentDate = dp.dateUTC;
            mRecentSST = dp.sst;
        }
        if (size < 1) {
            this.setSst(Double.NaN);
            this.setDateUTC(new Date(0L));
            return false;
        }
        this.setSst(mRecentSST);
        this.setDateUTC(mostRecentDate);
        return true;
    }
}

