/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.envdisp;

import java.util.Date;
import pt.lsts.neptus.plugins.envdisp.BaseDataPoint;

public class WavesDataPoint
extends BaseDataPoint<WavesDataPoint> {
    private double significantHeight = 0.0;
    private double peakPeriod = 0.0;
    private double peakDirection = 0.0;

    public WavesDataPoint(double lat, double lon) {
        super(lat, lon);
    }

    public double getSignificantHeight() {
        return this.significantHeight;
    }

    public void setSignificantHeight(double significantHeight) {
        this.significantHeight = significantHeight;
    }

    public double getPeakPeriod() {
        return this.peakPeriod;
    }

    public void setPeakPeriod(double peakPeriod) {
        this.peakPeriod = peakPeriod;
    }

    public double getPeakDirection() {
        return this.peakDirection;
    }

    public void setPeakDirection(double peakDirection) {
        this.peakDirection = peakDirection;
    }

    @Override
    public WavesDataPoint getACopyWithoutHistory() {
        WavesDataPoint copy = new WavesDataPoint(this.getLat(), this.getLon());
        copy.setSignificantHeight(this.significantHeight);
        copy.setPeakPeriod(this.peakPeriod);
        copy.setPeakDirection(this.peakDirection);
        return copy;
    }

    public WavesDataPoint copyToWithoutHistory(WavesDataPoint copy) {
        copy.setDateUTC(this.getDateUTC());
        copy.setSignificantHeight(this.significantHeight);
        copy.setPeakPeriod(this.peakPeriod);
        copy.setPeakDirection(this.peakDirection);
        return copy;
    }

    @Override
    public String toString() {
        return super.toString() + "\tsignificantHeight:\t" + this.significantHeight + "\tpeakPeriod:\t" + this.peakPeriod + "\tpeakDirection:\t" + this.peakDirection;
    }

    public boolean useMostRecent(Date currentDate) {
        if (this.historicalData.size() == 0) {
            return false;
        }
        Date mostRecentDate = null;
        double mRecentSh = 0.0;
        double mRecentPp = 0.0;
        double mRecentPd = 0.0;
        int size = this.historicalData.size();
        for (WavesDataPoint dp : this.historicalData) {
            if (currentDate.before(dp.dateUTC)) {
                --size;
                continue;
            }
            if (dp.dateUTC.after(currentDate) || mostRecentDate != null && !dp.dateUTC.after(mostRecentDate)) {
                --size;
                continue;
            }
            mostRecentDate = dp.dateUTC;
            mRecentSh = dp.significantHeight;
            mRecentPp = dp.peakPeriod;
            mRecentPd = dp.peakDirection;
        }
        if (size < 1) {
            this.setSignificantHeight(Double.NaN);
            this.setPeakPeriod(Double.NaN);
            this.setPeakDirection(Double.NaN);
            this.setDateUTC(new Date(0L));
            return false;
        }
        this.setSignificantHeight(mRecentSh);
        this.setPeakPeriod(mRecentPp);
        this.setPeakDirection(mRecentPd);
        this.setDateUTC(mostRecentDate);
        return true;
    }
}

