/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.envdisp;

import java.util.Date;
import pt.lsts.neptus.plugins.envdisp.BaseDataPoint;

public class WindDataPoint
extends BaseDataPoint<WindDataPoint> {
    private double u = 0.0;
    private double v = 0.0;

    public WindDataPoint(double lat, double lon) {
        super(lat, lon);
    }

    public double getU() {
        return this.u;
    }

    public void setU(double u) {
        this.u = u;
    }

    public double getV() {
        return this.v;
    }

    public void setV(double v) {
        this.v = v;
    }

    @Override
    public WindDataPoint getACopyWithoutHistory() {
        WindDataPoint copy = new WindDataPoint(this.getLat(), this.getLon());
        copy.setU(this.getU());
        copy.setV(this.getV());
        return copy;
    }

    public WindDataPoint copyToWithoutHistory(WindDataPoint copy) {
        copy.setDateUTC(this.getDateUTC());
        copy.setU(this.getU());
        copy.setV(this.getV());
        return copy;
    }

    @Override
    public String toString() {
        return super.toString() + "\tu:\t" + this.u + "\tv:\t" + this.v;
    }

    public double getSpeed() {
        double speed = Math.sqrt(this.u * this.u + this.v * this.v);
        return speed;
    }

    public double getHeading() {
        double heading = Math.atan2(this.v, this.u);
        return Math.toDegrees(heading);
    }

    public boolean useMostRecent(Date currentDate) {
        if (this.historicalData.size() == 0) {
            return false;
        }
        Date mostRecentDate = null;
        double mRecentU = 0.0;
        double mRecentV = 0.0;
        int size = this.historicalData.size();
        for (WindDataPoint dp : this.historicalData) {
            if (currentDate.before(dp.dateUTC)) {
                --size;
                continue;
            }
            if (dp.dateUTC.after(currentDate) || mostRecentDate != null && !dp.dateUTC.after(mostRecentDate)) {
                --size;
                continue;
            }
            mostRecentDate = dp.dateUTC;
            mRecentU = dp.u;
            mRecentV = dp.v;
        }
        if (size < 1) {
            this.setU(Double.NaN);
            this.setV(Double.NaN);
            this.setDateUTC(new Date(0L));
            return false;
        }
        this.setU(mRecentU);
        this.setV(mRecentV);
        this.setDateUTC(mostRecentDate);
        return true;
    }
}

