/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.nodes.loader;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import org.ietf.uri.ResourceConnection;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.nodes.loader.ContentLoadQueue;

abstract class AbstractContentLoader
implements Runnable {
    protected ContentLoadQueue pendingList;
    protected Map inProgress;
    protected boolean terminateCurrent;
    protected boolean processNext;
    protected ResourceConnection currentConnection;
    protected ErrorReporter errorReporter;

    AbstractContentLoader(ThreadGroup threadGroup, ContentLoadQueue contentLoadQueue, Map map) {
        this.pendingList = contentLoadQueue;
        this.inProgress = map;
        this.terminateCurrent = false;
        this.processNext = true;
        this.errorReporter = DefaultErrorReporter.getDefaultReporter();
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (errorReporter == null && !this.terminateCurrent && this.processNext) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
    }

    void abortCurrentFile() {
        this.terminateCurrent = true;
        if (this.currentConnection != null) {
            this.currentConnection.close();
        }
    }

    void shutdown() {
        this.terminateCurrent = true;
        this.processNext = false;
        this.pendingList.purge();
        if (this.currentConnection != null) {
            this.currentConnection.close();
        }
    }

    protected boolean makeConnection() {
        boolean bl = true;
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    AbstractContentLoader.this.currentConnection.connect();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            bl = false;
            Exception exception = privilegedActionException.getException();
            if (exception instanceof FileNotFoundException) {
                String string = "File not found: " + this.currentConnection.getURI();
                this.errorReporter.warningReport(string, null);
            }
            String string = "IO Error reading external file " + this.currentConnection.getURI();
            this.errorReporter.warningReport(string, privilegedActionException.getException());
        }
        return bl;
    }
}

