/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.nodes.loader;

import java.util.ArrayList;
import java.util.Map;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.lang.BasicScene;
import org.web3d.vrml.lang.VRMLNode;
import org.web3d.vrml.nodes.VRMLExternProtoDeclare;
import org.web3d.vrml.nodes.VRMLExternalNodeType;
import org.web3d.vrml.nodes.VRMLMultiExternalNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLScriptNodeType;
import org.web3d.vrml.nodes.VRMLSingleExternalNodeType;
import org.web3d.vrml.nodes.VRMLUrlListener;
import org.web3d.vrml.nodes.loader.ContentLoadQueue;
import org.web3d.vrml.nodes.loader.ExternalLoadManager;
import org.web3d.vrml.nodes.loader.FileCache;
import org.web3d.vrml.nodes.loader.LoadConstants;
import org.web3d.vrml.nodes.loader.LoadDetails;
import org.web3d.vrml.nodes.loader.LoadRequest;
import org.web3d.vrml.nodes.loader.LoaderThreadPool;
import org.web3d.vrml.util.NodeArray;

public abstract class AbstractLoadManager
implements ExternalLoadManager,
LoadConstants,
VRMLUrlListener {
    private LoaderThreadPool loaderPool = LoaderThreadPool.getLoaderThreadPool();
    private ContentLoadQueue pending = this.loaderPool.getWaitingList();
    private Map inProgress = this.loaderPool.getProgressMap();

    protected AbstractLoadManager() {
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.loaderPool.setErrorReporter(errorReporter);
    }

    public synchronized void queueExternProtoLoad(VRMLExternProtoDeclare vRMLExternProtoDeclare) {
        if (vRMLExternProtoDeclare == null) {
            return;
        }
        this.ayeShesDeadCapn();
        FileCache fileCache = this.getCache();
        LoadDetails loadDetails = new LoadDetails();
        loadDetails.fieldIndex = -1;
        loadDetails.node = vRMLExternProtoDeclare;
        String[] stringArray = vRMLExternProtoDeclare.getUrl();
        LoadRequest loadRequest = (LoadRequest)this.inProgress.get(stringArray);
        if (loadRequest != null) {
            if (!loadRequest.loadList.contains(loadDetails)) {
                loadRequest.loadList.add(loadDetails);
            }
        } else {
            this.pending.add(stringArray, fileCache, loadDetails);
        }
    }

    public void queueSceneLoad(BasicScene basicScene) {
        Object object;
        int n;
        Object object2;
        Object object3;
        LoadDetails loadDetails;
        if (basicScene == null) {
            return;
        }
        this.ayeShesDeadCapn();
        FileCache fileCache = this.getCache();
        ArrayList arrayList = basicScene.getNodeTemplates();
        int n2 = arrayList.size();
        for (int i = 0; i < n2; ++i) {
            Object e = arrayList.get(i);
            if (!(e instanceof VRMLExternalNodeType)) continue;
            loadDetails = new LoadDetails();
            loadDetails.fieldIndex = -1;
            loadDetails.node = (VRMLExternalNodeType)e;
            object3 = ((VRMLSingleExternalNodeType)e).getUrl();
            object2 = (LoadRequest)this.inProgress.get(object3);
            if (object2 != null) {
                if (object2.loadList.contains(loadDetails)) continue;
                object2.loadList.add(loadDetails);
                continue;
            }
            this.pending.add((String[])object3, fileCache, loadDetails);
        }
        ArrayList arrayList2 = basicScene.getBySecondaryType(44);
        n2 = arrayList2.size();
        for (n = 0; n < n2; ++n) {
            object3 = arrayList2.get(n);
            if (object3 instanceof VRMLScriptNodeType) continue;
            loadDetails = new LoadDetails();
            loadDetails.fieldIndex = -1;
            loadDetails.node = (VRMLExternalNodeType)object3;
            object2 = ((VRMLSingleExternalNodeType)object3).getUrl();
            object = (LoadRequest)this.inProgress.get(object2);
            if (object != null) {
                if (!object.loadList.contains(loadDetails)) {
                    object.loadList.add(loadDetails);
                }
            } else {
                this.pending.add((String[])object2, fileCache, loadDetails);
            }
            ((VRMLExternalNodeType)object3).addUrlListener(this);
        }
        arrayList2 = basicScene.getBySecondaryType(30);
        n2 = arrayList2.size();
        for (n = 0; n < n2; ++n) {
            object2 = (VRMLMultiExternalNodeType)arrayList2.get(n);
            object = object2.getUrlFieldIndexes();
            for (int i = 0; i < ((int[])object).length; ++i) {
                loadDetails = new LoadDetails();
                loadDetails.fieldIndex = object[i];
                loadDetails.node = object2;
                String[] stringArray = object2.getUrl(object[i]);
                LoadRequest loadRequest = (LoadRequest)this.inProgress.get(stringArray);
                if (loadRequest != null) {
                    if (loadRequest.loadList.contains(loadDetails)) continue;
                    loadRequest.loadList.add(loadDetails);
                    continue;
                }
                this.pending.add(stringArray, fileCache, loadDetails);
            }
            object2.addUrlListener(this);
        }
    }

    public void queueNodesLoad(NodeArray nodeArray) {
        int n = nodeArray.size();
        if (n == 0) {
            return;
        }
        FileCache fileCache = this.getCache();
        this.ayeShesDeadCapn();
        for (int i = 0; i < n; ++i) {
            Object[] objectArray;
            LoadDetails loadDetails;
            VRMLExternalNodeType vRMLExternalNodeType;
            VRMLNode vRMLNode = nodeArray.get(i);
            if (vRMLNode instanceof VRMLScriptNodeType) continue;
            if (vRMLNode instanceof VRMLSingleExternalNodeType) {
                vRMLExternalNodeType = (VRMLSingleExternalNodeType)((Object)vRMLNode);
                loadDetails = new LoadDetails();
                loadDetails.fieldIndex = -1;
                loadDetails.node = vRMLExternalNodeType;
                objectArray = vRMLExternalNodeType.getUrl();
                LoadRequest loadRequest = (LoadRequest)this.inProgress.get(objectArray);
                if (loadRequest != null) {
                    if (!loadRequest.loadList.contains(loadDetails)) {
                        loadRequest.loadList.add(loadDetails);
                    }
                } else {
                    this.pending.add((String[])objectArray, fileCache, loadDetails);
                }
                vRMLExternalNodeType.addUrlListener(this);
                continue;
            }
            if (!(vRMLNode instanceof VRMLMultiExternalNodeType)) continue;
            vRMLExternalNodeType = (VRMLMultiExternalNodeType)((Object)nodeArray.get(i));
            objectArray = vRMLExternalNodeType.getUrlFieldIndexes();
            for (int j = 0; j < objectArray.length; ++j) {
                loadDetails = new LoadDetails();
                loadDetails.fieldIndex = objectArray[j];
                loadDetails.node = vRMLExternalNodeType;
                String[] stringArray = vRMLExternalNodeType.getUrl(objectArray[j]);
                LoadRequest loadRequest = (LoadRequest)this.inProgress.get(stringArray);
                if (loadRequest != null) {
                    if (loadRequest.loadList.contains(loadDetails)) continue;
                    loadRequest.loadList.add(loadDetails);
                    continue;
                }
                this.pending.add(stringArray, fileCache, loadDetails);
            }
            vRMLExternalNodeType.addUrlListener(this);
        }
    }

    public void stopSceneLoad(BasicScene basicScene) {
        Object object;
        Object object2;
        VRMLExternalNodeType vRMLExternalNodeType;
        Object e;
        int n;
        if (basicScene == null) {
            return;
        }
        ArrayList arrayList = basicScene.getBySecondaryType(44);
        int n2 = arrayList.size();
        if (n2 == 0) {
            return;
        }
        for (n = 0; n < n2; ++n) {
            e = arrayList.get(n);
            vRMLExternalNodeType = (VRMLSingleExternalNodeType)e;
            object2 = new LoadDetails();
            ((LoadDetails)object2).fieldIndex = -1;
            ((LoadDetails)object2).node = vRMLExternalNodeType;
            String[] stringArray = vRMLExternalNodeType.getUrl();
            if (this.inProgress.containsKey(stringArray)) {
                object = (LoadRequest)this.inProgress.get(stringArray);
                ((LoadRequest)object).loadList.remove(object2);
                continue;
            }
            this.pending.remove(stringArray, (LoadDetails)object2);
        }
        arrayList = basicScene.getBySecondaryType(30);
        n2 = arrayList.size();
        if (n2 == 0) {
            return;
        }
        for (n = 0; n < n2; ++n) {
            e = arrayList.get(n);
            vRMLExternalNodeType = (VRMLMultiExternalNodeType)e;
            object2 = vRMLExternalNodeType.getUrlFieldIndexes();
            for (int i = 0; i < ((Object)object2).length; ++i) {
                object = new LoadDetails();
                ((LoadDetails)object).fieldIndex = (int)object2[i];
                ((LoadDetails)object).node = vRMLExternalNodeType;
                String[] stringArray = vRMLExternalNodeType.getUrl((int)object2[i]);
                if (this.inProgress.containsKey(stringArray)) {
                    LoadRequest loadRequest = (LoadRequest)this.inProgress.get(stringArray);
                    loadRequest.loadList.remove(object);
                    continue;
                }
                this.pending.remove(stringArray, (LoadDetails)object);
            }
        }
    }

    public void clear() {
        this.pending.clear();
        this.loaderPool.clear();
    }

    public void urlChanged(VRMLNodeType vRMLNodeType, int n) {
        FileCache fileCache = this.getCache();
        LoadDetails loadDetails = new LoadDetails();
        String[] stringArray = null;
        if (vRMLNodeType instanceof VRMLSingleExternalNodeType) {
            VRMLSingleExternalNodeType vRMLSingleExternalNodeType = (VRMLSingleExternalNodeType)((Object)vRMLNodeType);
            stringArray = vRMLSingleExternalNodeType.getUrl();
            if (stringArray == null || stringArray.length == 0) {
                return;
            }
            vRMLSingleExternalNodeType.setLoadState(1);
            loadDetails.fieldIndex = -1;
            loadDetails.node = vRMLSingleExternalNodeType;
            this.pending.add(stringArray, fileCache, loadDetails);
        } else {
            VRMLMultiExternalNodeType vRMLMultiExternalNodeType = (VRMLMultiExternalNodeType)((Object)vRMLNodeType);
            stringArray = vRMLMultiExternalNodeType.getUrl(n);
            if (stringArray == null || stringArray.length == 0) {
                return;
            }
            vRMLMultiExternalNodeType.setLoadState(n, 1);
            loadDetails.fieldIndex = n;
            loadDetails.node = vRMLMultiExternalNodeType;
            this.pending.add(stringArray, fileCache, loadDetails);
        }
    }

    public int getNumberInProgress() {
        return this.pending.size();
    }

    public void shutdown() {
        this.loaderPool.shutdown();
    }

    protected abstract FileCache getCache();

    private void ayeShesDeadCapn() {
        this.loaderPool.restartThreads();
    }
}

