/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.nodes.loader;

import java.util.HashMap;
import org.web3d.util.Queue;
import org.web3d.vrml.nodes.loader.FileCache;
import org.web3d.vrml.nodes.loader.LoadDetails;
import org.web3d.vrml.nodes.loader.LoadRequest;

public class ContentLoadQueue {
    private boolean purging = false;
    private Queue loadQueue = new Queue();
    private HashMap urlToRequestMap = new HashMap();

    ContentLoadQueue() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void add(String[] stringArray, FileCache fileCache, LoadDetails loadDetails) {
        HashMap hashMap = this.urlToRequestMap;
        synchronized (hashMap) {
            LoadRequest loadRequest = (LoadRequest)this.urlToRequestMap.get(stringArray);
            if (loadRequest == null) {
                loadRequest = new LoadRequest();
                loadRequest.url = stringArray;
                loadRequest.cache = fileCache;
                loadRequest.loadList.add(loadDetails);
                this.loadQueue.add(loadRequest);
                this.urlToRequestMap.put(stringArray, loadRequest);
            } else if (!loadRequest.loadList.contains(loadDetails)) {
                loadRequest.loadList.add(loadDetails);
            }
        }
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoadRequest getNext() {
        LoadRequest loadRequest = null;
        while (!this.purging && loadRequest == null) {
            Object object;
            while (!this.purging && !this.loadQueue.hasNext()) {
                try {
                    object = this;
                    synchronized (object) {
                        this.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
            object = this.urlToRequestMap;
            synchronized (object) {
                if (this.loadQueue.hasNext()) {
                    loadRequest = (LoadRequest)this.loadQueue.getNext();
                    this.urlToRequestMap.remove(loadRequest.url);
                }
            }
        }
        return loadRequest;
    }

    public synchronized int size() {
        return this.loadQueue.size();
    }

    public synchronized void purge() {
        this.loadQueue.clear();
        this.urlToRequestMap.clear();
        this.purging = true;
        this.notifyAll();
    }

    public synchronized void clear() {
        this.loadQueue.clear();
        this.urlToRequestMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String[] stringArray, LoadDetails loadDetails) {
        HashMap hashMap = this.urlToRequestMap;
        synchronized (hashMap) {
            LoadRequest loadRequest = (LoadRequest)this.urlToRequestMap.get(stringArray);
            if (loadRequest == null || !loadRequest.loadList.contains(loadDetails)) {
                return;
            }
            if (loadRequest.loadList.size() == 1) {
                this.loadQueue.remove(loadRequest);
                this.urlToRequestMap.remove(stringArray);
            } else {
                loadRequest.loadList.remove(loadDetails);
            }
        }
    }
}

