/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.nodes.loader;

import java.io.IOException;
import java.util.Map;
import java.util.Vector;
import org.ietf.uri.URI;
import org.ietf.uri.URIUtils;
import org.ietf.uri.URL;
import org.web3d.vrml.lang.BasicScene;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.nodes.VRMLMultiExternalNodeType;
import org.web3d.vrml.nodes.VRMLSingleExternalNodeType;
import org.web3d.vrml.nodes.loader.AbstractContentLoader;
import org.web3d.vrml.nodes.loader.CacheDetails;
import org.web3d.vrml.nodes.loader.ContentLoadQueue;
import org.web3d.vrml.nodes.loader.FileCache;
import org.web3d.vrml.nodes.loader.LoadDetails;
import org.web3d.vrml.nodes.loader.LoadRequest;

class ContentLoader
extends AbstractContentLoader {
    private static final String UNKNOWN_ERROR_MSG = "Unknown error in content loading process";
    private static final String CONTENT_ERROR_MSG = "Error setting external content:";
    private static final String INVALID_FIELD_MSG = "Internal error caused by attempting to send content to an invalid field index: ";
    private static final String NO_URLS_MSG = "Cannot resolve any URLS for URL: ";
    private Thread th;

    ContentLoader(ThreadGroup threadGroup, ContentLoadQueue contentLoadQueue, Map map) {
        super(threadGroup, contentLoadQueue, map);
        this.th = new Thread(threadGroup, this);
        this.th.start();
    }

    public void run() {
        while (this.processNext) {
            Object object;
            String[] stringArray;
            block19: {
                try {
                    VRMLMultiExternalNodeType vRMLMultiExternalNodeType;
                    VRMLSingleExternalNodeType vRMLSingleExternalNodeType;
                    int n;
                    LoadDetails loadDetails;
                    int n2;
                    LoadRequest loadRequest = this.pendingList.getNext();
                    if (loadRequest == null || loadRequest.loadList.size() == 0) {
                        if (!this.processNext) break;
                        continue;
                    }
                    boolean bl = false;
                    for (n2 = 0; n2 < loadRequest.loadList.size(); ++n2) {
                        loadDetails = (LoadDetails)loadRequest.loadList.get(n2);
                        n = 0;
                        if (loadDetails.fieldIndex == -1) {
                            vRMLSingleExternalNodeType = (VRMLSingleExternalNodeType)loadDetails.node;
                            n = vRMLSingleExternalNodeType.getLoadState();
                        } else {
                            vRMLMultiExternalNodeType = (VRMLMultiExternalNodeType)loadDetails.node;
                            vRMLMultiExternalNodeType.getLoadState(loadDetails.fieldIndex);
                        }
                        bl = n != 3;
                    }
                    if (!bl || !this.processNext) continue;
                    stringArray = loadRequest.url;
                    boolean bl2 = false;
                    this.terminateCurrent = false;
                    this.inProgress.put(loadRequest.url, loadRequest);
                    for (n2 = 0; n2 < loadRequest.loadList.size() && !bl; ++n2) {
                        loadDetails = (LoadDetails)loadRequest.loadList.get(n2);
                        if (loadDetails.fieldIndex == -1) {
                            vRMLSingleExternalNodeType = (VRMLSingleExternalNodeType)loadDetails.node;
                            vRMLSingleExternalNodeType.setLoadState(2);
                            continue;
                        }
                        vRMLMultiExternalNodeType = (VRMLMultiExternalNodeType)loadDetails.node;
                        vRMLMultiExternalNodeType.setLoadState(loadDetails.fieldIndex, 2);
                    }
                    if (this.terminateCurrent) {
                        this.inProgress.remove(loadRequest.url);
                        continue;
                    }
                    n2 = stringArray == null ? 0 : stringArray.length;
                    for (n = 0; !bl2 && n < n2; ++n) {
                        CacheDetails cacheDetails;
                        String string = stringArray[n];
                        int n3 = string.lastIndexOf(35);
                        if (n3 != -1) {
                            string = string.substring(0, n3);
                        }
                        if ((cacheDetails = loadRequest.cache.checkForFile(string)) != null) {
                            String string2 = cacheDetails.getContentType();
                            object = cacheDetails.getContent();
                            bl2 = true;
                            for (int i = 0; i < loadRequest.loadList.size(); ++i) {
                                loadDetails = (LoadDetails)loadRequest.loadList.get(i);
                                if (loadDetails.fieldIndex == -1) {
                                    vRMLSingleExternalNodeType = (VRMLSingleExternalNodeType)loadDetails.node;
                                    if (!vRMLSingleExternalNodeType.checkValidContentType(string2)) continue;
                                    vRMLSingleExternalNodeType.setLoadedURI(stringArray[n]);
                                    vRMLSingleExternalNodeType.setContent(string2, object);
                                    vRMLSingleExternalNodeType.setLoadState(3);
                                    continue;
                                }
                                vRMLMultiExternalNodeType = (VRMLMultiExternalNodeType)loadDetails.node;
                                if (!vRMLMultiExternalNodeType.checkValidContentType(loadDetails.fieldIndex, string2)) continue;
                                vRMLMultiExternalNodeType.setLoadedURI(loadDetails.fieldIndex, stringArray[n]);
                                vRMLMultiExternalNodeType.setContent(loadDetails.fieldIndex, string2, object);
                                vRMLMultiExternalNodeType.setLoadState(loadDetails.fieldIndex, 3);
                            }
                            continue;
                        }
                        bl2 = this.loadExternal(stringArray[n], string, loadRequest.cache, loadRequest.loadList);
                    }
                    this.inProgress.remove(loadRequest.url);
                    if (bl2) break block19;
                    for (n = 0; n < loadRequest.loadList.size(); ++n) {
                        loadDetails = (LoadDetails)loadRequest.loadList.get(n);
                        if (loadDetails.fieldIndex == -1) {
                            vRMLSingleExternalNodeType = (VRMLSingleExternalNodeType)loadDetails.node;
                            vRMLSingleExternalNodeType.setLoadState(4);
                            continue;
                        }
                        vRMLMultiExternalNodeType = (VRMLMultiExternalNodeType)loadDetails.node;
                        vRMLMultiExternalNodeType.setLoadState(loadDetails.fieldIndex, 4);
                    }
                    if (stringArray.length <= 0) break block19;
                    this.errorReporter.warningReport(NO_URLS_MSG + stringArray[0], null);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.errorReporter.errorReport(CONTENT_ERROR_MSG, illegalArgumentException);
                    continue;
                }
                catch (InvalidFieldException invalidFieldException) {
                    this.errorReporter.errorReport(INVALID_FIELD_MSG, invalidFieldException);
                    continue;
                }
                catch (Exception exception) {
                    this.errorReporter.errorReport(UNKNOWN_ERROR_MSG, exception);
                    continue;
                }
            }
            this.currentConnection = null;
            stringArray = null;
            object = null;
            Thread.yield();
        }
        this.th = null;
    }

    private boolean loadExternal(String string, String string2, FileCache fileCache, Vector vector) {
        VRMLSingleExternalNodeType vRMLSingleExternalNodeType = null;
        VRMLMultiExternalNodeType vRMLMultiExternalNodeType = null;
        boolean bl = false;
        URL[] uRLArray = null;
        try {
            URI uRI = URIUtils.createURI((String)string2);
            if (this.terminateCurrent) {
                return false;
            }
            uRLArray = uRI.getURLList();
        }
        catch (IOException iOException) {
            return false;
        }
        if (this.terminateCurrent || uRLArray == null) {
            return false;
        }
        for (int i = 0; i < uRLArray.length; ++i) {
            try {
                this.currentConnection = uRLArray[i].getResource();
            }
            catch (IOException iOException) {
                continue;
            }
            if (this.terminateCurrent) break;
            try {
                if (!this.makeConnection()) {
                    if (!this.terminateCurrent) continue;
                    break;
                }
                if (this.terminateCurrent) {
                    this.currentConnection.close();
                    break;
                }
                String string3 = this.currentConnection.getContentType();
                if (this.terminateCurrent) {
                    this.currentConnection.close();
                    break;
                }
                if (string3 == null) {
                    this.currentConnection.close();
                    continue;
                }
                Object object = this.currentConnection.getContent();
                this.currentConnection.close();
                if (object == null) continue;
                boolean bl2 = false;
                for (int j = 0; j < vector.size(); ++j) {
                    LoadDetails loadDetails = (LoadDetails)vector.get(j);
                    if (loadDetails.fieldIndex == -1) {
                        vRMLSingleExternalNodeType = (VRMLSingleExternalNodeType)loadDetails.node;
                        if (!vRMLSingleExternalNodeType.checkValidContentType(string3)) continue;
                        bl2 = true;
                        vRMLSingleExternalNodeType.setLoadedURI(string);
                        vRMLSingleExternalNodeType.setContent(string3, object);
                        vRMLSingleExternalNodeType.setLoadState(3);
                        continue;
                    }
                    vRMLMultiExternalNodeType = (VRMLMultiExternalNodeType)loadDetails.node;
                    if (!vRMLMultiExternalNodeType.checkValidContentType(loadDetails.fieldIndex, string3)) continue;
                    bl2 = true;
                    vRMLMultiExternalNodeType.setLoadedURI(loadDetails.fieldIndex, string);
                    vRMLMultiExternalNodeType.setContent(loadDetails.fieldIndex, string3, object);
                    vRMLMultiExternalNodeType.setLoadState(loadDetails.fieldIndex, 3);
                }
                if (!bl2) continue;
                if (!(object instanceof BasicScene)) {
                    fileCache.cacheFile(string2, string3, object);
                }
                bl = true;
                break;
            }
            catch (IOException iOException) {
                if (!this.terminateCurrent) continue;
                break;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.errorReporter.errorReport(CONTENT_ERROR_MSG, illegalArgumentException);
                continue;
            }
            catch (InvalidFieldException invalidFieldException) {
                this.errorReporter.errorReport(INVALID_FIELD_MSG, invalidFieldException);
                continue;
            }
            catch (Exception exception) {
                this.errorReporter.errorReport(UNKNOWN_ERROR_MSG, exception);
            }
        }
        return bl;
    }

    protected boolean isAlive() {
        if (this.th == null) {
            return false;
        }
        return this.th.isAlive();
    }
}

