/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.nodes.loader;

import java.util.HashMap;
import java.util.Map;
import org.web3d.util.ErrorReporter;
import org.web3d.util.IntHashMap;
import org.web3d.vrml.nodes.VRMLScriptNodeType;
import org.web3d.vrml.nodes.loader.ContentLoadQueue;
import org.web3d.vrml.nodes.loader.FileCache;
import org.web3d.vrml.nodes.loader.LoadRequest;
import org.web3d.vrml.nodes.loader.ScriptLoadDetails;
import org.web3d.vrml.nodes.loader.ScriptLoadStatusListener;
import org.web3d.vrml.nodes.loader.ScriptLoader;
import org.web3d.vrml.nodes.loader.ScriptThreadPool;
import org.web3d.vrml.nodes.loader.WeakRefFileCache;
import org.web3d.vrml.scripting.ScriptEngine;

public class DefaultScriptLoader
implements ScriptLoader {
    private static FileCache cache = new WeakRefFileCache();
    private ScriptThreadPool loaderPool;
    private ContentLoadQueue pending;
    private Map inProgress;
    private IntHashMap engineMap = new IntHashMap();
    private ScriptLoadStatusListener statusListener;

    public DefaultScriptLoader() {
        this.loaderPool = ScriptThreadPool.getScriptThreadPool();
        this.pending = this.loaderPool.getWaitingList();
        this.inProgress = this.loaderPool.getProgressMap();
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.loaderPool.setErrorReporter(errorReporter);
    }

    public void registerScriptingEngine(ScriptEngine scriptEngine) {
        String[] stringArray = scriptEngine.getSupportedContentTypes();
        int n = scriptEngine.getSupportedSpecificationVersion();
        HashMap<String, ScriptEngine> hashMap = (HashMap<String, ScriptEngine>)this.engineMap.get(n);
        if (hashMap == null) {
            hashMap = new HashMap<String, ScriptEngine>();
            this.engineMap.put(n, hashMap);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            hashMap.put(stringArray[i], scriptEngine);
        }
    }

    public void unregisterScriptingEngine(ScriptEngine scriptEngine) {
        String[] stringArray = scriptEngine.getSupportedContentTypes();
        int n = scriptEngine.getSupportedSpecificationVersion();
        HashMap hashMap = (HashMap)this.engineMap.get(n);
        for (int i = 0; i < stringArray.length; ++i) {
            Object v = hashMap.get(stringArray[i]);
            if (v != scriptEngine) continue;
            hashMap.remove(stringArray[i]);
        }
    }

    public void setStatusListener(ScriptLoadStatusListener scriptLoadStatusListener) {
        this.statusListener = scriptLoadStatusListener;
    }

    public void loadScript(VRMLScriptNodeType vRMLScriptNodeType) {
        if (vRMLScriptNodeType.getLoadState() != 1) {
            return;
        }
        String[] stringArray = vRMLScriptNodeType.getUrl();
        if (stringArray == null || stringArray.length == 0) {
            vRMLScriptNodeType.setLoadState(3);
            this.statusListener.loadCompleted(vRMLScriptNodeType);
        } else {
            this.loaderPool.restartThreads();
            ScriptLoadDetails scriptLoadDetails = new ScriptLoadDetails();
            scriptLoadDetails.fieldIndex = -1;
            scriptLoadDetails.node = vRMLScriptNodeType;
            scriptLoadDetails.engineMap = this.engineMap;
            scriptLoadDetails.statusListener = this.statusListener;
            String[] stringArray2 = vRMLScriptNodeType.getUrl();
            if (this.inProgress.containsKey(stringArray2)) {
                LoadRequest loadRequest = (LoadRequest)this.inProgress.get(stringArray2);
                loadRequest.loadList.add(scriptLoadDetails);
            } else {
                this.pending.add(stringArray2, cache, scriptLoadDetails);
            }
        }
    }

    public int getNumberInProgress() {
        return this.pending.size();
    }

    public void shutdown() {
        this.loaderPool.shutdown();
    }
}

