/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.nodes.loader;

import java.util.LinkedList;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.util.HashSet;
import org.web3d.vrml.nodes.FrameStateManager;
import org.web3d.vrml.nodes.loader.DefaultWorldLoader;
import org.web3d.vrml.nodes.loader.SceneBuilderFactory;
import org.web3d.vrml.nodes.loader.WorldLoader;
import org.web3d.vrml.nodes.loader.WorldLoaderManager;
import org.web3d.vrml.parser.VRMLParserFactory;

public class DefaultWorldLoaderManager
implements WorldLoaderManager {
    private ErrorReporter errorReporter;
    private FrameStateManager stateManager;
    private LinkedList availableLoaders;
    private HashSet allLoaders;

    public DefaultWorldLoaderManager(FrameStateManager frameStateManager) {
        this.stateManager = frameStateManager;
        this.availableLoaders = new LinkedList();
        this.allLoaders = new HashSet();
        this.errorReporter = DefaultErrorReporter.getDefaultReporter();
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
        if (this.allLoaders.size() != 0) {
            Object[] objectArray = this.allLoaders.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                DefaultWorldLoader defaultWorldLoader = (DefaultWorldLoader)objectArray[i];
                defaultWorldLoader.setErrorReporter(this.errorReporter);
            }
        }
    }

    public synchronized WorldLoader fetchLoader() {
        WorldLoader worldLoader = null;
        if (this.availableLoaders.size() != 0) {
            worldLoader = (WorldLoader)this.availableLoaders.remove(0);
        } else {
            DefaultWorldLoader defaultWorldLoader = new DefaultWorldLoader(this.stateManager);
            defaultWorldLoader.setErrorReporter(this.errorReporter);
            this.allLoaders.add(defaultWorldLoader);
            worldLoader = defaultWorldLoader;
        }
        return worldLoader;
    }

    public synchronized void releaseLoader(WorldLoader worldLoader) {
        this.availableLoaders.add(worldLoader);
    }

    public void registerBuilderFactory(int n, SceneBuilderFactory sceneBuilderFactory) {
        DefaultWorldLoader.registerBuilderFactory(n, sceneBuilderFactory);
    }

    public SceneBuilderFactory getBuilderFactory(int n) {
        return DefaultWorldLoader.getBuilderFactory(n);
    }

    public void registerParserFactory(int n, VRMLParserFactory vRMLParserFactory) {
        DefaultWorldLoader.registerParserFactory(n, vRMLParserFactory);
    }

    public VRMLParserFactory getParserFactory(int n) {
        return DefaultWorldLoader.getParserFactory(n);
    }
}

