/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.nodes.loader;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URLClassLoader;
import java.util.Map;
import java.util.Vector;
import org.ietf.uri.URI;
import org.ietf.uri.URIUtils;
import org.ietf.uri.URL;
import org.ietf.uri.UnsupportedServiceException;
import org.web3d.vrml.lang.BasicScene;
import org.web3d.vrml.lang.VRMLExecutionSpace;
import org.web3d.vrml.nodes.VRMLScriptNodeType;
import org.web3d.vrml.nodes.loader.AbstractContentLoader;
import org.web3d.vrml.nodes.loader.CacheDetails;
import org.web3d.vrml.nodes.loader.ContentLoadQueue;
import org.web3d.vrml.nodes.loader.FileCache;
import org.web3d.vrml.nodes.loader.LoadRequest;
import org.web3d.vrml.nodes.loader.ScriptLoadDetails;
import org.web3d.vrml.scripting.InvalidScriptContentException;
import org.web3d.vrml.scripting.ScriptEngine;
import org.web3d.vrml.scripting.ScriptWrapper;

class ScriptContentLoader
extends AbstractContentLoader {
    private Thread th;
    private static final String JAVA_MIME = "application/x-java";

    ScriptContentLoader(ThreadGroup threadGroup, ContentLoadQueue contentLoadQueue, Map map) {
        super(threadGroup, contentLoadQueue, map);
        this.th = new Thread(threadGroup, this);
        this.th.start();
    }

    public void run() {
        boolean bl = false;
        while (this.processNext) {
            Object object;
            Object object2;
            ScriptLoadDetails scriptLoadDetails;
            int n;
            LoadRequest loadRequest = this.pendingList.getNext();
            if (loadRequest == null || loadRequest.loadList.size() == 0) {
                if (!this.processNext) break;
                continue;
            }
            if (!this.processNext) continue;
            String[] stringArray = loadRequest.url;
            boolean bl2 = false;
            this.terminateCurrent = false;
            this.inProgress.put(loadRequest.url, loadRequest);
            for (n = 0; n < loadRequest.loadList.size(); ++n) {
                scriptLoadDetails = (ScriptLoadDetails)loadRequest.loadList.get(n);
                object2 = (VRMLScriptNodeType)scriptLoadDetails.node;
                object2.setLoadState(2);
            }
            if (this.terminateCurrent) {
                this.inProgress.remove(loadRequest.url);
                continue;
            }
            for (n = 0; !bl2 && n < stringArray.length; ++n) {
                int n2;
                object2 = stringArray[n];
                if (!((String)object2).startsWith("javascript:") && !((String)object2).startsWith("ecmascript:") && (n2 = ((String)object2).lastIndexOf(35)) != -1) {
                    object2 = ((String)object2).substring(0, n2);
                }
                CacheDetails cacheDetails = loadRequest.cache.checkForFile((String)object2);
                scriptLoadDetails = (ScriptLoadDetails)loadRequest.loadList.get(0);
                VRMLScriptNodeType vRMLScriptNodeType = (VRMLScriptNodeType)scriptLoadDetails.node;
                VRMLExecutionSpace vRMLExecutionSpace = vRMLScriptNodeType.getExecutionSpace();
                BasicScene basicScene = vRMLExecutionSpace.getContainedScene();
                int n3 = basicScene.getSpecificationMajorVersion();
                Map map = (Map)scriptLoadDetails.engineMap.get(n3);
                if (cacheDetails != null) {
                    String string = cacheDetails.getContentType();
                    ScriptEngine scriptEngine = (ScriptEngine)map.get(string);
                    if (scriptEngine == null) continue;
                    object = cacheDetails.getContent();
                    bl2 = true;
                    for (int i = 0; i < loadRequest.loadList.size(); ++i) {
                        scriptLoadDetails = (ScriptLoadDetails)loadRequest.loadList.get(i);
                        VRMLScriptNodeType vRMLScriptNodeType2 = (VRMLScriptNodeType)scriptLoadDetails.node;
                        if (!vRMLScriptNodeType2.checkValidContentType(string)) continue;
                        vRMLScriptNodeType2.setLoadedURI(stringArray[n]);
                        try {
                            ScriptWrapper scriptWrapper = scriptEngine.buildWrapper(vRMLScriptNodeType2.getExecutionSpace(), string, object);
                            vRMLScriptNodeType2.setContent(string, scriptWrapper);
                        }
                        catch (InvalidScriptContentException invalidScriptContentException) {
                            String string2 = "Invalid content for script " + (String)object2;
                            this.errorReporter.errorReport(string2, (Exception)((Object)invalidScriptContentException));
                            continue;
                        }
                        vRMLScriptNodeType2.setLoadState(3);
                        scriptLoadDetails.statusListener.loadCompleted(vRMLScriptNodeType2);
                    }
                    continue;
                }
                bl2 = this.loadExternal((String)object2, loadRequest.cache, loadRequest.loadList, map);
            }
            this.inProgress.remove(loadRequest.url);
            if (!bl2) {
                n = loadRequest.loadList.size();
                for (int i = 0; i < loadRequest.loadList.size(); ++i) {
                    scriptLoadDetails = (ScriptLoadDetails)loadRequest.loadList.get(i);
                    VRMLScriptNodeType vRMLScriptNodeType = (VRMLScriptNodeType)scriptLoadDetails.node;
                    vRMLScriptNodeType.setLoadState(4);
                    scriptLoadDetails.statusListener.loadFailed(vRMLScriptNodeType);
                }
                object2 = stringArray.length > 0 ? (stringArray[0].length() > 80 ? stringArray[0].substring(0, 80) : stringArray[0]) : "Empty Url";
                this.errorReporter.warningReport("Cannot resolve any URLS for a script. URL: " + (String)object2, null);
            }
            this.currentConnection = null;
            stringArray = null;
            object = null;
            Thread.yield();
        }
        this.th = null;
    }

    private boolean loadExternal(String string, FileCache fileCache, Vector vector, Map map) {
        boolean bl = false;
        URL[] uRLArray = null;
        if (string.endsWith(".class")) {
            ScriptEngine scriptEngine = (ScriptEngine)map.get(JAVA_MIME);
            if (scriptEngine == null) {
                return false;
            }
            return this.loadClass(string, fileCache, vector, scriptEngine);
        }
        if (string.startsWith("ecmascript:") || string.startsWith("javascript:")) {
            String string2 = string.startsWith("ecmascript:") ? "application/ecmascript" : "application/javascript";
            String string3 = string.length() > 10 ? string.substring(11) : "";
            ScriptEngine scriptEngine = (ScriptEngine)map.get(string2);
            for (int i = 0; i < vector.size(); ++i) {
                ScriptLoadDetails scriptLoadDetails = (ScriptLoadDetails)vector.get(i);
                VRMLScriptNodeType vRMLScriptNodeType = (VRMLScriptNodeType)scriptLoadDetails.node;
                if (!vRMLScriptNodeType.checkValidContentType(string2)) continue;
                bl = true;
                vRMLScriptNodeType.setLoadedURI(string);
                vRMLScriptNodeType.setLoadState(3);
                ScriptWrapper scriptWrapper = scriptEngine.buildWrapper(vRMLScriptNodeType.getExecutionSpace(), string2, (Object)string3);
                vRMLScriptNodeType.setContent(string2, scriptWrapper);
                vRMLScriptNodeType.setLoadState(3);
                scriptLoadDetails.statusListener.loadCompleted(vRMLScriptNodeType);
            }
            return bl;
        }
        try {
            URI uRI = URIUtils.createURI((String)string);
            if (this.terminateCurrent) {
                return false;
            }
            uRLArray = uRI.getURLList();
        }
        catch (IOException iOException) {
            String string4 = "URI does not resolve to anything useful.\nURI is " + string;
            this.errorReporter.warningReport(string4, iOException);
            return false;
        }
        if (this.terminateCurrent) {
            return false;
        }
        if (uRLArray == null) {
            this.errorReporter.warningReport("Script contains no URLs. Ignoring", null);
            return false;
        }
        for (int i = 0; i < uRLArray.length; ++i) {
            try {
                this.currentConnection = uRLArray[i].getResource();
            }
            catch (IOException iOException) {
                String string5 = "Can't find resource " + uRLArray[i];
                this.errorReporter.warningReport(string5, iOException);
                continue;
            }
            catch (UnsupportedServiceException unsupportedServiceException) {
                String string6 = "Can't run script: " + uRLArray[i];
                this.errorReporter.warningReport(string6, (Exception)((Object)unsupportedServiceException));
                continue;
            }
            if (!this.makeConnection()) {
                if (!this.terminateCurrent) continue;
                break;
            }
            try {
                if (this.terminateCurrent) {
                    this.currentConnection.close();
                    break;
                }
                String string7 = this.currentConnection.getContentType();
                if (this.terminateCurrent) {
                    this.currentConnection.close();
                    break;
                }
                if (string7 == null) {
                    this.currentConnection.close();
                    continue;
                }
                ScriptEngine scriptEngine = (ScriptEngine)map.get(string7);
                if (scriptEngine == null) {
                    this.currentConnection.close();
                    continue;
                }
                Object object = this.currentConnection.getContent();
                this.currentConnection.close();
                if (object == null) continue;
                if (this.terminateCurrent) break;
                boolean bl2 = false;
                for (int j = 0; j < vector.size(); ++j) {
                    ScriptLoadDetails scriptLoadDetails = (ScriptLoadDetails)vector.get(j);
                    VRMLScriptNodeType vRMLScriptNodeType = (VRMLScriptNodeType)scriptLoadDetails.node;
                    if (!vRMLScriptNodeType.checkValidContentType(string7)) continue;
                    bl2 = true;
                    vRMLScriptNodeType.setLoadedURI(string);
                    vRMLScriptNodeType.setLoadState(3);
                    ScriptWrapper scriptWrapper = scriptEngine.buildWrapper(vRMLScriptNodeType.getExecutionSpace(), string7, object);
                    vRMLScriptNodeType.setContent(string7, scriptWrapper);
                    vRMLScriptNodeType.setLoadState(3);
                    scriptLoadDetails.statusListener.loadCompleted(vRMLScriptNodeType);
                }
                if (!bl2) continue;
                if (this.terminateCurrent) break;
                fileCache.cacheFile(string, string7, object);
                if (this.terminateCurrent) break;
                bl = true;
                break;
            }
            catch (IOException iOException) {
                String string8 = "IO Error reading external file " + string;
                this.errorReporter.warningReport(string8, iOException);
                if (!this.terminateCurrent) continue;
                break;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.errorReporter.warningReport("Can't set external content", illegalArgumentException);
                continue;
            }
            catch (InvalidScriptContentException invalidScriptContentException) {
                String string9 = "Invalid content for script url " + string;
                this.errorReporter.warningReport(string9, (Exception)((Object)invalidScriptContentException));
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return bl;
    }

    private boolean loadClass(String string, FileCache fileCache, Vector vector, ScriptEngine scriptEngine) {
        String string2;
        String string3;
        boolean bl = true;
        int n = string.lastIndexOf(47);
        int n2 = string.lastIndexOf(46);
        if (string.startsWith("jar:")) {
            int n3 = string.lastIndexOf("!");
            string3 = string.substring(4, n3);
            string2 = string.substring(n3 + 2, n2);
        } else {
            string3 = string.substring(0, n + 1);
            string2 = string.substring(n + 1, n2);
        }
        String string4 = null;
        Throwable throwable = null;
        try {
            java.net.URL[] uRLArray = new java.net.URL[]{new java.net.URL(string3)};
            URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray);
            Class<?> clazz = null;
            try {
                clazz = uRLClassLoader.loadClass(string2);
            }
            catch (Exception exception) {
                ClassLoader classLoader = this.getClass().getClassLoader();
                clazz = classLoader.loadClass(string2);
            }
            for (int i = 0; i < vector.size(); ++i) {
                ScriptWrapper scriptWrapper;
                ScriptLoadDetails scriptLoadDetails = (ScriptLoadDetails)vector.get(i);
                VRMLScriptNodeType vRMLScriptNodeType = (VRMLScriptNodeType)scriptLoadDetails.node;
                try {
                    scriptWrapper = scriptEngine.buildWrapper(vRMLScriptNodeType.getExecutionSpace(), JAVA_MIME, clazz);
                }
                catch (Exception exception) {
                    ClassLoader classLoader = this.getClass().getClassLoader();
                    clazz = classLoader.loadClass(string2);
                    scriptWrapper = scriptEngine.buildWrapper(vRMLScriptNodeType.getExecutionSpace(), JAVA_MIME, clazz);
                }
                fileCache.cacheFile(string, JAVA_MIME, clazz);
                vRMLScriptNodeType.setContent(JAVA_MIME, scriptWrapper);
                vRMLScriptNodeType.setLoadState(3);
                scriptLoadDetails.statusListener.loadCompleted(vRMLScriptNodeType);
            }
        }
        catch (MalformedURLException malformedURLException) {
            string4 = "Invalid URL for the script " + string3;
            throwable = malformedURLException;
            bl = false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            string4 = "Couldn't find the Java class " + string2 + " at: " + string3;
            throwable = classNotFoundException;
            bl = false;
        }
        catch (InvalidScriptContentException invalidScriptContentException) {
            string4 = "Invalid content for script " + string;
            throwable = invalidScriptContentException;
            bl = false;
        }
        if (string4 != null) {
            this.errorReporter.errorReport(string4, (Exception)throwable);
        }
        return bl;
    }

    protected boolean isAlive() {
        if (this.th == null) {
            return false;
        }
        return this.th.isAlive();
    }
}

