/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.nodes.loader;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.nodes.loader.ContentLoadQueue;
import org.web3d.vrml.nodes.loader.ScriptContentLoader;

public class ScriptThreadPool {
    private static final String THREAD_COUNT_PROP = "org.web3d.vrml.nodes.loader.threads";
    private static final int DEFAULT_THREAD_COUNT = 5;
    private ContentLoadQueue pending = new ContentLoadQueue();
    private HashMap inProgress = new HashMap();
    private ScriptContentLoader[] loaders;
    private static ScriptThreadPool threadPool;
    private static ThreadGroup threadGroup;

    private ScriptThreadPool() {
        Integer n;
        int n2;
        if (threadGroup == null) {
            threadGroup = new ThreadGroup("Xj3D Script Loaders");
        }
        if ((n2 = (n = (Integer)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Integer.getInteger(ScriptThreadPool.THREAD_COUNT_PROP, 5);
            }
        })).intValue()) <= 0) {
            n2 = 5;
        }
        this.loaders = new ScriptContentLoader[n2];
        int n3 = n2;
        while (--n3 >= 0) {
            this.loaders[n3] = new ScriptContentLoader(threadGroup, this.pending, this.inProgress);
        }
    }

    public static ScriptThreadPool getScriptThreadPool() {
        if (threadPool == null) {
            threadPool = new ScriptThreadPool();
        }
        return threadPool;
    }

    public static void setThreadGroup(ThreadGroup threadGroup) throws IllegalStateException {
        if (ScriptThreadPool.threadGroup != null) {
            throw new IllegalStateException("Cannot assign thread group now");
        }
        ScriptThreadPool.threadGroup = threadGroup;
    }

    public static ThreadGroup getThreadGroup() {
        return threadGroup;
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        for (int i = 0; i < this.loaders.length; ++i) {
            this.loaders[i].setErrorReporter(errorReporter);
        }
    }

    public ContentLoadQueue getWaitingList() {
        return this.pending;
    }

    public Map getProgressMap() {
        return this.inProgress;
    }

    public void shutdown() {
        int n = this.loaders.length;
        while (--n >= 0) {
            this.loaders[n].shutdown();
        }
    }

    protected void restartThreads() {
        int n;
        int n2 = n = this.loaders.length;
        while (--n2 >= 0) {
            if (this.loaders[n2].isAlive()) continue;
            threadGroup = new ThreadGroup("Xj3D Script Loaders");
            this.loaders[n2] = new ScriptContentLoader(threadGroup, this.pending, this.inProgress);
        }
    }
}

