/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.nodes.runtime;

import java.util.HashMap;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.nodes.VRMLClock;
import org.web3d.vrml.nodes.VRMLNetworkInterfaceNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.runtime.NetworkManager;
import org.web3d.vrml.nodes.runtime.NetworkProtocolHandler;

public class DefaultNetworkManager
implements NetworkManager {
    private static final int[] MANAGED_NODE_TYPES = new int[]{75};
    private ErrorReporter errorReporter = DefaultErrorReporter.getDefaultReporter();
    private HashMap protocolMap = new HashMap();
    private NetworkProtocolHandler[] protocolHandlers = new NetworkProtocolHandler[4];
    private int numHandlers;

    public boolean initialize() {
        return true;
    }

    public void shutdown() {
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
    }

    public boolean evaluatePreEventModel() {
        return true;
    }

    public boolean evaluatePostEventModel() {
        return false;
    }

    public void setVRMLClock(VRMLClock vRMLClock) {
    }

    public void resetTimeZero() {
    }

    public int[] getManagedNodeTypes() {
        return MANAGED_NODE_TYPES;
    }

    public void executePreEventModel(long l) {
        for (int i = 0; i < this.numHandlers; ++i) {
            this.protocolHandlers[i].processNetworkTraffic();
        }
    }

    public void executePostEventModel(long l) {
    }

    public void addManagedNode(VRMLNodeType vRMLNodeType) {
        if (!(vRMLNodeType instanceof VRMLNetworkInterfaceNodeType)) {
            this.errorReporter.warningReport("Non-network node added to the manager: " + vRMLNodeType, null);
            return;
        }
        VRMLNetworkInterfaceNodeType vRMLNetworkInterfaceNodeType = (VRMLNetworkInterfaceNodeType)vRMLNodeType;
        NetworkProtocolHandler networkProtocolHandler = (NetworkProtocolHandler)this.protocolMap.get(vRMLNetworkInterfaceNodeType.getProtocol());
        if (networkProtocolHandler == null) {
            this.errorReporter.warningReport("No network handler for protocol: " + vRMLNetworkInterfaceNodeType.getProtocol(), null);
        } else {
            networkProtocolHandler.addNode(vRMLNetworkInterfaceNodeType);
        }
    }

    public void removeManagedNode(VRMLNodeType vRMLNodeType) {
        if (!(vRMLNodeType instanceof VRMLNetworkInterfaceNodeType)) {
            this.errorReporter.warningReport("Non-network node added to the manager", null);
            return;
        }
        VRMLNetworkInterfaceNodeType vRMLNetworkInterfaceNodeType = (VRMLNetworkInterfaceNodeType)vRMLNodeType;
        NetworkProtocolHandler networkProtocolHandler = (NetworkProtocolHandler)this.protocolMap.get(vRMLNetworkInterfaceNodeType.getProtocol());
        if (networkProtocolHandler == null) {
            this.errorReporter.warningReport("No network handler for protocol: " + vRMLNetworkInterfaceNodeType.getProtocol(), null);
        } else {
            networkProtocolHandler.removeNode(vRMLNetworkInterfaceNodeType);
        }
    }

    public void clear() {
        for (int i = 0; i < this.numHandlers; ++i) {
            this.protocolHandlers[i].clear();
        }
    }

    public boolean addProtocolHandler(NetworkProtocolHandler networkProtocolHandler) {
        if (this.protocolMap.containsKey(networkProtocolHandler)) {
            return false;
        }
        this.protocolMap.put(networkProtocolHandler.getProtocol(), networkProtocolHandler);
        if (this.protocolHandlers.length == this.numHandlers) {
            NetworkProtocolHandler[] networkProtocolHandlerArray = new NetworkProtocolHandler[this.numHandlers + 4];
            System.arraycopy(this.protocolHandlers, 0, networkProtocolHandlerArray, 0, this.numHandlers);
            this.protocolHandlers = networkProtocolHandlerArray;
        }
        this.protocolHandlers[this.numHandlers++] = networkProtocolHandler;
        return true;
    }

    public void removeProtocolHandler(NetworkProtocolHandler networkProtocolHandler) {
        if (!this.protocolMap.containsKey(networkProtocolHandler)) {
            return;
        }
        for (int i = 0; i < this.numHandlers; ++i) {
            if (this.protocolHandlers[i] != networkProtocolHandler) continue;
            System.arraycopy(this.protocolHandlers, i + 1, this.protocolHandlers, i, this.numHandlers - i - 1);
            --this.numHandlers;
        }
        this.protocolMap.remove(networkProtocolHandler);
    }
}

