/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.nodes.runtime;

import org.j3d.geom.particle.ParticleSystem;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.nodes.VRMLClock;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLParticleSystemNodeType;
import org.web3d.vrml.nodes.runtime.NodeManager;
import org.web3d.vrml.util.NodeArray;

public class DefaultParticleSystemManager
implements NodeManager {
    private static final int[] MANAGED_NODE_TYPES = new int[]{66};
    private ErrorReporter errorReporter;
    private NodeArray systems = new NodeArray();
    private NodeArray newSystems = new NodeArray();

    public DefaultParticleSystemManager() {
        this.errorReporter = DefaultErrorReporter.getDefaultReporter();
    }

    public boolean initialize() {
        return true;
    }

    public void shutdown() {
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
    }

    public void setVRMLClock(VRMLClock vRMLClock) {
    }

    public void resetTimeZero() {
    }

    public int[] getManagedNodeTypes() {
        return MANAGED_NODE_TYPES;
    }

    public boolean evaluatePreEventModel() {
        return false;
    }

    public boolean evaluatePostEventModel() {
        return true;
    }

    public void addManagedNode(VRMLNodeType vRMLNodeType) {
        if (!(vRMLNodeType instanceof VRMLParticleSystemNodeType)) {
            this.errorReporter.warningReport("Non-Particle System node added to the manager", null);
            return;
        }
        this.systems.add(vRMLNodeType);
        this.newSystems.add(vRMLNodeType);
    }

    public void removeManagedNode(VRMLNodeType vRMLNodeType) {
        if (!(vRMLNodeType instanceof VRMLParticleSystemNodeType)) {
            this.errorReporter.warningReport("Non- Particle System removed from the manager", null);
            return;
        }
        this.systems.remove(vRMLNodeType);
    }

    public void executePreEventModel(long l) {
    }

    public void executePostEventModel(long l) {
        ParticleSystem particleSystem;
        VRMLParticleSystemNodeType vRMLParticleSystemNodeType;
        int n;
        int n2 = this.newSystems.size();
        for (n = 0; n < n2; ++n) {
            vRMLParticleSystemNodeType = (VRMLParticleSystemNodeType)this.newSystems.get(n);
            particleSystem = vRMLParticleSystemNodeType.getSystem();
            particleSystem.initialize(l);
        }
        this.newSystems.clear();
        n2 = this.systems.size();
        for (n = 0; n < n2; ++n) {
            vRMLParticleSystemNodeType = (VRMLParticleSystemNodeType)this.systems.get(n);
            if (!vRMLParticleSystemNodeType.getEnabled() || !vRMLParticleSystemNodeType.isActive() || (particleSystem = vRMLParticleSystemNodeType.getSystem()).update(l)) continue;
            vRMLParticleSystemNodeType.setActive(false);
        }
    }

    public void clear() {
        this.systems.clear();
        this.newSystems.clear();
    }
}

