/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.nodes.runtime;

import java.util.ArrayList;
import java.util.Map;
import java.util.WeakHashMap;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.util.HashSet;
import org.web3d.vrml.lang.BasicScene;
import org.web3d.vrml.lang.ROUTE;
import org.web3d.vrml.lang.VRMLExecutionSpace;
import org.web3d.vrml.nodes.VRMLInlineNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.nodes.runtime.RouteManager;
import org.web3d.vrml.nodes.runtime.Router;
import org.web3d.vrml.nodes.runtime.RouterFactory;

public class DefaultRouteManager
implements RouteManager {
    private static final int DEFAULT_SIZE = 32;
    private static final int ARRAY_INC = 8;
    private ErrorReporter errorReporter;
    private Map spaceMap = new WeakHashMap();
    private RouterFactory factory;
    private Router[] routers;
    private int numRouters = 0;
    private boolean[] routerInUse;
    private boolean hasUnusedRouter = false;
    private HashSet spacesToAdd = new HashSet();
    private HashSet spacesToRemove = new HashSet();
    private VRMLExecutionSpace[] tmpSpaceVals;

    public DefaultRouteManager() {
        this.routers = new Router[32];
        this.routerInUse = new boolean[32];
        this.tmpSpaceVals = new VRMLExecutionSpace[32];
        this.errorReporter = DefaultErrorReporter.getDefaultReporter();
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
    }

    public void setRouterFactory(RouterFactory routerFactory) {
        this.factory = routerFactory;
    }

    public boolean processRoutes(double d) {
        boolean bl = false;
        for (int i = 0; i < this.numRouters; ++i) {
            if (!this.routerInUse[i]) continue;
            bl = bl || this.routers[i].processRoutes(d);
        }
        return bl;
    }

    public void addRoute(VRMLExecutionSpace vRMLExecutionSpace, VRMLNodeType vRMLNodeType, int n, VRMLNodeType vRMLNodeType2, int n2) {
        Router router = this.getRouter(vRMLExecutionSpace);
        if (router != null) {
            router.addRoute(vRMLNodeType, n, vRMLNodeType2, n2);
        }
    }

    public void addRoute(VRMLExecutionSpace vRMLExecutionSpace, ROUTE rOUTE) {
        Router router = this.getRouter(vRMLExecutionSpace);
        if (router != null) {
            router.addRoute((VRMLNodeType)rOUTE.getSourceNode(), rOUTE.getSourceIndex(), (VRMLNodeType)rOUTE.getDestinationNode(), rOUTE.getDestinationIndex());
        }
    }

    public void removeRoute(VRMLExecutionSpace vRMLExecutionSpace, VRMLNodeType vRMLNodeType, int n, VRMLNodeType vRMLNodeType2, int n2) {
        Router router = (Router)this.spaceMap.get(vRMLExecutionSpace);
        if (router != null) {
            router.removeRoute(vRMLNodeType, n, vRMLNodeType2, n2);
        } else {
            this.errorReporter.warningReport("Attempting to remove route from a space that doesn't exist", null);
        }
    }

    public void removeRoute(VRMLExecutionSpace vRMLExecutionSpace, ROUTE rOUTE) {
        Router router = (Router)this.spaceMap.get(vRMLExecutionSpace);
        if (router != null) {
            router.removeRoute((VRMLNodeType)rOUTE.getSourceNode(), rOUTE.getSourceIndex(), (VRMLNodeType)rOUTE.getDestinationNode(), rOUTE.getDestinationIndex());
        } else {
            this.errorReporter.warningReport("Attempting to remove route (object) from a space that doesn't exist", null);
        }
    }

    public synchronized void addSpace(VRMLExecutionSpace vRMLExecutionSpace) {
        if (this.spaceMap.containsKey(vRMLExecutionSpace) || this.spacesToAdd.contains(vRMLExecutionSpace)) {
            this.errorReporter.warningReport("Trying to add duplicate space!", null);
            return;
        }
        this.spacesToAdd.add(vRMLExecutionSpace);
    }

    public synchronized void removeSpace(VRMLExecutionSpace vRMLExecutionSpace) {
        if (!this.spaceMap.containsKey(vRMLExecutionSpace)) {
            this.errorReporter.warningReport("Trying to remove non-existent space!", null);
            return;
        }
        if (this.spacesToRemove.contains(vRMLExecutionSpace)) {
            this.errorReporter.warningReport("Trying to duplicate remove space!!", null);
            return;
        }
        this.spacesToRemove.add(vRMLExecutionSpace);
    }

    public synchronized void updateSpaces() {
        int n;
        int n2 = this.spaceMap.size() + this.spacesToAdd.size() - this.spacesToRemove.size();
        this.checkSize(n2);
        n2 = this.spacesToRemove.size();
        if (n2 != 0) {
            if (this.tmpSpaceVals.length < n2) {
                this.tmpSpaceVals = new VRMLExecutionSpace[n2];
            }
            this.spacesToRemove.toArray(this.tmpSpaceVals);
            for (n = 0; n < n2; ++n) {
                BasicScene basicScene = this.tmpSpaceVals[n].getContainedScene();
                this.delayedRemoveSpace(this.tmpSpaceVals[n]);
                this.tmpSpaceVals[n] = null;
            }
        }
        if ((n2 = this.spacesToAdd.size()) != 0) {
            if (this.tmpSpaceVals.length < n2) {
                this.tmpSpaceVals = new VRMLExecutionSpace[n2];
            }
            this.spacesToAdd.toArray(this.tmpSpaceVals);
            for (n = 0; n < n2; ++n) {
                this.delayedAddSpace(this.tmpSpaceVals[n]);
                this.tmpSpaceVals[n] = null;
            }
        }
        this.spacesToAdd.clear();
        this.spacesToRemove.clear();
    }

    public void updateRoutes() {
        for (int i = 0; i < this.numRouters; ++i) {
            if (!this.routerInUse[i]) continue;
            this.routers[i].updateRoutes();
        }
    }

    public void clear() {
        for (int i = 0; i < this.numRouters; ++i) {
            if (!this.routerInUse[i]) continue;
            this.routers[i].clear();
            this.routerInUse[i] = false;
        }
        this.spaceMap.clear();
        this.spacesToAdd.clear();
        this.spacesToRemove.clear();
    }

    private void delayedAddSpace(VRMLExecutionSpace vRMLExecutionSpace) {
        VRMLExecutionSpace vRMLExecutionSpace2;
        int n;
        if (vRMLExecutionSpace == null) {
            return;
        }
        BasicScene basicScene = vRMLExecutionSpace.getContainedScene();
        if (basicScene == null) {
            return;
        }
        Router router = this.getRouter(vRMLExecutionSpace);
        ArrayList arrayList = basicScene.getRoutes();
        router.addRoutes(arrayList);
        arrayList = basicScene.getByPrimaryType(38);
        int n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            vRMLExecutionSpace2 = (VRMLExecutionSpace)arrayList.get(n);
            if (((VRMLProtoInstance)vRMLExecutionSpace2).getImplementationNode() == null) continue;
            this.delayedAddSpace(vRMLExecutionSpace2);
        }
        arrayList = basicScene.getByPrimaryType(24);
        n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            vRMLExecutionSpace2 = (VRMLInlineNodeType)arrayList.get(n);
            if (vRMLExecutionSpace2.getLoadState() != 3) continue;
            this.delayedAddSpace(vRMLExecutionSpace2);
        }
    }

    private void delayedRemoveSpace(VRMLExecutionSpace vRMLExecutionSpace) {
        VRMLExecutionSpace vRMLExecutionSpace2;
        int n;
        if (vRMLExecutionSpace == null) {
            return;
        }
        BasicScene basicScene = vRMLExecutionSpace.getContainedScene();
        if (basicScene == null) {
            return;
        }
        Router router = (Router)this.spaceMap.remove(vRMLExecutionSpace);
        if (router == null) {
            return;
        }
        router.clear();
        for (n = 0; n < this.numRouters; ++n) {
            if (this.routers[n] != router) continue;
            this.routerInUse[n] = false;
            break;
        }
        ArrayList arrayList = basicScene.getByPrimaryType(38);
        int n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            vRMLExecutionSpace2 = (VRMLExecutionSpace)arrayList.get(n);
            this.delayedRemoveSpace(vRMLExecutionSpace2);
        }
        arrayList = basicScene.getByPrimaryType(24);
        n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            vRMLExecutionSpace2 = (VRMLInlineNodeType)arrayList.get(n);
            if (vRMLExecutionSpace2.getLoadState() != 3) continue;
            this.delayedRemoveSpace(vRMLExecutionSpace2);
        }
    }

    private Router getRouter(VRMLExecutionSpace vRMLExecutionSpace) {
        Router router = (Router)this.spaceMap.get(vRMLExecutionSpace);
        if (router == null && this.factory != null) {
            if (this.hasUnusedRouter) {
                int n;
                for (n = 0; n < this.numRouters; ++n) {
                    if (this.routerInUse[n]) continue;
                    router = this.routers[n];
                    this.routerInUse[n] = true;
                    break;
                }
                if (n == this.numRouters - 1) {
                    this.hasUnusedRouter = false;
                } else if (n == this.numRouters && router == null) {
                    this.checkSize(-1);
                    this.routers[this.numRouters] = router;
                    this.routerInUse[this.numRouters] = true;
                    ++this.numRouters;
                    this.hasUnusedRouter = false;
                }
            } else {
                this.checkSize(-1);
                this.routers[this.numRouters] = router = this.factory.newRouter();
                this.routerInUse[this.numRouters] = true;
                ++this.numRouters;
            }
            this.spaceMap.put(vRMLExecutionSpace, router);
        }
        return router;
    }

    private void checkSize(int n) {
        if (n == -1) {
            if (this.routers.length == this.numRouters) {
                int n2 = this.routers.length;
                Router[] routerArray = new Router[n2 + 8];
                System.arraycopy(this.routers, 0, routerArray, 0, n2);
                this.routers = routerArray;
                boolean[] blArray = new boolean[n2 + 8];
                System.arraycopy(this.routerInUse, 0, blArray, 0, n2);
                this.routerInUse = blArray;
            }
        } else if (this.routers.length < n) {
            int n3 = this.routers.length;
            Router[] routerArray = new Router[n];
            System.arraycopy(this.routers, 0, routerArray, 0, n3);
            this.routers = routerArray;
            boolean[] blArray = new boolean[n];
            System.arraycopy(this.routerInUse, 0, blArray, 0, n3);
            this.routerInUse = blArray;
        }
    }
}

