/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.nodes.runtime;

import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.util.HashSet;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLScriptNodeType;
import org.web3d.vrml.nodes.VRMLUrlListener;
import org.web3d.vrml.nodes.loader.ScriptLoadStatusListener;
import org.web3d.vrml.nodes.loader.ScriptLoader;
import org.web3d.vrml.nodes.runtime.ScriptManager;
import org.web3d.vrml.util.NodeArray;

public class DefaultScriptManager
implements ScriptManager,
VRMLUrlListener,
ScriptLoadStatusListener {
    private ErrorReporter errorReporter;
    private ScriptLoader loader;
    private NodeArray loadedList;
    private NodeArray processedList;
    private NodeArray shutdownList;
    private NodeArray deletedList;
    private HashSet allScripts;
    private NodeArray activeScripts;
    private Object loadedListMutex = new Object();
    private Object processedListMutex = new Object();

    public DefaultScriptManager() {
        this.loadedList = new NodeArray();
        this.activeScripts = new NodeArray();
        this.shutdownList = new NodeArray();
        this.deletedList = new NodeArray();
        this.processedList = new NodeArray();
        this.allScripts = new HashSet();
        this.errorReporter = DefaultErrorReporter.getDefaultReporter();
    }

    public void urlChanged(VRMLNodeType vRMLNodeType, int n) {
        this.shutdownList.add(vRMLNodeType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadCompleted(VRMLScriptNodeType vRMLScriptNodeType) {
        Object object = this.loadedListMutex;
        synchronized (object) {
            this.loadedList.add(vRMLScriptNodeType);
        }
        object = this.processedListMutex;
        synchronized (object) {
            this.processedList.add(vRMLScriptNodeType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFailed(VRMLScriptNodeType vRMLScriptNodeType) {
        Object object = this.processedListMutex;
        synchronized (object) {
            this.processedList.add(vRMLScriptNodeType);
        }
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
        if (this.loader != null) {
            this.loader.setErrorReporter(this.errorReporter);
        }
    }

    public void setScriptLoader(ScriptLoader scriptLoader) {
        if (this.loader != null) {
            this.loader.setStatusListener(null);
        }
        this.loader = scriptLoader;
        if (this.loader != null) {
            this.loader.setErrorReporter(this.errorReporter);
            this.loader.setStatusListener(this);
        }
    }

    public ScriptLoader getScriptLoader() {
        return this.loader;
    }

    public void shutdownActiveScripts() {
        int n = this.shutdownList.size();
        for (int i = 0; i < n; ++i) {
            VRMLScriptNodeType vRMLScriptNodeType = (VRMLScriptNodeType)this.shutdownList.get(i);
            vRMLScriptNodeType.shutdown();
        }
        this.shutdownList.clear();
    }

    public void shutdown() {
        Object[] objectArray = this.allScripts.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            VRMLScriptNodeType vRMLScriptNodeType = (VRMLScriptNodeType)objectArray[i];
            vRMLScriptNodeType.shutdownAll();
        }
        this.shutdownList.clear();
        this.activeScripts.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeScripts(double d) {
        int n = this.loadedList.size();
        if (n != 0) {
            Object object = this.loadedListMutex;
            synchronized (object) {
                for (int i = 0; i < n; ++i) {
                    VRMLScriptNodeType vRMLScriptNodeType = (VRMLScriptNodeType)this.loadedList.get(i);
                    vRMLScriptNodeType.initialize(d);
                    this.activeScripts.add(vRMLScriptNodeType);
                }
                this.loadedList.clear();
            }
        }
    }

    public void prepareEvents(double d) {
        int n = this.activeScripts.size();
        for (int i = 0; i < n; ++i) {
            VRMLScriptNodeType vRMLScriptNodeType = (VRMLScriptNodeType)this.activeScripts.get(i);
            vRMLScriptNodeType.prepareEvents(d);
        }
    }

    public void processEvents() {
        int n = this.activeScripts.size();
        for (int i = 0; i < n; ++i) {
            VRMLScriptNodeType vRMLScriptNodeType = (VRMLScriptNodeType)this.activeScripts.get(i);
            vRMLScriptNodeType.processEvents();
        }
    }

    public void eventsProcessed() {
        int n = this.activeScripts.size();
        for (int i = 0; i < n; ++i) {
            VRMLScriptNodeType vRMLScriptNodeType = (VRMLScriptNodeType)this.activeScripts.get(i);
            vRMLScriptNodeType.eventsProcessed();
        }
    }

    public void removeScripts(NodeArray nodeArray) {
        int n = nodeArray.size();
        for (int i = 0; i < n; ++i) {
            VRMLScriptNodeType vRMLScriptNodeType = (VRMLScriptNodeType)nodeArray.get(i);
            vRMLScriptNodeType.removeUrlListener(this);
            this.allScripts.remove(vRMLScriptNodeType);
            this.activeScripts.remove(vRMLScriptNodeType);
        }
    }

    public void addScripts(NodeArray nodeArray) {
        if (this.loader == null) {
            return;
        }
        int n = nodeArray.size();
        for (int i = 0; i < n; ++i) {
            VRMLScriptNodeType vRMLScriptNodeType = (VRMLScriptNodeType)nodeArray.get(i);
            vRMLScriptNodeType.addUrlListener(this);
            this.allScripts.add(vRMLScriptNodeType);
            this.loader.loadScript(vRMLScriptNodeType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getProcessedScripts(NodeArray nodeArray) {
        Object object = this.processedListMutex;
        synchronized (object) {
            nodeArray.set(this.processedList);
            this.processedList.clear();
        }
    }
}

