/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.nodes.runtime;

import java.util.ArrayList;
import java.util.HashMap;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.util.HashSet;
import org.web3d.util.IntHashMap;
import org.web3d.util.ObjectArray;
import org.web3d.vrml.lang.BasicScene;
import org.web3d.vrml.lang.SceneMetaData;
import org.web3d.vrml.lang.VRMLExecutionSpace;
import org.web3d.vrml.lang.VRMLNode;
import org.web3d.vrml.nodes.FrameStateManager;
import org.web3d.vrml.nodes.VRMLBackgroundNodeType;
import org.web3d.vrml.nodes.VRMLBindableNodeType;
import org.web3d.vrml.nodes.VRMLClock;
import org.web3d.vrml.nodes.VRMLExternProtoDeclare;
import org.web3d.vrml.nodes.VRMLExternalSynchronizedNodeType;
import org.web3d.vrml.nodes.VRMLFogNodeType;
import org.web3d.vrml.nodes.VRMLNavigationInfoNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.nodes.VRMLScene;
import org.web3d.vrml.nodes.VRMLScriptNodeType;
import org.web3d.vrml.nodes.VRMLTerrainSource;
import org.web3d.vrml.nodes.VRMLViewpointNodeType;
import org.web3d.vrml.nodes.loader.ExternalLoadManager;
import org.web3d.vrml.nodes.runtime.BindableNodeManager;
import org.web3d.vrml.nodes.runtime.EventModelEvaluator;
import org.web3d.vrml.nodes.runtime.EventModelInitListener;
import org.web3d.vrml.nodes.runtime.ExternalView;
import org.web3d.vrml.nodes.runtime.NodeManager;
import org.web3d.vrml.nodes.runtime.RouteManager;
import org.web3d.vrml.nodes.runtime.ScriptManager;
import org.web3d.vrml.nodes.runtime.SensorManager;
import org.web3d.vrml.nodes.runtime.TerrainSectorManager;
import org.web3d.vrml.nodes.runtime.ViewpointManager;
import org.web3d.vrml.util.NodeArray;
import org.web3d.vrml.util.NodeTemplateArray;

public class GeneralisedEventModelEvaluator
implements EventModelEvaluator {
    private static final String SYNCH_START_MSG = "Error during external synchronised node pre-event callback";
    private static final String SYNCH_STOP_MSG = "Error during external synchronised node post-event callback";
    private static final int NUM_NODES = 32;
    private static final int NUM_NODES_INC = 8;
    private ErrorReporter errorReporter = DefaultErrorReporter.getDefaultReporter();
    private EventModelInitListener initListener;
    private SensorManager sensorManager;
    private RouteManager routeManager;
    private ViewpointManager viewpointManager;
    private ScriptManager scriptManager;
    private FrameStateManager stateManager;
    private ExternalLoadManager contentLoader;
    private ArrayList externalViews = new ArrayList();
    private NodeArray externalSyncNodes = new NodeArray();
    private IntHashMap bindablesMap = new IntHashMap();
    private VRMLScene currentScene;
    private boolean active = false;
    private VRMLNodeType[] tmpNodes;
    private NodeArray tmpArray;
    private HashMap scriptToSceneMap = new HashMap();
    private VRMLScene sceneToLoad;
    private String initialViewpoint;
    private VRMLViewpointNodeType defaultViewpoint;
    private VRMLNavigationInfoNodeType defaultNavInfo;
    private VRMLBackgroundNodeType defaultBackground;
    private VRMLFogNodeType defaultFog;
    private TerrainSectorManager terrainManager;
    private NodeManager[] preEventManagers;
    private int numPreEventManagers;
    private NodeManager[] postEventManagers;
    private int numPostEventManagers;
    private HashMap sceneToScriptListMap = new HashMap();
    private boolean justStarted = false;
    private boolean initialWorldLoadComplete = false;
    private VRMLExecutionSpace rootSpace;
    private long lastTime;
    private boolean shutdownNow = false;

    public GeneralisedEventModelEvaluator() {
        this.tmpNodes = new VRMLNodeType[32];
        this.tmpArray = new NodeArray(32);
    }

    public void initialize(ScriptManager scriptManager, RouteManager routeManager, SensorManager sensorManager, FrameStateManager frameStateManager, ExternalLoadManager externalLoadManager, ViewpointManager viewpointManager, NodeManager[] nodeManagerArray) {
        int n;
        this.scriptManager = scriptManager;
        this.routeManager = routeManager;
        this.sensorManager = sensorManager;
        this.stateManager = frameStateManager;
        this.contentLoader = externalLoadManager;
        this.viewpointManager = viewpointManager;
        VRMLClock vRMLClock = this.sensorManager.getVRMLClock();
        int n2 = nodeManagerArray == null ? 0 : nodeManagerArray.length;
        int n3 = 0;
        int n4 = 0;
        for (n = 0; n < n2; ++n) {
            if (nodeManagerArray[n].evaluatePreEventModel()) {
                ++n4;
            }
            if (!nodeManagerArray[n].evaluatePostEventModel()) continue;
            ++n3;
        }
        this.preEventManagers = new NodeManager[n4];
        this.postEventManagers = new NodeManager[n3];
        n4 = 0;
        n3 = 0;
        for (n = 0; n < n2; ++n) {
            if (!nodeManagerArray[n].initialize()) {
                this.errorReporter.warningReport("Manager " + nodeManagerArray[n].getClass() + " failed to initialise. Ignoring", null);
                continue;
            }
            if (nodeManagerArray[n].evaluatePreEventModel()) {
                this.preEventManagers[n4++] = nodeManagerArray[n];
            }
            if (nodeManagerArray[n].evaluatePostEventModel()) {
                this.postEventManagers[n3++] = nodeManagerArray[n];
            }
            this.stateManager.listenFor(nodeManagerArray[n].getManagedNodeTypes());
            nodeManagerArray[n].setErrorReporter(this.errorReporter);
            nodeManagerArray[n].setVRMLClock(vRMLClock);
        }
        this.stateManager.listenFor(new int[]{55});
        this.numPreEventManagers = n4;
        this.numPostEventManagers = n3;
        BindableNodeManager bindableNodeManager = new BindableNodeManager();
        bindableNodeManager.setVRMLClock(vRMLClock);
        bindableNodeManager.setErrorReporter(this.errorReporter);
        this.bindablesMap.put(55, bindableNodeManager);
        BindableNodeManager bindableNodeManager2 = new BindableNodeManager();
        bindableNodeManager2.setVRMLClock(vRMLClock);
        bindableNodeManager2.setErrorReporter(this.errorReporter);
        this.bindablesMap.put(31, bindableNodeManager2);
        BindableNodeManager bindableNodeManager3 = new BindableNodeManager();
        bindableNodeManager3.setVRMLClock(vRMLClock);
        bindableNodeManager3.setErrorReporter(this.errorReporter);
        this.bindablesMap.put(4, bindableNodeManager3);
        BindableNodeManager bindableNodeManager4 = new BindableNodeManager();
        bindableNodeManager4.setVRMLClock(vRMLClock);
        bindableNodeManager4.setErrorReporter(this.errorReporter);
        this.bindablesMap.put(18, bindableNodeManager4);
        this.terrainManager = new TerrainSectorManager();
        if (this.sensorManager != null) {
            this.sensorManager.setNavigationStacks(bindableNodeManager, bindableNodeManager2, bindableNodeManager3, bindableNodeManager4);
            this.sensorManager.setTerrainSectorManager(this.terrainManager);
        }
    }

    public void shutdown() {
        int n;
        this.shutdownNow = true;
        for (n = 0; n < this.numPreEventManagers; ++n) {
            this.preEventManagers[n].clear();
            this.preEventManagers[n].shutdown();
        }
        for (n = 0; n < this.numPostEventManagers; ++n) {
            this.postEventManagers[n].clear();
            this.postEventManagers[n].shutdown();
        }
        this.viewpointManager.shutdown();
    }

    public void setDefaultBindables(VRMLViewpointNodeType vRMLViewpointNodeType, VRMLNavigationInfoNodeType vRMLNavigationInfoNodeType, VRMLBackgroundNodeType vRMLBackgroundNodeType, VRMLFogNodeType vRMLFogNodeType) {
        this.defaultViewpoint = vRMLViewpointNodeType;
        this.defaultNavInfo = vRMLNavigationInfoNodeType;
        this.defaultBackground = vRMLBackgroundNodeType;
        this.defaultFog = vRMLFogNodeType;
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        int n;
        this.errorReporter = errorReporter;
        if (errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
        this.scriptManager.setErrorReporter(this.errorReporter);
        this.routeManager.setErrorReporter(this.errorReporter);
        this.sensorManager.setErrorReporter(this.errorReporter);
        this.stateManager.setErrorReporter(this.errorReporter);
        this.contentLoader.setErrorReporter(this.errorReporter);
        this.viewpointManager.setErrorReporter(this.errorReporter);
        int[] nArray = this.bindablesMap.keySet();
        for (n = 0; n < nArray.length; ++n) {
            BindableNodeManager bindableNodeManager = (BindableNodeManager)this.bindablesMap.get(nArray[n]);
            bindableNodeManager.setErrorReporter(this.errorReporter);
        }
        for (n = 0; n < this.numPreEventManagers; ++n) {
            this.preEventManagers[n].setErrorReporter(this.errorReporter);
        }
        for (n = 0; n < this.numPostEventManagers; ++n) {
            this.postEventManagers[n].setErrorReporter(this.errorReporter);
        }
    }

    public BindableNodeManager getBindableManager(int n) {
        BindableNodeManager bindableNodeManager = (BindableNodeManager)this.bindablesMap.get(n);
        if (bindableNodeManager == null) {
            bindableNodeManager = new BindableNodeManager();
            bindableNodeManager.setErrorReporter(this.errorReporter);
            bindableNodeManager.setVRMLClock(this.sensorManager.getVRMLClock());
            this.bindablesMap.put(n, bindableNodeManager);
        }
        return bindableNodeManager;
    }

    public VRMLClock getVRMLClock() {
        return this.sensorManager.getVRMLClock();
    }

    public void addExternalView(ExternalView externalView) {
        if (!this.externalViews.contains(externalView)) {
            this.externalViews.add(externalView);
        }
    }

    public void removeExternalView(ExternalView externalView) {
        this.externalViews.remove(externalView);
    }

    public void setScene(VRMLScene vRMLScene, String string) {
        this.sceneToLoad = vRMLScene;
        this.initialViewpoint = string;
    }

    private void finishSetScene(double d) {
        if (this.active) {
            this.clear();
        }
        this.currentScene = this.sceneToLoad;
        this.sceneToLoad = null;
        if (this.currentScene == null) {
            this.active = false;
            return;
        }
        this.rootSpace = (VRMLExecutionSpace)((Object)this.currentScene.getRootNode());
        ((VRMLNodeType)((Object)this.rootSpace)).setFrameStateManager(this.stateManager);
        SceneMetaData sceneMetaData = this.currentScene.getMetaData();
        if (sceneMetaData.isVrmlSpec()) {
            this.loadVRMLScripts(this.rootSpace, this.currentScene, this.currentScene);
        } else {
            this.loadX3DScene(this.rootSpace, this.currentScene);
        }
        this.routeManager.updateSpaces();
        this.routeManager.updateRoutes();
        this.active = true;
        this.initialWorldLoadComplete = this.justStarted = this.scriptToSceneMap.size() == 0;
    }

    public void clear() {
        int n;
        this.active = false;
        this.scriptManager.shutdown();
        this.routeManager.clear();
        this.sensorManager.clear();
        this.stateManager.clear();
        this.contentLoader.clear();
        this.viewpointManager.clear();
        this.scriptToSceneMap.clear();
        this.sceneToScriptListMap.clear();
        int[] nArray = this.bindablesMap.keySet();
        for (n = 0; n < nArray.length; ++n) {
            BindableNodeManager bindableNodeManager = (BindableNodeManager)this.bindablesMap.get(nArray[n]);
            bindableNodeManager.clearAll();
        }
        for (n = 0; n < this.numPreEventManagers; ++n) {
            this.preEventManagers[n].clear();
        }
        for (n = 0; n < this.numPostEventManagers; ++n) {
            this.postEventManagers[n].clear();
        }
        this.currentScene = null;
        this.rootSpace = null;
    }

    public void evaluate(long l) {
        this.lastTime = l;
        if (this.sceneToLoad != null) {
            if (this.initListener != null) {
                this.initListener.changeWorld();
            }
            this.finishSetScene(l);
            return;
        }
        if (!this.active) {
            return;
        }
        if (!this.initialWorldLoadComplete) {
            this.evaluateTimeZero(l);
        } else {
            if (this.justStarted) {
                int n;
                if (this.initListener != null) {
                    try {
                        this.initListener.worldInitComplete();
                    }
                    catch (Exception exception) {
                        this.errorReporter.warningReport("Error sending core init", exception);
                    }
                }
                for (n = 0; n < this.numPreEventManagers; ++n) {
                    this.preEventManagers[n].resetTimeZero();
                }
                for (n = 0; n < this.numPostEventManagers; ++n) {
                    this.postEventManagers[n].resetTimeZero();
                }
                this.justStarted = false;
            }
            this.evaluateRunning(l);
        }
    }

    public void setInitListener(EventModelInitListener eventModelInitListener) {
        this.initListener = eventModelInitListener;
    }

    public SensorManager getSensorManager() {
        return this.sensorManager;
    }

    public ScriptManager getScriptManager() {
        return this.scriptManager;
    }

    public RouteManager getRouteManager() {
        return this.routeManager;
    }

    public ExternalLoadManager getContentLoader() {
        return this.contentLoader;
    }

    public FrameStateManager getFrameStateManager() {
        return this.stateManager;
    }

    public NodeManager[] getNodeManagers() {
        int n;
        int n2 = this.numPreEventManagers + this.numPostEventManagers;
        if (n2 == 0) {
            return null;
        }
        NodeManager[] nodeManagerArray = new NodeManager[n2];
        int n3 = 0;
        for (n = 0; n < this.numPreEventManagers; ++n) {
            nodeManagerArray[n3++] = this.preEventManagers[n];
        }
        for (n = 0; n < this.numPostEventManagers; ++n) {
            nodeManagerArray[n3++] = this.postEventManagers[n];
        }
        return nodeManagerArray;
    }

    private void evaluateTimeZero(long l) {
        this.processScripts();
        if (this.shutdownNow) {
            return;
        }
        this.processViewpoints(l);
        if (this.scriptToSceneMap.size() != 0) {
            return;
        }
        this.scriptManager.initializeScripts(l);
        if (this.shutdownNow) {
            return;
        }
        this.scriptManager.processEvents();
        if (this.shutdownNow) {
            return;
        }
        this.routeManager.processRoutes((double)l * 0.001);
        if (this.shutdownNow) {
            return;
        }
        this.routeManager.updateSpaces();
        if (this.shutdownNow) {
            return;
        }
        NodeArray nodeArray = this.stateManager.getAddedUrlNodes();
        if (this.shutdownNow) {
            return;
        }
        this.contentLoader.queueNodesLoad(nodeArray);
        if (this.shutdownNow) {
            return;
        }
        this.processBindables();
        if (this.shutdownNow) {
            return;
        }
        this.routeManager.updateRoutes();
        if (this.shutdownNow) {
            return;
        }
        this.sensorManager.addSensors(this.stateManager.getAddedSensors());
        if (this.shutdownNow) {
            return;
        }
        this.sensorManager.addViewDependentNodes(this.stateManager.getAddedViewDependents());
        if (this.shutdownNow) {
            return;
        }
        this.scriptManager.addScripts(this.stateManager.getAddedScripts());
        if (this.shutdownNow) {
            return;
        }
        this.processTerrains();
        if (this.shutdownNow) {
            return;
        }
        this.stateManager.clearRemovedNodes();
        this.stateManager.clearAddedNodes();
        if (this.shutdownNow) {
            return;
        }
        this.stateManager.frameFinished();
        this.justStarted = true;
        this.initialWorldLoadComplete = true;
    }

    private void evaluateRunning(long l) {
        Object object;
        int n;
        this.processViewpoints(l);
        this.externalSyncNodes.remove(this.stateManager.getRemovedExtSynchronizedNodes());
        if (this.shutdownNow) {
            return;
        }
        this.externalSyncNodes.add(this.stateManager.getAddedExtSynchronizedNodes());
        if (this.shutdownNow) {
            return;
        }
        this.processSynchronisedNodes(true);
        if (this.shutdownNow) {
            return;
        }
        this.sensorManager.processUserInput(l);
        if (this.shutdownNow) {
            return;
        }
        this.processPreEventManagers(l);
        if (this.shutdownNow) {
            return;
        }
        for (int i = 0; i < this.externalViews.size(); ++i) {
            ExternalView externalView = (ExternalView)this.externalViews.get(i);
            if (this.shutdownNow) {
                return;
            }
            externalView.processEvents();
        }
        if (this.shutdownNow) {
            return;
        }
        double d = (double)l * 0.001;
        this.scriptManager.prepareEvents(d);
        if (this.shutdownNow) {
            return;
        }
        this.routeManager.processRoutes(d);
        if (this.shutdownNow) {
            return;
        }
        this.scriptManager.processEvents();
        if (this.shutdownNow) {
            return;
        }
        this.loadScenes(this.stateManager.getAddedScenes());
        if (this.shutdownNow) {
            return;
        }
        this.stateManager.clearAddedScenes();
        if (this.shutdownNow) {
            return;
        }
        NodeArray nodeArray = this.stateManager.getAddedUrlNodes();
        if (this.shutdownNow) {
            return;
        }
        this.contentLoader.queueNodesLoad(nodeArray);
        if (this.shutdownNow) {
            return;
        }
        NodeTemplateArray nodeTemplateArray = this.stateManager.getAddedExternProtos();
        if (this.shutdownNow) {
            return;
        }
        if (nodeTemplateArray.size() != 0) {
            int n2 = nodeTemplateArray.size();
            for (n = 0; n < n2; ++n) {
                object = (VRMLExternProtoDeclare)nodeTemplateArray.get(n);
                if (this.shutdownNow) {
                    return;
                }
                this.contentLoader.queueExternProtoLoad((VRMLExternProtoDeclare)object);
            }
        }
        do {
            this.scriptManager.shutdownActiveScripts();
            if (this.shutdownNow) {
                return;
            }
            this.scriptManager.removeScripts(this.stateManager.getRemovedScripts());
            if (this.shutdownNow) {
                return;
            }
            ObjectArray objectArray = this.stateManager.getRemovedScenes();
            n = objectArray.size();
            for (int i = 0; i < n; ++i) {
                object = (VRMLExecutionSpace)objectArray.get(i);
                this.removeScene((VRMLExecutionSpace)object);
            }
            if (this.shutdownNow) {
                return;
            }
            this.sensorManager.removeSensors(this.stateManager.getRemovedSensors());
            if (this.shutdownNow) {
                return;
            }
            this.sensorManager.removeViewDependentNodes(this.stateManager.getRemovedViewDependents());
            if (this.shutdownNow) {
                return;
            }
            this.routeManager.updateSpaces();
            if (this.shutdownNow) {
                return;
            }
            this.processBindables();
            if (this.shutdownNow) {
                return;
            }
            this.routeManager.updateRoutes();
            if (this.shutdownNow) {
                return;
            }
            this.sensorManager.addSensors(this.stateManager.getAddedSensors());
            if (this.shutdownNow) {
                return;
            }
            this.sensorManager.addViewDependentNodes(this.stateManager.getAddedViewDependents());
            if (this.shutdownNow) {
                return;
            }
            this.scriptManager.eventsProcessed();
            if (this.shutdownNow) {
                return;
            }
            this.processScripts();
            if (this.shutdownNow) {
                return;
            }
            this.scriptManager.addScripts(this.stateManager.getAddedScripts());
            if (this.shutdownNow) {
                return;
            }
            this.scriptManager.initializeScripts(l);
            if (this.shutdownNow) {
                return;
            }
            this.processTerrains();
            if (this.shutdownNow) {
                return;
            }
            this.stateManager.clearRemovedNodes();
            this.stateManager.clearAddedNodes();
            if (!this.shutdownNow) continue;
            return;
        } while (this.routeManager.processRoutes(d));
        if (this.shutdownNow) {
            return;
        }
        this.processPostEventManagers(l);
        if (this.shutdownNow) {
            return;
        }
        this.stateManager.frameFinished();
        if (this.shutdownNow) {
            return;
        }
        this.sensorManager.updateViewMatrix();
        if (this.shutdownNow) {
            return;
        }
        this.processSynchronisedNodes(false);
    }

    private void processViewpoints(long l) {
        VRMLNodeType vRMLNodeType;
        int n;
        NodeArray nodeArray = this.stateManager.getRemovedNodes(55);
        int n2 = nodeArray.size();
        for (n = 0; n < n2; ++n) {
            vRMLNodeType = (VRMLNodeType)nodeArray.get(n);
            this.viewpointManager.removeManagedNode(vRMLNodeType);
        }
        nodeArray = this.stateManager.getAddedNodes(55);
        n2 = nodeArray.size();
        for (n = 0; n < n2; ++n) {
            vRMLNodeType = (VRMLNodeType)nodeArray.get(n);
            this.viewpointManager.addManagedNode(vRMLNodeType);
        }
        this.viewpointManager.updateViewpoint(l);
    }

    private void processBindables() {
        BindableNodeManager bindableNodeManager;
        VRMLNode vRMLNode;
        int n;
        NodeArray nodeArray = this.stateManager.getRemovedBindables();
        int n2 = nodeArray.size();
        for (n = 0; n < n2; ++n) {
            vRMLNode = nodeArray.get(n);
            bindableNodeManager = (BindableNodeManager)this.bindablesMap.get(vRMLNode.getPrimaryType());
            if (bindableNodeManager == null) {
                this.errorReporter.warningReport("attempting to remove a bindable node that has no manager", null);
                continue;
            }
            bindableNodeManager.removeNode((VRMLBindableNodeType)vRMLNode);
        }
        if (this.shutdownNow) {
            return;
        }
        nodeArray = this.stateManager.getAddedBindables();
        n2 = nodeArray.size();
        for (n = 0; n < n2; ++n) {
            vRMLNode = nodeArray.get(n);
            bindableNodeManager = this.getBindableManager(vRMLNode.getPrimaryType());
            if (this.shutdownNow) {
                return;
            }
            bindableNodeManager.addNode((VRMLBindableNodeType)vRMLNode, false);
        }
    }

    private void processPreEventManagers(long l) {
        for (int i = 0; i < this.numPreEventManagers; ++i) {
            int[] nArray = this.preEventManagers[i].getManagedNodeTypes();
            if (this.shutdownNow) {
                return;
            }
            for (int j = 0; j < nArray.length; ++j) {
                VRMLNodeType vRMLNodeType;
                int n;
                NodeArray nodeArray = this.stateManager.getRemovedNodes(nArray[j]);
                int n2 = nodeArray.size();
                for (n = 0; n < n2; ++n) {
                    vRMLNodeType = (VRMLNodeType)nodeArray.get(n);
                    this.preEventManagers[i].removeManagedNode(vRMLNodeType);
                }
                if (this.shutdownNow) {
                    return;
                }
                nodeArray = this.stateManager.getAddedNodes(nArray[j]);
                n2 = nodeArray.size();
                for (n = 0; n < n2; ++n) {
                    vRMLNodeType = (VRMLNodeType)nodeArray.get(n);
                    this.preEventManagers[i].addManagedNode(vRMLNodeType);
                }
            }
            if (this.shutdownNow) {
                return;
            }
            this.preEventManagers[i].executePreEventModel(l);
        }
    }

    private void processPostEventManagers(long l) {
        for (int i = 0; i < this.numPostEventManagers; ++i) {
            int[] nArray = this.postEventManagers[i].getManagedNodeTypes();
            if (this.shutdownNow) {
                return;
            }
            for (int j = 0; j < nArray.length; ++j) {
                VRMLNodeType vRMLNodeType;
                int n;
                NodeArray nodeArray = this.stateManager.getRemovedNodes(nArray[j]);
                int n2 = nodeArray.size();
                for (n = 0; n < n2; ++n) {
                    vRMLNodeType = (VRMLNodeType)nodeArray.get(n);
                    this.postEventManagers[i].removeManagedNode(vRMLNodeType);
                }
                if (this.shutdownNow) {
                    return;
                }
                nodeArray = this.stateManager.getAddedNodes(nArray[j]);
                n2 = nodeArray.size();
                for (n = 0; n < n2; ++n) {
                    vRMLNodeType = (VRMLNodeType)nodeArray.get(n);
                    this.postEventManagers[i].addManagedNode(vRMLNodeType);
                }
                if (!this.shutdownNow) continue;
                return;
            }
            if (this.shutdownNow) {
                return;
            }
            this.postEventManagers[i].executePostEventModel(l);
        }
    }

    private void processTerrains() {
        VRMLNode vRMLNode;
        int n;
        NodeArray nodeArray = this.stateManager.getRemovedTerrains();
        int n2 = nodeArray.size();
        for (n = 0; n < n2; ++n) {
            vRMLNode = nodeArray.get(n);
            this.terrainManager.removeSector((VRMLTerrainSource)((Object)vRMLNode));
        }
        nodeArray = this.stateManager.getAddedTerrains();
        n2 = nodeArray.size();
        for (n = 0; n < n2; ++n) {
            vRMLNode = nodeArray.get(n);
            this.terrainManager.addSector((VRMLTerrainSource)((Object)vRMLNode));
        }
    }

    private void processScripts() {
        if (this.scriptToSceneMap.size() == 0) {
            return;
        }
        this.scriptManager.getProcessedScripts(this.tmpArray);
        if (this.shutdownNow) {
            return;
        }
        int n = this.tmpArray.size();
        for (int i = 0; i < n; ++i) {
            VRMLScriptNodeType vRMLScriptNodeType = (VRMLScriptNodeType)this.tmpArray.get(i);
            BasicScene basicScene = (BasicScene)this.scriptToSceneMap.get(vRMLScriptNodeType);
            if (this.shutdownNow) {
                return;
            }
            if (basicScene == null) continue;
            this.scriptToSceneMap.remove(vRMLScriptNodeType);
            HashSet hashSet = (HashSet)this.sceneToScriptListMap.get(basicScene);
            if (!hashSet.contains(vRMLScriptNodeType)) {
                System.out.println("processScripts.invalid mapping happened!");
                continue;
            }
            if (this.shutdownNow) {
                return;
            }
            if (hashSet.size() == 1) {
                this.completeVRMLSceneLoad(basicScene);
                this.sceneToScriptListMap.remove(basicScene);
                continue;
            }
            hashSet.remove(vRMLScriptNodeType);
        }
        this.tmpArray.clear();
    }

    private void loadScenes(ObjectArray objectArray) {
        int n = objectArray.size();
        for (int i = 0; i < n; ++i) {
            VRMLExecutionSpace vRMLExecutionSpace = (VRMLExecutionSpace)objectArray.get(i);
            BasicScene basicScene = vRMLExecutionSpace.getContainedScene();
            if (basicScene instanceof VRMLScene) {
                VRMLScene vRMLScene = (VRMLScene)basicScene;
                SceneMetaData sceneMetaData = vRMLScene.getMetaData();
                if (sceneMetaData.isVrmlSpec()) {
                    this.loadVRMLScripts(vRMLExecutionSpace, vRMLScene, vRMLScene);
                } else {
                    this.loadX3DScene(vRMLExecutionSpace, vRMLScene);
                }
            } else {
                this.loadX3DScene(vRMLExecutionSpace, basicScene);
            }
            if (!this.shutdownNow) continue;
            return;
        }
    }

    private void completeVRMLSceneLoad(BasicScene basicScene) {
        Object object;
        VRMLNodeType vRMLNodeType;
        int n;
        ArrayList arrayList = basicScene.getBySecondaryType(5);
        int n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            vRMLNodeType = (VRMLNodeType)arrayList.get(n);
            object = this.getBindableManager(vRMLNodeType.getPrimaryType());
            ((BindableNodeManager)object).addNode((VRMLBindableNodeType)vRMLNodeType, false);
        }
        if (this.shutdownNow) {
            return;
        }
        this.contentLoader.queueSceneLoad(basicScene);
        if (this.shutdownNow) {
            return;
        }
        arrayList = basicScene.getByPrimaryType(38);
        n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            vRMLNodeType = (VRMLProtoInstance)arrayList.get(n);
            object = vRMLNodeType.getContainedScene();
            if (this.shutdownNow) {
                return;
            }
            this.completeVRMLSceneLoad((BasicScene)object);
        }
        if (this.shutdownNow) {
            return;
        }
        if (this.currentScene == basicScene) {
            this.initialBind();
        }
    }

    private void loadVRMLScripts(VRMLExecutionSpace vRMLExecutionSpace, VRMLScene vRMLScene, BasicScene basicScene) {
        ArrayList arrayList = basicScene.getByPrimaryType(41);
        int n = arrayList.size();
        if (n != 0) {
            this.checkTmpArray(n);
            arrayList.toArray(this.tmpNodes);
            this.tmpArray.add(this.tmpNodes, 0, n);
            this.scriptManager.addScripts(this.tmpArray);
            this.tmpArray.clear();
            HashSet hashSet = (HashSet)this.sceneToScriptListMap.get(vRMLScene);
            if (hashSet == null) {
                hashSet = new HashSet(n);
                this.sceneToScriptListMap.put(vRMLScene, hashSet);
            }
            for (int i = 0; i < n; ++i) {
                hashSet.add(this.tmpNodes[i]);
                this.scriptToSceneMap.put(this.tmpNodes[i], vRMLScene);
            }
        } else {
            this.completeVRMLSceneLoad(basicScene);
        }
        if (this.shutdownNow) {
            return;
        }
        this.routeManager.addSpace(vRMLExecutionSpace);
        if (this.shutdownNow) {
            return;
        }
        this.sensorManager.loadScene(basicScene);
        if (this.shutdownNow) {
            return;
        }
        arrayList = basicScene.getByPrimaryType(38);
        n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            VRMLProtoInstance vRMLProtoInstance = (VRMLProtoInstance)arrayList.get(i);
            if (vRMLProtoInstance.getImplementationNode() == null) continue;
            if (this.shutdownNow) {
                return;
            }
            BasicScene basicScene2 = vRMLProtoInstance.getContainedScene();
            this.loadVRMLScripts(vRMLProtoInstance, vRMLScene, basicScene2);
        }
    }

    private void loadX3DScene(VRMLExecutionSpace vRMLExecutionSpace, BasicScene basicScene) {
        VRMLProtoInstance vRMLProtoInstance;
        VRMLNodeType vRMLNodeType;
        int n;
        ArrayList arrayList;
        Object object;
        int n2;
        ArrayList arrayList2 = basicScene.getByPrimaryType(41);
        int n3 = arrayList2.size();
        if (n3 != 0) {
            this.checkTmpArray(n3);
            arrayList2.toArray(this.tmpNodes);
            this.tmpArray.add(this.tmpNodes, 0, n3);
            this.scriptManager.addScripts(this.tmpArray);
            this.tmpArray.clear();
        }
        if (this.shutdownNow) {
            return;
        }
        arrayList2 = basicScene.getBySecondaryType(5);
        n3 = arrayList2.size();
        for (n2 = 0; n2 < n3; ++n2) {
            object = (VRMLNodeType)arrayList2.get(n2);
            BindableNodeManager bindableNodeManager = this.getBindableManager(object.getPrimaryType());
            bindableNodeManager.addNode((VRMLBindableNodeType)object, false);
        }
        if (this.shutdownNow) {
            return;
        }
        arrayList2 = basicScene.getBySecondaryType(74);
        n3 = arrayList2.size();
        for (n2 = 0; n2 < n3; ++n2) {
            object = (VRMLNodeType)arrayList2.get(n2);
            this.externalSyncNodes.add((VRMLNode)object);
        }
        for (n2 = 0; n2 < this.numPreEventManagers; ++n2) {
            object = this.preEventManagers[n2].getManagedNodeTypes();
            if (this.shutdownNow) {
                return;
            }
            for (int i = 0; i < ((Object)object).length; ++i) {
                arrayList = basicScene.getByPrimaryType((int)object[i]);
                if (this.shutdownNow) {
                    return;
                }
                n3 = arrayList.size();
                for (n = 0; n < n3; ++n) {
                    vRMLNodeType = (VRMLNodeType)arrayList.get(n);
                    if (this.shutdownNow) {
                        return;
                    }
                    if (vRMLNodeType.getPrimaryType() == 38) {
                        vRMLProtoInstance = (VRMLProtoInstance)vRMLNodeType;
                        vRMLNodeType = vRMLProtoInstance.getImplementationNode();
                        while (vRMLNodeType != null && vRMLNodeType instanceof VRMLProtoInstance) {
                            vRMLNodeType = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
                        }
                    }
                    if (this.shutdownNow) {
                        return;
                    }
                    if (vRMLNodeType == null) continue;
                    this.preEventManagers[n2].addManagedNode(vRMLNodeType);
                }
            }
        }
        for (n2 = 0; n2 < this.numPostEventManagers; ++n2) {
            object = this.postEventManagers[n2].getManagedNodeTypes();
            if (this.shutdownNow) {
                return;
            }
            for (int i = 0; i < ((Object)object).length; ++i) {
                arrayList = basicScene.getByPrimaryType((int)object[i]);
                if (this.shutdownNow) {
                    return;
                }
                n3 = arrayList.size();
                for (n = 0; n < n3; ++n) {
                    vRMLNodeType = (VRMLNodeType)arrayList.get(n);
                    if (this.shutdownNow) {
                        return;
                    }
                    if (vRMLNodeType.getPrimaryType() == 38) {
                        vRMLProtoInstance = (VRMLProtoInstance)vRMLNodeType;
                        vRMLNodeType = vRMLProtoInstance.getImplementationNode();
                        while (vRMLNodeType != null && vRMLNodeType instanceof VRMLProtoInstance) {
                            vRMLNodeType = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
                        }
                    }
                    if (this.shutdownNow) {
                        return;
                    }
                    if (vRMLNodeType == null) continue;
                    this.postEventManagers[n2].addManagedNode(vRMLNodeType);
                }
            }
        }
        this.contentLoader.queueSceneLoad(basicScene);
        if (this.shutdownNow) {
            return;
        }
        this.routeManager.addSpace(vRMLExecutionSpace);
        if (this.shutdownNow) {
            return;
        }
        this.sensorManager.loadScene(basicScene);
        if (this.shutdownNow) {
            return;
        }
        arrayList2 = basicScene.getByPrimaryType(38);
        n3 = arrayList2.size();
        for (n2 = 0; n2 < n3; ++n2) {
            object = (VRMLProtoInstance)arrayList2.get(n2);
            if (object.getImplementationNode() == null) continue;
            BasicScene basicScene2 = object.getContainedScene();
            if (this.shutdownNow) {
                return;
            }
            this.loadX3DScene((VRMLExecutionSpace)object, basicScene2);
        }
        if (this.shutdownNow) {
            return;
        }
        if (this.currentScene == basicScene) {
            this.initialBind();
        }
    }

    private void checkTmpArray(int n) {
        if (this.tmpNodes.length < n) {
            int n2;
            for (n2 = this.tmpNodes.length + 8; n2 < n; n2 += 8) {
            }
            this.tmpNodes = new VRMLNodeType[n2];
        }
    }

    private void initialBind() {
        VRMLNodeType vRMLNodeType;
        VRMLNodeType vRMLNodeType2;
        VRMLViewpointNodeType vRMLViewpointNodeType;
        Object object;
        double d = (double)this.lastTime * 0.001;
        BindableNodeManager bindableNodeManager = this.getBindableManager(55);
        BindableNodeManager bindableNodeManager2 = this.getBindableManager(31);
        BindableNodeManager bindableNodeManager3 = this.getBindableManager(4);
        BindableNodeManager bindableNodeManager4 = this.getBindableManager(18);
        bindableNodeManager.addNode(this.defaultViewpoint, true);
        bindableNodeManager2.addNode(this.defaultNavInfo, true);
        bindableNodeManager3.addNode(this.defaultBackground, true);
        bindableNodeManager4.addNode((VRMLBindableNodeType)((Object)this.defaultFog), true);
        if (this.initialViewpoint != null) {
            object = this.currentScene.getDEFNodes();
            VRMLNodeType vRMLNodeType3 = (VRMLNodeType)object.get(this.initialViewpoint);
            if (vRMLNodeType3 instanceof VRMLViewpointNodeType) {
                vRMLViewpointNodeType = (VRMLViewpointNodeType)vRMLNodeType3;
            } else if (vRMLNodeType3 instanceof VRMLProtoInstance) {
                vRMLNodeType2 = (VRMLProtoInstance)vRMLNodeType3;
                vRMLNodeType = vRMLNodeType2.getImplementationNode();
                if (vRMLNodeType instanceof VRMLViewpointNodeType) {
                    vRMLViewpointNodeType = (VRMLViewpointNodeType)vRMLNodeType;
                } else {
                    this.errorReporter.warningReport("Proto instance referenced by " + this.initialViewpoint + " is not a " + "viewpoint node type. Using " + "normal default behaviour", null);
                    vRMLViewpointNodeType = (VRMLViewpointNodeType)bindableNodeManager.getFirstNode();
                }
            } else {
                this.errorReporter.warningReport("DEF name " + this.initialViewpoint + " does not describe a viewpoint. " + "Using the normal default behaviour", null);
                vRMLViewpointNodeType = (VRMLViewpointNodeType)bindableNodeManager.getFirstNode();
            }
        } else {
            vRMLViewpointNodeType = (VRMLViewpointNodeType)bindableNodeManager.getFirstNode();
        }
        object = (VRMLNavigationInfoNodeType)bindableNodeManager2.getFirstNode();
        vRMLNodeType2 = (VRMLBackgroundNodeType)bindableNodeManager3.getFirstNode();
        vRMLNodeType = (VRMLFogNodeType)((Object)bindableNodeManager4.getFirstNode());
        object.setBind(true, true, d);
        vRMLViewpointNodeType.setBind(true, true, d);
        vRMLNodeType2.setBind(true, true, d);
        ((VRMLBindableNodeType)vRMLNodeType).setBind(true, true, d);
    }

    private void processSynchronisedNodes(boolean bl) {
        int n = this.externalSyncNodes.size();
        if (n == 0) {
            return;
        }
        if (bl) {
            for (int i = 0; i < n; ++i) {
                try {
                    VRMLExternalSynchronizedNodeType vRMLExternalSynchronizedNodeType = (VRMLExternalSynchronizedNodeType)this.externalSyncNodes.get(i);
                    vRMLExternalSynchronizedNodeType.preEventEvaluation();
                    continue;
                }
                catch (Exception exception) {
                    this.errorReporter.errorReport(SYNCH_START_MSG, exception);
                }
            }
        } else {
            for (int i = 0; i < n; ++i) {
                try {
                    VRMLExternalSynchronizedNodeType vRMLExternalSynchronizedNodeType = (VRMLExternalSynchronizedNodeType)this.externalSyncNodes.get(i);
                    vRMLExternalSynchronizedNodeType.postEventEvaluation();
                    continue;
                }
                catch (Exception exception) {
                    this.errorReporter.errorReport(SYNCH_STOP_MSG, exception);
                }
            }
        }
    }

    private void removeScene(VRMLExecutionSpace vRMLExecutionSpace) {
        VRMLProtoInstance vRMLProtoInstance;
        VRMLNodeType vRMLNodeType;
        int n;
        ArrayList arrayList;
        Object object;
        int n2;
        BasicScene basicScene = vRMLExecutionSpace.getContainedScene();
        ArrayList arrayList2 = basicScene.getByPrimaryType(41);
        int n3 = arrayList2.size();
        if (n3 != 0) {
            this.checkTmpArray(n3);
            arrayList2.toArray(this.tmpNodes);
            this.tmpArray.add(this.tmpNodes, 0, n3);
            this.scriptManager.removeScripts(this.tmpArray);
            this.tmpArray.clear();
        }
        arrayList2 = basicScene.getBySecondaryType(5);
        n3 = arrayList2.size();
        for (n2 = 0; n2 < n3; ++n2) {
            object = (VRMLNodeType)arrayList2.get(n2);
            BindableNodeManager bindableNodeManager = this.getBindableManager(object.getPrimaryType());
            bindableNodeManager.removeNode((VRMLBindableNodeType)object);
        }
        arrayList2 = basicScene.getBySecondaryType(74);
        n3 = arrayList2.size();
        for (n2 = 0; n2 < n3; ++n2) {
            object = (VRMLNodeType)arrayList2.get(n2);
            this.externalSyncNodes.remove((VRMLNode)object);
        }
        for (n2 = 0; n2 < this.numPreEventManagers; ++n2) {
            object = this.preEventManagers[n2].getManagedNodeTypes();
            for (int i = 0; i < ((Object)object).length; ++i) {
                arrayList = basicScene.getByPrimaryType((int)object[i]);
                n3 = arrayList.size();
                for (n = 0; n < n3; ++n) {
                    vRMLNodeType = (VRMLNodeType)arrayList.get(n);
                    if (this.shutdownNow) {
                        return;
                    }
                    if (vRMLNodeType.getPrimaryType() == 38) {
                        vRMLProtoInstance = (VRMLProtoInstance)vRMLNodeType;
                        vRMLNodeType = vRMLProtoInstance.getImplementationNode();
                        while (vRMLNodeType != null && vRMLNodeType instanceof VRMLProtoInstance) {
                            vRMLNodeType = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
                        }
                    }
                    if (this.shutdownNow) {
                        return;
                    }
                    if (vRMLNodeType == null) continue;
                    this.preEventManagers[n2].removeManagedNode(vRMLNodeType);
                }
            }
        }
        for (n2 = 0; n2 < this.numPostEventManagers; ++n2) {
            object = this.postEventManagers[n2].getManagedNodeTypes();
            if (this.shutdownNow) {
                return;
            }
            for (int i = 0; i < ((Object)object).length; ++i) {
                arrayList = basicScene.getByPrimaryType((int)object[i]);
                if (this.shutdownNow) {
                    return;
                }
                n3 = arrayList.size();
                for (n = 0; n < n3; ++n) {
                    vRMLNodeType = (VRMLNodeType)arrayList.get(n);
                    if (this.shutdownNow) {
                        return;
                    }
                    if (vRMLNodeType.getPrimaryType() == 38) {
                        vRMLProtoInstance = (VRMLProtoInstance)vRMLNodeType;
                        vRMLNodeType = vRMLProtoInstance.getImplementationNode();
                        while (vRMLNodeType != null && vRMLNodeType instanceof VRMLProtoInstance) {
                            vRMLNodeType = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
                        }
                    }
                    if (this.shutdownNow) {
                        return;
                    }
                    if (vRMLNodeType == null) continue;
                    this.postEventManagers[n2].removeManagedNode(vRMLNodeType);
                }
            }
        }
        this.routeManager.removeSpace(vRMLExecutionSpace);
        this.sensorManager.unloadScene(basicScene);
        arrayList2 = basicScene.getByPrimaryType(38);
        n3 = arrayList2.size();
        for (n2 = 0; n2 < n3; ++n2) {
            object = (VRMLProtoInstance)arrayList2.get(n2);
            if (object.getImplementationNode() == null) continue;
            this.removeScene((VRMLExecutionSpace)object);
        }
        if (this.shutdownNow) {
            return;
        }
        if (this.currentScene == basicScene) {
            this.initialBind();
        }
    }
}

