/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.nodes.runtime;

import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLViewpointNodeType;
import org.web3d.vrml.nodes.runtime.ViewpointManager;
import org.web3d.vrml.util.NodeArray;

public class GeneralisedViewpointManager
implements ViewpointManager {
    private static final int[] MANAGED_NODE_TYPES = new int[]{55};
    private ErrorReporter errorReporter;
    private NodeArray viewpoints = new NodeArray();
    private VRMLViewpointNodeType nextViewpoint;
    private VRMLViewpointNodeType currentViewpoint;

    public GeneralisedViewpointManager() {
        this.errorReporter = DefaultErrorReporter.getDefaultReporter();
    }

    public void updateViewpoint(long l) {
        if (this.nextViewpoint != null) {
            this.nextViewpoint.setBind(true, true, l);
            this.currentViewpoint = this.nextViewpoint;
            this.nextViewpoint = null;
        }
    }

    public void shutdown() {
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
    }

    public void setViewpoint(VRMLViewpointNodeType vRMLViewpointNodeType) {
        this.nextViewpoint = vRMLViewpointNodeType;
    }

    public void firstViewpoint() {
        if (this.viewpoints.size() != 0) {
            this.nextViewpoint = (VRMLViewpointNodeType)this.viewpoints.get(0);
        }
    }

    public void lastViewpoint() {
        int n = this.viewpoints.size();
        if (n != 0) {
            this.nextViewpoint = (VRMLViewpointNodeType)this.viewpoints.get(n - 1);
        }
    }

    public void nextViewpoint() {
        if (this.viewpoints.size() < 2) {
            return;
        }
        int n = this.viewpoints.indexOf(this.currentViewpoint);
        if (n != -1) {
            this.nextViewpoint = n != this.viewpoints.size() - 1 ? (VRMLViewpointNodeType)this.viewpoints.get(n + 1) : (VRMLViewpointNodeType)this.viewpoints.get(0);
        }
    }

    public void previousViewpoint() {
        if (this.viewpoints.size() < 2) {
            return;
        }
        int n = this.viewpoints.indexOf(this.currentViewpoint);
        if (n != -1) {
            this.nextViewpoint = n != 0 ? (VRMLViewpointNodeType)this.viewpoints.get(n - 1) : (VRMLViewpointNodeType)this.viewpoints.get(this.viewpoints.size() - 1);
        }
    }

    public void addManagedNode(VRMLNodeType vRMLNodeType) {
        if (!(vRMLNodeType instanceof VRMLViewpointNodeType)) {
            this.errorReporter.warningReport("Non-Viewpoint node added to the manager", null);
            return;
        }
        this.viewpoints.add(vRMLNodeType);
    }

    public void removeManagedNode(VRMLNodeType vRMLNodeType) {
        if (!(vRMLNodeType instanceof VRMLViewpointNodeType)) {
            this.errorReporter.warningReport("Non-Viewpoint node removed from the manager", null);
            return;
        }
        this.viewpoints.remove(vRMLNodeType);
    }

    public void clear() {
        this.viewpoints.clear();
    }
}

