/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.nodes.runtime;

import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.device.ControllerDevice;
import org.web3d.vrml.device.DeviceManager;
import org.web3d.vrml.device.GamepadDevice;
import org.web3d.vrml.device.GamepadState;
import org.web3d.vrml.device.GenericHIDState;
import org.web3d.vrml.device.InputDevice;
import org.web3d.vrml.device.JoystickDevice;
import org.web3d.vrml.device.JoystickState;
import org.web3d.vrml.device.MidiDevice;
import org.web3d.vrml.device.Tracker;
import org.web3d.vrml.device.TrackerDevice;
import org.web3d.vrml.device.TrackerState;
import org.web3d.vrml.device.WheelDevice;
import org.web3d.vrml.device.WheelState;
import org.web3d.vrml.nodes.VRMLDeviceSensorNodeType;
import org.web3d.vrml.nodes.runtime.UserInputHandler;

public class InputDeviceManager
implements KeyListener {
    private static final int DEFAULT_SIZE = 1024;
    private static final int INCREMENT_SIZE = 128;
    private static final String PROPERTY_FILE = "xj3d-devices.properties";
    private Object keyMutex;
    private int numKeyEvents;
    private KeyEvent[] keyEvents;
    private InputDevice[] devices;
    private int deviceCnt;
    private UserInputHandler uiHandler;
    private TrackerState state;
    private ErrorReporter errorReporter;
    private TrackerDevice[] trackerDevices;
    private ControllerDevice[] controllerDevices;
    private MidiDevice[] midiDevices;
    private Tracker[] trackers;
    private GamepadState gamepadState;
    private JoystickState joystickState;
    private WheelState wheelState;
    private HashMap controllerMap;
    private Component canvas;
    private Object surface;
    private String renderer;
    private boolean initialized;
    static /* synthetic */ Class class$org$web3d$vrml$nodes$runtime$InputDeviceManager;

    public InputDeviceManager(String string, Component component, Object object) {
        this.renderer = string;
        this.canvas = component;
        this.surface = object;
        this.initialized = false;
        this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        this.gamepadState = new GamepadState();
        this.joystickState = new JoystickState();
        this.wheelState = new WheelState();
        this.controllerMap = new HashMap();
        this.state = new TrackerState();
        this.keyMutex = new Object();
        this.numKeyEvents = 0;
        this.keyEvents = new KeyEvent[1024];
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
    }

    public void initialize(UserInputHandler userInputHandler) {
        int n;
        int n2;
        this.uiHandler = userInputHandler;
        final ArrayList arrayList = new ArrayList();
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    Object object;
                    InputStream inputStream;
                    String string = System.getProperty("user.dir");
                    String string2 = string + File.separator + InputDeviceManager.PROPERTY_FILE;
                    String string3 = "config/common/xj3d-devices.properties";
                    try {
                        inputStream = new FileInputStream(string2);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        inputStream = ClassLoader.getSystemResourceAsStream(string3);
                    }
                    if (inputStream == null) {
                        object = (class$org$web3d$vrml$nodes$runtime$InputDeviceManager == null ? (class$org$web3d$vrml$nodes$runtime$InputDeviceManager = InputDeviceManager.class$("org.web3d.vrml.nodes.runtime.InputDeviceManager")) : class$org$web3d$vrml$nodes$runtime$InputDeviceManager).getClassLoader();
                        inputStream = ((ClassLoader)object).getResourceAsStream(string3);
                    }
                    if (inputStream == null) {
                        InputDeviceManager.this.errorReporter.warningReport("No property file found in " + string3, null);
                        InputDeviceManager.this.deviceCnt = 0;
                    } else {
                        object = new Properties();
                        try {
                            ((Properties)object).load(inputStream);
                            inputStream.close();
                        }
                        catch (IOException iOException) {
                            InputDeviceManager.this.errorReporter.warningReport("Error reading" + string3, null);
                        }
                        String string4 = "devices." + InputDeviceManager.this.renderer + ".list";
                        String string5 = ((Properties)object).getProperty(string4);
                        if (string5 == null) {
                            InputDeviceManager.this.errorReporter.warningReport("No devices list found: " + string4, null);
                            return null;
                        }
                        StringTokenizer stringTokenizer = new StringTokenizer(string5);
                        int n = 0;
                        while (stringTokenizer.hasMoreTokens()) {
                            n = 0;
                            String string6 = stringTokenizer.nextToken();
                            String string7 = ((Properties)object).getProperty(string6 + ".name");
                            String string8 = ((Properties)object).getProperty(string6 + ".class");
                            String string9 = ((Properties)object).getProperty(string6 + ".params");
                            Object[] objectArray = new Object[n];
                            if (string9 != null && (n = Integer.parseInt(string9)) > 0) {
                                objectArray = new Object[n];
                                for (int i = 0; i < n; ++i) {
                                    string9 = ((Properties)object).getProperty(string6 + ".param." + i);
                                    if (string9 == null) continue;
                                    if (string9.equals("PARAM_CANVAS")) {
                                        objectArray[i] = InputDeviceManager.this.canvas;
                                        continue;
                                    }
                                    if (string9.equals("PARAM_SURFACE")) {
                                        objectArray[i] = InputDeviceManager.this.surface;
                                        continue;
                                    }
                                    InputDeviceManager.this.errorReporter.warningReport("Unhandled param in device: " + string7, null);
                                }
                            }
                            Class<?> clazz = null;
                            Object e = null;
                            boolean bl = false;
                            try {
                                clazz = Class.forName(string8);
                                Constructor<?>[] constructorArray = clazz.getConstructors();
                                for (int i = 0; i < constructorArray.length; ++i) {
                                    Class<?>[] classArray = constructorArray[i].getParameterTypes();
                                    if (classArray.length != n) continue;
                                    e = constructorArray[i].newInstance(objectArray);
                                    bl = true;
                                    break;
                                }
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                InputDeviceManager.this.errorReporter.warningReport("Unable to locate the class " + string8 + " required by the device: " + string7, null);
                            }
                            catch (Exception exception) {
                                if (exception instanceof InvocationTargetException) {
                                    InputDeviceManager.this.errorReporter.warningReport("Unable to locate the class " + string8 + " required by the device: " + string7, null);
                                    exception.printStackTrace();
                                    continue;
                                }
                                InputDeviceManager.this.errorReporter.warningReport("Error loading " + string7 + " at: " + string8, exception);
                                continue;
                            }
                            if (bl) {
                                arrayList.add(e);
                                continue;
                            }
                            InputDeviceManager.this.errorReporter.warningReport("Cannot load " + string7 + " at: " + string8, null);
                        }
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            this.errorReporter.errorReport("Error getting device properties", privilegedActionException);
        }
        int n3 = arrayList.size();
        this.deviceCnt = 0;
        ArrayList<InputDevice> arrayList2 = new ArrayList<InputDevice>();
        ArrayList<InputDevice> arrayList3 = new ArrayList<InputDevice>();
        ArrayList<InputDevice> arrayList4 = new ArrayList<InputDevice>();
        for (int i = 0; i < n3; ++i) {
            DeviceManager deviceManager = (DeviceManager)arrayList.get(i);
            deviceManager.setErrorReporter(this.errorReporter);
            InputDevice[] inputDeviceArray = deviceManager.getDevices();
            for (n2 = 0; n2 < inputDeviceArray.length; ++n2) {
                InputDevice inputDevice = inputDeviceArray[n2];
                this.errorReporter.messageReport("Device found: " + inputDevice.getName());
                if (inputDevice instanceof TrackerDevice) {
                    arrayList3.add(inputDevice);
                }
                if (inputDevice instanceof ControllerDevice) {
                    arrayList2.add(inputDevice);
                }
                if (inputDevice instanceof MidiDevice) {
                    arrayList4.add(inputDevice);
                }
                if (inputDevice instanceof MouseListener) {
                    this.canvas.addMouseListener((MouseListener)((Object)inputDevice));
                }
                if (inputDevice instanceof MouseMotionListener) {
                    this.canvas.addMouseMotionListener((MouseMotionListener)((Object)inputDevice));
                }
                if (!(inputDevice instanceof KeyListener)) continue;
                this.canvas.addKeyListener((KeyListener)((Object)inputDevice));
            }
        }
        if (arrayList3.size() == 0) {
            System.out.println("No devices registered in device manager?");
        }
        this.trackerDevices = new TrackerDevice[arrayList3.size()];
        arrayList3.toArray(this.trackerDevices);
        this.controllerDevices = new ControllerDevice[arrayList2.size()];
        arrayList2.toArray(this.controllerDevices);
        this.midiDevices = new MidiDevice[arrayList4.size()];
        arrayList4.toArray(this.midiDevices);
        arrayList3.clear();
        arrayList2.clear();
        arrayList4.clear();
        n3 = this.trackerDevices.length;
        n2 = 0;
        for (n = 0; n < n3; ++n) {
            TrackerDevice trackerDevice = this.trackerDevices[n];
            n2 += trackerDevice.getTrackerCount();
        }
        this.trackers = new Tracker[n2];
        n = 0;
        for (int i = 0; i < n3; ++i) {
            Tracker[] trackerArray = this.trackerDevices[i].getTrackers();
            for (int j = 0; j < trackerArray.length; ++j) {
                this.trackers[n++] = trackerArray[j];
            }
        }
        this.initialized = true;
    }

    public void addX3DNode(VRMLDeviceSensorNodeType vRMLDeviceSensorNodeType) {
        String string = vRMLDeviceSensorNodeType.getName();
        ArrayList<VRMLDeviceSensorNodeType> arrayList = (ArrayList<VRMLDeviceSensorNodeType>)this.controllerMap.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList<VRMLDeviceSensorNodeType>();
            arrayList.add(vRMLDeviceSensorNodeType);
            this.controllerMap.put(string, arrayList);
            int n = this.controllerDevices.length;
            for (int i = 0; i < n; ++i) {
                if (!this.controllerDevices[i].getName().equals(string)) continue;
                vRMLDeviceSensorNodeType.setDevice(this.controllerDevices[i]);
            }
        } else {
            arrayList.add(vRMLDeviceSensorNodeType);
        }
    }

    public void removeX3DNode(VRMLDeviceSensorNodeType vRMLDeviceSensorNodeType) {
        System.out.println("Got remove sensor node: " + vRMLDeviceSensorNodeType);
    }

    public void processTrackers() {
        int n;
        if (!this.initialized) {
            return;
        }
        int n2 = this.controllerDevices.length;
        GenericHIDState genericHIDState = null;
        for (n = 0; n < n2; ++n) {
            if (this.controllerDevices[n] instanceof GamepadDevice) {
                ((GamepadDevice)this.controllerDevices[n]).getState(this.gamepadState);
                genericHIDState = this.gamepadState;
            } else if (this.controllerDevices[n] instanceof JoystickDevice) {
                ((JoystickDevice)this.controllerDevices[n]).getState(this.joystickState);
                genericHIDState = this.joystickState;
            } else if (this.controllerDevices[n] instanceof WheelDevice) {
                ((WheelDevice)this.controllerDevices[n]).getState(this.wheelState);
                genericHIDState = this.wheelState;
            }
            ArrayList arrayList = (ArrayList)this.controllerMap.get(this.controllerDevices[n].getName());
            if (arrayList != null) {
                int n3 = arrayList.size();
                for (int i = 0; i < n3; ++i) {
                    VRMLDeviceSensorNodeType vRMLDeviceSensorNodeType = (VRMLDeviceSensorNodeType)arrayList.get(i);
                    vRMLDeviceSensorNodeType.update(genericHIDState);
                }
            }
            if (genericHIDState == null) continue;
            genericHIDState.clearChanged();
        }
        n2 = this.trackers.length;
        block11: for (n = 0; n < n2; ++n) {
            this.trackers[n].getState(this.state);
            switch (this.state.actionType) {
                case 128: {
                    this.uiHandler.trackerButton(n, this.state);
                    continue block11;
                }
                case 2: {
                    this.uiHandler.trackerPressed(n, this.state);
                    continue block11;
                }
                case 16: {
                    this.uiHandler.trackerReleased(n, this.state);
                    continue block11;
                }
                case 32: {
                    this.uiHandler.trackerMoved(n, this.state);
                    continue block11;
                }
                case 8: {
                    this.uiHandler.trackerClicked(n, this.state);
                    continue block11;
                }
                case 4: {
                    this.uiHandler.trackerDragged(n, this.state);
                    continue block11;
                }
                case 64: {
                    this.uiHandler.trackerOrientation(n, this.state);
                }
            }
        }
        this.uiHandler.processNavigation();
        n2 = this.midiDevices.length;
        for (n = 0; n < n2; ++n) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getKeyEvents(KeyEvent[] keyEventArray) {
        int n = this.numKeyEvents;
        if (this.numKeyEvents != 0) {
            Object object = this.keyMutex;
            synchronized (object) {
                int n2 = keyEventArray.length < this.numKeyEvents ? keyEventArray.length : this.numKeyEvents;
                System.arraycopy(this.keyEvents, 0, keyEventArray, 0, n2);
                int n3 = this.numKeyEvents;
                while (--n3 >= 0) {
                    this.keyEvents[n3] = null;
                }
                this.numKeyEvents = 0;
            }
        }
        return n;
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.addKeyEvent(keyEvent);
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.addKeyEvent(keyEvent);
    }

    public void keyTyped(KeyEvent keyEvent) {
        this.addKeyEvent(keyEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addKeyEvent(KeyEvent keyEvent) {
        Object object = this.keyMutex;
        synchronized (object) {
            if (this.numKeyEvents == this.keyEvents.length) {
                KeyEvent[] keyEventArray = new KeyEvent[this.numKeyEvents + 128];
                System.arraycopy(this.keyEvents, 0, keyEventArray, 0, this.numKeyEvents);
                this.keyEvents = keyEventArray;
            }
            this.keyEvents[this.numKeyEvents++] = keyEvent;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

